
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.biz.campus.constant.KefuRuleValue;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.google.common.collect.Lists;

import lombok.Data;

/**
 * @title KefuRuleDto
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */
@Data
public class KefuRuleDto {
    private Integer consultRule;
    private Integer bespeakOrder;
    private List<String> consultMobiles;

    public static KefuRuleDto from(TXKefuRule txKefuRule,OrgTxtMsg txtMsg) {
        if (txKefuRule == null) {
            return null;
        }
        KefuRuleDto dto = new KefuRuleDto();
        dto.setBespeakOrder(txKefuRule.getBespeakRule());
        dto.setConsultRule(txKefuRule.getConsultRule());
        if(txtMsg != null && StringUtils.isNotBlank(txtMsg.getValue())){
            dto.setConsultMobiles(Lists.newArrayList(StringUtils.split(txtMsg.getValue(), ',')));
        }
        return dto;
    }

    public boolean valid() {
        if (consultRule != null) {
            if (consultRule != KefuRuleValue.CONSULTRULE_IN_TURN.getCode()
                && consultRule != KefuRuleValue.CONSULTRULE_RANDOM.getCode()) {
                return false;
            }
        }
        if (bespeakOrder != null) {
            if (bespeakOrder != KefuRuleValue.BESPEAK_RULE_PRIVATE.getCode()
                && bespeakOrder != KefuRuleValue.BESPEAK_RULE_PUBLIC.getCode()) {
                return false;
            }
        }
        return true;
    }
}
