
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.org.constant.CampusAccountType;

import lombok.Data;
/**
 * @title AddAccountRequest
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年5月16日
 * @version 1.0
 */
@Data
public class AddAccountRequest {
    protected Integer campusNumber;
    protected String name;
    protected String mobile;
    protected String title;
    protected Integer type;
    protected List<TXPermissionNodeDto> authList;

    public boolean validRequest() {
        return campusNumber != null && CampusAccountType.isTypeValid(type) && StringUtils.isNotBlank(mobile)
            && StringUtils.isNotBlank(name);
    }
}
