/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.utils;

import com.baijia.tianxiao.biz.campus.dto.OrgAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.OrgSubAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.finance.BindCardForPerVerifyDto;
import com.baijia.tianxiao.biz.campus.dto.finance.OrgAccountRecordDetailDto;
import com.baijia.tianxiao.biz.campus.utils.PayRestUtils;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgAccountBankListDto;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class PayMentSystemApiHelper {
    private static final String BASE_URL = PropertiesReader.getValue((String)"rest", (String)"rest.appServiceUrl.new");
    private static final String APPID = PropertiesReader.getValue((String)"rest", (String)"rest.appId");
    private static final String APPKEY = PropertiesReader.getValue((String)"rest", (String)"rest.appKey");

    public static RestfulResult<Object> commonBanks() throws Exception {
        String controller = "pay";
        String action = "api";
        HashMap params = Maps.newHashMap();
        params.put("class", "Account\\UserMarketingAccount");
        params.put("method", "billBankList");
        params.put("_param", "[]");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("app_id", APPID);
        params.put("auth_token", String.valueOf(PayRestUtils.getAuthToken()));
        return PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    private static boolean isNotNullJsonNode(Object node) {
        return node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]");
    }

    private static String collextionToStr(Collection collection) {
        String result;
        StringBuilder builder = new StringBuilder("");
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next()).append(",");
            }
        }
        if ((result = builder.toString()).endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static RestfulResult<Object> drawCash(Integer client, Long orgId, Integer orgNum, Double ammount, Double feeAmount) throws Exception {
        if (feeAmount == null) {
            feeAmount = 0.0;
        }
        String controller = "org";
        String action = "orgAccountDrawCash";
        HashMap params = Maps.newHashMap();
        params.put("client", "" + client);
        params.put("org_id", "" + orgId);
        params.put("org_number", "" + orgNum);
        params.put("amount", "" + ammount);
        params.put("fee_amount", "" + feeAmount);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("app_id", APPID);
        params.put("auth_token", String.valueOf(PayRestUtils.getAuthToken()));
        return PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    public static RestfulResult<OrgAccountDetailDto> orgAccountDetail(Integer orgId, Collection<Integer> subOrgIds) throws Exception {
        String controller = "org";
        String action = "orgAccountDetail";
        HashMap params = Maps.newHashMap();
        JSONObject orgIdsJson = new JSONObject();
        orgIdsJson.put((Object)"main", orgId == null ? "" : orgId);
        orgIdsJson.put((Object)"sub", (Object)PayMentSystemApiHelper.collextionToStr(subOrgIds));
        params.put("org_ids", orgIdsJson.toString());
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject((Object)restResult.getData());
            OrgAccountDetailDto dto = new OrgAccountDetailDto();
            dto.setBalance(data.optDouble("balance", 0.0));
            dto.setExpected(data.optDouble("expected", 0.0));
            dto.setIncome(data.optDouble("income", 0.0));
            dto.setIncomeMonth(data.optDouble("income_month", 0.0));
            dto.setIncomeWeek(data.optDouble("income_week", 0.0));
            dto.setFreezeMoney(data.optDouble("freeze_money", 0.0));
            methodResult.setData((Object)dto);
        }
        return methodResult;
    }

    public static RestfulResult<Map<Integer, OrgSubAccountDetailDto>> subOrgAccountDetail(Collection<Integer> subOrgIds) throws Exception {
        JSONObject data;
        JSONArray records;
        String controller = "org";
        String action = "subOrgAccountDetail";
        HashMap params = Maps.newHashMap();
        params.put("sub_org_ids", subOrgIds != null ? subOrgIds.toString() : new ArrayList().toString());
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        HashMap<Integer, OrgSubAccountDetailDto> map = new HashMap<Integer, OrgSubAccountDetailDto>();
        methodResult.setData(map);
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult.getData()) && (records = (data = JSONObject.fromObject((Object)restResult.getData())).getJSONArray("records")) != null && records.size() > 0) {
            int i = 0;
            while (i < records.size()) {
                JSONObject record = records.getJSONObject(i);
                OrgSubAccountDetailDto dto = new OrgSubAccountDetailDto();
                dto.setBalance(record.optDouble("balance", 0.0));
                dto.setEarn(record.optDouble("earn", 0.0));
                dto.setExpected(record.optDouble("expected", 0.0));
                dto.setIncome(record.optDouble("income", 0.0));
                dto.setOrgId(record.getInt("org_id"));
                map.put(dto.getOrgId(), dto);
                ++i;
            }
        }
        return methodResult;
    }

    public static RestfulResult<OrgAccountBankListDto> orgAccountBankList(Long orgId) throws Exception {
        String controller = "org";
        String action = "orgAccountBankList";
        HashMap params = Maps.newHashMap();
        params.put("org_id", "" + orgId);
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult)) {
            JSONArray bankArray;
            JSONObject data = JSONObject.fromObject((Object)restResult.getData());
            OrgAccountBankListDto dto = new OrgAccountBankListDto();
            methodResult.setData((Object)dto);
            JSONObject userInfoNode = data.getJSONObject("user_info");
            if (PayMentSystemApiHelper.isNotNullJsonNode(userInfoNode) && PayMentSystemApiHelper.isNotNullJsonNode(userInfoNode.getString("bank_no"))) {
                OrgAccountBankListDto.UserInfo userInfo = new OrgAccountBankListDto.UserInfo(dto);
                userInfo.setBankNo(userInfoNode.getString("bank_no"));
                userInfo.setBankName(userInfoNode.getString("bank_name"));
                userInfo.setCardNum(userInfoNode.getString("card_num"));
                userInfo.setRegion(userInfoNode.getString("region"));
                userInfo.setOwnerName(userInfoNode.getString("owner_name"));
                userInfo.setOrgId(Long.valueOf(Long.parseLong(userInfoNode.getString("org_id"))));
                userInfo.setOpenLocation(userInfoNode.getString("open_location"));
                String status = userInfoNode.getString("status");
                String id = userInfoNode.getString("id");
                if (status != null && !status.equals("null")) {
                    userInfo.setStatus(Integer.valueOf(Integer.parseInt(userInfoNode.getString("status"))));
                }
                if (id != null && !id.equals("null")) {
                    userInfo.setId(Integer.valueOf(Integer.parseInt(userInfoNode.getString("id"))));
                }
                dto.setUserInfo(userInfo);
            }
            if ((bankArray = data.getJSONArray("bank_list")) != null) {
                ArrayList<OrgAccountBankListDto.Bank> bankList = new ArrayList<OrgAccountBankListDto.Bank>();
                if (bankArray.size() > 0) {
                    int i = 0;
                    while (i < bankArray.size()) {
                        JSONObject bankNode = bankArray.getJSONObject(i);
                        OrgAccountBankListDto.Bank bank = new OrgAccountBankListDto.Bank(dto);
                        bank.setCode(bankNode.getString("code"));
                        bank.setIconUrl(bankNode.getString("icon_url"));
                        bank.setName(bankNode.getString("name"));
                        bank.setPayFast(bankNode.getBoolean("pay_fast"));
                        bankList.add(bank);
                        ++i;
                    }
                }
                dto.setBankList(bankList);
            }
        }
        return methodResult;
    }

    public static RestfulResult<Object> bindCardForCot(Long orgId, String bankNo, String cardNum, String ownerName, String region, String openLocation) throws Exception {
        String controller = "org";
        String action = "bindCardForCot";
        HashMap params = Maps.newHashMap();
        params.put("org_id", "" + orgId);
        params.put("bank_no", bankNo);
        params.put("card_num", cardNum);
        params.put("owner_name", ownerName);
        params.put("region", region);
        if (openLocation == null) {
            params.put("open_location", "");
        } else {
            params.put("open_location", openLocation);
        }
        return PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    public static RestfulResult<BindCardForPerVerifyDto> bindCardForPerVerify(Long orgId, String idNumber, String bankNo, String cardNum, String ownerName, String mobile) throws Exception {
        String controller = "org";
        String action = "bindCardForPerVerify";
        HashMap params = Maps.newHashMap();
        params.put("org_id", "" + orgId);
        params.put("id_number", idNumber);
        params.put("bank_no", bankNo);
        params.put("card_num", cardNum);
        params.put("owner_name", ownerName);
        params.put("mobile", mobile);
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject((Object)restResult.getData());
            BindCardForPerVerifyDto dto = new BindCardForPerVerifyDto();
            dto.setPurchaseId(data.getLong("purchase_id"));
            dto.setToken(data.getString("token"));
            dto.setThirdType(data.getInt("third_type"));
            methodResult.setData((Object)dto);
        }
        return methodResult;
    }

    public static RestfulResult<Object> bindCardForPer(Long orgId, String idNumber, String purchaseId, String bankNo, String cardNum, String ownerName, String region, String openLocation, String mobile, String smsCode, String token, Integer thirdType) throws Exception {
        String controller = "org";
        String action = "bindCardForPer";
        HashMap params = Maps.newHashMap();
        params.put("org_id", "" + orgId);
        params.put("purchase_id", String.valueOf(purchaseId));
        params.put("id_number", idNumber);
        params.put("bank_no", bankNo);
        params.put("card_num", cardNum);
        params.put("owner_name", ownerName);
        params.put("region", region);
        params.put("mobile", mobile);
        params.put("sms_code", smsCode);
        params.put("token", token);
        params.put("third_type", "" + thirdType);
        if (openLocation == null) {
            params.put("open_location", "");
        } else {
            params.put("open_location", openLocation);
        }
        return PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    public static RestfulResult<Object> unbindCard(Long orgId, String payPassword) throws Exception {
        String controller = "org";
        String action = "unbindCard";
        HashMap params = Maps.newHashMap();
        params.put("org_id", "" + orgId);
        params.put("pay_password", payPassword);
        return PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    public static RestfulResult<OrgAccountRecordDetailDto> orgAccountRecordDetail(Long orgId, Collection<Long> subOrgIds, String startTime, String endTime, Long teacherId, Integer pageNum, Integer size) throws Exception {
        String controller = "org";
        String action = "orgAccountRecordDetail";
        if (pageNum == null) {
            pageNum = -1;
        }
        if (size == null) {
            size = -1;
        }
        HashMap params = Maps.newHashMap();
        params.put("size", "" + size);
        if (pageNum != -1) {
            params.put("offset", String.valueOf((pageNum - 1) * size + 1));
        }
        JSONObject orgIdsJson = new JSONObject();
        orgIdsJson.put((Object)"main", orgId != null ? orgId : "");
        orgIdsJson.put((Object)"sub", (Object)PayMentSystemApiHelper.collextionToStr(subOrgIds));
        params.put("org_ids", orgIdsJson.toString());
        if (StringUtils.isNotBlank((String)startTime)) {
            params.put("start_time", String.valueOf(startTime) + " 00:00:00");
        } else {
            params.put("start_time", "2014-09-22 00:00:00");
        }
        if (StringUtils.isNotBlank((String)endTime)) {
            params.put("end_time", String.valueOf(endTime) + " 23:59:59");
        } else {
            params.put("end_time", "2020-01-01 23:59:59");
        }
        if (teacherId != null && teacherId.intValue() != -1) {
            params.put("teacher_id", "" + teacherId);
        } else {
            params.put("teacher_id", "");
        }
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject((Object)restResult.getData());
            OrgAccountRecordDetailDto dto = new OrgAccountRecordDetailDto();
            methodResult.setData((Object)dto);
            String sumMoney = data.getString("sum_money");
            if (StringUtils.isNotBlank((String)sumMoney) && !sumMoney.equals("null")) {
                dto.setSumMoney(Double.parseDouble(data.getString("sum_money")));
            } else {
                dto.setSumMoney(0.0);
            }
            dto.setTotal(data.getInt("total"));
            JSONArray recordArray = data.getJSONArray("records");
            if (recordArray != null) {
                ArrayList<OrgAccountRecordDetailDto.Record> recordList = new ArrayList<OrgAccountRecordDetailDto.Record>();
                if (recordArray.size() > 0) {
                    int i = 0;
                    while (i < recordArray.size()) {
                        JSONObject recordNode = recordArray.getJSONObject(i);
                        OrgAccountRecordDetailDto.Record record = dto.new OrgAccountRecordDetailDto.Record();
                        record.setOpInfo(recordNode.getString("op_info"));
                        record.setOpType(recordNode.getInt("op_type"));
                        record.setOpMoney(recordNode.optDouble("op_money", 0.0));
                        record.setOpDesc(recordNode.getString("op_desc"));
                        record.setCreateTime(Timestamp.valueOf(recordNode.getString("create_time")));
                        record.setPurchaseId(recordNode.optString("purchase_id", ""));
                        record.setOpTypeName(recordNode.optString("op_type_name", ""));
                        if (recordNode.containsKey((Object)"is_settlement") && PayMentSystemApiHelper.isNotNullJsonNode(recordNode.get("is_settlement"))) {
                            record.setIsSettlement(recordNode.getInt("is_settlement"));
                        }
                        if (recordNode.containsKey((Object)"is_coin_pay") && PayMentSystemApiHelper.isNotNullJsonNode(recordNode.get("is_coin_pay"))) {
                            record.setIsCoinPay(recordNode.getInt("is_coin_pay"));
                        }
                        recordList.add(record);
                        ++i;
                    }
                }
                dto.setRecordList(recordList);
            }
        }
        return methodResult;
    }
}

