/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.dto.BaseCampusDto;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriew;
import com.baijia.tianxiao.biz.campus.dto.EnrollOverriewDto;
import com.baijia.tianxiao.biz.campus.dto.OrgAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.OrgSubAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusDto;
import com.baijia.tianxiao.biz.campus.dto.OverriewCampusListDto;
import com.baijia.tianxiao.biz.campus.service.OverriewService;
import com.baijia.tianxiao.biz.campus.utils.PayMentSystemApiHelper;
import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OverriewServiceImpl
implements OverriewService {
    private static final Logger log = LoggerFactory.getLogger(OverriewServiceImpl.class);
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgStudentDao orgStudentDAo;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Override
    public List<OverriewCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception {
        RestfulResult<OrgAccountDetailDto> masterResult;
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        ArrayList data = Lists.newArrayList();
        OrgSubAccount masterSub = this.orgSubAccountService.getMaster(orgAccount.getId());
        OverriewCampusListDto master = new OverriewCampusListDto();
        OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(orgId.intValue()));
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        master.setCampusTypeName(CampusType.MASTER.getLabel());
        master.setCoverUrl(masterSub.getCoverUrl());
        data.add(master);
        if (pageDto != null) {
            if (pageDto.getPageNum() == 1) {
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - 1));
            } else {
                pageDto.setCurPageCount(Integer.valueOf((pageDto.getPageNum() - 1) * pageDto.getPageSize() - 1));
                data.clear();
            }
        }
        List slaves = this.orgSubAccountService.getSlaves(orgId, pageDto);
        ArrayList subOrgIds = Lists.newArrayList();
        Double subIncome = 0.0;
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount ca : slaves) {
                subOrgIds.add(ca.getOrgId());
            }
            RestfulResult<Map<Integer, OrgSubAccountDetailDto>> restfulResult = null;
            Map subOrgDetailMap = Maps.newHashMap();
            try {
                restfulResult = PayMentSystemApiHelper.subOrgAccountDetail(subOrgIds);
                log.info("call - payMentSystem api - subOrgAccountDetail - masterOrgId:{} , restfulResult:{}", (Object)orgId, restfulResult);
            }
            catch (Exception e) {
                log.error("call - payMentSystem api - subOrgAccountDetail - exception - masterOrgId:{}" + orgId);
            }
            if (restfulResult != null && restfulResult.getCode() != 0) {
                log.error("call - payMentSystem api - subOrgAccountDetail - fail - masterOrgId:{}, restfulResult:{}", (Object)orgId, restfulResult);
            } else {
                subOrgDetailMap = (Map)restfulResult.getData();
            }
            for (OrgSubAccount ca : slaves) {
                OrgAccount oa = this.orgAccountService.getOrgAccountById(ca.getOrgId());
                if (oa == null) continue;
                OrgInfoSimpleDto slaveOrgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(oa.getId().intValue()));
                OverriewCampusListDto slave = new OverriewCampusListDto();
                slave.setCampusName(slaveOrgInfo.getShortName());
                slave.setCampusNumber(oa.getNumber());
                slave.setCampusType(ca.getAccountType());
                slave.setCampusTypeName(CampusType.getLabelByCode(ca.getAccountType()));
                slave.setCoverUrl(ca.getCoverUrl());
                OrgSubAccountDetailDto dto = (OrgSubAccountDetailDto)subOrgDetailMap.get(oa.getId());
                if (dto != null) {
                    if (ca.getAccountType().intValue() == CampusType.LEAGUE.getCode().intValue()) {
                        subIncome = subIncome + dto.getIncome();
                    }
                    slave.setBalance(dto.getBalance());
                    slave.setIncomeSum(dto.getIncome());
                } else {
                    RestfulResult<OrgAccountDetailDto> league;
                    try {
                        league = PayMentSystemApiHelper.orgAccountDetail(oa.getId(), Arrays.asList(oa.getId()));
                    }
                    catch (Exception e) {
                        log.error("call - payMentSystem api - orgAccountDetail - exception - leagueOrgId:{}", (Object)orgAccount.getId());
                        return data;
                    }
                    if (league.getCode() != 0) {
                        log.error("call - payMentSystem api - orgAccountDetail - fail - leagueOrgid:{}, restfulResult:{}", (Object)orgId, league);
                        return data;
                    }
                    OrgAccountDetailDto l = (OrgAccountDetailDto)league.getData();
                    slave.setBalance(l.getBalance());
                    slave.setIncomeSum(l.getIncome());
                    subIncome = subIncome + l.getIncome();
                }
                int enrollSum = this.orgSignupInfoDao.countByTime(Arrays.asList((long)oa.getId()), null, null);
                slave.setEnrollSum(enrollSum);
                int teacherSum = this.orgTeacherDao.getTeacherIds(Long.valueOf(oa.getId().intValue()), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())).size();
                slave.setTeacherSum(teacherSum);
                int studentSum = this.orgStudentDAo.getStudentSum(oa.getId());
                slave.setStudentSum(studentSum);
                data.add(slave);
            }
        }
        try {
            masterResult = PayMentSystemApiHelper.orgAccountDetail(orgId, subOrgIds);
            log.info("call - payMentSystem api - orgAccountDetail - masterOrgId:{} , restfulResult:{}", (Object)orgId, masterResult);
        }
        catch (Exception e) {
            log.error("call - payMentSystem api - orgAccountDetail - exception - masterOrgId:{}" + orgId);
            return data;
        }
        if (masterResult.getCode() != 0) {
            log.error("call - payMentSystem api - orgAccountDetail - fail - masterOrgId:{}, restfulResult:{}", (Object)orgId, masterResult);
            return data;
        }
        OrgAccountDetailDto masterDetail = (OrgAccountDetailDto)masterResult.getData();
        master.setBalance(masterDetail.getBalance());
        master.setIncomeSum(masterDetail.getIncome() + subIncome);
        int enrollSum = this.orgSignupInfoDao.countByTime(Arrays.asList((long)orgId), null, null);
        master.setEnrollSum(enrollSum);
        int teacherSum = this.orgTeacherDao.getTeacherIds(Long.valueOf(orgId.intValue()), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())).size();
        master.setTeacherSum(teacherSum);
        int studentSum = this.orgStudentDAo.getStudentSum(orgId);
        master.setStudentSum(studentSum);
        if (pageDto != null) {
            Integer count = this.orgSubAccountService.getSlaveCount(orgId);
            count = count + 1;
            pageDto.setCount(count);
        }
        return data;
    }

    @Override
    public OverriewCampusDto getCampusOverriew(Integer orgId) throws Exception {
        RestfulResult<OrgAccountDetailDto> masterResult;
        OverriewCampusDto data = new OverriewCampusDto();
        List slaves = this.orgSubAccountService.getSlaves(orgId, null);
        int teacherSum = 0;
        int studentSum = 0;
        ArrayList subOrgIds = Lists.newArrayList();
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(Long.valueOf(orgId.intValue()));
        subOrgIds.add(orgId);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount slave : slaves) {
                if (slave.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode().intValue()) {
                    subOrgIds.add(slave.getOrgId());
                }
                orgIds.add(Long.valueOf(slave.getOrgId().intValue()));
                OrgAccount oa = this.orgAccountService.getOrgAccountById(slave.getOrgId());
                if (oa == null) continue;
                teacherSum += this.orgTeacherDao.getTeacherIds(Long.valueOf(oa.getId().intValue()), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())).size();
                studentSum += this.orgStudentDAo.getStudentSum(oa.getId()).intValue();
            }
        }
        teacherSum += this.orgTeacherDao.getTeacherIds(Long.valueOf(orgId.intValue()), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())).size();
        studentSum += this.orgStudentDAo.getStudentSum(orgId).intValue();
        log.debug("enroll count week orgIds:{},start{},end{}", new Object[]{orgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek()});
        log.debug("enroll count month orgIds:{},start{},end{}", new Object[]{orgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth()});
        int weekEnroll = this.orgSignupInfoDao.countByTime((List)orgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        int monthEnroll = this.orgSignupInfoDao.countByTime((List)orgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setMonthEnroll(monthEnroll);
        data.setStudentSum(studentSum);
        data.setWeekEnroll(weekEnroll);
        data.setTeacherSum(teacherSum);
        try {
            masterResult = PayMentSystemApiHelper.orgAccountDetail(orgId, subOrgIds);
            log.info("call - payMentSystem api - orgAccountDetail - masterOrgId:{} ,subOrgIds:{}, restfulResult:{}", new Object[]{orgId, subOrgIds, masterResult});
        }
        catch (Exception e) {
            log.error("call - payMentSystem api - orgAccountDetail - exception - masterOrgId:{},subOrgIds:{}", (Object)orgId, (Object)subOrgIds);
            return data;
        }
        if (masterResult.getCode() != 0) {
            log.error("call - payMentSystem api - orgAccountDetail - fail - masterOrgId:{},subOrgids:{} restfulResult:{}", new Object[]{orgId, subOrgIds, masterResult});
            return data;
        }
        data.setMonthIncome(((OrgAccountDetailDto)masterResult.getData()).getIncomeMonth());
        data.setWeekIncome(((OrgAccountDetailDto)masterResult.getData()).getIncomeWeek());
        return data;
    }

    @Override
    public List<BaseCampusDto> getCampusList(Integer orgId) throws Exception {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        ArrayList data = Lists.newArrayList();
        BaseCampusDto master = new BaseCampusDto();
        OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(orgId.intValue()));
        master.setCampusId(orgId);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        data.add(master);
        List slaves = this.orgSubAccountService.getSlaves(orgId, null);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount ca : slaves) {
                OrgAccount oa = this.orgAccountService.getOrgAccountById(ca.getOrgId());
                if (oa == null) continue;
                OrgInfoSimpleDto slaveOrgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(oa.getId().intValue()));
                BaseCampusDto slave = new BaseCampusDto();
                slave.setCampusId(ca.getOrgId());
                slave.setCampusName(slaveOrgInfo.getShortName());
                slave.setCampusNumber(oa.getNumber());
                slave.setCampusType(ca.getAccountType());
                slave.setCampusTypeName(CampusType.getLabelByCode(ca.getAccountType()));
                data.add(slave);
            }
        }
        return data;
    }

    @Override
    public EnrollOverriewDto enrollOverriew(Integer orgId) throws Exception {
        List slaves = this.orgSubAccountService.getSlaves(orgId, null);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(orgId);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount slave : slaves) {
                orgIds.add(slave.getOrgId());
            }
        }
        EnrollOverriewDto data = new EnrollOverriewDto();
        int studentSum = 0;
        Date now = new Date();
        Date yestoday = DateUtil.getDayDiff((int)-1);
        ArrayList countOrgIds = Lists.newArrayList();
        for (Integer id : orgIds) {
            studentSum += this.orgStudentDAo.getStudentSum(id).intValue();
            countOrgIds.add(Long.valueOf(id.intValue()));
        }
        int todayEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfDay((Date)now), DateUtil.getEndOfDay((Date)now));
        int yestodayEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfDay((Date)yestoday), DateUtil.getEndOfDay((Date)yestoday));
        int weekEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        int monthEnroll = this.orgSignupInfoDao.countByTime((List)countOrgIds, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        data.setMonthEnroll(monthEnroll);
        data.setTodayEnroll(todayEnroll);
        data.setWeekEnroll(weekEnroll);
        data.setYestodayEnroll(yestodayEnroll);
        data.setStudentSum(studentSum);
        return data;
    }

    @Override
    public List<EnrollOverriew> enrollList(Integer orgNumber, Integer orgId, Date startTime, Date endTime, PageDto pageDto) throws BussinessException, Exception {
        OrgInfoSimpleDto orgInfoSimpleDto;
        ArrayList orgIds = Lists.newArrayList();
        if (orgNumber != null && orgNumber > 0) {
            OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(orgNumber);
            if (orgAccount != null) {
                orgIds.add(Long.valueOf(orgAccount.getId().intValue()));
            }
        } else {
            orgIds.add(Long.valueOf(orgId.intValue()));
            List subAccounts = this.orgSubAccountService.getSlaves(orgId, null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(Long.valueOf(subAccount.getOrgId().intValue()));
                }
            }
        }
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return data;
        }
        List orgSignupInfos = this.orgSignupInfoDao.getPurchases(startTime, endTime, (List)orgIds, pageDto);
        if (CollectionUtils.isEmpty((Collection)orgSignupInfos)) {
            return data;
        }
        ArrayList purchaseIds = Lists.newArrayList();
        ArrayList studentIds = Lists.newArrayList();
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
            studentIds.add(orgSignupInfo.getUserId());
        }
        ArrayList courseIds = Lists.newArrayList();
        ArrayListMultimap pidCidsMap = ArrayListMultimap.create();
        List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgSignupCourses)) {
            for (OrgSignupCourse orgSignupCourse : orgSignupCourses) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
                pidCidsMap.put((Object)orgSignupCourse.getSignupPurchaseId(), (Object)orgSignupCourse.getOrgCourseId());
            }
        }
        Map cidCourseMap = Maps.newHashMap();
        List orgCourses = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                cidCourseMap.put(orgCourse.getId(), orgCourse);
            }
        }
        Map studentsMap = this.orgStudentDAo.getOrgStudentMapByUserIds((Collection)studentIds);
        Map orgInfoMap = Maps.newHashMap();
        for (Long tempOrgId : orgIds) {
            orgInfoSimpleDto = this.orgInfoService.getOrgInfo(tempOrgId);
            if (orgInfoSimpleDto == null) continue;
            orgInfoMap.put(tempOrgId, orgInfoSimpleDto);
        }
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            OrgStudent orgStudent;
            orgInfoSimpleDto = (OrgInfoSimpleDto)orgInfoMap.get(orgSignupInfo.getOrgId());
            EnrollOverriew dto = new EnrollOverriew();
            if (orgInfoSimpleDto != null) {
                dto.setCampusName(orgInfoSimpleDto.getShortName());
            }
            dto.setCreateTime(orgSignupInfo.getCreateTime().getTime());
            dto.setExportTime(orgSignupInfo.getCreateTime());
            dto.setPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100.0);
            Collection cids = pidCidsMap.get((Object)orgSignupInfo.getSignupPurchaseId());
            if (CollectionUtils.isNotEmpty((Collection)cids)) {
                StringBuilder courseName = new StringBuilder();
                ArrayList tempCids = new ArrayList(cids);
                for (int i = 0; i < tempCids.size(); ++i) {
                    Long cid = (Long)tempCids.get(i);
                    OrgCourse orgCourse = (OrgCourse)cidCourseMap.get(cid);
                    if (orgCourse != null) {
                        courseName.append(orgCourse.getName());
                    }
                    if (i + 1 >= tempCids.size()) continue;
                    courseName.append(",");
                }
                dto.setCourseName(courseName.toString());
            }
            if ((orgStudent = (OrgStudent)studentsMap.get(orgSignupInfo.getUserId())) != null) {
                if (StringUtils.isBlank((CharSequence)orgStudent.getName())) {
                    if (StringUtils.isNotEmpty((CharSequence)orgStudent.getNickName())) {
                        dto.setStudentName(orgStudent.getNickName());
                    } else {
                        dto.setStudentName(MaskUtil.maskMobile((String)orgStudent.getMobile()));
                    }
                } else {
                    dto.setStudentName(orgStudent.getName());
                }
            }
            data.add(dto);
        }
        return data;
    }

    @Override
    public boolean isRequestValid() {
        boolean flag = false;
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer txAccountId = TianxiaoPCContext.getTXLoginAccountId();
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        if (orgAccount != null) {
            flag = true;
        }
        TXAccount txAccount = null;
        if (txAccountId != null && orgId != null) {
            txAccount = this.txAccountService.getByIdAndOrgId(txAccountId, orgId);
        }
        if (txAccount == null) {
            TXCascadeAccount cascadeAccount;
            if (TianxiaoPCContext.getTXCascadeId() != null && (cascadeAccount = this.txCascadeAccountDao.getByIdAndOrgId(TianxiaoPCContext.getTXCascadeId(), orgId)) != null && this.txAccountService.getByOrgId(orgId) != null) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }
}

