/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.utils;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class PayRestUtils {
    private static final Logger logger = LoggerFactory.getLogger(PayRestUtils.class);
    private static final String URL_SPLIT = "/";
    private static final String SIGN_SPLIT = "-";
    private static final String DEF_CHARSET = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final byte[] LOGIN_LOCK = new byte[0];
    private static final long EXPIRE_TIME = 604800000L;
    public static String APP_ID;
    public static String APP_KEY;
    public static String DEF_BASE_URL;
    public static String DEF_BASE_URL_NEW;
    public static volatile String authToken;
    public static volatile long loginTime;
    public static String TTS_WEBSERVICE_URL;

    public PayRestUtils(String appId, String appKey, String baseUrl) {
        APP_ID = appId;
        APP_KEY = appKey;
        DEF_BASE_URL = baseUrl;
    }

    public PayRestUtils() {
        Properties prop = PropertiesReader.getProperties((String)"rest.properties");
        if (prop != null) {
            APP_ID = prop.getProperty("rest.appId");
            APP_KEY = prop.getProperty("rest.appKey");
            DEF_BASE_URL = prop.getProperty("rest.appServiceUrl");
            DEF_BASE_URL_NEW = prop.getProperty("rest.appServiceUrl.new");
            TTS_WEBSERVICE_URL = prop.getProperty("tts.webservice.url");
        }
    }

    public static <T> RestfulResult<T> rest(RestMethod restMethod, String baseUrl, String controller, String action, List<String> urlVarList, Map<String, String> params, T dataType) throws Exception {
        StringBuilder loginUrl = new StringBuilder();
        loginUrl.append(baseUrl);
        loginUrl.append(URL_SPLIT).append(controller);
        loginUrl.append(URL_SPLIT).append(action);
        String signData = PayRestUtils.createSignData(restMethod.toString(), controller, action, urlVarList, params);
        String sign = PayRestUtils.getSignature(signData.getBytes(DEF_CHARSET), APP_KEY.getBytes(DEF_CHARSET));
        params.put("sign", sign);
        logger.info("loginUrl:{}, postData:{}", (Object)loginUrl.toString(), params);
        Set<String> keys = params.keySet();
        StringBuffer sb = new StringBuffer();
        for (String k : keys) {
            sb.append(k);
            sb.append("=");
            sb.append(URLEncoder.encode(params.get(k)));
            sb.append("&");
        }
        logger.info("loginUrl:{}, ik:{}", (Object)loginUrl.toString(), (Object)sb.toString());
        String resultJson = null;
        switch (restMethod) {
            case POST: {
                resultJson = HttpClientUtils.doPost((String)loginUrl.toString(), params, (String)DEF_CHARSET);
                break;
            }
            case GET: {
                resultJson = HttpClientUtils.doGet((String)loginUrl.toString(), params, (String)DEF_CHARSET);
                break;
            }
            default: {
                throw new Exception("\u4e0d\u652f\u6301\u7684REST\u65b9\u6cd5");
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        logger.info("rest.resultJson:{}", (Object)resultJson);
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        RestfulResult result = null;
        if (StringUtils.isNotBlank((String)resultJson)) {
            result = (RestfulResult)mapper.readValue(resultJson, RestfulResult.class);
        } else {
            result = new RestfulResult();
            result.setCode(1);
            result.setMsg("\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAuthToken() throws Exception {
        byte[] byArray = LOGIN_LOCK;
        synchronized (LOGIN_LOCK) {
            if (loginTime - System.currentTimeMillis() < 604800000L && authToken != null) {
                // ** MonitorExit[byArray] (shouldn't be in output)
                return authToken;
            }
            String result = null;
            try {
                String controller = "auth";
                String action = "login";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("app_id", APP_ID);
                params.put("app_key", APP_KEY);
                params.put("timestamp", String.valueOf(System.currentTimeMillis()));
                Object dataType = null;
                RestfulResult<Object> loginResult = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
                if (loginResult == null) {
                    String string = null;
                    // ** MonitorExit[byArray] (shouldn't be in output)
                    return string;
                }
                if (loginResult.getCode() != 0) {
                    throw new Exception(loginResult.getMsg());
                }
                String string = result = ((Map)loginResult.getData()).get("auth_token").toString();
                // ** MonitorExit[byArray] (shouldn't be in output)
                return string;
            }
            finally {
                loginTime = System.currentTimeMillis();
                authToken = result;
            }
        }
    }

    public static RestfulResult<Map<String, Object>> createTeacher(String mobile, String password, String email, String name, String invite_code, String authToken, int orgId) throws Exception {
        logger.trace("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        RestfulResult<Object> createResult = null;
        if (StringUtils.isBlank((String)mobile) || StringUtils.isBlank((String)password)) {
            createResult = new RestfulResult<Object>();
            createResult.setCode(1);
            createResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        if (StringUtils.isBlank((String)authToken) && StringUtils.isBlank((String)(authToken = PayRestUtils.getAuthToken()))) {
            createResult = new RestfulResult();
            createResult.setCode(1);
            createResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            return createResult;
        }
        String controller = "teacher";
        String action = "create";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("org_id", orgId + "");
        Object dataType = null;
        createResult = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
        logger.info("ResUtils.createTeacher   params:{}, createResult:{}", params, createResult);
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> addRole(String mobile, Integer target_role, String invite_code, String authToken, int orgId) throws Exception {
        logger.trace("mobile:" + mobile + ",target_role" + target_role);
        RestfulResult<Object> addResult = null;
        if (StringUtils.isBlank((String)mobile) || target_role != 0 && target_role != 2) {
            addResult = new RestfulResult<Object>();
            addResult.setCode(1);
            addResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return addResult;
        }
        if (StringUtils.isBlank((String)authToken) && StringUtils.isBlank((String)(authToken = PayRestUtils.getAuthToken()))) {
            addResult = new RestfulResult();
            addResult.setCode(1);
            addResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            return addResult;
        }
        String controller = "user";
        String action = "addRole";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("mobile", mobile);
        params.put("target_role", target_role.toString());
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("org_id", orgId + "");
        Object dataType = null;
        addResult = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
        logger.info("ResUtils.addRole   params:{}, addResult:{}", params, addResult);
        return addResult;
    }

    public static RestfulResult<Map<String, Object>> createStudent(String mobile, String password, String email, String name, String invite_code, String authToken, String controller, String action) throws Exception {
        logger.trace("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        RestfulResult<Object> createResult = null;
        if (StringUtils.isBlank((String)mobile) || StringUtils.isBlank((String)password)) {
            createResult = new RestfulResult<Object>();
            createResult.setCode(1);
            createResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        if (StringUtils.isBlank((String)authToken) && StringUtils.isBlank((String)(authToken = PayRestUtils.getAuthToken()))) {
            createResult = new RestfulResult();
            createResult.setCode(1);
            createResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            return createResult;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Object dataType = null;
        createResult = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> sendBoundCardMessage(String orgId, String ownerName, String idNumber, String mobile, String cardNumber, String bankNo, String authToken) throws Exception {
        logger.info("orgId:" + orgId + ",ownerName:" + ownerName + ",idNumber:" + idNumber + ",mobile:" + mobile + ",cardNumber:" + cardNumber + ",bankNo:" + bankNo);
        RestfulResult sendMessage = null;
        if (StringUtils.isBlank((String)orgId) || StringUtils.isBlank((String)ownerName) || StringUtils.isBlank((String)idNumber) || StringUtils.isBlank((String)mobile) || StringUtils.isBlank((String)cardNumber)) {
            sendMessage = new RestfulResult();
            sendMessage.setCode(1);
            sendMessage.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return sendMessage;
        }
        if (StringUtils.isBlank((String)authToken) && StringUtils.isBlank((String)(authToken = PayRestUtils.getAuthToken()))) {
            sendMessage = new RestfulResult();
            sendMessage.setCode(1);
            sendMessage.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            return sendMessage;
        }
        String controller = "pay";
        String action = "sendOrgBindCardSms";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("org_id", orgId);
        params.put("owner_name", ownerName);
        params.put("id_number", idNumber);
        params.put("mobile", mobile);
        params.put("card_num", cardNumber);
        params.put("bank_no", bankNo);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Object dataType = null;
        RestfulResult<Object> sendMessages = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL_NEW, controller, action, null, params, dataType);
        logger.info("ResUtils.createTeacher   params:{}, createResult:{}", params, sendMessages);
        return sendMessages;
    }

    public static RestfulResult<Map<String, Object>> boundCard(String orgId, String ownerName, String idNumber, String bankNo, String mobile, String cardNumber, String purchaseId, String smsCode, String authToken) throws Exception {
        logger.info("orgId:" + orgId + ",ownerName:" + ownerName + ",idNumber:" + idNumber + ",mobile:" + mobile + ",cardNumber:" + cardNumber);
        RestfulResult<Object> boundCard = null;
        if (StringUtils.isBlank((String)orgId) || StringUtils.isBlank((String)ownerName) || StringUtils.isBlank((String)idNumber) || StringUtils.isBlank((String)bankNo) || StringUtils.isBlank((String)mobile) || StringUtils.isBlank((String)cardNumber) || StringUtils.isBlank((String)purchaseId) || StringUtils.isBlank((String)smsCode)) {
            boundCard = new RestfulResult<Object>();
            boundCard.setCode(1);
            boundCard.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return boundCard;
        }
        if (StringUtils.isBlank((String)authToken) && StringUtils.isBlank((String)(authToken = PayRestUtils.getAuthToken()))) {
            boundCard = new RestfulResult();
            boundCard.setCode(1);
            boundCard.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            return boundCard;
        }
        String controller = "pay";
        String action = "checkOrgBindCardSms";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("auth_token", authToken);
        params.put("org_id", orgId);
        params.put("owner_name", ownerName);
        params.put("id_number", idNumber);
        params.put("bank_no", bankNo);
        params.put("mobile", mobile);
        params.put("card_num", cardNumber);
        params.put("purchase_id", purchaseId);
        params.put("sms_code", smsCode);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Object dataType = null;
        boundCard = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL_NEW, controller, action, null, params, dataType);
        logger.info("ResUtils.boundCard   params:{}, createResult:{}", params, boundCard);
        return boundCard;
    }

    public static String createSignData(String restMethod, String controllerName, String actionName, List<String> urlVarList, Map<String, String> params) {
        StringBuilder signData = new StringBuilder();
        signData.append(restMethod.toLowerCase());
        signData.append(SIGN_SPLIT).append(controllerName);
        signData.append(SIGN_SPLIT).append(actionName);
        if (urlVarList != null && !urlVarList.isEmpty()) {
            for (String urlVar : urlVarList) {
                if (urlVar == null) {
                    signData.append(SIGN_SPLIT).append("");
                    continue;
                }
                signData.append(SIGN_SPLIT).append(urlVar);
            }
        }
        if (params != null && !params.isEmpty()) {
            String[] paraNames = new String[params.size()];
            Arrays.sort(params.keySet().toArray(paraNames));
            for (String paraName : paraNames) {
                String value = params.get(paraName);
                if (StringUtils.isBlank((String)value)) {
                    value = "";
                }
                signData.append(SIGN_SPLIT).append(value);
            }
        }
        return signData.toString();
    }

    public static String getSignature(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data);
        return Base64.encodeBase64String((byte[])rawHmac);
    }

    public static String doService(String controller, String action, Map<String, String> params) {
        try {
            String token = PayRestUtils.getAuthToken();
            int timestamp = (int)(System.currentTimeMillis() / 1000L);
            params.put("app_id", APP_ID);
            params.put("auth_token", token);
            params.put("timestamp", String.valueOf(timestamp));
            Object dataType = null;
            RestfulResult<Object> response = PayRestUtils.rest(RestMethod.POST, DEF_BASE_URL, controller, action, null, params, dataType);
            logger.info("response:{}", response);
            return response.getMsg();
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    static {
        authToken = null;
        loginTime = -1L;
        Properties prop = PropertiesReader.getProperties((String)"rest.properties");
        if (prop != null) {
            APP_ID = prop.getProperty("rest.appId");
            APP_KEY = prop.getProperty("rest.appKey");
            DEF_BASE_URL = prop.getProperty("rest.appServiceUrl");
            DEF_BASE_URL_NEW = prop.getProperty("rest.appServiceUrl.new");
            TTS_WEBSERVICE_URL = prop.getProperty("tts.webservice.url");
        }
    }

    public static enum RestMethod {
        GET,
        POST;

    }
}

