/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.CampusAccountStatus;
import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.dto.AddAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.AddCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.CampusAccountDto;
import com.baijia.tianxiao.biz.campus.dto.ModAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.ModCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.SettingCampusListDto;
import com.baijia.tianxiao.biz.campus.dto.TXPermissionNodeDto;
import com.baijia.tianxiao.biz.campus.dto.TXPerssionGroupDto;
import com.baijia.tianxiao.biz.campus.service.SettingService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.SMSErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.RootPermission;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConstant;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.constant.WebPermissionMapping;
import com.baijia.tianxiao.sal.organization.mqs.OrganizationRegist;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.MqsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.VerifyCodeUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.common.web.WebResponse;
import com.baijia.yunying.hag.dal.bo.Entity;
import com.baijia.yunying.hag.service.HagService;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SettingServiceImpl
implements SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    public List<SettingCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception {
        ArrayList data = Lists.newArrayList();
        SettingCampusListDto master = new SettingCampusListDto();
        OrgSubAccount masterSub = this.orgSubAccountService.getMaster(orgId);
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        master.setCampusTypeName(CampusType.MASTER.getLabel());
        master.setAreaId(orgInfo.getAreaId());
        master.setMobile(orgAccount.getMobile());
        master.setPrincipal(orgInfo.getContacts());
        master.setCoverUrl(masterSub.getCoverUrl());
        if (orgInfo.getAreaId() != null) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)orgInfo.getAreaId().intValue());
            master.setProvince((String)areaMap.get("province"));
            master.setCity((String)areaMap.get("city"));
        }
        Integer mCascadeCount = this.txCascadeAccountDao.getCountByOrgId(orgId);
        mCascadeCount = mCascadeCount + 1;
        master.setAccountSum(mCascadeCount);
        data.add(master);
        if (pageDto.getPageNum() == 1) {
            pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - 1));
        } else {
            pageDto.setCurPageCount(Integer.valueOf((pageDto.getPageNum() - 1) * pageDto.getPageSize() - 1));
            data.clear();
        }
        List slaves = this.orgSubAccountService.getSlaves(orgId, pageDto);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount subAccount : slaves) {
                OrgAccount oAccount = this.orgAccountService.getOrgAccountById(subAccount.getOrgId());
                if (oAccount == null) continue;
                OrgInfo oInfo = this.orgInfoDao.getOrgInfo(oAccount.getId(), new String[0]);
                Integer subCount = this.txCascadeAccountDao.getCountByOrgId(oAccount.getId());
                SettingCampusListDto slave = new SettingCampusListDto();
                subCount = subCount + 1;
                slave.setAccountSum(subCount);
                slave.setCampusName(oInfo.getShortName());
                slave.setCampusNumber(oAccount.getNumber());
                slave.setCampusType(subAccount.getAccountType());
                slave.setAreaId(oInfo.getAreaId());
                slave.setCampusId(subAccount.getId());
                slave.setMobile(oAccount.getMobile());
                slave.setCoverUrl(subAccount.getCoverUrl());
                if (oInfo.getAreaId() != null) {
                    Map areaMap = AreaUtils.getAreaNameByCode((Integer)oInfo.getAreaId().intValue());
                    slave.setProvince((String)areaMap.get("province"));
                    slave.setCity((String)areaMap.get("city"));
                }
                slave.setPrincipal(oInfo.getContacts());
                data.add(slave);
            }
        }
        Integer slaveCount = this.orgSubAccountService.getSlaveCount(orgId);
        slaveCount = slaveCount + 1;
        pageDto.setCount(slaveCount);
        return data;
    }

    @Override
    public void addCampus(AddCampusRequest addCampusRequest) {
        OrgSubAccount slaveInDB;
        Integer subCount = this.orgSubAccountService.getSlaveCount(TianxiaoPCContext.getOrgId());
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (txAccount.getCampusCount() <= subCount + 1) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CAMPUS_COUNT);
        }
        OrgAccount subAccount = this.orgAccountService.getOrgAccountByMobile(addCampusRequest.getMobile());
        if (subAccount != null) {
            if (subAccount.getId().intValue() == txAccount.getOrgId().intValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0d\u80fd\u6dfb\u52a0\u81ea\u5df1");
            }
            if (StringUtils.isBlank((CharSequence)addCampusRequest.getCode()) || VerifyCodeUtil.valid((boolean)false, (String)addCampusRequest.getMobile(), (String)addCampusRequest.getCode(), (String)TxSmsCodeType.INVITE_TOBE_CAMPUS.getCacheKey())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
        } else {
            subAccount = this.saveOrgAccount(addCampusRequest.getMobile());
            this.saveOrgInfo(addCampusRequest.getAreaId(), subAccount.getId(), addCampusRequest.getCampusName(), addCampusRequest.getPrincipal());
            this.sendMQSMsg(subAccount.getId(), addCampusRequest.getAreaId(), null);
            boolean sendResult = false;
            try {
                sendResult = SmsSendUtil.sendSms((String)addCampusRequest.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_ORG_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, (boolean)true);
            }
            catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.info("send invite campus sms to :{} error:{}!code :{}", new Object[]{addCampusRequest.getMobile(), sendResult, "a123456"});
            }
            log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{addCampusRequest.getMobile(), sendResult, "a123456"});
        }
        if ((slaveInDB = this.orgSubAccountService.getByOrgId(subAccount.getId())) != null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6b64\u6821\u533a\u5df2\u7ed1\u5b9a\u4e3b\u6821\u533a\uff0c\u4e0d\u53ef\u91cd\u590d\u7ed1\u5b9a");
        }
        OrgSubAccount slave = new OrgSubAccount();
        slave.setAccountType(addCampusRequest.getCampusType());
        slave.setComment(addCampusRequest.getPrincipal());
        slave.setOrgId(subAccount.getId());
        slave.setCreateTime(new Date());
        slave.setPid(TianxiaoPCContext.getOrgId());
        slave.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
        this.orgSubAccountService.addOrgSubAccount(slave);
        OrgSubAccount masterInDB = this.orgSubAccountService.getMaster(TianxiaoPCContext.getOrgId());
        if (masterInDB == null) {
            OrgSubAccount master = new OrgSubAccount();
            master.setAccountType(CampusType.MASTER.getCode());
            master.setCreateTime(new Date());
            master.setOrgId(TianxiaoPCContext.getOrgId());
            master.setPid(Integer.valueOf(0));
            master.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
            this.orgSubAccountService.addOrgSubAccount(master);
        }
        this.addToHag(subAccount.getNumber());
        TXAccount subTXAccount = this.txAccountDao.getByOrgId(subAccount.getId());
        if (subTXAccount != null) {
            subTXAccount.setStatus(TXAccountStatus.PAUSE.getCode());
            this.txAccountDao.update((Object)subTXAccount, new String[0]);
        }
    }

    private void sendMQSMsg(int orgId, long areaId, String mobile) {
        OrganizationRegist regist = new OrganizationRegist();
        regist.setAreaId(Long.valueOf(areaId));
        regist.setMobile(StringUtils.isNotBlank((CharSequence)mobile) ? mobile : "");
        regist.setOrgId(Integer.valueOf(orgId));
        regist.setTime(String.valueOf(System.currentTimeMillis() / 1000L));
        String messageBody = JSONObject.fromObject((Object)regist).toString();
        MqsUtils mqs = new MqsUtils();
        String queueName = PropertiesReader.getValue((String)"mns", (String)"mqs.queue.org.reg");
        mqs.sendMessage(queueName, messageBody);
    }

    private void addToHag(Integer orgNumber) {
        log.info("add to hag orgNumber:{}", (Object)orgNumber);
        if (orgNumber == null) {
            return;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName((Object)orgNumber);
        entities.add(entity);
        WebResponse result1 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tianxiao_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_tianxiao_orgNumber", result1});
        WebResponse result2 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_3810_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_3810_orgNumber", result2});
        WebResponse result3 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tixian_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_tixian_orgNumber", result3});
    }

    private OrgAccount saveOrgAccount(String mobile) {
        OrgAccount saveToDB = new OrgAccount();
        saveToDB.setCreateTime(new Date());
        saveToDB.setMobile(mobile);
        saveToDB.setPassword(PasswordUtil.createHash((String)"a123456"));
        saveToDB.setUpdateTime(new Date());
        this.orgAccountDao.save((Object)saveToDB, new String[0]);
        Integer id = saveToDB.getId();
        if (id == null) {
            throw new BusinessException("\u6d45\u6ce8\u518c\u8d26\u6237\u5931\u8d25");
        }
        saveToDB.setNumber(Integer.valueOf(SerialNumberUtil.generateNumber((int)id, (int)99999999)));
        this.orgAccountDao.update((Object)saveToDB, new String[0]);
        return saveToDB;
    }

    private void saveOrgInfo(Long areaId, int org_id, String shortName, String contacts) {
        OrgInfo info = new OrgInfo();
        Date time = new Date();
        info.setName("");
        info.setShortName(shortName);
        info.setOrgType(Integer.valueOf(0));
        info.setAreaId(areaId);
        info.setContacts(contacts);
        info.setIdCardType(Integer.valueOf(0));
        info.setIdCard("");
        info.setIdCardStorageId(Integer.valueOf(0));
        info.setBizLicense("");
        info.setBizLicenseStorageId(Integer.valueOf(0));
        info.setSchLicenseType(Integer.valueOf(0));
        info.setSchLicense("");
        info.setSchLicenseStorageId(Integer.valueOf(0));
        info.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        info.setRejectReason("");
        info.setRejectReasonOther("");
        info.setSignStatus(Integer.valueOf(SignStatus.UNSIGN.getCode()));
        info.setOrgId(Integer.valueOf(org_id));
        info.setCreateTime(time);
        info.setUpdateTime(time);
        this.orgInfoDao.save((Object)info, new String[0]);
    }

    @Override
    public void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception {
        OrgInfo orgInfo;
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(modCampusRequest.getCampusNumber());
        if (orgAccount == null) {
            return;
        }
        boolean subChange = false;
        OrgSubAccount subAccount = null;
        if (modCampusRequest.getCampusType().intValue() == CampusType.MASTER.getCode().intValue()) {
            subAccount = this.orgSubAccountService.getMaster(orgAccount.getId());
        } else {
            log.debug("mod subCampus orgId:{},pid:{}", (Object)orgAccount.getId(), (Object)TianxiaoPCContext.getOrgId());
            subAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        }
        if (subAccount == null) {
            log.error("Oops! check orgsubAccount data! orgId:{}", (Object)orgAccount.getId());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getPrincipal())) {
            subAccount.setComment(modCampusRequest.getPrincipal());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getCoverUrl())) {
            subAccount.setCoverUrl(modCampusRequest.getCoverUrl());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (subChange) {
            this.orgSubAccountService.update(subAccount);
        }
        if ((orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0])) == null) {
            log.error("Oops! check orgInfo data! orgId:{}", (Object)orgAccount.getId());
            return;
        }
        boolean orgInfoChange = false;
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getCampusName())) {
            orgInfo.setShortName(modCampusRequest.getCampusName());
            orgInfoChange = true;
        }
        if (modCampusRequest.getAreaId() != null && modCampusRequest.getAreaId() > 0L) {
            orgInfo.setAreaId(modCampusRequest.getAreaId());
            orgInfoChange = true;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getPrincipal())) {
            orgInfo.setContacts(modCampusRequest.getPrincipal());
        }
        if (orgInfoChange) {
            orgInfo.setUpdateTime(new Date());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        }
    }

    @Override
    public List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, boolean isAll) throws BussinessException, Exception {
        OrgInfo parentInfo;
        OrgAccount parentAccount;
        List cascadeAccounts;
        int curPageCount;
        List subAccounts;
        List<CampusAccountDto> data = Lists.newArrayList();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        CampusAccountDto master = this.makeMasterDto(orgAccount, orgInfo);
        data.add(master);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(orgAccount.getId());
        if (isAll && CollectionUtils.isNotEmpty((Collection)(subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(orgAccount.getId(), null)))) {
            for (OrgSubAccount subAccount : subAccounts) {
                OrgAccount slaveAccount = this.orgAccountService.getOrgAccountById(subAccount.getOrgId());
                OrgInfo slaveInfo = this.orgInfoDao.getOrgInfo(subAccount.getOrgId(), new String[0]);
                CampusAccountDto slave = this.makeSlaveDto(slaveAccount, slaveInfo, subAccount);
                data.add(slave);
                orgIds.add(slaveAccount.getId());
            }
        }
        if ((curPageCount = (pageDto.getPageNum() - 1) * pageDto.getPageSize()) == 0) {
            if (data.size() >= pageDto.getPageSize()) {
                data = data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - data.size()));
                cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
                if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        parentAccount = this.orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                        parentInfo = this.orgInfoDao.getOrgInfo(parentAccount.getId(), new String[0]);
                        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                        CampusAccountDto cascade = this.makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                        data.add(cascade);
                    }
                }
            }
        } else if (data.size() >= curPageCount) {
            if ((data = data.subList(curPageCount, data.size())).size() >= pageDto.getPageSize()) {
                data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setCurPageCount(Integer.valueOf(0));
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - data.size()));
                cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
                if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        parentAccount = this.orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                        parentInfo = this.orgInfoDao.getOrgInfo(parentAccount.getId(), new String[0]);
                        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                        CampusAccountDto cascade = this.makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                        data.add(cascade);
                    }
                }
            }
        } else {
            pageDto.setCurPageCount(Integer.valueOf(curPageCount - data.size()));
            data.clear();
            cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
            if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                    parentAccount = this.orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                    parentInfo = this.orgInfoDao.getOrgInfo(parentAccount.getId(), new String[0]);
                    TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                    CampusAccountDto cascade = this.makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                    data.add(cascade);
                }
            }
        }
        Integer count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds, null);
        pageDto.setCount(Integer.valueOf(count + orgIds.size()));
        return data;
    }

    private CampusAccountDto makeCascadeDto(OrgAccount orgAccount, OrgInfo orgInfo, TXCascadeCredential credential, TXCascadeAccount cascadeAccount) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(cascadeAccount.getAccountType());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId());
        if (txAccount != null) {
            dto.setCampusType(CampusType.MASTER.getCode());
        } else {
            OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId());
            if (orgSubAccount != null) {
                dto.setCampusType(orgSubAccount.getAccountType());
            }
        }
        dto.setName(credential.getName());
        dto.setMobile(credential.getMobile());
        dto.setStatus(cascadeAccount.getStatus());
        dto.setTitle(cascadeAccount.getTitle());
        dto.setCredentialId(cascadeAccount.getId());
        List rootPermissions = this.txPermissionService.getTXPermissionsList(RootPermission.allRootCode);
        ArrayList groupDtos = Lists.newArrayList();
        Map groupMap = Maps.newHashMap();
        for (TXPermission txPermission : rootPermissions) {
            TXPerssionGroupDto groupDto = new TXPerssionGroupDto();
            groupDto.setCode(txPermission.getCode());
            groupDto.setName(txPermission.getName());
            groupDto.setSubAuths(new ArrayList<TXPermissionNodeDto>());
            groupMap.put(txPermission.getId(), groupDto);
            groupDtos.add(groupDto);
        }
        Map txAccountPermissions = this.txAccountPermissionService.getPermissionMap(cascadeAccount.getId());
        List childPermissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
        for (TXPermission txPermission : childPermissions) {
            TXPerssionGroupDto groupDto = (TXPerssionGroupDto)groupMap.get(txPermission.getParentId());
            if (groupDto == null) continue;
            TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            groupDto.getSubAuths().add(nodeDto);
        }
        dto.setAuth(groupDtos);
        return dto;
    }

    private CampusAccountDto makeSlaveDto(OrgAccount orgAccount, OrgInfo orgInfo, OrgSubAccount subAccount) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        dto.setCampusType(subAccount.getAccountType());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setStatus(subAccount.getStatus());
        dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
        return dto;
    }

    private CampusAccountDto makeMasterDto(OrgAccount orgAccount, OrgInfo orgInfo) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
        dto.setCampusType(CampusType.MASTER.getCode());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setStatus(CampusAccountStatus.NORMAL.getCode());
        dto.setTitle(CampusAccountType.MASTER_PRINCIPAL.getLabel());
        return dto;
    }

    public static void main(String[] args) {
        List list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list = list.subList(5, list.size());
        System.out.println(list);
    }

    @Override
    public boolean addAccount(AddAccountRequest request) {
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (txAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(TianxiaoPCContext.getOrgId());
        List subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
        if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
            for (OrgSubAccount subAccount : subAccounts) {
                orgIds.add(subAccount.getOrgId());
            }
        }
        boolean hasSendSms = false;
        Integer count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds);
        if (count + 1 > txAccount.getCascadeAccountCount() - txAccount.getCampusCount()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
        }
        OrgAccount master = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        TXCascadeCredential credential = this.txCascadeCredentialDao.getByMobile(request.getMobile());
        if (credential == null) {
            credential = new TXCascadeCredential();
            credential.setCreateTime(new Date());
            credential.setMobile(request.getMobile());
            credential.setName(request.getName());
            OrgAccount credentialOrg = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (credentialOrg == null) {
                credential.setPassword(PasswordUtil.createHash((String)"a123456"));
                boolean sendResult = false;
                try {
                    sendResult = SmsSendUtil.sendSms((String)request.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_ORG_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, (boolean)true);
                    hasSendSms = true;
                }
                catch (Throwable e) {
                    log.error("send invite campus sms error:", e);
                }
                if (!sendResult) {
                    log.info("send invite campus sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
                }
                log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
            }
            this.txCascadeCredentialDao.save((Object)credential, new String[0]);
        }
        TXCascadeAccount txCascadeAccount = new TXCascadeAccount();
        txCascadeAccount.setAccountType(request.getType());
        txCascadeAccount.setCreateTime(new Date());
        txCascadeAccount.setCredentialId(credential.getId());
        txCascadeAccount.setOrgId(master.getId());
        txCascadeAccount.setStatus(TXCascadeAccountStatus.VALID.getCode());
        txCascadeAccount.setTitle(request.getTitle());
        this.txCascadeAccountDao.save((Object)txCascadeAccount, new String[0]);
        this.initPermission(txCascadeAccount, request);
        return hasSendSms;
    }

    private void initPermission(TXCascadeAccount txCascadeAccount, AddAccountRequest request) {
        TxAccountPermission txAccountPermission;
        List<TXPerssionGroupDto> auth = request.getAuth();
        if (CollectionUtils.isEmpty(auth)) {
            this.txAccountPermissionService.getAllPermissionsByUId(txCascadeAccount.getId());
            return;
        }
        Map nodeMap = Maps.newHashMap();
        ArrayList appCodes = Lists.newArrayList();
        ArrayList pcCodes = Lists.newArrayList();
        Map appPType = Maps.newHashMap();
        Map pcPType = Maps.newHashMap();
        for (TXPerssionGroupDto txPerssionGroupDto : auth) {
            List<TXPermissionNodeDto> txPermissionNodeDtos = txPerssionGroupDto.getSubAuths();
            for (TXPermissionNodeDto nodeDto : txPermissionNodeDtos) {
                nodeMap.put(nodeDto.getCode(), nodeDto);
                ArrayList appCode = new ArrayList(WebPermissionMapping.appCodeMapping.get((Object)nodeDto.getCode()));
                ArrayList pcCode = new ArrayList(WebPermissionMapping.pcCodeMapping.get((Object)nodeDto.getCode()));
                if (CollectionUtils.isNotEmpty(pcCode)) {
                    pcCodes.addAll(pcCode);
                }
                if (CollectionUtils.isNotEmpty(appCode)) {
                    appCodes.addAll(appCode);
                }
                for (Long code : appCode) {
                    appPType.put("app_" + code, nodeDto.getType());
                    this.specialAPPType(appPType, code, nodeDto, txCascadeAccount);
                }
                for (Long code : pcCode) {
                    pcPType.put("pc_" + code, nodeDto.getType());
                }
            }
        }
        ArrayList txAccountPermissions = Lists.newArrayList();
        List appPermissions = this.txPermissionService.getTXPermissionsList((List)appCodes);
        List pcPermissions = this.txPermissionService.getTXPermissionsList((List)pcCodes);
        log.debug("****************appPermissionsSize:{}", (Object)appPermissions.size());
        log.debug("****************appPermissions:{}", (Object)appPermissions);
        log.debug("****************pcPermissionsSize:{}", (Object)pcPermissions.size());
        log.debug("****************pcPermissions:{}", (Object)pcPermissions);
        for (TXPermission txPermission : appPermissions) {
            txAccountPermission = new TxAccountPermission();
            txAccountPermission.setDeviceType(Integer.valueOf(DeviceType.APP.getCode()));
            txAccountPermission.setCreateTime(new Date());
            txAccountPermission.setPId(txPermission.getId());
            txAccountPermission.setPType((Integer)appPType.get("app_" + txPermission.getCode()));
            txAccountPermission.setUId(txCascadeAccount.getId());
            txAccountPermission.setUType(Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
            txAccountPermissions.add(txAccountPermission);
        }
        for (TXPermission txPermission : pcPermissions) {
            txAccountPermission = new TxAccountPermission();
            txAccountPermission.setDeviceType(Integer.valueOf(DeviceType.PC.getCode()));
            txAccountPermission.setCreateTime(new Date());
            txAccountPermission.setPId(txPermission.getId());
            txAccountPermission.setPType((Integer)pcPType.get("pc_" + txPermission.getCode()));
            txAccountPermission.setUId(txCascadeAccount.getId());
            txAccountPermission.setUType(Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
            txAccountPermissions.add(txAccountPermission);
        }
        this.txAccountPermissionService.saveAll((List)txAccountPermissions);
    }

    private void specialPCType() {
    }

    private void specialAPPType(Map<String, Integer> appPType, Long code, TXPermissionNodeDto nodeDto, TXCascadeAccount txCascadeAccount) {
        if (nodeDto.getType().intValue() != TXPermissionHasType.OWN.getCode()) {
            return;
        }
        if (code.longValue() == TXPermissionConstant.PAIKE_XIANSHI.getCode()) {
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                appPType.put("app_" + code, TXPermissionConstant.PAIKE_XIANSHI.getManagerDef());
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                appPType.put("app_" + code, TXPermissionConstant.PAIKE_XIANSHI.getEmployeeDef());
            }
        }
        if (code.longValue() == TXPermissionConstant.KEBIAO_XIANSHI.getCode()) {
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                appPType.put("app_" + code, TXPermissionConstant.KEBIAO_XIANSHI.getManagerDef());
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                appPType.put("app_" + code, TXPermissionConstant.KEBIAO_XIANSHI.getEmployeeDef());
            }
        }
    }

    @Override
    public void modAccount(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode((int)request.getType());
        switch (accountType) {
            case MASTER_PRINCIPAL: {
                this.modMasterPrincipal(request);
                break;
            }
            case SLAVE_PRINCIPAL: {
                this.modSlavePrincipal(request);
                break;
            }
            case DIRECTOR: {
                this.modDirector(request);
                break;
            }
            case STAFF: {
                this.modDirector(request);
                break;
            }
        }
    }

    private void modMasterPrincipal(ModAccountRequest request) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (StringUtils.isNotBlank((CharSequence)request.getMobile()) && !orgAccount.getMobile().equals(request.getMobile())) {
            if (StringUtils.isBlank((CharSequence)request.getCode())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
            if (!VerifyCodeUtil.valid((boolean)false, (String)orgAccount.getMobile(), (String)request.getCode(), (String)TxSmsCodeType.MOD_ORG_MOBILE.getCacheKey())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
            orgAccount.setMobile(request.getMobile());
            this.orgAccountDao.update((Object)orgAccount, new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
            orgInfo.setContacts(request.getName());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        }
    }

    private void modSlavePrincipal(ModAccountRequest request) {
        OrgSubAccount orgSubAccount;
        if (request.getCampusNumber() == null || StringUtils.isEmpty((CharSequence)request.getCampusName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        orgInfo.setShortName(request.getCampusName());
        orgInfo.setContacts(request.getName());
        orgInfo.setUpdateTime(new Date());
        this.orgInfoDao.update((Object)orgInfo, new String[0]);
        if (!request.getMobile().equals(orgAccount.getMobile()) && (orgSubAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId())) != null) {
            if (orgSubAccount.getAccountType().intValue() == CampusType.LEAGUE.getCode().intValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u52a0\u76df\u5206\u6821\u4e0d\u652f\u6301\u4fee\u6539\u7535\u8bdd\uff0c\u8bf7\u8054\u7cfb\u5e08\u8d44");
            }
            OrgAccount temp = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (temp != null) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.MOBILE_EXIST);
            }
            orgAccount.setMobile(request.getMobile());
            orgAccount.setUpdateTime(new Date());
            this.orgAccountDao.update((Object)orgAccount, new String[0]);
        }
    }

    private void modDirector(ModAccountRequest request) {
        if (request.getCampusNumber() == null || request.getCredentialId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCredentialId(), new String[0]);
        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
        if (cascadeAccount == null || credential == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        cascadeAccount.setOrgId(orgAccount.getId());
        cascadeAccount.setTitle(request.getTitle());
        cascadeAccount.setUpdateTime(new Date());
        this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        if (!credential.getMobile().equals(request.getMobile())) {
            TXCascadeCredential temp = this.txCascadeCredentialDao.getByMobile(request.getMobile());
            if (temp == null) {
                credential.setName(request.getName());
                credential.setUpdateTime(new Date());
                credential.setMobile(request.getMobile());
                this.txCascadeCredentialDao.update((Object)credential, new String[0]);
            } else {
                temp.setName(request.getName());
                temp.setUpdateTime(new Date());
                this.txCascadeCredentialDao.update((Object)temp, new String[0]);
                cascadeAccount.setCredentialId(temp.getId());
                cascadeAccount.setUpdateTime(new Date());
                this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            }
        } else {
            credential.setName(request.getName());
            credential.setUpdateTime(new Date());
            this.txCascadeCredentialDao.update((Object)credential, new String[0]);
        }
        this.modPermission(cascadeAccount, request);
    }

    private void modPermission(TXCascadeAccount cascadeAccount, ModAccountRequest request) {
        List txAccountPermissions = this.txAccountPermissionService.getAllPermissionsByUId(cascadeAccount.getId());
        List<TXPerssionGroupDto> auth = request.getAuth();
        Map nodeMap = Maps.newHashMap();
        Map appPType = Maps.newHashMap();
        Map pcPType = Maps.newHashMap();
        for (TXPerssionGroupDto txPerssionGroupDto : auth) {
            List<TXPermissionNodeDto> txPermissionNodeDtos = txPerssionGroupDto.getSubAuths();
            for (TXPermissionNodeDto nodeDto : txPermissionNodeDtos) {
                nodeMap.put(nodeDto.getCode(), nodeDto);
                ArrayList appCode = new ArrayList(WebPermissionMapping.appCodeMapping.get((Object)nodeDto.getCode()));
                ArrayList pcCode = new ArrayList(WebPermissionMapping.pcCodeMapping.get((Object)nodeDto.getCode()));
                if (CollectionUtils.isNotEmpty(pcCode)) {
                    for (Long code : pcCode) {
                        pcPType.put("pc_" + code, nodeDto.getType());
                    }
                }
                if (!CollectionUtils.isNotEmpty(appCode)) continue;
                for (Long code : appCode) {
                    appPType.put("app_" + code, nodeDto.getType());
                    this.specialAPPType(appPType, code, nodeDto, cascadeAccount);
                }
            }
        }
        Map pcMap = Maps.newHashMap();
        Map appMap = Maps.newHashMap();
        ArrayList pids = Lists.newArrayList();
        for (TxAccountPermission txAccountPermission : txAccountPermissions) {
            if (txAccountPermission.getDeviceType().intValue() == DeviceType.APP.getCode()) {
                appMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
            if (txAccountPermission.getDeviceType().intValue() == DeviceType.PC.getCode()) {
                pcMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
            pids.add(txAccountPermission.getPId());
        }
        List txPermissions = this.txPermissionService.getAllByPid((List)pids);
        for (TXPermission txPermission : txPermissions) {
            TxAccountPermission pc = (TxAccountPermission)pcMap.get(txPermission.getId());
            Integer pcPtype = (Integer)pcPType.get("pc_" + txPermission.getCode());
            if (pc != null && pcPtype != null) {
                pc.setPType(pcPtype);
                pc.setUpdateTime(new Date());
            }
            TxAccountPermission app = (TxAccountPermission)appMap.get(txPermission.getId());
            Integer appPtype = (Integer)appPType.get("app_" + txPermission.getCode());
            if (app == null || appPType == null) continue;
            app.setPType(appPtype);
            app.setUpdateTime(new Date());
        }
        this.txAccountPermissionService.updateAll(txAccountPermissions);
    }

    @Override
    public void modAccountStatus(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode((int)request.getType());
        switch (accountType) {
            case SLAVE_PRINCIPAL: {
                this.modSlavePrincipalStatus(request);
                break;
            }
            case DIRECTOR: {
                this.modDirectorStatus(request);
                break;
            }
            case STAFF: {
                this.modDirectorStatus(request);
                break;
            }
        }
    }

    private void modSlavePrincipalStatus(ModAccountRequest request) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        OrgSubAccount subAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode().intValue()) {
            subAccount.setStatus(request.getStatus());
            subAccount.setUpdateTime(new Date());
            this.orgSubAccountService.update(subAccount);
            this.addToHag(orgAccount.getNumber());
        }
        if (request.getStatus().intValue() == OrgSubAccountStatus.FIRE.getCode().intValue()) {
            subAccount.setStatus(request.getStatus());
            subAccount.setFireTime(new Date());
            subAccount.setUpdateTime(new Date());
            this.orgSubAccountService.update(subAccount);
            this.delInHag(orgAccount.getNumber());
        }
    }

    private void delInHag(Integer orgNumber) {
        log.info("del hag orgNumber:{}", (Object)orgNumber);
        if (orgNumber == null) {
            return;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName((Object)orgNumber);
        entities.add(entity);
        WebResponse result1 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tianxiao_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_tianxiao_orgNumber", result1});
        WebResponse result2 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_3810_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_3810_orgNumber", result2});
        WebResponse result3 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tixian_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_tixian_orgNumber", result3});
    }

    private void modDirectorStatus(ModAccountRequest request) {
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode().intValue()) {
            Integer count;
            if (txAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8d26\u6237\u4e0d\u5b58\u5728");
            }
            ArrayList orgIds = Lists.newArrayList();
            orgIds.add(TianxiaoPCContext.getOrgId());
            List subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId());
                }
            }
            if ((count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds)) + 1 > txAccount.getCascadeAccountCount() - txAccount.getCampusCount()) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
            }
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCredentialId(), new String[0]);
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode().intValue() || request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode().intValue()) {
            cascadeAccount.setStatus(request.getStatus());
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            if (request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode().intValue()) {
                try {
                    this.releaseConsulter(cascadeAccount.getId().longValue());
                    this.orgCourseDao.batchUpdateHeadTeacher(txAccount.getOrgNumber(), cascadeAccount.getId(), Integer.valueOf(-1));
                }
                catch (Exception e) {
                    log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", (Object)cascadeAccount.getId());
                    log.error("modDirectorStatus - releaseConsulter - error:{}", (Throwable)e);
                    throw new BusinessException("\u91ca\u653e\u7ebf\u7d22\u5931\u8d25\uff0c\u53ef\u5c1d\u8bd5\u624b\u52a8\u6e05\u7a7a\u8d26\u53f7\u7ebf\u7d22\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002");
                }
            }
        }
    }

    public void releaseConsulter(Long cascadeId) {
        Date now = new Date();
        List consulterIds = this.consultUserDao.listConsulterUserIdsByCascade(cascadeId);
        log.info("modAccountStatus - consulter - Release - consulterIds:{}, size:{},time:{}", new Object[]{consulterIds, consulterIds.size(), now.getTime()});
        if (CollectionUtils.isNotEmpty((Collection)consulterIds)) {
            this.consultUserDao.release(consulterIds, now);
            ArrayList<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
            for (int i = 0; i > consulterIds.size(); ++i) {
                TxConsulterOperationLog log = new TxConsulterOperationLog((Long)consulterIds.get(i), Long.valueOf(Flag.NULL.getLong()), Long.valueOf(Flag.NULL.getLong()), ConsulterOperation.PUSH_MANUAL);
                manualLogs.add(log);
                if (i % 100 != 0 && i != consulterIds.size() - 1) continue;
                this.txConsulterOperationLogDao.saveAll(manualLogs, new String[0]);
            }
        }
    }
}

