/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.biz.campus.constant.KefuRuleValue;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KefuRuleDto {
    private Integer consultRule;
    private Integer bespeakOrder;
    private List<String> consultMobiles;

    public static KefuRuleDto from(TXKefuRule txKefuRule, OrgTxtMsg txtMsg) {
        if (txKefuRule == null) {
            return null;
        }
        KefuRuleDto dto = new KefuRuleDto();
        dto.setBespeakOrder(txKefuRule.getBespeakRule());
        dto.setConsultRule(txKefuRule.getConsultRule());
        if (txtMsg != null && StringUtils.isNotBlank((CharSequence)txtMsg.getValue())) {
            dto.setConsultMobiles(Lists.newArrayList((Object[])StringUtils.split((String)txtMsg.getValue(), (char)',')));
        }
        return dto;
    }

    public boolean valid() {
        if (this.consultRule != null && this.consultRule.intValue() != KefuRuleValue.CONSULTRULE_IN_TURN.getCode() && this.consultRule.intValue() != KefuRuleValue.CONSULTRULE_RANDOM.getCode()) {
            return false;
        }
        return this.bespeakOrder == null || this.bespeakOrder.intValue() == KefuRuleValue.BESPEAK_RULE_PRIVATE.getCode() || this.bespeakOrder.intValue() == KefuRuleValue.BESPEAK_RULE_PUBLIC.getCode();
    }

    public Integer getConsultRule() {
        return this.consultRule;
    }

    public Integer getBespeakOrder() {
        return this.bespeakOrder;
    }

    public List<String> getConsultMobiles() {
        return this.consultMobiles;
    }

    public void setConsultRule(Integer consultRule) {
        this.consultRule = consultRule;
    }

    public void setBespeakOrder(Integer bespeakOrder) {
        this.bespeakOrder = bespeakOrder;
    }

    public void setConsultMobiles(List<String> consultMobiles) {
        this.consultMobiles = consultMobiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KefuRuleDto)) {
            return false;
        }
        KefuRuleDto other = (KefuRuleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$consultRule = this.getConsultRule();
        Integer other$consultRule = other.getConsultRule();
        if (this$consultRule == null ? other$consultRule != null : !((Object)this$consultRule).equals(other$consultRule)) {
            return false;
        }
        Integer this$bespeakOrder = this.getBespeakOrder();
        Integer other$bespeakOrder = other.getBespeakOrder();
        if (this$bespeakOrder == null ? other$bespeakOrder != null : !((Object)this$bespeakOrder).equals(other$bespeakOrder)) {
            return false;
        }
        List<String> this$consultMobiles = this.getConsultMobiles();
        List<String> other$consultMobiles = other.getConsultMobiles();
        return !(this$consultMobiles == null ? other$consultMobiles != null : !((Object)this$consultMobiles).equals(other$consultMobiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KefuRuleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $consultRule = this.getConsultRule();
        result = result * 59 + ($consultRule == null ? 43 : ((Object)$consultRule).hashCode());
        Integer $bespeakOrder = this.getBespeakOrder();
        result = result * 59 + ($bespeakOrder == null ? 43 : ((Object)$bespeakOrder).hashCode());
        List<String> $consultMobiles = this.getConsultMobiles();
        result = result * 59 + ($consultMobiles == null ? 43 : ((Object)$consultMobiles).hashCode());
        return result;
    }

    public String toString() {
        return "KefuRuleDto(consultRule=" + this.getConsultRule() + ", bespeakOrder=" + this.getBespeakOrder() + ", consultMobiles=" + this.getConsultMobiles() + ")";
    }
}

