/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.utils;

import com.baijia.tianxiao.biz.campus.dto.OrgAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.OrgSubAccountDetailDto;
import com.baijia.tianxiao.biz.campus.utils.PayRestUtils;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PayMentSystemApiHelper {
    private static final String BASE_URL = PropertiesReader.getValue((String)"rest", (String)"rest.appServiceUrl.new");
    private static final String APPID = PropertiesReader.getValue((String)"rest", (String)"rest.appId");
    private static final String APPKEY = PropertiesReader.getValue((String)"rest", (String)"rest.appKey");

    private static boolean isNotNullJsonNode(Object node) {
        return node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]");
    }

    private static String collextionToStr(Collection collection) {
        String result;
        StringBuilder builder = new StringBuilder("");
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next()).append(",");
            }
        }
        if ((result = builder.toString()).endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static RestfulResult<Object> drawCash(Integer client, Long orgId, Integer orgNum, Double ammount, Double feeAmount) throws Exception {
        if (feeAmount == null) {
            feeAmount = 0.0;
        }
        String controller = "org";
        String action = "orgAccountDrawCash";
        HashMap params = Maps.newHashMap();
        params.put("client", client + "");
        params.put("org_id", orgId + "");
        params.put("org_number", orgNum + "");
        params.put("amount", ammount + "");
        params.put("fee_amount", feeAmount + "");
        params.put("timestamp", System.currentTimeMillis() + "");
        params.put("app_id", APPID);
        params.put("auth_token", PayRestUtils.getAuthToken() + "");
        return PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    public static RestfulResult<OrgAccountDetailDto> orgAccountDetail(Integer orgId, Collection<Integer> subOrgIds) throws Exception {
        String controller = "org";
        String action = "orgAccountDetail";
        HashMap params = Maps.newHashMap();
        JSONObject orgIdsJson = new JSONObject();
        orgIdsJson.put((Object)"main", orgId == null ? "" : orgId);
        orgIdsJson.put((Object)"sub", (Object)PayMentSystemApiHelper.collextionToStr(subOrgIds));
        params.put("org_ids", orgIdsJson.toString());
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject((Object)restResult.getData());
            OrgAccountDetailDto dto = new OrgAccountDetailDto();
            dto.setBalance(data.optDouble("balance", 0.0));
            dto.setExpected(data.optDouble("expected", 0.0));
            dto.setIncome(data.optDouble("income", 0.0));
            dto.setIncomeMonth(data.optDouble("income_month", 0.0));
            dto.setIncomeWeek(data.optDouble("income_week", 0.0));
            dto.setFreezeMoney(data.optDouble("freeze_money", 0.0));
            methodResult.setData((Object)dto);
        }
        return methodResult;
    }

    public static RestfulResult<Map<Integer, OrgSubAccountDetailDto>> subOrgAccountDetail(Collection<Integer> subOrgIds) throws Exception {
        JSONObject data;
        JSONArray records;
        String controller = "org";
        String action = "subOrgAccountDetail";
        HashMap params = Maps.newHashMap();
        params.put("sub_org_ids", subOrgIds != null ? subOrgIds.toString() : new ArrayList().toString());
        RestfulResult<Object> restResult = PayRestUtils.rest(PayRestUtils.RestMethod.POST, BASE_URL, controller, action, null, params, null);
        RestfulResult methodResult = new RestfulResult();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());
        HashMap<Integer, OrgSubAccountDetailDto> map = new HashMap<Integer, OrgSubAccountDetailDto>();
        methodResult.setData(map);
        if (PayMentSystemApiHelper.isNotNullJsonNode(restResult.getData()) && (records = (data = JSONObject.fromObject((Object)restResult.getData())).getJSONArray("records")) != null && records.size() > 0) {
            for (int i = 0; i < records.size(); ++i) {
                JSONObject record = records.getJSONObject(i);
                OrgSubAccountDetailDto dto = new OrgSubAccountDetailDto();
                dto.setBalance(record.optDouble("balance", 0.0));
                dto.setEarn(record.optDouble("earn", 0.0));
                dto.setExpected(record.optDouble("expected", 0.0));
                dto.setIncome(record.optDouble("income", 0.0));
                dto.setOrgId(record.getInt("org_id"));
                map.put(dto.getOrgId(), dto);
            }
        }
        return methodResult;
    }
}

