/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.article.service.impl;

import com.baijia.tianxiao.biz.marketing.article.service.ArticleSyncService;
import com.baijia.tianxiao.biz.marketing.utils.SynchMailSender;
import com.baijia.tianxiao.dal.activity.dao.article.ArticleBaseInfoDao;
import com.baijia.tianxiao.dal.activity.po.ArticleBaseInfo;
import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.dal.article.dao.BisArticleInfoDao;
import com.baijia.tianxiao.dal.article.dao.BisChannelInfoDao;
import com.baijia.tianxiao.dal.article.dao.BisFeedChannelDao;
import com.baijia.tianxiao.dal.article.po.BisArticleInfo;
import com.baijia.tianxiao.dal.article.po.BisChannelInfo;
import com.baijia.tianxiao.dal.article.po.BisFeedChannel;
import com.baijia.tianxiao.sal.marketing.article.enums.TouTiaoArticleEnum;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticleSyncServiceImpl
implements ArticleSyncService {
    private static final Logger log = LoggerFactory.getLogger(ArticleSyncServiceImpl.class);
    @Autowired
    private BisChannelInfoDao bisChannelInfoDao;
    @Autowired
    private BisFeedChannelDao bisFeedChannelDao;
    @Autowired
    private BisArticleInfoDao bisArticleInfoDao;
    @Autowired(required=false)
    private ArticleBaseInfoDao articleBaseInfoDao;
    @Autowired
    private RedisService redisService;
    public static final Long ONE_DAY = 86400000L;

    @Override
    public void syncArticle() {
        log.debug(" begin to syncArticles ");
        List typeDescs = TouTiaoArticleEnum.getTypeDescs();
        if (GenericsUtils.isNullOrEmpty((Object)typeDescs)) {
            return;
        }
        List listBisChannelInfos = this.bisChannelInfoDao.listBisChannelInfos(typeDescs);
        List listOtherBisChannelInfos = this.bisChannelInfoDao.listOtherBisChannelInfos(typeDescs);
        listBisChannelInfos.addAll(listOtherBisChannelInfos);
        log.info("find all bisChannelInfos are : {} ", (Object)listBisChannelInfos);
        if (GenericsUtils.isNullOrEmpty((Object)listBisChannelInfos)) {
            return;
        }
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(1000));
        HashMap typeCounts = Maps.newHashMap();
        for (BisChannelInfo bisChannelInfo : listBisChannelInfos) {
            log.info("begin to sync type : {} ", (Object)bisChannelInfo);
            Long curSysnTime = this.getPreSyncTime(bisChannelInfo.getName());
            Long channelId = bisChannelInfo.getId();
            List listFeedIdsWithPublistTime = this.bisFeedChannelDao.listFeedIdsWithPublistTime(channelId, curSysnTime.longValue(), pageDto);
            if (GenericsUtils.isNullOrEmpty((Object)listFeedIdsWithPublistTime)) {
                log.info("can not find any feedChannel with channel type : {} ", (Object)bisChannelInfo.getName());
                continue;
            }
            List articleIds = ListUtil.toKeyList((Collection)listFeedIdsWithPublistTime, (String)"feedId", BisFeedChannel.class);
            try {
                int count = this.searchArticleAndReStore(TouTiaoArticleEnum.getCategory((String)bisChannelInfo.getName()), articleIds);
                typeCounts.put(bisChannelInfo.getName(), count);
            }
            catch (Exception e) {
                log.error("can not insert docs for type : {} cause by : {} ", (Object)bisChannelInfo.getName(), (Object)e);
            }
            this.reSetLastSyncTime(bisChannelInfo.getName(), (BisFeedChannel)listFeedIdsWithPublistTime.get(listFeedIdsWithPublistTime.size() - 1));
        }
        SynchMailSender.sendNotifyMail(typeCounts);
    }

    private void reSetLastSyncTime(String name, BisFeedChannel bisFeedChannel) {
        String key = this.createSpecialKey(name);
        this.redisService.setKey(key, (Object)bisFeedChannel.getPublishTime().getTime());
        log.info("reset last sync time to : {} and the type name is : {} ", (Object)ArticleSyncServiceImpl.getStrByDateFormate(new Date(bisFeedChannel.getPublishTime().getTime()), "yyyy-MM-dd HH:mm:ss"), (Object)name);
    }

    private Long getPreSyncTime(String name) {
        String key = this.createSpecialKey(name);
        Long syncTime = (Long)this.redisService.getKeyValue(key);
        if (syncTime == null) {
            log.info("pre sync time is not exists ,and will use current time to startup sync task");
            syncTime = new Date().getTime() - 10L * ONE_DAY;
        }
        return syncTime;
    }

    private String createSpecialKey(String name) {
        String format = "SYNC_ONELINE_ARTICLE:%s";
        return String.format(format, name);
    }

    private int searchArticleAndReStore(Integer category, List<Long> listFeedIdsWithPublistTime) {
        log.info("begin to search all article ,and the length of ids is : {}  ", (Object)listFeedIdsWithPublistTime.size());
        List listBisArticleInfos = this.bisArticleInfoDao.listBisArticleInfos(listFeedIdsWithPublistTime);
        log.info("find all articles's size is : {} ", (Object)listBisArticleInfos.size());
        if (GenericsUtils.notNullAndEmpty((Object)listBisArticleInfos)) {
            List<ArticleBaseInfo> articles = this.toArticles(category, listBisArticleInfos);
            this.articleBaseInfoDao.insertArticles(articles);
            return listBisArticleInfos.size();
        }
        return 0;
    }

    private List<ArticleBaseInfo> toArticles(Integer category, List<BisArticleInfo> listBisArticleInfos) {
        ArrayList articles = Lists.newArrayListWithCapacity((int)listBisArticleInfos.size());
        for (BisArticleInfo bisArticle : listBisArticleInfos) {
            ArticleDetail articleDetail = new ArticleDetail();
            articleDetail.setAbstractContent(bisArticle.getSummary());
            String coverUrl = bisArticle.getCoverUrl();
            if (GenericsUtils.isNullOrEmpty((Object)coverUrl)) continue;
            String[] coverUrls = coverUrl.split(",");
            articleDetail.setArticleImg(coverUrls[0]);
            String title = bisArticle.getTitle();
            title = title.replaceAll("\\s+", "");
            articleDetail.setArticleTitle(title);
            articleDetail.setArticleUrl(bisArticle.getOriArticleUrl());
            String author = bisArticle.getAuthor();
            author = GenericsUtils.isNullOrEmpty((Object)author) ? "\u5929\u6821" : author;
            articleDetail.setAuthor(author);
            articleDetail.setContent(bisArticle.getContent());
            articleDetail.setCreateTime(Long.valueOf(bisArticle.getCreateTime().getTime()));
            String pushTime = ArticleSyncServiceImpl.getStrByDateFormate(bisArticle.getPublishTime(), "yyyy-MM-dd HH:mm:ss");
            articleDetail.setPushTime(pushTime);
            int baseCount = RandomUtils.nextInt((int)9000);
            String thumbUpCount = String.valueOf(baseCount);
            articleDetail.setThumbUpCount(thumbUpCount);
            int visitCountBase = baseCount + RandomUtils.nextInt((int)9000);
            String visitCount = String.valueOf(visitCountBase);
            articleDetail.setVisitCount(visitCount);
            articleDetail.setCategory(category.intValue());
            articles.add(articleDetail);
        }
        return articles;
    }

    public static String getStrByDateFormate(Date date, String formate) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(formate);
        String str = dateformat1.format(date);
        return str;
    }
}

