
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.marketing.smsGroupSend.service.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

import com.baijia.tianxiao.consants.UserRole;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.marketing.dto.SmsSendResponse;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.RedissonService;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.TxMarktingSmsService;
import com.baijia.tianxiao.biz.marketing.utils.CompletionableExecutor;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsAccountDao;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsAccount;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.commons.utils.SmsUtils;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.RecordRespDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 22, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
@Service
public class TxMarktingSmsServiceImpl implements TxMarktingSmsService {

    public static final Long LOCK_TIMEOUT = 60000L;

    @Autowired
    private SmsAccountDao smsAccountDao;
    @Autowired(required = false)
    private RedissonService redissonService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    // @Autowired
    // private ShardedJedisPool pool;

    /**
     * 获取当前机构当月剩余的短信额度,只用于调用代码做一次判断，不加锁控制
     */
    @Override
    public Integer leftSmsCount(Long orgId) {
        Timestamp dataMonth = SmsAccount.createDataMonth();
        SmsAccount smsAccountInfo = this.smsAccountDao.getSmsAccountInfo(orgId, dataMonth);
        if (smsAccountInfo == null) {
            return RecordRespDto.system_limit;
        } else {
            // 使用DB配置的发送上限
            return smsAccountInfo.getCountLimit() - smsAccountInfo.getTotalCount();
        }
    }

    /*
     * 
     * @see
     * com.baijia.tianxiao.biz.marketing.smsGroupSend.service.TxMarktingSmsService#sendSmsMessage(java.util.Collection,
     * java.lang.String)
     * 
     * @UnThreadSafe :当前没有对多线程进行控制
     */
    @Override
    public SmsSendResponse sendSmsMessage(Long orgId, Collection<StudentDto> studentDtos, String content) {

        if (GenericsUtils.isNullOrEmpty(content) || GenericsUtils.isNullOrEmpty(studentDtos)) {
            return SmsSendResponse.newInstance(SmsSendResult.FAILED, 0);
        }

        int countOfSms = SmsUtils.countContentSimple(content);
        int totalSucc = 0;

        Map<String, List<Long>> mobileStudentIdMaps = Maps.newHashMap();
        for (StudentDto dto : studentDtos) {
            String mobile = dto.getMobile();
            List<Long> list = mobileStudentIdMaps.get(mobile);
            if (GenericsUtils.isNullOrEmpty(list)) {
                list = Lists.newArrayList();
                mobileStudentIdMaps.put(mobile, list);
            }
            list.add(dto.getId());
        }
        String branchSchoolName = getOrgName(orgId);
        Set<String> mobiles = mobileStudentIdMaps.keySet();
        List<CallableTask> callableTasks = Lists.newArrayListWithCapacity(studentDtos.size());
        for (String mobile : mobiles) {
            callableTasks.add(new CallableTask(orgId,mobile, content, branchSchoolName));
        }

        // RedisLock lock = getRedisLock(orgId);
        // RLock lock = getLock(orgId);
        List<String> executeTasks = null;
        // 如果当前发送没有失败的，则返回的SmsSendResponse对象中,失败学员id的集合是空的，否则该是null的
        List<Long> failureIds = Lists.newArrayList();
        // lock.tryLock(LOCK_TIMEOUT, TimeUnit.MILLISECONDS);
        try {
            Integer leftSmsCount = this.leftSmsCount(orgId);
            if (leftSmsCount <= 0 || (leftSmsCount < mobiles.size() && leftSmsCount < RecordRespDto.system_limit)) {
                return SmsSendResponse.newInstance(SmsSendResult.FAILED, 0);
            }
            // 发送的逻辑是否需要放在锁控制区域
            executeTasks = CompletionableExecutor.executeTasks(callableTasks);
            for (String retInfo : executeTasks) {
                String[] retInfos = retInfo.split(":");
                String mobile = retInfos[0];
                Boolean isOk = Boolean.valueOf(Boolean.parseBoolean(retInfos[1]));
                if (isOk) {
                    totalSucc++;
                } else {
                    failureIds.addAll(mobileStudentIdMaps.get(mobile));
                    log.info("mobile :{} ,and with this mobile has student's count:{}", mobile,
                        mobileStudentIdMaps.get(mobile).size());
                }
            }
            SmsAccount smsAccountInfo = smsAccountDao.getSmsAccountInfo(orgId, SmsAccount.createDataMonth());
            if (smsAccountInfo == null) {
                smsAccountInfo = SmsAccount.newInstance(orgId);
            }
            smsAccountInfo.setCountLimit(RecordRespDto.system_limit);
            smsAccountInfo.setTotalCount(smsAccountInfo.getTotalCount() + totalSucc * countOfSms);
            log.info("saveOrUpdate smsAccount : {} ", smsAccountInfo);
            this.smsAccountDao.saveOrUpdate(smsAccountInfo);
        } catch (Exception e) {
            log.error("error while send messages ", e);
            throw new RuntimeException("error ,and will tracaction roll-back");
        } finally {
            // lock.unlock();
        }
        mobileStudentIdMaps.clear();

        SmsSendResponse resp = SmsSendResponse.newInstance(SmsSendResult.FAILED, totalSucc);
        if (totalSucc != 0) {
            resp.setResult(SmsSendResult.SUCCESS);
            resp.setFailureIds(failureIds);
        } else {
            resp.setFailureIds(null);
            log.info("totalSendSucc is 0 ");
        }
        log.info("smsSendResponse is : {} ", resp);
        return resp;
    }

    public static final String OWN_LOCK = "lockValue";

    /**
     * @param orgId
     * @return
     */
    // private RedisLock getRedisLock(Long orgId) {
    // RedisUtil redisUtil = new RedisUtil(pool);
    // String key = this.createLockKey(orgId);
    // String owner = OWN_LOCK;
    // long expireTime = LOCK_TIMEOUT;
    // TimeUnit expireTimeUnit = TimeUnit.MILLISECONDS;
    // RedisLock lock = new RedisLock(redisUtil, key, owner, expireTime, expireTimeUnit);
    // return lock;
    // }

    /**
     * @param orgId
     * @return
     */
    private String getOrgName(Long orgId) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue(), "name", "shortName");
        if (orgInfo == null) {
            throw new BussinessException(CommonErrorCode.NO_LOGIN, "当前机构未登录或机构不存在");
        }
        String name = orgInfo.getName();
        name = GenericsUtils.isNullOrEmpty(name) ? orgInfo.getShortName() : name;
        return name;
    }

    @SuppressWarnings("unused")
    private RLock getLock(Long orgId) {
        String lockKey = this.createLockKey(orgId);
        RedissonClient client = this.redissonService.getClient();
        RLock lock = client.getLock(lockKey);
        return lock;
    }

    public static final String LOCK_FORMAT = "lock:smsSend:%s";
    public static final String MOBILE_RESULT = "%s:%s"; // mobile:false/true
    // {通知} + 短信内容+机构校区名+回t退订+【天校】
    public static final String SMS_CONTENT_FORMAT = "[通知]   %s %s 回t退订【天校】";

    private String createLockKey(Long orgId) {
        return String.format(LOCK_FORMAT, orgId);
    }

    static class CallableTask implements Callable<String> {

        private String mobile;
        private String content;
        private Long orgId;

        public CallableTask(Long orgId , String mobile, String content, String branchSchoolName) {
            this.orgId = orgId;
            this.mobile = mobile;
            this.content = String.format(SMS_CONTENT_FORMAT, content, branchSchoolName);
        }

        /*
         * (non-Javadoc)
         * 
         * @see java.util.concurrent.Callable#call()
         */
        @Override
        public String call() throws Exception {
            boolean isOk = false;
            try {
                isOk = SmsSendUtil.sendSms(mobile, content, SmsMessageType.TIANXIAO_NOTIFY.getCode(), this.orgId.intValue(), UserRole.ORGANIZATION.getRole());
            } catch (Exception e) {
                log.error("can not send sms to mobile : {} cause by : {} ", mobile, e);
            }
            return String.format(MOBILE_RESULT, this.mobile, isOk);
        }
    }

}
