package com.baijia.tianxiao.biz.marketing.referral.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.marketing.referral.service.QRCodeService;
import com.baijia.tianxiao.sal.marketing.commons.utils.QRCodeUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Mar 4, 2016 10:48:37 AM
 * @desc :
 */
@Slf4j
@Service
public class QRCodeServiceImpl implements QRCodeService {

    @Override
    public byte[] findQRCode(String url) {
        String path = System.getProperty("java.io.tmpdir");
        String fileName = org.apache.commons.codec.binary.Base64.encodeBase64(url.getBytes()) + ".png";
        byte[] buffer = new byte[2048];
        String filePath = path + File.separator + fileName;
        log.info("filepath is : {} ", filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            log.info("file was not  exists");
            generatorQRCode(file, url);
        }
        InputStream input = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            input = new FileInputStream(file);
            int len = 0;
            while ((len = input.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            log.info("length is :{}", baos.toByteArray().length);
            baos.flush();
        } catch (Exception e) {
            log.error("generator qrCode failure cause by :{} ", e);
        } finally {
            IOUtils.closeQuietly(input);
        }
        return baos.toByteArray();
    }

    public void generatorQRCode(File file, String url) {
        OutputStream out = null;
        try {
            file.createNewFile();
            out = new FileOutputStream(file);
            QRCodeUtils.genQrCode(url, out);
            out.flush();
        } catch (Exception e) {
            log.error("generator qrcode fail cause by : {}", e);
        } finally {
            if (out != null) {
                IOUtils.closeQuietly(out);
            }
        }
    }

    @Override
    public void createQRCode(String text, OutputStream stream) {
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(new String(text.getBytes("UTF-8"), "ISO-8859-1"),
                BarcodeFormat.QR_CODE, 260, 260);
            MatrixToImageWriter.writeToStream(bitMatrix, "png", stream);
        } catch (WriterException e) {
            log.error("[CreateQRCode]", e);
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            log.error("[CreateQRCode]", e);
            e.printStackTrace();
        } catch (IOException e) {
            log.error("[CreateQRCode]", e);
            e.printStackTrace();
        }
    }

}
