/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.constant.AccountTypeEnum;
import com.baijia.tianxiao.biz.marketing.export.constant.CompusType;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgTypeDto;
import com.baijia.tianxiao.biz.marketing.export.service.OrgTypeService;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年6月8日
* @desc 
 */
@Slf4j
@Service
public class OrgTypeServiceImpl implements OrgTypeService{
    @Autowired
    OrgAccountDao orgAccountDao;
    @Autowired
    TXAccountDao txAccountDao;
    @Autowired
    OrgSubAccountDao orgSubAccountDao;
    

    @Override
    public Map<Long, OrgTypeDto> getOrgTypeDtoMap(List<Long> TianxiaoOrgIds) {
        Map<Long, OrgTypeDto> orgTypeDtoMap = new HashMap<>();
        
        //机构orgId与orgNumber映射关系
        Map<Long, Integer> orgIdMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        //获取机构类型
        Map<Long, TXAccount> txAccountMap = this.txAccountDao.getAccountTypeMap(TianxiaoOrgIds);
        
        //判断机构类型  是否有主分校区
        List<OrgSubAccount> orgSubAccounts = this.orgSubAccountDao.getOrgSubAccountByOrgIds(TianxiaoOrgIds, 
            OrgSubAccountStatus.NORMAL.getCode());
        
        //子校区的主校区orgNumber与子校区orgId映射关系，主键是子帐号orgId,值是其对应主校区orgNumber
        Map<Long, Integer> mainOrgNumberMap = new HashMap<>();
        Map<Long, List<Long>> orgSubIdsMap = new HashMap<>();
        if(GenericsUtils.notNullAndEmpty(orgSubAccounts)){
            for(OrgSubAccount orgSubAccount : orgSubAccounts){
                Integer pid = orgSubAccount.getPid();
                Long orgId = orgSubAccount.getOrgId().longValue();
                if(pid != OrgSubAccount.MASTER_PID){ //说明pid是主账号，此时orgId是其分校区
                    List<Long> orgSubIds = orgSubIdsMap.get(pid.longValue());
                    if(GenericsUtils.isNullOrEmpty(orgSubIds)){
                        orgSubIds = new ArrayList<>();
                        orgSubIdsMap.put(pid.longValue(), orgSubIds);
                    }
                    orgSubIds.add(orgId);
                    Integer mainOrgNumber = orgIdMap.get(pid.longValue());
                    mainOrgNumberMap.put(orgId, mainOrgNumber);
                }
                
                int compusType = orgSubAccount.getAccountType();
                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if(GenericsUtils.isNullOrEmpty(orgTypeDto)){
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                String compusTypeDesc = null;
                if(compusType == 0){
                    compusTypeDesc = "";
                }else{
                    compusTypeDesc = CompusType.getCompusTypeByCode(compusType).getMessage();
                }
                orgTypeDto.setCompusTypeDesc(compusTypeDesc);
            }
        }
        
        //进行子校区类型填充
        if(GenericsUtils.notNullAndEmpty(orgSubIdsMap)){
            for(Long mainOrgId : orgSubIdsMap.keySet()){
                TXAccount account = txAccountMap.get(mainOrgId);
                if(GenericsUtils.notNullAndEmpty(account)){
                    List<Long> subOrgIds = orgSubIdsMap.get(mainOrgId);
                    for(Long subOrgId : subOrgIds){
                        txAccountMap.put(subOrgId, account);
                    }
                }
            }
            log.info("填充后txAccountTypeMap param:{}", txAccountMap.size());
        }
        
        //机构类型 以及机构版本类型填充(定制版。大众版。白金版等等)
        for(Long orgId : txAccountMap.keySet()){
            TXAccount account = txAccountMap.get(orgId);
            String accountTypeDesc = AccountTypeEnum.getAccountTypeEnumByCode(account.getAccountType()).getLabel();
            OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
            if(GenericsUtils.isNullOrEmpty(orgTypeDto)){
                orgTypeDto = new OrgTypeDto();
                orgTypeDtoMap.put(orgId, orgTypeDto);
            }
            TXAccountType accountTypeEumn = null;
            if(account.getVipLevel() != TXAccountType.ERROR_TYPE.getCode()){
                accountTypeEumn = TXAccountType.getTXAccountTypeByCode(account.getVipLevel());
            }
            if(accountTypeEumn != null){
                orgTypeDto.setOrgVipLevelStr(accountTypeEumn.getLabel());
            }else{
                orgTypeDto.setOrgVipLevelStr("");
            }
            orgTypeDto.setAccountType(account.getAccountType());
            orgTypeDto.setAccountTypeDesc(accountTypeDesc);
        }
        
        //机构主分校区类型
        for(Long orgId : mainOrgNumberMap.keySet()){
            Integer subOrgNumber = mainOrgNumberMap.get(orgId);
            OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
            if(GenericsUtils.isNullOrEmpty(orgTypeDto)){
                orgTypeDto = new OrgTypeDto();
                orgTypeDtoMap.put(orgId, orgTypeDto);
            }
            orgTypeDto.setSubOrgNumber(subOrgNumber);
        }
        
        return orgTypeDtoMap;
    }
    
}
