
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.marketing.dto;

import java.util.List;

import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.Data;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 25, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
public class SmsSendResponse {

    private SmsSendResult result;
    private int totalCount;
    // 如果当前发送没有失败的，则返回的SmsSendResponse对象中,失败学员id的集合是空的，否则该是null的
    private List<Long> failureIds;

    public static SmsSendResponse newInstance(SmsSendResult resultStatus, Integer totalSuccCount) {
        SmsSendResponse resp = new SmsSendResponse();
        resp.setResult(resultStatus);
        resp.setTotalCount(totalSuccCount);
        return resp;
    }

    public String getFailureIdsStr() {
        if (GenericsUtils.isNullOrEmpty(this.failureIds)) {
            return "";
        }
        StringBuilder failureReceiver = new StringBuilder();
        for (Long studentId : this.failureIds) {
            failureReceiver.append(studentId).append(",");
        }
        return GenericsUtils.deleteLastCharToString(failureReceiver);
    }

}
