package com.baijia.tianxiao.biz.marketing.activity.service.impl;

import com.baijia.tianxiao.biz.marketing.activity.service.BizActivityService;
import com.baijia.tianxiao.biz.marketing.utils.PictureUtil;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityDetailDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityEnrollDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityRenderDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivitySearchRequest;
import com.baijia.tianxiao.sal.marketing.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityService;
import com.baijia.tianxiao.sal.marketing.activity.service.EnrollService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.ResultType;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.CsvUtils;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.mail.Session;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/4/9.
 */
@Service
@Slf4j
public class BizActivityServiceImpl implements BizActivityService {
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private EnrollService enrollService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private EnrollDao enrollDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ActivityConfDao activityConfDao;
    @Autowired
    private TemplateDao templateDao;

    @Override
    public ActivityRenderDto renderActivity(Long activityId, Long orgId) {
        if (activityId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(activityId, orgId, null);
        if (activity == null) {
            return null;
        }

        Map<Long, ActivityConf> confMap = this.activityConfDao.getConfigMapByActivityIds(Arrays.asList(activityId));

        ActivityDetailDto tempDto = new ActivityDetailDto();
        if (activity != null && confMap != null) {
            if (confMap.get(activityId) != null) {
                tempDto = ActivityDetailDto.buildResponse(activity, confMap.get(activityId));
            } else {
                tempDto = ActivityDetailDto.buildResponse(activity);
            }
        }
        ActivityRenderDto dto = new ActivityRenderDto();
        try {
            BeanUtils.copyProperties(dto, tempDto);
            int enrollCount = enrollDao.getEnrollCount(activityId);
            dto.setEnrollCount(enrollCount);
            OrgInfoSimpleDto simple = orgInfoService.getOrgInfo(Long.valueOf(activity.getOrgId()));

            // 微官网连接
            String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + simple.getOrgNumber();
            dto.setOrgWeiPage(weiPage);

            dto.setOrgLogo(simple.getLogo());
            dto.setOrgName(simple.getShortName());
            dto.setOrgNumber(simple.getOrgNumber());
        } catch (Exception e) {
            log.error("renderActivity error!", e);
        }
        return dto;
    }

    /**
     * 进行邮件发送
     */
    @Override
    public ResultWrapper<String> sendEmail(ActivitySearchRequest request) {
        log.info(" begin to send mail ");
        final Long orgId = request.getOrgId();
        final Long activityId = request.getId();
        ResultWrapper<String> rr = new ResultWrapper<String>();
        rr.setRetType(ResultType.FAIL);
        rr.setRetDesc("参数异常");

        OrgInfoSimpleDto simple = null;
        try {
            simple = orgInfoService.getOrgInfo(orgId);
        } catch (Exception e) {
            log.info("can not find an org with org_ID {}", orgId);
            return rr;
        }

        final String orgName = simple.getShortName();
        final ActivityDetailDto activityDetail = activityService.getActivityDetail(request);
        if (activityDetail == null) {
            log.info("can not find activityDetial with id : {} ", request.getId());
            return rr;
        }
        final List<ActivityEnrollDto> enrollList = enrollService.getEnrollList(request.getId(), null);
        // logger.info("activityDetail is : {}", activityDetail.toString());
        if (GenericsUtils.isNullOrEmpty(enrollList)) {
            log.info(" enroll is empty  ");
            return rr;
        }

        log.info("can send mail ");
        boolean isNotLimited =
            redisService.addOrgEmailCount(orgId, activityId, activityDetail.getTemplateTypeId(), EmailType.ACCESS);
        if (!isNotLimited) {
            log.info("次数已达上限，请明天再发");
            return ResultWrapper.<String> getInstance(false)
                .setRetDesc("今日已发送" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "次，请明日再试");
        }
        final String email = request.getEmail();
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                File csvFile = null;
                try {
                    Mail mail = new Mail();
                    String from = ConstantEnums.MAILBOX_FROM.value();
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    String subject = ConstantEnums.MAILBOX_SUBJECT.value();
                    String content = ConstantEnums.MAILBOX_CONTENT.value();
                    content = content.replace("{#ORG_NAME#}", orgName);
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);

                    CsvUtils.CsvContent csvContent = getCsvFileContent(activityDetail, enrollList);
                    try {
                        String filename = activityDetail.getId() + "_" + DateUtil.getStrByDate(new Date()) + ".csv";
                        csvFile = CsvUtils.writerToCsvFile(null, csvContent, filename);
                        if (csvFile == null) {
                            log.info("csvFile is null ");
                        }
                        log.info("csvFile path is : {}", csvFile.getAbsolutePath());
                        if (csvFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(csvFile.getName());
                            fileAttach.setFile(csvFile);
                            fileAttach.setFileName(csvFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    } catch (Exception e) {
                        log.error("error :", e);
                    }

                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                } finally {
                    if (csvFile != null) {
                        csvFile.delete();
                    }
                }
            }
        });
        return ResultWrapper.<String> getInstance(true).setRetDesc("发送成功");
    }

    private CsvUtils.CsvContent getCsvFileContent(ActivityDetailDto activityDetail,
        List<ActivityEnrollDto> enrollList) {
        String activityName = activityDetail.getName();
        CsvUtils.CsvContent csvContent = new CsvUtils.CsvContent();
        String headRow = new StringBuilder("活动名称:").append(activityName).toString();
        csvContent.addRowBean(CsvUtils.RowBean.createRowType(headRow));
        String[] heads = "姓名,电话,其他,报名时间".split(",");
        List<String> rowLists = new ArrayList<>();
        for (ActivityEnrollDto aed : enrollList) {
            StringBuilder sb = new StringBuilder();
            sb.append(aed.getName()).append(",").append(aed.getMobile()).append(",");
            List<String> otherInfos = getOtherInfosFromJson(String.valueOf(aed.getContent()));
            if (GenericsUtils.notNullAndEmpty(otherInfos)) {
                for (String info : otherInfos) {
                    sb.append(info).append("/");
                }
                sb.deleteCharAt(sb.toString().length() - 1);
            } else {
                sb.append("无");
            }
            sb.append(",").append(DateUtil.getStrByDateFormate(new Date(aed.getCreateTime()), "yyyy/MM/dd HH:mm:ss"));
            rowLists.add(sb.toString());
        }
        csvContent.addRowBean(CsvUtils.RowBean.createTableType(heads, rowLists));
        return csvContent;
    }

    private List<String> getOtherInfosFromJson(String content) {
        return Arrays.asList(content.split(","));
    }

    @Override
    public ShareDto getShareInfo(Long activityId, Long orgId) {
        ShareDto dto = new ShareDto();
        Activity activity = activityDao.getActivityByIdAndOrgId(activityId, orgId);
        ActivityConf activityConf = activityConfDao.getConfigByActivityId(activity.getId());
        dto.setTitle(activity.getTitle());
        try {
            String logo = orgInfoService.getOrgInfo(activity.getOrgId().longValue()).getLogo();
            dto.setImageUrl(PictureUtil.handlePictureSize(logo));
        } catch (Exception e) {
            e.printStackTrace();
        }
        dto.setContent(getContent(activity.getTitle()));
        dto.setShareUrl(getActivityUrl(activityConf.getTemplateId(), activityId));
        return dto;
    }

    private String getContent(String name) {
        String str = "我刚参加了这个很棒的活动，邀您也来参加“" + name + "”，机会不是天天有，该出手时就出手哦...";
        return str;
    }

    private String getUrl(long activityId) {
        StringBuilder sb = new StringBuilder();
        sb.append(Config.DOMAIN);
        sb.append("/activity.html?activityId=").append(activityId);
        return sb.toString();
    }
    
    private String getActivityUrl(Integer templateId, Long activityId){
        String templateUrl = TemplateConstant.getTemplateUrl(templateId);
        templateUrl = templateUrl.replaceAll("templateId=\\d+", "");
        String url = Config.DOMAIN + templateUrl + "activityId=" + activityId;
        return url;
        
    }

}
