/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.utils;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionableExecutor {
    private static final Logger log = LoggerFactory.getLogger(CompletionableExecutor.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(500);

    public static <T> List<T> executeTasks(Collection<? extends Callable<T>> tasks) {
        if (GenericsUtils.isNullOrEmpty(tasks)) {
            return GenericsUtils.emptyList();
        }
        ExecutorCompletionService<T> completionService = new ExecutorCompletionService<T>(executor);
        ArrayList rets = Lists.newArrayListWithCapacity((int)tasks.size());
        for (Callable<T> task : tasks) {
            completionService.submit(task);
        }
        try {
            int t = 0;
            int n = tasks.size();
            while (t < n) {
                Future f = completionService.take();
                Object retT = f.get();
                rets.add(retT);
                ++t;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("cause error : {} ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return rets;
    }
}

