/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.dto.CoursePurchaseDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ERPStatisticServiceImpl
implements ERPStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ERPStatisticServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseSmsDao orgCourseSmsDao;
    @Autowired
    private OrgLessonCommentDao OrgLessonCommentDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private OrgFinanceAccountService orgFinanceAccountService;

    @Override
    public Map<Long, ERPStatisticData> getERPDatas(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers, List<Long> TianxiaoOrgIds) {
        Map commentByTeachers;
        Map commentByStudents;
        Map map;
        Map signStudentTotals;
        Map signLessonTotals;
        Map incomeTotals;
        Map courseSmsTotals;
        Map lessonTotals;
        Map arrangedClassTotals;
        Object erpStatisticData;
        HashMap<Long, ERPStatisticData> ERPDataMap = new HashMap<Long, ERPStatisticData>();
        Map courseTotals = this.orgCourseDao.getCourseTotal(startTime, endTime, TianxiaoOrgNumbers, null, null, null);
        if (GenericsUtils.notNullAndEmpty((Object)courseTotals)) {
            ArrayList<Integer> orgNumbers = new ArrayList<Integer>();
            for (Integer orgNumber : courseTotals.keySet()) {
                orgNumbers.add(orgNumber);
            }
            List orgAccounts = this.orgAccountDao.getAccountByNumbers(orgNumbers, new String[0]);
            for (OrgAccount orgAccount : orgAccounts) {
                Integer number = orgAccount.getNumber();
                Long orgId = orgAccount.getId().longValue();
                erpStatisticData = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData);
                }
                ((ERPStatisticData)erpStatisticData).setCourseTotal(courseTotals.get(number) == null ? 0 : (Integer)courseTotals.get(number));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(arrangedClassTotals = this.orgClassLessonDao.getArrangedClassCount(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : arrangedClassTotals.keySet()) {
                Object erpStatisticData2 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData2 == null) {
                    erpStatisticData2 = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData2);
                }
                ((ERPStatisticData)erpStatisticData2).setArrangedClassTotal(arrangedClassTotals.get(orgId) == null ? 0 : (Integer)arrangedClassTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(lessonTotals = this.orgClassLessonDao.getLessonTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : lessonTotals.keySet()) {
                Object erpStatisticData3 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData3 == null) {
                    erpStatisticData3 = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData3);
                }
                ((ERPStatisticData)erpStatisticData3).setLessonTotal(lessonTotals.get(orgId) == null ? 0 : (Integer)lessonTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(courseSmsTotals = this.orgCourseSmsDao.courseSmsTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : courseSmsTotals.keySet()) {
                Object erpStatisticData4 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData4 == null) {
                    erpStatisticData4 = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData4);
                }
                ((ERPStatisticData)erpStatisticData4).setCourseSmsTotal(courseSmsTotals.get(orgId) == null ? 0 : (Integer)courseSmsTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(incomeTotals = this.coursePurchaseDao.getIncomeTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : incomeTotals.keySet()) {
                erpStatisticData = (ERPStatisticData)ERPDataMap.get(orgId);
                CoursePurchaseDto coursePurchaseDto = (CoursePurchaseDto)incomeTotals.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData);
                }
                Integer count = coursePurchaseDto.getCount();
                Double payMoneySum = coursePurchaseDto.getPayMoneySum();
                ((ERPStatisticData)erpStatisticData).setIncomeTotal(count == null ? 0 : count);
                ((ERPStatisticData)erpStatisticData).setIncomeSum(payMoneySum == null ? 0.0 : payMoneySum);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(signLessonTotals = this.orgLessonSignDao.getOrgSignLessonTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : signLessonTotals.keySet()) {
                Object erpStatisticData5 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData5 == null) {
                    erpStatisticData5 = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData5);
                }
                ((ERPStatisticData)erpStatisticData5).setSignLessonTotal(signLessonTotals.get(orgId) == null ? 0 : (Integer)signLessonTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(signStudentTotals = this.orgLessonSignDao.getOrgSignStudentTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : signStudentTotals.keySet()) {
                Object erpStatisticData6 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData6 == null) {
                    erpStatisticData6 = new ERPStatisticData();
                    ERPDataMap.put(orgId, (ERPStatisticData)erpStatisticData6);
                }
                ((ERPStatisticData)erpStatisticData6).setSignStudentTotal(signStudentTotals.get(orgId) == null ? 0 : (Integer)signStudentTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(map = this.orgFinanceAccountService.getAccountInfos(TianxiaoOrgIds)))) {
            for (Integer orgId : map.keySet()) {
                Object erpStatisticData7 = (ERPStatisticData)ERPDataMap.get(orgId.longValue());
                if (erpStatisticData7 == null) {
                    erpStatisticData7 = new ERPStatisticData();
                    ERPDataMap.put(orgId.longValue(), (ERPStatisticData)erpStatisticData7);
                }
                OrgFinanceAccountDto ofadto = (OrgFinanceAccountDto)map.get(orgId);
                double d = ArithUtil.round((double)(new Double(ofadto.getBalance()) + new Double(ofadto.getFreeze_money())), (int)2);
                ((ERPStatisticData)erpStatisticData7).setCashPurchaseSum(d);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(commentByStudents = this.OrgLessonCommentDao.getComment(2, startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : commentByStudents.keySet()) {
                ERPStatisticData erpStatisticData8 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData8 == null) {
                    erpStatisticData8 = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData8);
                }
                erpStatisticData8.setCommentByStudent(commentByStudents.get(orgId) == null ? 0 : (Integer)commentByStudents.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(commentByTeachers = this.OrgLessonCommentDao.getComment(0, startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : commentByTeachers.keySet()) {
                ERPStatisticData erpStatisticData9 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData9 == null) {
                    erpStatisticData9 = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData9);
                }
                erpStatisticData9.setCommentByTeacher(commentByTeachers.get(orgId) == null ? 0 : (Integer)commentByTeachers.get(orgId));
            }
        }
        return ERPDataMap;
    }
}

