package com.baijia.tianxiao.biz.marketing.vote.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.marketing.utils.PictureUtil;
import com.baijia.tianxiao.biz.marketing.vote.service.BizVoteService;
import com.baijia.tianxiao.dal.activity.constants.CommonConstant;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.DeleteStatus;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.WechatException;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.sal.marketing.commons.utils.ActivityMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.enums.DrawCode;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteCacheDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoRequest;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoResponse;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteRenderDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteResult;
import com.baijia.tianxiao.sal.marketing.vote.enums.VotedCode;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteOptionService;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteService;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteStatisticsService;
import com.baijia.tianxiao.sal.marketing.vote.utils.VoteOptionUtil;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * Created by liuxp on 16/2/20.
 */

@Service
@Slf4j
public class BizVoteServiceImpl implements BizVoteService {

    @Autowired
    private VoteService voteService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private VoteStatisticsService voteStatisticsService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private FansService fansService;
    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private VoteOptionService optionService;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private VoteOptionDao optionDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;
    @Autowired
    private TxActivityCommonService txActivityCommonService;

    @Override
    @Transactional("yunyingTransactionManager")
    public VoteInfoResponse addVote(VoteInfoRequest request, Long orgId) {
        VoteInfo info = request.getVoteInfo();
        info.setTemplateTypeId(CommonConstant.VOTE_ACTIVITY_TYPE_ID);
        info.setStatus(1);
        info.setOrgId(orgId);

        // 判断机构类型 如果是免费版，需要判断机构已经创建活动的个数
        this.txActivityCommonService.checkoutOrgActivityVipLevelAndAmount(orgId.longValue());

        voteInfoDao.insertVoteActivity(info);

        // 将数据同步到tx_activity_conf中
        TxActivityCommon conf = new TxActivityCommon();
        txActivityCommonService.saveOrUpdateTxActivityCommon(conf, TemplateTypeCategory.VOTE_TYPE, info, null);

        List<VoteOption> optionList = VoteOptionUtil.parseOptionList(request);
        if (optionList != null) {
            Map<String, Integer> doubleCheck = new HashMap<>();
            for (VoteOption option : optionList) {
                String name = option.getName();
                if (doubleCheck.get(name) == null) {
                    doubleCheck.put(name, 1);
                } else {
                    doubleCheck.put(name, doubleCheck.get(name) + 1);
                }
                option.setActivityId(info.getActivityId());
                option.setStatus(1);
            }
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry<String, Integer> entry : doubleCheck.entrySet()) {
                if (entry.getValue() > 1) {
                    sb.append(entry.getKey()).append(",");
                }
            }
            if (GenericsUtils.notNullAndEmpty(sb.toString().trim())) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(" are repeat");
                BussinessException doublNames = new BussinessException(CommonErrorCode.PARAM_ERROR, sb.toString());
                throw doublNames;
            }
        }
        templateDao.updateTemplateUseCount(request.getTemplateId().longValue());
        try {
            log.info("[Param]=" + ToStringBuilder.reflectionToString(request));
            Integer replaceOrgId = request.getReplaceOrgId();
            log.info("replaceOrgId is null : {} ", replaceOrgId);
            CustomActivityDto wechat = customActivityService.createCustomActivityForReplace(replaceOrgId,
                orgId.intValue(), info.getActivityId().intValue(), request.getTemplateId(), request.getName(), "点击参与。",
                ConstantEnums.VOTE_TOP_IMG_URL.value());
            if (wechat == null) {
                throw new RuntimeException("创建微信二维码失败");
            }
        } catch (Exception e) {
            log.warn("[Vote] create error.{}", e);
            throw new WechatException("微信接口调用失败，请确认微信公众号权限！");
        }
        optionDao.batchInsertVoteOptions(optionList);
        VoteInfoResponse response = VoteInfoResponse.getVoteInfoResponse(info);
        response.setVoteOptions(optionService.getOptionList(info.getActivityId()));

        return response;
    }

    /**
     * 微信用户进行投票操作
     */
    @Override
    @Transactional("yunyingTransactionManager")
    public VoteResult vote(Long activityId, Long optionsId, String wechatOpenId, String userInfo, String targetOpenId) {

        VoteResult result = new VoteResult();

        Integer status = this.redisService.getActivityStatus(activityId, TemplateTypeCategory.VOTE_TYPE.getType());
        if (status != null && status == DeleteStatus.IS_DELETE.code) { // 活动被删除
            result.setCode(VotedCode.DELETE.getCode());
            return result;
        }

        try {
            VoteCacheDto voteCacheDto = this.findVoteCache(activityId);
            // 如果当前仍然没有找到当前活动，说明投票活动不存在
            if (voteCacheDto == null) {
                result.setCode(VotedCode.ERROR.code);
                return result;
            }

            Integer infoFillStatus = voteCacheDto.getInfoFillStatus();
            infoFillStatus = infoFillStatus == null ? 1 : infoFillStatus;

            Fans fans = null;
            if (infoFillStatus == 1 || infoFillStatus == 3) {
                fans = fansService.getFans(voteCacheDto.getOrgId().intValue(), wechatOpenId);
                log.info(" fans 0 is : {} ", fans);
                CustomActivityDto wechatDto =
                    customActivityService.getCustomActivity(activityId.intValue(), voteCacheDto.getTemplateId());
                log.info("wechatDto is : {} ", wechatDto);
                boolean needAuth = false;
                if (fans == null && wechatDto != null && wechatDto.getReplaceOrgId() != null) {
                    Integer visitCount = this.redisService.visitCount(wechatOpenId, voteCacheDto.getOrgId());
                    log.info("find visit count is : {} ", visitCount);
                    if (visitCount == null || visitCount == 0) {
                        visitCount = 1;
                        needAuth = true;
                        this.redisService.setVisitCount(wechatOpenId, voteCacheDto.getOrgId(), visitCount);
                        // 如果第一次访问，没有关注，不是从公众号回复里面点击的链接进来的，这里不会进行递增
                        // if (targetOpenId != null && targetOpenId.equals(wechatOpenId)) {
                        // this.redisService.setVisitCount(wechatOpenId, voteCacheDto.getOrgId(), visitCount);
                        // needAuth = false;
                        // }
                    } else {
                        fans = ((fans == null || !fans.isSubscribed())
                            ? fansService.getFans(wechatDto.getReplaceOrgId(), wechatOpenId) : fans);
                        fans.setSubscribe(1); //
                        log.info("fans 1 is : {} ", fans);
                        log.info("with replaceOrgId , and isSubscribed for ReplaceOrgId : {} ",
                            wechatDto.getReplaceOrgId());
                    }
                }

                log.info("needAuth is : {} ", needAuth);

                if (needAuth || (fans == null || !fans.isSubscribed())) {
                    result.setCode(DrawCode.UN_BIND.getCode());
                    result.setQrcodeUrl(wechatDto.getQrCodeUrl());
                    String replyWord = wechatDto.getKeyWord();
                    if (GenericsUtils.notNullAndEmpty(replyWord)) {
                        JSONArray array = JSONArray.fromObject(replyWord);
                        JSONObject object = array.getJSONObject(0);
                        replyWord = object.getString("keyword");
                        log.info("replyWord is : {}", replyWord);
                    }
                    result.setKeyWord(replyWord);
                    return result;
                }
                if (infoFillStatus == 3) {
                    infoFillStatus = 2;
                }
            }

            // 判断当前活动的状态
            VotedCode votedCode = null;
            boolean needUpdate = false;
            try {
                // 可能存在缓存中的数据
                votedCode = validate(voteCacheDto);
            } catch (Exception e) {
                needUpdate = true;
            }
            if (votedCode != null || needUpdate) {
                VoteInfo voteInfo = voteInfoDao.selectVoteInfo(activityId, null);
                voteCacheDto = VoteCacheDto.getInstanceByVoteInfo(voteInfo);
                this.redisService.setVoteActivityBase(activityId, voteCacheDto);
                validate(voteCacheDto);
                // 验证失败的时从数据库再验证一次
                if (votedCode != null) {
                    result.setCode(votedCode.getCode());
                    return result;
                }
            }

            // 判断是否是重复投票
            Map<Long, ActivityUser> extractMap =
                voteService.getVoteResultByWechatOpenId(activityId, wechatOpenId, voteCacheDto.getIsVotedByDay());

            int voteNums = 0;
            if (GenericsUtils.notNullAndEmpty(extractMap)) {
                voteNums = extractMap.size();
            }

            if (extractMap.get(optionsId) != null) {
                result.setCode(VotedCode.REPEAT_VOTE.code);
                return result;
            }

            if (voteNums >= voteCacheDto.getCountLimit()) {
                result.setCode(DrawCode.LIMIT_COUNT.getCode());
                return result;
            }

            // 在一系列校验都通过的情况下，再判断今天是否有过投票，如果没有投票记录
            if (infoFillStatus == 2) {
                String preUserInfo = this.activityUserDao.searchFillUserInfo(wechatOpenId, activityId,
                    TemplateTypeCategory.VOTE_TYPE.getType());
                userInfo = GenericsUtils.isNullOrEmpty(userInfo) ? preUserInfo : userInfo;
                if (GenericsUtils.isNullOrEmpty(userInfo)) {
                    result.setCode(DrawCode.INFO_LOSE.getCode());
                    return result;
                }
            }

            ActivityUser user = new ActivityUser();
            user.setActivityId(activityId);
            user.setCreateTime(new Date());
            user.setDoneCount(0);
            user.setDoneDate(DateUtil.getStrByDateFormate(new Date(), "yyyy-MM-dd"));
            user.setWechatOpenId(wechatOpenId);
            user.setOptionsId(optionsId);
            user.setCategory(TemplateTypeCategory.VOTE_TYPE.getType());
            user.setUpdateTime(new Date());
            user.setUserInfo(userInfo);

            // 进行投票
            this.activityUserDao.insertActivityUser(user);
            result.setCode(VotedCode.SUCCESS.code);
        } catch (Exception e) {
            log.error("error while vote cause by : ", e);
            result.setCode(VotedCode.ERROR.code);
        }
        return result;
    }

    /**
     * @param activityId
     * @return
     */

    private VoteCacheDto findVoteCache(Long activityId) {
        // VoteCacheDto voteCacheDto = null;
        // 便于调试
        VoteCacheDto voteCacheDto = this.redisService.getVoteActivityBase(activityId);
        if (voteCacheDto == null) {
            VoteInfo voteInfo = voteInfoDao.selectVoteInfo(activityId, null);
            voteCacheDto = VoteCacheDto.getInstanceByVoteInfo(voteInfo);
            this.redisService.setVoteActivityBase(activityId, voteCacheDto);
        }
        return voteCacheDto;
    }

    private VotedCode validate(VoteCacheDto voteCacheDto) {
        if (voteCacheDto.getStatus() == 0) {
            return VotedCode.CLOSED;
        }
        Date current = new Date();
        Date begin = new Date(voteCacheDto.getStartTime());
        Date end = new Date(voteCacheDto.getEndTime());
        if (current.before(begin)) {
            return VotedCode.NOT_START;
        } else if (current.after(end)) {
            return VotedCode.IS_END;
        }
        return null;
    }

    @Override
    public VoteRenderDto renderVoteActivity(Long activityId, String wechatOpenId) {
        VoteRenderDto dto = voteService.getVoteRenderDtoById(activityId, wechatOpenId);
        if (dto == null) {
            return null;
        }
        OrgInfoSimpleDto orgInfo = null;
        try {
            orgInfo = this.orgInfoService.getOrgInfo(dto.getOrgId());
            String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfo.getOrgNumber();
            dto.setOrgWeiPage(weiPage);
            dto.setOrgName(orgInfo.getShortName());
            dto.setOrgLogo(orgInfo.getLogo());
            dto.setOrgNumber(orgInfo.getOrgNumber());
        } catch (Exception e) {
            log.error("[Vote] Query org error.orgId=" + dto.getOrgId());
            log.error("[Vote] Query org error", e);
        }
        return dto;
    }

    @Override
    public TwoTuple<Integer, String> exportVoteResult(VoteInfoRequest request) {
        final Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = orgInfoService.getOrgInfo(orgId);
        } catch (Exception e) {
            log.info("can not find an org with org_ID {}", orgId);
            return TupleUtil.tuple(400, "机构不存在");
        }
        final String orgName = simple.getShortName();
        final String email = request.getEmail();
        return createVoteResultStatisticsMail(orgId, activityId, orgName, email);
    }

    /**
     * 生成并创建参与者名单
     *
     * @param activityId
     * @param orgName
     * @param email
     * @return
     */
    private TwoTuple<Integer, String> createVoteResultStatisticsMail(Long orgId, final Long activityId,
        final String orgName, final String email) {
        VoteInfoResponse voteInfo = voteService.getVoteInfoById(activityId, orgId);
        if (voteInfo == null) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "活动不存在");
        }

        List<VoteResult> voteResult = this.voteStatisticsService.votedDairyCountStatistics(activityId, orgId);

        if (GenericsUtils.isNullOrEmpty(voteResult)) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "暂无投票结果");
        }

        boolean isNotLimited =
            redisService.addOrgEmailCount(orgId, activityId, TemplateTypeCategory.VOTE_TYPE.getType(), EmailType.USER);
        if (!isNotLimited) {
            log.info("次数已达上限，请明天再发");
            return TupleUtil.tuple(TupleUtil.NO_OK, "今日已发送" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "次，请明日再试");
        }
        final List<Map<String, String>> rows = new ArrayList<>();
        for (VoteResult statistics : voteResult) {
            Map<String, String> rowMap = new LinkedHashMap<>();
            Integer number = statistics.getNumber();
            String name = statistics.getName();
            String count = String.valueOf(statistics.getCount());
            rowMap.put("编号", String.valueOf(number));
            rowMap.put("名称", name);
            rowMap.put("得票数", String.valueOf(count));
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_VOTE_SUBJECT_RESULT.value();
        String content = ConstantEnums.MAILBOX_VOTE_CONTENT_RESULT.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        ActivityMailSender.sendMail(email, subject, content, activityId, rows);
        return TupleUtil.tuple(TupleUtil.OK, "邮件发送成功");
    }

    @Override
    public ShareDto getShareInfo(Long activityId, Long orgId) {
        ShareDto dto = new ShareDto();

        VoteInfo voteInfo = this.voteInfoDao.selectVoteInfo(activityId, orgId);
        if (voteInfo == null) {
            return dto;
        }
        dto.setTitle(voteInfo.getName());
        try {
            String logo = orgInfoService.getOrgInfo(orgId).getLogo();
            dto.setImageUrl(PictureUtil.handlePictureSize(logo));
        } catch (Exception e) {
            log.error("[ActivityShareService ] ", e);
        }
        dto.setContent(ConstantEnums.VOTE_SLOGAN.value());
        dto.setShareUrl(getUrl(activityId, voteInfo.getTemplateId()));
        return dto;
    }

    private String getUrl(long activityId, int templateId) {
        CustomActivityDto dto = customActivityService.getCustomActivity((int) activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        } else {
            return "";
        }
    }

    /**
     */
    @Override
    @Transactional("yunyingTransactionManager")
    public void deleteVoteActivity(Long activityId, Long orgId) {
        // 获取正常未删除活动
        VoteInfo info = voteInfoDao.selectVoteInfo(activityId, orgId);

        if (info != null) {
            this.redisService.setchangeActivityStatus(activityId, TemplateTypeCategory.VOTE_TYPE.getType(),
                DeleteStatus.IS_DELETE.getCode());
            VoteInfo updateInfo = new VoteInfo();
            updateInfo.setActivityId(activityId);
            updateInfo.setDelStatus(DeleteStatus.IS_DELETE.getCode());
            updateInfo.setUpdateTime(new Timestamp(new Date().getTime()));
            voteInfoDao.updateVoteActivity(updateInfo);

            // 更新tx_activity_conf活动删除状态
            TxActivityCommon conf =
                txActivityCommonDao.getTxActivityCommon(orgId, info.getTemplateTypeId(), info.getActivityId());
            conf.setDelStatus(DeleteStatus.IS_DELETE.getCode());
            conf.setUpdateTime(new Date());
            txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, "delStatus", "updateTime");
            log.info("[Vote] delete status set success confId:{}", conf.getId());
        } else {
            log.info("[Vote] vote is not exist  , voteId=", activityId);
        }
    }

}
