
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.marketing.smsGroupSend.service.impl;

import java.sql.Timestamp;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.biz.marketing.dto.SmsSendResponse;
import com.baijia.tianxiao.biz.marketing.dto.StudentAndCourseListDto;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.BizSmsGroupSendService;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.TxMarktingSmsService;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao;
import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.CourseDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.RecordRespDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendRequest;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendResp;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.service.SmsGroupSendService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 19, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Service
@Slf4j
public class BizSmsGroupSendServiceImpl implements BizSmsGroupSendService {

    @Autowired
    private SmsGroupSendRecordDao smsGroupSendRecordDao;
    @Autowired
    private SmsGroupSendService smsGroupSendService;
    @Autowired
    private TxMarktingSmsService smsService;
    @Autowired
    private CourseStudentService courseStudentService;
    @Autowired
    private ErpCourseListService erpCourseListService;

    /**
     * @param type 0:全部 1:学员 2:班级 检索的类型
     * @param keyWord
     * @return 返回检索到的学员或者班级信息
     */
    @Override
    public StudentAndCourseListDto searchStudentAndCourses(Long orgId, int type, String keyWord, PageDto pageDto) {

        StudentAndCourseListDto retData = new StudentAndCourseListDto();

        List<StudentDto> studentDtos = null;
        List<CourseDto> courseDtos = null;
        int totalStuCount = 0;
        int totalCourseCount = 0;

        // 检索学员表
        if (type == 0 || type == 1) {
            List<OrgStudentsChooseListDto> studentChooseList =
                courseStudentService.getStudentChooseList(orgId, -1L, keyWord, pageDto);
            studentDtos = buildStudetnDtos(studentChooseList);
            totalStuCount = pageDto.getCount();
        }
        if (type == 0 || type == 2) {
            CourseListRequestDto params = new CourseListRequestDto();
            params.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
            params.setSearchKey(keyWord);
            params.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
            List<CourseListInfoDto> dtoList = erpCourseListService.getCourseList(orgId, null, null, params, pageDto,CourseListInfoDto.class);
            courseDtos = buildCourseDtos(dtoList);
            totalCourseCount = pageDto.getCount();
        }

        retData.setCourses(courseDtos);
        retData.setStudents(studentDtos);

        retData.setTotalStuCount(totalStuCount);
        retData.setTotalCourseCount(totalCourseCount);

        return retData;
    }

    /**
     * @param dtoList
     * @return
     */
    private List<CourseDto> buildCourseDtos(List<CourseListInfoDto> dtoList) {
        if (GenericsUtils.isNullOrEmpty(dtoList)) {
            return GenericsUtils.emptyList();
        }
        List<CourseDto> dtos = Lists.newArrayListWithExpectedSize(dtoList.size());
        for (CourseListInfoDto courseListInfoDto : dtoList) {
            CourseDto dto = new CourseDto(courseListInfoDto.getCourseId(), courseListInfoDto.getCourseName(),
                courseListInfoDto.getStudentCount() == null ? 0 : courseListInfoDto.getStudentCount());
            dtos.add(dto);
        }
        return dtos;
    }

    /**
     * @param studentChooseList
     * @return
     */
    private List<StudentDto> buildStudetnDtos(List<OrgStudentsChooseListDto> studentChooseList) {
        if (GenericsUtils.isNullOrEmpty(studentChooseList)) {
            return GenericsUtils.emptyList();
        }
        List<StudentDto> dtos = Lists.newArrayListWithCapacity(studentChooseList.size());
        for (OrgStudentsChooseListDto stu : studentChooseList) {
            StudentDto dto = new StudentDto(stu.getStudentId(), stu.getName(), stu.getMobile(), stu.getAvatarUrl());
            dtos.add(dto);
        }
        return dtos;
    }

    /**
     * 进行短信群发并进行记录的保存
     */
    @Override
    public SmsGroupSendResp sendAndSaveRecord(SmsGroupSendRequest request) {
        String content = request.getContent();
        if (GenericsUtils.isNullOrEmpty(content)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "短信内容为空");
        }

        SendStatus sendStatus = SendStatus.SEND_OK;
        Integer code = null; // 用于放置在data外层

        Long orgId = request.getOrgId();
        SmsGroupSendRecord record = null;
        if (request.getRecordId() != null) {
            SmsGroupSendRecord searchRecordWithOrgId =
                this.smsGroupSendRecordDao.searchRecordWithOrgId(request.getRecordId(), orgId);
            if (searchRecordWithOrgId == null) {
                throw new BussinessException(CommonErrorCode.INVALIDATE_CLIENTID, "非法访问群发记录");
            }
        }

        List<StudentDto> studentDtos = this.smsGroupSendService.getAllStudents(request);
        if (GenericsUtils.isNullOrEmpty(studentDtos)) {
            throw new BussinessException(CommonErrorCode.NOT_FOUND, "未找到任何学员");
        }

        record = request.buildPo(studentDtos);

        Timestamp sendTime = null;
        // 尝试进行短信群发
        Integer leftSmsCount = this.smsService.leftSmsCount(orgId);
        if (leftSmsCount <= 0 || (leftSmsCount < studentDtos.size() && leftSmsCount < RecordRespDto.system_limit)) {
            log.info("orgId:{} has't enought smsCount to send messages , and record id  is : {} , limitCount is : {}  ",
                orgId, record.getId(), leftSmsCount);
            sendStatus = SendStatus.NOT_ENOUGHT_SMS;
            code = SendStatus.SEND_OK.getCode();
        } else {
            sendTime = new Timestamp(System.currentTimeMillis());
            // 进行系统短信发送,控制发送条数以及发送成功后短信额度值的更新
            SmsSendResponse sendSmsMessage = this.smsService.sendSmsMessage(orgId, studentDtos, content);
            if (sendSmsMessage.getResult() == SmsSendResult.FAILED) {
                sendStatus = SendStatus.SYSTEM_SEND_ERROR;
                record.setFailureReceiver(record.getAllReceiver());
                code = sendStatus.getCode();
            } else {
                record.setSendStatus(SendStatus.SEND_OK.code);
                record.setFailureReceiver(sendSmsMessage.getFailureIdsStr());
            }
            leftSmsCount = this.smsService.leftSmsCount(orgId);
        }

        record.setSendStatus(sendStatus.getCode());
        record.setSendTime(sendTime);
        // 进行群发记录的保存
        this.smsGroupSendRecordDao.saveOrUpdate(record);

        RecordRespDto resp =
            RecordRespDto.buildDto(record.getId(), record.getTotalCount(), leftSmsCount, sendStatus.getCode(), code);
        return resp;
    }

}
