/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.TxBacklogStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.TxBacklogStatisticService;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年4月24日
 * @desc
 */
@Service
public class TxBacklogStatisticServiceImpl implements TxBacklogStatisticService {
    @Autowired
    private TxBacklogDao txBacklogDao;

    @Override
    public Map<Long, TxBacklogStatisticData> getTxBacklogData(Date startDate, Date endDate, List<Long> TianxiaoOrgIds, int way) {
        Map<Long, TxBacklogStatisticData> txBacklogDataMap = new HashMap<>();
        Map<Long, Integer> countsOfBacklogTotalMap =
            this.txBacklogDao.getBacklogTotal(startDate, endDate, TianxiaoOrgIds);
        Map<Long, Integer> countsOfBacklogExpireMap =
            this.txBacklogDao.getBacklogExpired(startDate, endDate, TianxiaoOrgIds);
        Map<Long, Integer> backlogFinishMap = new HashMap<>();
        if (way != 0) {
            backlogFinishMap = this.txBacklogDao.getBacklogFinish(TianxiaoOrgIds);
        }

        for (Long orgId : countsOfBacklogTotalMap.keySet()) {
            TxBacklogStatisticData statisticData = txBacklogDataMap.get(orgId);
            if (statisticData == null) {
                statisticData = new TxBacklogStatisticData();
                txBacklogDataMap.put(orgId, statisticData);
            }
            Integer total = countsOfBacklogTotalMap.get(orgId);
            statisticData.setBacklogTotal(total == null ? 0 : total);
        }

        for (Long orgId : countsOfBacklogExpireMap.keySet()) {
            TxBacklogStatisticData statisticData = txBacklogDataMap.get(orgId);
            if (statisticData == null) {
                statisticData = new TxBacklogStatisticData();
                txBacklogDataMap.put(orgId, statisticData);
            }
            Integer expire = countsOfBacklogExpireMap.get(orgId);
            statisticData.setBacklogExpire(expire == null ? 0 : expire);
        }

        for (Long orgId : backlogFinishMap.keySet()) {
            TxBacklogStatisticData statisticData = txBacklogDataMap.get(orgId);
            if (statisticData == null) {
                statisticData = new TxBacklogStatisticData();
                txBacklogDataMap.put(orgId, statisticData);
            }
            Integer finish = backlogFinishMap.get(orgId);
            statisticData.setBacklogFinish(finish == null ? 0 : finish);
        }
        return txBacklogDataMap;
    }

}
