/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service;

import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;

import java.util.Date;
import java.util.List;

/**
 * @author gaodan
 * @createdate 2016年4月18日
 * @desc
 */
public interface ExportOrgInfoService {
    //way表示得到数据的方式：0按天，1按周，2按月，3截至今日
    public List<ExportDto> getExportDtoByDay(Date startTime,Date endTime, int way);

    public void createExcel(Date startTime,Date endTime);
    
    public void createHSSFWorkbookByDay(Date startTime,Date endTime);

    public void createHSSFWorkbookTotal(Date startTime, Date endTime) ;
    
    public void createMailByWeekAndMonth(Date startTime, Date endTime, int beforeDay);
    
    //获取课程签到信息需求
    public void createExcelOrgSignInfo();
    
    public void getMonitorData(Date startTime, Date endTime);
    
    //获取群发消息详请
    public void createExcelOrgGroupMsgInfo();
    
    //获取ERP课程相关信息
    public void createExcelOfErpData();
    
    //获取微信线索消息和预约留单线索消息数据
    public void createExcelOfMsgRecordData();
    
    //获取机构类型详情
    public void getOrgTypeInfo(Date startTime, Date endTime);
    
}
