/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.dto;

import com.baijia.tianxiao.biz.marketing.export.constant.CourseStatus;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.util.GenericsUtils;

import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年6月2日
* @desc 
 */
@Slf4j
public class OrgCourseDetailDto extends CourseListReponseDto{
    
    private Date createTime;
    private Integer orgNumber;
    private String classStatus; //班课状态.0=招生中,1=已下架
    
    public String getClassStatus(){
        return this.classStatus;
    }
    
    public void setClassStatus(String classStatus){
        this.classStatus = classStatus;
    }
    
    public void setOrgNumber(Integer orgNumber){
        this.orgNumber = orgNumber;
    }
    
    public Integer getOrgNumber(){
        return this.orgNumber;
    }
    
    public void setCreateTime(Date createTime){
        this.createTime = createTime;
    }
    
    public Date getCreateTime(){
        return createTime;
    }
    
    public static OrgCourseDetailDto buildOrgCourseDetailDtoByOrgCourse(OrgCourse orgCourse){
        OrgCourseDetailDto orgCourseDetailDto = new OrgCourseDetailDto();
        orgCourseDetailDto.setOrgCourseId(orgCourse.getId());
        orgCourseDetailDto.setCourseName(orgCourse.getName());
        orgCourseDetailDto.setPrice(orgCourse.getPrice());
        orgCourseDetailDto.setFreq(orgCourse.getFreq());    //上课次数
        orgCourseDetailDto.setMaxStudent(orgCourse.getMaxStudent());
        orgCourseDetailDto.setCreateTime(orgCourse.getCreateTime());
        orgCourseDetailDto.setStartTime(orgCourse.getBeginTime());
        orgCourseDetailDto.setEndTime(orgCourse.getEndTime());
        orgCourseDetailDto.setAddress(orgCourse.getAddress());
        orgCourseDetailDto.setOrgNumber(orgCourse.getOrgNumber().intValue());
        Blob introduction = orgCourse.getIntroduction();
        String contentIntro = null;
        if(GenericsUtils.notNullAndEmpty(introduction)){
            try{ 
                
                contentIntro = new String(introduction.getBytes((long)1, (int)introduction.length()));  
            } catch(SQLException e) {  
                e.printStackTrace();  
            }  
        }
        orgCourseDetailDto.setIntroduction(contentIntro);
        Integer value = orgCourse.getStatus();
        String classStatus = null;
        if(value == 0){
            classStatus = CourseStatus.ENROLLING.getMessage();
        }
        if(value == 1){
            classStatus = CourseStatus.YIXIAJIA.getMessage(); 
        }
        orgCourseDetailDto.setClassStatus(classStatus);
        
        return orgCourseDetailDto;
    }

}
