/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年6月5日
* @desc 校区类型
 */
public enum CompusType {
    ZONG(1, "总校区"),
    ZHI(2, "直营分校"),
    JIA(3, "加盟分校");
    
    private int code;

    private String message;

    private CompusType(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }
    
    public String getMessage() {
        return message;
    }
    
    private static Map<Integer, CompusType> map = new HashMap<>();
    
    static{
        for(CompusType compusType : CompusType.values()){
           map.put(compusType.getCode(), compusType);
        }
    }
    
    public static CompusType getCompusTypeByCode(Integer code){
        CompusType compusType = map.get(code);
        return compusType;
    }

}
