/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年6月5日
* @desc 
 */
public enum AccountTypeEnum {
    ZHENGSHI(1,"正式"),
    NEIBU(2,"内部"),
    CESHI(3,"测试"),
    SHIYONG(4,"试用");
    
    private Integer code;
    private String label;
    
    AccountTypeEnum(Integer code, String label){
        this.code = code;
        this.label = label;
    }
    
    private static Map<Integer, AccountTypeEnum> map = new HashMap<>();
    
    static{
        for(AccountTypeEnum accountTypeEnum : AccountTypeEnum.values()){
           map.put(accountTypeEnum.getCode(), accountTypeEnum);
        }
    }
    
    public static AccountTypeEnum getAccountTypeEnumByCode(Integer code){
        AccountTypeEnum accountTypeEnum = map.get(code);
        return accountTypeEnum;
    }

    public Integer getCode() {
    
        return code;
    }

    public void setCode(Integer code) {
    
        this.code = code;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }

}
