package com.baijia.tianxiao.biz.marketing.draw.service.impl;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

import javax.mail.Session;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.marketing.draw.service.BizDrawActivityService;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.constants.TemplateSuffix;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.DeleteStatus;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.Status;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.WechatException;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelHelper;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.sal.marketing.commons.utils.NumberFormat;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityBase;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityDetail;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRenderDto;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRequest;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawCacheDto;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawResult;
import com.baijia.tianxiao.sal.marketing.draw.enums.DrawCode;
import com.baijia.tianxiao.sal.marketing.draw.service.ActivityUserService;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawPrizesService;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawService;
import com.baijia.tianxiao.sal.marketing.draw.service.WinnerService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * Created by liuxp on 16/4/7.
 */
@Service
@Slf4j
public class BizDrawActivityServiceImpl implements BizDrawActivityService {
    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private FansService fansService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private DrawPrizesService drawPrizesService;
    @Autowired
    private ActivityUserService activityUserService;
    @Autowired
    private WinnerService winnerService;
    @Autowired
    private DrawService drawService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private PrizeInfoDao prizeInfoDao;
    @Autowired
    private DrawActivityDao activityDao;
    @Autowired
    private TxActivityCommonService txActivityCommonService;
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;

    private static final ThreadLocalRandom random = ThreadLocalRandom.current();

    @Override
    @Transactional("yunyingTransactionManager")
    public DrawActivityBase addDrawActivity(DrawActivityRequest request) {
        TwoTuple<DrawInfo, List<PrizeInfo>> buildDetailPo = DrawActivityDetail.buildDetailPo(request);
        DrawInfo di = buildDetailPo.first;
        di.setStatus(1); // 活动一创建，默认是打开的
        Long current = new Date().getTime();
        Timestamp currentTimestamp = new Timestamp(current);
        di.setCreateTime(currentTimestamp);
        di.setUpdateTime(currentTimestamp);

        // 判断机构类型 如果是免费版，需要判断机构已经创建活动的个数,如果超过抛出异常和提示文案
        this.txActivityCommonService.checkoutOrgActivityVipLevelAndAmount(request.getOrgId());

        Long activityId = this.drawActivityDao.addDrawActivity(di);
        log.info("[Draw] drawInfo param:{}", di);

        // 同步tx_activity_conf
        TxActivityCommon conf = new TxActivityCommon();
        txActivityCommonService.saveOrUpdateTxActivityCommon(conf, TemplateTypeCategory.DRAW_TYPE, di, null);

        List<PrizeInfo> prizeInfos = buildDetailPo.second;
        if (GenericsUtils.notNullAndEmpty(prizeInfos)) {
            for (PrizeInfo pi : prizeInfos) {
                pi.setActivityId(activityId);
                if (GenericsUtils.isNullOrEmpty(pi.getUrl())) {
                    pi.setUrl(ConstantEnums.findProperties(TemplateSuffix.getSuffixKey(TemplateTypeCategory.DRAW_TYPE,
                        request.getTemplateId(), "DEFAULT_IMAGE")));
                }
            }
            this.drawPrizesService.addPrizeInfo(prizeInfos);
        }
        templateDao.updateTemplateUseCount(request.getTemplateId().longValue());
        log.info("[Param]=" + ToStringBuilder.reflectionToString(request));
        Template template = templateDao.selectTemplateById(request.getTemplateId());
        try {
            CustomActivityDto wechat = customActivityService.createCustomActivityForReplace(request.getReplaceOrgId(),
                request.getOrgId().intValue(), activityId.intValue(), request.getTemplateId(), request.getName(),
                request.getIntroduction(), template.getThumbNail());
            log.info("wechat is : {} ", wechat);
            if (wechat == null) {
                throw new RuntimeException("创建微信二维码失败");
            }
        } catch (Exception e) {
            log.warn("[DrawActivity] create error.{}", e);
            throw new WechatException("微信接口调用失败，请确认微信公众号权限！");
        }

        request.setActivityId(activityId);
        return drawService.getActivityDetail(request);
    }

    /**
     * 导出参与人名单
     */
    @Override
    public TwoTuple<Integer, String> exportUserList(DrawActivityRequest request) {
        final Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = orgInfoService.getOrgInfo(orgId);
        } catch (Exception e) {
            log.info("can not find an org with org_ID {}", orgId);
            return TupleUtil.tuple(400, "机构不存在");
        }
        final String orgName = simple.getShortName();
        final String email = request.getEmail();
        return createPartakeStatisticsMail(orgId, activityId, orgName, email);
    }

    /**
     * 导出中奖者名单
     */
    @Override
    public TwoTuple<Integer, String> exportWinnerList(DrawActivityRequest request) {
        final Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = orgInfoService.getOrgInfo(orgId);
        } catch (Exception e) {
            log.info("can not find an org with org_ID {}", orgId);
            return TupleUtil.tuple(400, "机构不存在");
        }
        final String orgName = simple.getShortName();
        final String email = request.getEmail();
        return createWinnerStatisticsMail(orgId, activityId, orgName, email);
    }

    /**
     * 生成并创建参与者名单
     *
     * @param activityId
     * @param orgName
     * @param email
     * @return
     */
    private TwoTuple<Integer, String> createPartakeStatisticsMail(Long orgId, final Long activityId,
        final String orgName, final String email) {
        List<DairyCountStatistics> activityUserStatistics =
            activityUserService.getActivityUserStatistics(activityId, orgId);
        if (GenericsUtils.isNullOrEmpty(activityUserStatistics)) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "暂无参与用户");
        }

        DrawInfo drawInfo = drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "活动不存在");
        }

        boolean isNotLimited = redisService.addOrgEmailCount(drawInfo.getOrgId(), activityId,
            drawInfo.getTemplateTypeId(), EmailType.USER);
        if (!isNotLimited) {
            log.info("次数已达上限，请明天再发");
            return TupleUtil.tuple(TupleUtil.NO_OK, "今日已发送" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "次，请明日再试");
        }
        final List<Map<String, String>> rows = new ArrayList<>();
        for (DairyCountStatistics statistics : activityUserStatistics) {
            Map<String, String> rowMap = new HashMap<>();
            String data = statistics.getDate();
            String count = String.valueOf(statistics.getCount());
            rowMap.put("日期", data);
            rowMap.put("参与者", count);
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_RRAW_SUBJECT_PARTAKE.value();
        String content = ConstantEnums.MAILBOX_DRAW_CONTENT_PARTAKE.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        sendMail(email, orgName, subject, content, activityId, rows);
        return TupleUtil.tuple(TupleUtil.OK, "邮件发送成功");
    }

    /**
     * 生成并创建中奖者名单
     *
     * @param activityId
     * @param orgName
     * @param email
     * @return
     */
    private TwoTuple<Integer, String> createWinnerStatisticsMail(Long orgId, Long activityId, String orgName,
        String email) {
        List<Winner> winnerStatistics = winnerService.getWinnerList(activityId, null);
        if (GenericsUtils.isNullOrEmpty(winnerStatistics)) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "暂无中奖用户");
        }

        DrawInfo drawInfo = drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "活动不存在");
        }

        boolean isNotLimited = redisService.addOrgEmailCount(drawInfo.getOrgId(), activityId,
            drawInfo.getTemplateTypeId(), EmailType.WINNER);
        if (!isNotLimited) {
            log.info("次数已达上限，请明天再发");
            return TupleUtil.tuple(TupleUtil.NO_OK, "今日已发送" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "次，请明日再试");
        }

        final List<Map<String, String>> rows = new ArrayList<>();
        for (Winner winner : winnerStatistics) {
            Map<String, String> rowMap = new LinkedHashMap<>();
            String grade = NumberFormat.numToWord(winner.getGrade()) + "等奖";

            rowMap.put("编号", String.valueOf(winner.getDrawId()));
            rowMap.put("奖品等级", grade);
            rowMap.put("奖品名称", winner.getPrizeName());
            rowMap.put("中奖微信昵称", winner.getNickName());
            rowMap.put("中奖微信OpenId", winner.getWechatOpenId());
            rowMap.put("中奖时间", DateUtil.getStrByDateFormate(winner.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
            rowMap.put("登记时间", DateUtil.getStrByDateFormate(winner.getCheckInTime(), "yyyy-MM-dd HH:mm:ss"));
            rowMap.put("姓名", winner.getName());
            rowMap.put("手机号", winner.getMobile());
            rowMap.put("地址", winner.getAddress());
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_DRAW_SUBJECT_WINNER.value();
        String content = ConstantEnums.MAILBOX_DRAW_CONTENT_WINNER.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        sendMail(email, orgName, subject, content, activityId, rows);
        return TupleUtil.tuple(TupleUtil.OK, "邮件发送成功");
    }

    public void sendMail(final String email, final String orgName, final String subject, final String content,
        final Long activityId, final List<Map<String, String>> rows) {
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                File reportFile = null;
                try {
                    Mail mail = new Mail();
                    String from = ConstantEnums.MAILBOX_FROM.value();
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);
                    try {
                        String filename = activityId + "_" + DateUtil.getStrByDate(new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
                        if (reportFile == null) {
                            return;
                        }
                        log.info("PARTAKE FILE  path is : {}", reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    } catch (Exception e) {
                        log.error("error :", e);
                    }
                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                } finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public DrawResult draw(long activityId, String wechatOpenId, String fillInfoJson, String targetOpenId) {

        DrawResult drawResult = new DrawResult();
        // 1、根据wechatOpenId查询是否已关注,如果未关注，直接返回错误码和url
        // 2、查询活动信息，如果活动不存在，或者不在抽奖时间范围内，返回错误码

        Integer status = this.redisService.getActivityStatus(activityId, TemplateTypeCategory.DRAW_TYPE.getType());
        if (status != null && status == DeleteStatus.IS_DELETE.code) { // 活动被删除
            drawResult.setCode(DrawCode.DELETE.getCode());
            return drawResult;
        }

        DrawCacheDto drawCacheDto = this.findDrawInfoCache(activityId);
        if (drawCacheDto == null) {
            drawResult.setCode(DrawCode.ERROR.getCode());
            return drawResult;
        }

        log.info("[Draw] Cache Dto=" + ToStringBuilder.reflectionToString(drawCacheDto));

        Integer infoFillStatus = drawCacheDto.getInfoFillStatus();
        log.info("0 infoFillStatus is : {} ", infoFillStatus);
        infoFillStatus = infoFillStatus == null ? 1 : infoFillStatus;
        log.info("1 infoFillStatus is : {} ", infoFillStatus);

        Fans fans = null;
        if (infoFillStatus == 1 || infoFillStatus == 3) {
            fans = fansService.getFans(drawCacheDto.getOrgId().intValue(), wechatOpenId);
            log.info(" fans 0 is : {} ", fans);
            CustomActivityDto wechatDto =
                customActivityService.getCustomActivity((int) activityId, drawCacheDto.getTemplateId());
            log.info("wechatDto is : {} ", wechatDto);
            boolean needAuth = false;
            if (wechatDto != null && wechatDto.getReplaceOrgId() != null) {
                Integer visitCount = this.redisService.visitCount(wechatOpenId, drawCacheDto.getOrgId());
                log.info("find visit count is : {} ", visitCount);
                if (visitCount == null || visitCount == 0) {
                    visitCount = 1;
                    needAuth = true;
                    this.redisService.setVisitCount(wechatOpenId, drawCacheDto.getOrgId(), visitCount);
                    // 如果第一次访问，没有关注，不是从公众号回复里面点击的链接进来的，这里不会进行递增,需要走uid
                    // if (targetOpenId != null && targetOpenId.equals(wechatOpenId)) {
                    // this.redisService.setVisitCount(wechatOpenId, drawCacheDto.getOrgId(), visitCount);
                    // needAuth = false;
                    // }
                } else {
                    fans = ((fans == null || !fans.isSubscribed())
                        ? fansService.getFans(wechatDto.getReplaceOrgId(), wechatOpenId) : fans);
                    fans.setSubscribe(1); //
                    log.info("fans 1 is : {} ", fans);
                    log.info("with replaceOrgId , and isSubscribed for ReplaceOrgId : {} ",
                        wechatDto.getReplaceOrgId());
                }
            }

            log.info("needAuth is : {} ", needAuth);

            if (needAuth || (fans == null || !fans.isSubscribed())) {
                drawResult.setCode(DrawCode.UN_BIND.getCode());
                drawResult.setQrcodeUrl(wechatDto.getQrCodeUrl());
                String replyWord = wechatDto.getKeyWord();
                if (GenericsUtils.notNullAndEmpty(replyWord)) {
                    JSONArray array = JSONArray.fromObject(replyWord);
                    JSONObject object = array.getJSONObject(0);
                    replyWord = object.getString("keyword");
                }
                drawResult.setKeyWord(replyWord);
                return drawResult;
            }
            if (infoFillStatus == 3) {
                infoFillStatus = 2;
            }
        }
        log.info("3 infoFillStatus is : {} ", infoFillStatus);

        boolean needUpdate = false;
        DrawCode drawCode = null;
        try {
            // 可能存在缓存中的数据
            drawCode = validate(drawCacheDto);
        } catch (Exception e) {
            needUpdate = true;
        }
        if (drawCode != null || needUpdate) {
            drawCacheDto = drawService.getDrawCacheDtoFromDbById(activityId);
            this.redisService.setDrawActivityBase(activityId, drawCacheDto);
            validate(drawCacheDto);
            // 验证失败的时从数据库再验证一次
            if (drawCode != null) {
                drawResult.setCode(drawCode.getCode());
                return drawResult;
            }
        }

        // 验证配置信息
        ActivityUser user =
            activityUserDao.selectActivityUser(wechatOpenId, DateUtil.getStrByDateFormate(new Date(), "yyyy-MM-dd"),
                activityId, TemplateTypeCategory.DRAW_TYPE.getType());
        if (user == null) {
            user = new ActivityUser();
            user.setActivityId(activityId);
            user.setCreateTime(new Date());
            user.setDoneCount(0);
            user.setDoneDate(DateUtil.getStrByDateFormate(new Date(), "yyyy-MM-dd"));
            user.setUpdateTime(new Date());
            user.setWechatOpenId(wechatOpenId);
        }
        if (user.getDoneCount() >= drawCacheDto.getLimitCount()) {
            drawResult.setCode(DrawCode.LIMIT_COUNT.getCode());
            return drawResult;
        }

        if (infoFillStatus == 2) {
            fillInfoJson =
                this.isExistsUserInfo(fillInfoJson, wechatOpenId, activityId, TemplateTypeCategory.DRAW_TYPE.getType());
            log.info("userInfo is : {} ", fillInfoJson);
            if (GenericsUtils.isNullOrEmpty(fillInfoJson)) {
                drawResult.setCode(DrawCode.INFO_LOSE.getCode());
                return drawResult;
            }
        }

        // 跟新表单数据
        user.setUserInfo(fillInfoJson);

        Date startTime = DateUtil.getStartOfDay(new Date());
        Date endTime = DateUtil.getEndOfDay(new Date());
        Map<Integer, Integer> todayPrizeCount = winnerDao.selectPrizesByDate(activityId, startTime, endTime);

        // 随机抽取判断是否中奖
        int lucyDigit = luckyDraw(drawCacheDto.getBaseNum(), drawCacheDto.getProbabilities(), drawCacheDto.getPrizes(),
            todayPrizeCount);
        if (user.getId() == null) {
            user.setDoneCount(1);
            activityUserDao.insertActivityUser(user);
        } else {
            user.setDoneCount(user.getDoneCount() + 1);
            activityUserDao.updateActivityUserDoneCount(user);
        }

        if (lucyDigit > 0) {

            PrizeInfo[] prizes = drawCacheDto.getPrizes();

            log.info("[Draw] grade=" + lucyDigit);

            PrizeInfo prize = prizes[lucyDigit - 1];

            if (prize.getWinNum() >= prize.getCountLimit()) {
                drawResult.setCode(DrawCode.UN_WIN.getCode());
                return drawResult;
            }

            Integer count = todayPrizeCount.get(lucyDigit);
            if (count != null) {
                if (count > prize.getNumber()) {
                    drawResult.setCode(DrawCode.UN_WIN.getCode());
                    return drawResult;
                }
            }

            drawResult.setCode(DrawCode.SUCCESS.getCode());
            drawResult.setName(prize.getName());
            drawResult.setGrade(lucyDigit);

            // 7、如果中奖，更新数据库信息及缓存信息
            Winner winner = new Winner();
            winner.setGrade(lucyDigit);
            winner.setPrizeName(prize.getName());
            winner.setActivityId(activityId);
            winner.setWechatOpenId(wechatOpenId);
            winner.setNickName(fans == null ? wechatOpenId : fans.getNick());
            winner.setUserInfo(fillInfoJson);
            winnerDao.insertWinner(winner);
            drawResult.setDrawId(winner.getDrawId());
            prize.setWinNum(prize.getWinNum() + 1);
            int updateNum = prizeInfoDao.updateWinNum(prize.getId());
            if (updateNum != 1) {
                PrizeInfo dbPrizeInfo = prizeInfoDao.getPrizeByCondition(activityId, prize.getGrade());
                prize.setWinNum(dbPrizeInfo.getWinNum());
                // 修订缓存数据
                redisService.setDrawActivityBase(activityId, drawCacheDto);
                throw new BusinessException("已超出奖品总数量");
            }
            redisService.setDrawActivityBase(activityId, drawCacheDto);
        } else {
            drawResult.setCode(DrawCode.UN_WIN.getCode());
            return drawResult;
        }
        return drawResult;
    }

    /**
     * @param fillInfoJson
     * @param wechatOpenId
     * @param activityId
     * @param type
     * @return
     */

    private String isExistsUserInfo(String fillInfoJson, String wechatOpenId, long activityId, int type) {
        if (GenericsUtils.notNullAndEmpty(fillInfoJson)) {
            return fillInfoJson;
        }
        return this.activityUserDao.searchFillUserInfo(wechatOpenId, activityId, type);
    }

    public DrawCacheDto findDrawInfoCache(long activityId) {
        DrawCacheDto drawCacheDto = redisService.getDrawActivityBase(activityId);
        if (drawCacheDto == null) {
            drawCacheDto = this.drawService.getDrawCacheDtoFromDbById(activityId);
            redisService.setDrawActivityBase(activityId, drawCacheDto);
        }
        return drawCacheDto;
    }

    private DrawCode validate(DrawCacheDto cacheDto) {
        Long currentTime = new Date().getTime();
        if (cacheDto == null) {
            log.info("[Draw] Validate.activity is not exist.");
            return DrawCode.ERROR;
        }
        if (cacheDto.getDelStatus() == DeleteStatus.IS_DELETE.getCode()) {
            return DrawCode.DELETE;
        }
        if (cacheDto.getStartTime() > currentTime) {
            return DrawCode.NOT_START;
        }
        if (cacheDto.getEndTime() <= currentTime) {
            return DrawCode.IS_END;
        }
        if (cacheDto.getStatus() == Status.CLOSED.getCode()) {
            return DrawCode.CLOSED;
        }
        return null;
    }

    /**
     * how it work?
     * 
     * @param base
     * @param probabilities
     * @param prizes
     * @param todayPrizeCount
     * @return
     */
    private int luckyDraw(int base, int[] probabilities, PrizeInfo[] prizes, Map<Integer, Integer> todayPrizeCount) {

        for (int i = 0; i < prizes.length; i++) {
            Integer count = todayPrizeCount.get(prizes[i].getGrade());
            if (count != null
                && (prizes[i].getNumber() <= count || prizes[i].getWinNum() >= prizes[i].getCountLimit())) {
                log.info("[Draw] No prize =" + prizes[i].getGrade());
                base = base - probabilities[i];
            }
        }

        log.info("[Draw] base=" + base);

        if (base <= 0) {
            return -1;
        }

        int digit = random.nextInt(base);
        int rank = 0;
        for (int i = 0; i < probabilities.length; i++) {
            Integer count = todayPrizeCount.get(prizes[i].getGrade());
            if (count != null
                && (prizes[i].getNumber() <= count || prizes[i].getWinNum() >= prizes[i].getCountLimit())) {
                continue;
            } else {
                rank += probabilities[i];
            }

            if (digit < rank) {
                return i + 1;
            }
        }
        return -1;
    }

    @Override
    public DrawActivityRenderDto renderDrawActivity(DrawActivityRequest request) {
        DrawActivityRenderDto render = new DrawActivityRenderDto();
        DrawActivityDetail detail = this.drawService.getActivityDetail(request);
        if (detail == null) {
            return null;
        }
        try {
            BeanUtils.copyProperties(render, detail);
            log.info("[Draw] orgId=" + detail.getOrgId());
            OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(detail.getOrgId());

            // 微官网连接
            String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfo.getOrgNumber();
            render.setOrgWeiPage(weiPage);

            log.info(ToStringBuilder.reflectionToString(orgInfo));
            render.setOrgName(orgInfo.getShortName());
            render.setOrgLogo(orgInfo.getLogo());
            String _400_phone = orgInfo.getExtension();
            if (StringUtils.isNotBlank(_400_phone)) {
                render.setOrgPhone(BizConf._400_PHONE_PREFIX + "," + orgInfo.getExtension());
            } else {
                render.setOrgPhone(BizConf._400_PHONE_PREFIX);
            }
            render.setOrgNumber(orgInfo.getOrgNumber());
        } catch (Exception e) {
            log.error("[Draw] Query orgInfo error.", e);
        }
        ActivityUser user = activityUserDao.selectActivityUser(request.getWechatOpenId(),
            DateUtil.getStrByDateFormate(new Date(), "yyyy-MM-dd"), request.getActivityId(),
            TemplateTypeCategory.DRAW_TYPE.getType());
        Integer remainCount = render.getCountLimit();
        if (user != null) {
            remainCount = remainCount - user.getDoneCount();
        }
        render.setRemainCount(remainCount);
        return render;
    }

    /**
     * 获取奖品的详细信息
     */
    @Override
    public Map<String, Object> getPrize(Long drawId) {
        Map<String, Object> retMap = new HashMap<>();

        Winner winner = winnerDao.selectWinnerById(drawId);
        if (winner == null) {
            return retMap;
        }
        PrizeInfo prizeInfo = this.prizeInfoDao.getPrizeByCondition(winner.getActivityId(), winner.getGrade());
        if (prizeInfo == null) {
            return retMap;
        }
        Long activityId = prizeInfo.getActivityId();
        DrawActivityRequest request = new DrawActivityRequest();
        request.setActivityId(activityId);
        DrawActivityDetail detail = this.drawService.getActivityDetail(request);
        Integer infoFillStatus = detail.getInfoFillStatus();
        if (infoFillStatus == 2 || infoFillStatus == 3) {
            String fillInfoJson = winner.getUserInfo();
            if (GenericsUtils.notNullAndEmpty(fillInfoJson)) {
                JSONObject jsonObj = JSONObject.fromObject(fillInfoJson);
                String userName = jsonObj.getString("name");
                String mobile = jsonObj.getString("mobile");
                String wechatNumber = jsonObj.getString("wechatNumber");
                retMap.put("userName", userName);
                retMap.put("mobile", mobile);
                retMap.put("wechatNumber", wechatNumber);
            }
        }
        Long orgId = detail.getOrgId();
        OrgInfoSimpleDto orgInfo;
        try {
            orgInfo = this.orgInfoService.getOrgInfo(orgId);
            String orgName = orgInfo.getShortName();
            String logo = orgInfo.getLogo();
            retMap.put("orgLogo", logo);
            retMap.put("orgName", orgName);
            retMap.put("name", prizeInfo.getName());
            retMap.put("url", prizeInfo.getUrl());
            retMap.put("grade", prizeInfo.getGrade());
        } catch (Exception e) {
            log.error("error ", e);
        }
        return retMap;
    }

    @Override
    public ShareDto getShareInfo(long activityId, long orgId) {
        log.info("[ShareDraw] Param: activityId=" + activityId + ";orgId=" + orgId);
        ShareDto dto = new ShareDto();
        DrawInfo info = activityDao.getDrawInfoDetail(activityId, null);
        if (info == null) {
            return dto;
        }

        dto.setTitle(info.getName());

        try {
            Template template = templateDao.selectTemplateById(info.getTemplateId());
            dto.setImageUrl(template.getThumbNail());
            dto.setContent(ConstantEnums.findProperties(
                TemplateSuffix.getSuffixKey(TemplateTypeCategory.DRAW_TYPE, template.getTemplateId(), "slogan")));
        } catch (Exception e) {
            e.printStackTrace();
        }
        dto.setShareUrl(getUrl(activityId, info.getTemplateId()));
        return dto;
    }

    private String getUrl(long activityId, int templateId) {
        log.info("[param] activityId=" + activityId + ";templateId=" + templateId);
        CustomActivityDto dto = customActivityService.getCustomActivity((int) activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        } else {
            return "";
        }
    }

    @Override
    public void deleteDrawActivity(Long activityId) {
        DrawInfo drawInfo = drawActivityDao.getDrawInfoDetail(activityId, null);
        if (drawInfo != null) {
            this.redisService.setchangeActivityStatus(activityId, TemplateTypeCategory.DRAW_TYPE.getType(),
                DeleteStatus.IS_DELETE.getCode());
            DrawInfo updateInfo = new DrawInfo();
            updateInfo.setActivityId(activityId);
            updateInfo.setDelStatus(DeleteStatus.IS_DELETE.getCode());
            updateInfo.setUpdateTime(new Timestamp(new Date().getTime()));
            this.drawActivityDao.updateDrawActivity(updateInfo);

            // 同步tx_activity_conf
            TxActivityCommon conf =
                txActivityCommonDao.getTxActivityCommon(drawInfo.getOrgId(), drawInfo.getTemplateTypeId(), activityId);
            conf.setDelStatus(DeleteStatus.IS_DELETE.getCode());
            conf.setUpdateTime(new Date());
            txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, "delStatus", "updateTime");
            log.info("[Draw] delete status set success confId:{}", conf.getId());
        } else {
            log.warn("[Draw] draw is not exist or delete.activityId=" + activityId);
        }
    }
}
