package com.baijia.tianxiao.biz.marketing.draw.service;

import java.util.Map;

import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityBase;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRenderDto;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRequest;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawResult;

/**
 * Created by liuxp on 16/4/7.
 */
public interface BizDrawActivityService {

    /**
     * 添加一个抽奖活动
     *
     * @param request
     * @return
     */
    public DrawActivityBase addDrawActivity(DrawActivityRequest request);

    /**
     * 导出参与者
     *
     * @param request
     * @return
     */
    public TwoTuple<Integer, String> exportUserList(DrawActivityRequest request);

    /**
     * 导出获奖者名单，发送至指定的邮箱
     *
     * @param request
     * @return
     */
    public TwoTuple<Integer, String> exportWinnerList(DrawActivityRequest request);

    /**
     * 活动抽奖
     *
     * @param activityId
     * @param wechatOpenId
     * @param appId
     */
    public DrawResult draw(long activityId, String wechatOpenId, String fillInfoJson, String targetOpenId);

    /**
     * 获取分享信息
     * 
     * @param activityId
     * @param orgId
     * @return
     */
    public ShareDto getShareInfo(long activityId, long orgId);

    /**
     * 活动渲染
     * 
     * @param request
     * @return
     */
    public DrawActivityRenderDto renderDrawActivity(DrawActivityRequest request);

    /**
     * 获取奖品
     * 
     * @param drawId
     * @return
     */
    public Map<String, Object> getPrize(Long drawId);

    /**
     * 删除抽奖活动
     */
    public void deleteDrawActivity(Long activityId);
}
