/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.utils;

import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchMailSender {
    private static final Logger log = LoggerFactory.getLogger(SynchMailSender.class);
    private static String ip;
    public static final String SINGLE_INFO_FORMAT = "<font color='red'>\u9891\u9053:%s ------------ %s</font><br/>";
    private static final String SUCCESS_TEMPLATE = "Hi,xxx\u4eec,\u672c\u6b21\u5934\u6761\u540c\u6b65\u4efb\u52a1\u5b8c\u6210\u72b6\u6001:%s,\u673a\u5668IP:%s\u5177\u4f53\u8be6\u60c5\u4e3a:<br/><br/>%s <br/>";
    private static final String FAILURE_TEMPLATE = "<font size='18' color='orange' >\u672c\u6b21\u722c\u53d6\u4efb\u52a1\u5931\u8d25\u4e86\uff0c\u5177\u4f53\u539f\u56e0\u6b63\u5728\u6392\u67e5,\u5982\u679c\u6025\u7684\u8bdd\u8bf7\u8054\u7cfb{\u4f59\u6587\u6d69:18270826271},\u89c1\u8c05!</br>";

    public static void sendNotifyMail(Map<String, Integer> typeCounts) {
        if (GenericsUtils.isNullOrEmpty(typeCounts)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : typeCounts.entrySet()) {
            String key = entry.getKey();
            Integer count = entry.getValue();
            sb.append(String.format(SINGLE_INFO_FORMAT, key, count));
        }
        String content = SynchMailSender.createContent(true, sb.toString());
        SynchMailSender.sendMail(content, "\u5934\u6761\u6587\u4ef6\u540c\u6b65\u76d1\u63a7", "yuwenhao@baijiahulian.com");
    }

    public static void sendMail(String content, String subject, String ... emails) {
        if (GenericsUtils.isNullOrEmpty((Object)emails)) {
            log.info("can not send mail cause by not assign any email receiver ");
            return;
        }
        try {
            Mail mail = new Mail();
            String from = ConstantEnums.MAILBOX_FROM.value();
            String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
            String username = ConstantEnums.MAILBOX_USERNAME.value();
            String password = ConstantEnums.MAILBOX_PASSWORD.value();
            mail.setFrom(from);
            mail.setContent(content);
            for (String email : emails) {
                mail.addToAddress(email);
            }
            mail.setSubject(subject);
            Session session = null;
            session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession((String)host, (String)username, (String)password) : MailUtils.createSession((String)host);
            MailUtils.send((Session)session, (Mail)mail);
            log.info("send successful");
        }
        catch (Exception ex) {
            log.error("can not send email cause by {}", (Throwable)ex);
        }
    }

    private static String createContent(boolean isOk, String info) {
        String append = "";
        if (!isOk) {
            append = FAILURE_TEMPLATE;
        }
        String successRet = String.format(SUCCESS_TEMPLATE, isOk ? "\u6210\u529f" : "\u5931\u8d25", ip, info, append);
        return successRet;
    }

    static {
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            ip = " unknow ";
        }
    }
}

