/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.smsGroupSend.service;

import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RandomLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonService {
    private static final Logger log = LoggerFactory.getLogger(RedissonService.class);
    private static RedissonService instance;
    private String filename;
    private static RedissonClient redisson;

    public RedissonService(String filename) throws FileNotFoundException, IOException {
        this.init(filename);
    }

    public static RedissonService getInstance() {
        return instance;
    }

    public static synchronized RedissonService getInstance(String filename) {
        if (instance == null) {
            try {
                instance = new RedissonService(filename);
            }
            catch (FileNotFoundException e) {
                log.error("can not find the init file for redis : {}", (Object)filename);
            }
            catch (IOException e) {
                log.error("error ", (Throwable)e);
            }
        }
        return instance;
    }

    public RedissonClient getClient() {
        return redisson;
    }

    public void init(String filename) throws FileNotFoundException, IOException {
        Properties props = PropertiesReader.getProperties((String)filename);
        String masterName = props.getProperty("redis.masterName");
        String masteAddress = props.getProperty("redis.masteAddress");
        int deploymeModel = Integer.valueOf(props.getProperty("redis.deploymentModel"));
        int timeout = Integer.valueOf(props.getProperty("redis.timeout"));
        String password = props.getProperty("redis.password");
        int database = Integer.valueOf(props.getProperty("redis.visit.db"));
        String hosts = props.getProperty("redis.hosts");
        switch (deploymeModel) {
            case 1: {
                redisson = this.getSingleClient(hosts, password, database, timeout);
                break;
            }
            case 2: {
                redisson = this.getMasterSlaveClient(masteAddress, hosts);
                break;
            }
            case 3: {
                redisson = this.getSentinelClient(masterName, hosts);
                break;
            }
            case 4: {
                redisson = this.getClusterClient(hosts);
            }
        }
    }

    public RedissonClient getSingleClient(String host, String password, int database, int timeout) {
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(host).setPassword(password)).setDatabase(database).setTimeout(timeout)).setConnectionPoolSize(1000);
        RedissonClient redisson = Redisson.create((Config)config);
        return redisson;
    }

    public RedissonClient getMasterSlaveClient(String add, String hosts) {
        Config config = new Config();
        String[] hostarr = hosts.split(",");
        ((MasterSlaveServersConfig)((MasterSlaveServersConfig)config.useMasterSlaveServers().setMasterAddress(add).setLoadBalancer((LoadBalancer)new RandomLoadBalancer())).addSlaveAddress(hostarr).setMasterConnectionPoolSize(10000)).setSlaveConnectionPoolSize(10000);
        RedissonClient redisson = Redisson.create((Config)config);
        return redisson;
    }

    public RedissonClient getSentinelClient(String masterName, String hosts) {
        String[] hostarr = hosts.split(",");
        Config config = new Config();
        ((SentinelServersConfig)config.useSentinelServers().setMasterName(masterName).addSentinelAddress(hostarr).setMasterConnectionPoolSize(10000)).setSlaveConnectionPoolSize(10000);
        RedissonClient redisson = Redisson.create((Config)config);
        return redisson;
    }

    @Deprecated
    public RedissonClient getClusterClient(String hosts) {
        Config config = new Config();
        ((ClusterServersConfig)config.useClusterServers().setScanInterval(2000).addNodeAddress(new String[]{"127.0.0.1:7000", "127.0.0.1:7001"}).setMasterConnectionPoolSize(10000)).setSlaveConnectionPoolSize(10000);
        RedissonClient redisson = Redisson.create((Config)config);
        return redisson;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedissonService)) {
            return false;
        }
        RedissonService other = (RedissonService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedissonService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        return result;
    }

    public String toString() {
        return "RedissonService(filename=" + this.getFilename() + ")";
    }

    static {
        redisson = null;
    }
}

