/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.draw.service.impl;

import com.baijia.tianxiao.biz.marketing.draw.service.BizDrawActivityService;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.constants.TemplateSuffix;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.DeleteStatus;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.Status;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.WechatException;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelHelper;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.sal.marketing.commons.utils.NumberFormat;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityBase;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityDetail;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRenderDto;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRequest;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawCacheDto;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawResult;
import com.baijia.tianxiao.sal.marketing.draw.enums.DrawCode;
import com.baijia.tianxiao.sal.marketing.draw.service.ActivityUserService;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawPrizesService;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawService;
import com.baijia.tianxiao.sal.marketing.draw.service.WinnerService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.mail.Session;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizDrawActivityServiceImpl
implements BizDrawActivityService {
    private static final Logger log = LoggerFactory.getLogger(BizDrawActivityServiceImpl.class);
    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private FansService fansService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private DrawPrizesService drawPrizesService;
    @Autowired
    private ActivityUserService activityUserService;
    @Autowired
    private WinnerService winnerService;
    @Autowired
    private DrawService drawService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private PrizeInfoDao prizeInfoDao;
    @Autowired
    private DrawActivityDao activityDao;
    @Autowired
    private TxActivityCommonService txActivityCommonService;
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;
    private static final ThreadLocalRandom random = ThreadLocalRandom.current();

    @Override
    @Transactional(value="yunyingTransactionManager")
    public DrawActivityBase addDrawActivity(DrawActivityRequest request) {
        TwoTuple buildDetailPo = DrawActivityDetail.buildDetailPo((DrawActivityDetail)request);
        DrawInfo di = (DrawInfo)buildDetailPo.first;
        di.setStatus(Integer.valueOf(1));
        Long current = new Date().getTime();
        Timestamp currentTimestamp = new Timestamp(current);
        di.setCreateTime(currentTimestamp);
        di.setUpdateTime(currentTimestamp);
        this.txActivityCommonService.checkoutOrgActivityVipLevelAndAmount(request.getOrgId());
        Long activityId = this.drawActivityDao.addDrawActivity(di);
        log.info("[Draw] drawInfo param:{}", (Object)di);
        TxActivityCommon conf = new TxActivityCommon();
        this.txActivityCommonService.saveOrUpdateTxActivityCommon(conf, TemplateTypeCategory.DRAW_TYPE, (Object)di, null, new String[0]);
        List prizeInfos = (List)buildDetailPo.second;
        if (GenericsUtils.notNullAndEmpty((Object)prizeInfos)) {
            for (PrizeInfo pi : prizeInfos) {
                pi.setActivityId(activityId);
                if (!GenericsUtils.isNullOrEmpty((Object)pi.getUrl())) continue;
                pi.setUrl(ConstantEnums.findProperties((String)TemplateSuffix.getSuffixKey((TemplateTypeCategory)TemplateTypeCategory.DRAW_TYPE, (Number)request.getTemplateId(), (String)"DEFAULT_IMAGE")));
            }
            this.drawPrizesService.addPrizeInfo(prizeInfos);
        }
        this.templateDao.updateTemplateUseCount(Long.valueOf(request.getTemplateId().longValue()));
        log.info("[Param]=" + ToStringBuilder.reflectionToString((Object)request));
        Template template = this.templateDao.selectTemplateById(request.getTemplateId());
        try {
            CustomActivityDto wechat = this.customActivityService.createCustomActivityForReplace(request.getReplaceOrgId(), request.getOrgId().intValue(), activityId.intValue(), request.getTemplateId().intValue(), request.getName(), request.getIntroduction(), template.getThumbNail());
            log.info("wechat is : {} ", (Object)wechat);
            if (wechat == null) {
                throw new RuntimeException("\u521b\u5efa\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.warn("[DrawActivity] create error.{}", (Throwable)e);
            throw new WechatException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5fae\u4fe1\u516c\u4f17\u53f7\u6743\u9650\uff01");
        }
        request.setActivityId(activityId);
        return this.drawService.getActivityDetail(request);
    }

    @Override
    public TwoTuple<Integer, String> exportUserList(DrawActivityRequest request) {
        Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            log.info("can not find an org with org_ID {}", (Object)orgId);
            return TupleUtil.tuple((Object)400, (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String orgName = simple.getShortName();
        String email = request.getEmail();
        return this.createPartakeStatisticsMail(orgId, activityId, orgName, email);
    }

    @Override
    public TwoTuple<Integer, String> exportWinnerList(DrawActivityRequest request) {
        Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            log.info("can not find an org with org_ID {}", (Object)orgId);
            return TupleUtil.tuple((Object)400, (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String orgName = simple.getShortName();
        String email = request.getEmail();
        return this.createWinnerStatisticsMail(orgId, activityId, orgName, email);
    }

    private TwoTuple<Integer, String> createPartakeStatisticsMail(Long orgId, Long activityId, String orgName, String email) {
        List activityUserStatistics = this.activityUserService.getActivityUserStatistics(activityId.longValue(), orgId.longValue());
        if (GenericsUtils.isNullOrEmpty((Object)activityUserStatistics)) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6682\u65e0\u53c2\u4e0e\u7528\u6237");
        }
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        boolean isNotLimited = this.redisService.addOrgEmailCount(drawInfo.getOrgId().longValue(), activityId.longValue(), drawInfo.getTemplateTypeId().intValue(), EmailType.USER);
        if (!isNotLimited) {
            log.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)("\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5"));
        }
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (DairyCountStatistics statistics : activityUserStatistics) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            String data = statistics.getDate();
            String count = String.valueOf(statistics.getCount());
            rowMap.put("\u65e5\u671f", data);
            rowMap.put("\u53c2\u4e0e\u8005", count);
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_RRAW_SUBJECT_PARTAKE.value();
        String content = ConstantEnums.MAILBOX_DRAW_CONTENT_PARTAKE.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        this.sendMail(email, orgName, subject, content, activityId, rows);
        return TupleUtil.tuple((Object)TupleUtil.OK, (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    private TwoTuple<Integer, String> createWinnerStatisticsMail(Long orgId, Long activityId, String orgName, String email) {
        List winnerStatistics = this.winnerService.getWinnerList(activityId.longValue(), null);
        if (GenericsUtils.isNullOrEmpty((Object)winnerStatistics)) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6682\u65e0\u4e2d\u5956\u7528\u6237");
        }
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        boolean isNotLimited = this.redisService.addOrgEmailCount(drawInfo.getOrgId().longValue(), activityId.longValue(), drawInfo.getTemplateTypeId().intValue(), EmailType.WINNER);
        if (!isNotLimited) {
            log.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)("\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5"));
        }
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (Winner winner : winnerStatistics) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            String grade = NumberFormat.numToWord((int)winner.getGrade()) + "\u7b49\u5956";
            rowMap.put("\u7f16\u53f7", String.valueOf(winner.getDrawId()));
            rowMap.put("\u5956\u54c1\u7b49\u7ea7", grade);
            rowMap.put("\u5956\u54c1\u540d\u79f0", winner.getPrizeName());
            rowMap.put("\u4e2d\u5956\u5fae\u4fe1\u6635\u79f0", winner.getNickName());
            rowMap.put("\u4e2d\u5956\u5fae\u4fe1OpenId", winner.getWechatOpenId());
            rowMap.put("\u4e2d\u5956\u65f6\u95f4", DateUtil.getStrByDateFormate((Date)winner.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rowMap.put("\u767b\u8bb0\u65f6\u95f4", DateUtil.getStrByDateFormate((Date)winner.getCheckInTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rowMap.put("\u59d3\u540d", winner.getName());
            rowMap.put("\u624b\u673a\u53f7", winner.getMobile());
            rowMap.put("\u5730\u5740", winner.getAddress());
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_DRAW_SUBJECT_WINNER.value();
        String content = ConstantEnums.MAILBOX_DRAW_CONTENT_WINNER.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        this.sendMail(email, orgName, subject, content, activityId, rows);
        return TupleUtil.tuple((Object)TupleUtil.OK, (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    public void sendMail(final String email, String orgName, final String subject, final String content, final Long activityId, final List<Map<String, String>> rows) {
        MailSendExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File reportFile = null;
                try {
                    String password;
                    String username;
                    String host;
                    Mail mail;
                    block11: {
                        mail = new Mail();
                        String from = ConstantEnums.MAILBOX_FROM.value();
                        host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                        username = ConstantEnums.MAILBOX_USERNAME.value();
                        password = ConstantEnums.MAILBOX_PASSWORD.value();
                        mail.setFrom(from);
                        mail.setContent(content);
                        mail.addToAddress(email);
                        mail.setSubject(subject);
                        String filename = activityId + "_" + DateUtil.getStrByDate((Date)new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap((List)rows, (String)filename);
                        if (reportFile != null) break block11;
                        return;
                    }
                    try {
                        log.info("PARTAKE FILE  path is : {}", (Object)reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    }
                    catch (Exception e) {
                        log.error("error :", (Throwable)e);
                    }
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession((String)host, (String)username, (String)password) : MailUtils.createSession((String)host);
                    MailUtils.send((Session)session, (Mail)mail);
                    log.info("send successful");
                }
                catch (Exception ex) {
                    log.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public DrawResult draw(long activityId, String wechatOpenId, String fillInfoJson, String targetOpenId) {
        ActivityUser user;
        DrawResult drawResult = new DrawResult();
        Integer status = this.redisService.getActivityStatus(Long.valueOf(activityId), Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()));
        if (status != null && status == DeleteStatus.IS_DELETE.code) {
            drawResult.setCode(DrawCode.DELETE.getCode());
            return drawResult;
        }
        DrawCacheDto drawCacheDto = this.redisService.getDrawActivityBase(activityId);
        if (drawCacheDto == null) {
            drawCacheDto = this.drawService.getDrawCacheDtoFromDbById(activityId);
            this.redisService.setDrawActivityBase(activityId, drawCacheDto);
        }
        if (drawCacheDto == null) {
            drawResult.setCode(DrawCode.ERROR.getCode());
            return drawResult;
        }
        log.info("[Draw] Cache Dto=" + ToStringBuilder.reflectionToString((Object)drawCacheDto));
        Integer infoFillStatus = drawCacheDto.getInfoFillStatus();
        log.info("0 infoFillStatus is : {} ", (Object)infoFillStatus);
        infoFillStatus = infoFillStatus == null ? 1 : infoFillStatus;
        log.info("1 infoFillStatus is : {} ", (Object)infoFillStatus);
        Fans fans = null;
        if (infoFillStatus == 1 || infoFillStatus == 3) {
            fans = this.fansService.getFans(drawCacheDto.getOrgId().intValue(), wechatOpenId);
            log.info(" fans 0 is : {} ", (Object)fans);
            CustomActivityDto wechatDto = this.customActivityService.getCustomActivity((int)activityId, drawCacheDto.getTemplateId());
            log.info("wechatDto is : {} ", (Object)wechatDto);
            boolean needAuth = false;
            if (wechatDto != null && wechatDto.getReplaceOrgId() != null) {
                Integer visitCount = this.redisService.visitCount(wechatOpenId, drawCacheDto.getOrgId());
                log.info("find visit count is : {} ", (Object)visitCount);
                if (visitCount == null || visitCount == 0) {
                    visitCount = 1;
                    needAuth = true;
                    this.redisService.setVisitCount(wechatOpenId, drawCacheDto.getOrgId(), visitCount);
                } else {
                    fans = fans == null || !fans.isSubscribed() ? this.fansService.getFans(wechatDto.getReplaceOrgId().intValue(), wechatOpenId) : fans;
                    fans.setSubscribe(Integer.valueOf(1));
                    log.info("fans 1 is : {} ", (Object)fans);
                    log.info("with replaceOrgId , and isSubscribed for ReplaceOrgId : {} ", (Object)wechatDto.getReplaceOrgId());
                }
            }
            log.info("needAuth is : {} ", (Object)needAuth);
            if (needAuth || fans == null || !fans.isSubscribed()) {
                drawResult.setCode(DrawCode.UN_BIND.getCode());
                drawResult.setQrcodeUrl(wechatDto.getQrCodeUrl());
                String replyWord = wechatDto.getKeyWord();
                if (GenericsUtils.notNullAndEmpty((Object)replyWord)) {
                    JSONArray array = JSONArray.fromObject((Object)replyWord);
                    JSONObject object = array.getJSONObject(0);
                    replyWord = object.getString("keyword");
                }
                drawResult.setKeyWord(replyWord);
                return drawResult;
            }
            if (infoFillStatus == 3) {
                infoFillStatus = 2;
            }
        }
        log.info("3 infoFillStatus is : {} ", (Object)infoFillStatus);
        boolean needUpdate = false;
        DrawCode drawCode = null;
        try {
            drawCode = this.validate(drawCacheDto);
        }
        catch (Exception e) {
            needUpdate = true;
        }
        if (drawCode != null || needUpdate) {
            drawCacheDto = this.drawService.getDrawCacheDtoFromDbById(activityId);
            this.redisService.setDrawActivityBase(activityId, drawCacheDto);
            this.validate(drawCacheDto);
            if (drawCode != null) {
                drawResult.setCode(drawCode.getCode());
                return drawResult;
            }
        }
        if ((user = this.activityUserDao.selectActivityUser(wechatOpenId, DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd"), activityId, TemplateTypeCategory.DRAW_TYPE.getType())) == null) {
            user = new ActivityUser();
            user.setActivityId(Long.valueOf(activityId));
            user.setCreateTime(new Date());
            user.setDoneCount(0);
            user.setDoneDate(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd"));
            user.setUpdateTime(new Date());
            user.setWechatOpenId(wechatOpenId);
        }
        if (user.getDoneCount() >= drawCacheDto.getLimitCount()) {
            drawResult.setCode(DrawCode.LIMIT_COUNT.getCode());
            return drawResult;
        }
        String preUserInfos = null;
        if (infoFillStatus == 2 && GenericsUtils.isNullOrEmpty((Object)fillInfoJson)) {
            if (GenericsUtils.isNullOrEmpty((Object)user.getUserInfo())) {
                drawResult.setCode(DrawCode.INFO_LOSE.getCode());
                return drawResult;
            }
            preUserInfos = user.getUserInfo();
        }
        user.setUserInfo(fillInfoJson);
        Date startTime = DateUtil.getStartOfDay((Date)new Date());
        Date endTime = DateUtil.getEndOfDay((Date)new Date());
        Map todayPrizeCount = this.winnerDao.selectPrizesByDate(activityId, startTime, endTime);
        int lucyDigit = this.luckyDraw(drawCacheDto.getBaseNum(), drawCacheDto.getProbabilities(), drawCacheDto.getPrizes(), todayPrizeCount);
        if (user.getId() == null) {
            user.setDoneCount(1);
            this.activityUserDao.insertActivityUser(user);
        } else {
            user.setDoneCount(user.getDoneCount() + 1);
            this.activityUserDao.updateActivityUserDoneCount(user);
        }
        if (lucyDigit > 0) {
            PrizeInfo[] prizes = drawCacheDto.getPrizes();
            log.info("[Draw] grade=" + lucyDigit);
            PrizeInfo prize = prizes[lucyDigit - 1];
            if (prize.getWinNum() >= prize.getCountLimit()) {
                drawResult.setCode(DrawCode.UN_WIN.getCode());
                return drawResult;
            }
            Integer count = (Integer)todayPrizeCount.get(lucyDigit);
            if (count != null && count > prize.getNumber()) {
                drawResult.setCode(DrawCode.UN_WIN.getCode());
                return drawResult;
            }
            drawResult.setCode(DrawCode.SUCCESS.getCode());
            drawResult.setName(prize.getName());
            drawResult.setGrade(lucyDigit);
            Winner winner = new Winner();
            winner.setGrade(lucyDigit);
            winner.setPrizeName(prize.getName());
            winner.setActivityId(Long.valueOf(activityId));
            winner.setWechatOpenId(wechatOpenId);
            winner.setNickName(fans == null ? wechatOpenId : fans.getNick());
            winner.setUserInfo(GenericsUtils.isNullOrEmpty((Object)fillInfoJson) ? preUserInfos : fillInfoJson);
            this.winnerDao.insertWinner(winner);
            drawResult.setDrawId(winner.getDrawId().longValue());
            prize.setWinNum(Integer.valueOf(prize.getWinNum() + 1));
            int updateNum = this.prizeInfoDao.updateWinNum(prize.getId().longValue());
            if (updateNum != 1) {
                PrizeInfo dbPrizeInfo = this.prizeInfoDao.getPrizeByCondition(Long.valueOf(activityId), prize.getGrade().intValue());
                prize.setWinNum(dbPrizeInfo.getWinNum());
                this.redisService.setDrawActivityBase(activityId, drawCacheDto);
                throw new BusinessException("\u5df2\u8d85\u51fa\u5956\u54c1\u603b\u6570\u91cf");
            }
        } else {
            drawResult.setCode(DrawCode.UN_WIN.getCode());
            return drawResult;
        }
        this.redisService.setDrawActivityBase(activityId, drawCacheDto);
        return drawResult;
    }

    private DrawCode validate(DrawCacheDto cacheDto) {
        Long currentTime = new Date().getTime();
        if (cacheDto == null) {
            log.info("[Draw] Validate.activity is not exist.");
            return DrawCode.ERROR;
        }
        if (cacheDto.getDelStatus().intValue() == DeleteStatus.IS_DELETE.getCode()) {
            return DrawCode.DELETE;
        }
        if (cacheDto.getStartTime() > currentTime) {
            return DrawCode.NOT_START;
        }
        if (cacheDto.getEndTime() <= currentTime) {
            return DrawCode.IS_END;
        }
        if (cacheDto.getStatus() == Status.CLOSED.getCode()) {
            return DrawCode.CLOSED;
        }
        return null;
    }

    private int luckyDraw(int base, int[] probabilities, PrizeInfo[] prizes, Map<Integer, Integer> todayPrizeCount) {
        for (int i = 0; i < prizes.length; ++i) {
            Integer count = todayPrizeCount.get(prizes[i].getGrade());
            if (count == null || prizes[i].getNumber() > count && prizes[i].getWinNum() < prizes[i].getCountLimit()) continue;
            log.info("[Draw] No prize =" + prizes[i].getGrade());
            base -= probabilities[i];
        }
        log.info("[Draw] base=" + base);
        if (base <= 0) {
            return -1;
        }
        int digit = random.nextInt(base);
        int rank = 0;
        for (int i = 0; i < probabilities.length; ++i) {
            Integer count = todayPrizeCount.get(prizes[i].getGrade());
            if (count != null && (prizes[i].getNumber() <= count || prizes[i].getWinNum() >= prizes[i].getCountLimit()) || digit >= (rank += probabilities[i])) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public DrawActivityRenderDto renderDrawActivity(DrawActivityRequest request) {
        DrawActivityRenderDto render = new DrawActivityRenderDto();
        DrawActivityDetail detail = this.drawService.getActivityDetail(request);
        if (detail == null) {
            return null;
        }
        try {
            BeanUtils.copyProperties((Object)render, (Object)detail);
            log.info("[Draw] orgId=" + detail.getOrgId());
            OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(detail.getOrgId());
            String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfo.getOrgNumber();
            render.setOrgWeiPage(weiPage);
            log.info(ToStringBuilder.reflectionToString((Object)orgInfo));
            render.setOrgName(orgInfo.getShortName());
            render.setOrgLogo(orgInfo.getLogo());
            String _400_phone = orgInfo.getExtension();
            if (StringUtils.isNotBlank((CharSequence)_400_phone)) {
                render.setOrgPhone("4000122166," + orgInfo.getExtension());
            } else {
                render.setOrgPhone("4000122166");
            }
            render.setOrgNumber(orgInfo.getOrgNumber());
        }
        catch (Exception e) {
            log.error("[Draw] Query orgInfo error.", (Throwable)e);
        }
        ActivityUser user = this.activityUserDao.selectActivityUser(request.getWechatOpenId(), DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd"), request.getActivityId().longValue(), TemplateTypeCategory.DRAW_TYPE.getType());
        Integer remainCount = render.getCountLimit();
        if (user != null) {
            remainCount = remainCount - user.getDoneCount();
        }
        render.setRemainCount(remainCount);
        return render;
    }

    @Override
    public Map<String, Object> getPrize(Long drawId) {
        String fillInfoJson;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Winner winner = this.winnerDao.selectWinnerById(drawId);
        if (winner == null) {
            return retMap;
        }
        PrizeInfo prizeInfo = this.prizeInfoDao.getPrizeByCondition(winner.getActivityId(), winner.getGrade());
        if (prizeInfo == null) {
            return retMap;
        }
        Long activityId = prizeInfo.getActivityId();
        DrawActivityRequest request = new DrawActivityRequest();
        request.setActivityId(activityId);
        DrawActivityDetail detail = this.drawService.getActivityDetail(request);
        Integer infoFillStatus = detail.getInfoFillStatus();
        if ((infoFillStatus == 2 || infoFillStatus == 3) && GenericsUtils.notNullAndEmpty((Object)(fillInfoJson = winner.getUserInfo()))) {
            JSONObject jsonObj = JSONObject.fromObject((Object)fillInfoJson);
            String userName = jsonObj.getString("name");
            String mobile = jsonObj.getString("mobile");
            String wechatNumber = jsonObj.getString("wechatNumber");
            retMap.put("userName", userName);
            retMap.put("mobile", mobile);
            retMap.put("wechatNumber", wechatNumber);
        }
        Long orgId = detail.getOrgId();
        try {
            OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(orgId);
            String orgName = orgInfo.getShortName();
            String logo = orgInfo.getLogo();
            retMap.put("orgLogo", logo);
            retMap.put("orgName", orgName);
            retMap.put("name", prizeInfo.getName());
            retMap.put("url", prizeInfo.getUrl());
            retMap.put("grade", prizeInfo.getGrade());
        }
        catch (Exception e) {
            log.error("error ", (Throwable)e);
        }
        return retMap;
    }

    @Override
    public ShareDto getShareInfo(long activityId, long orgId) {
        log.info("[ShareDraw] Param: activityId=" + activityId + ";orgId=" + orgId);
        ShareDto dto = new ShareDto();
        DrawInfo info = this.activityDao.getDrawInfoDetail(Long.valueOf(activityId), null);
        if (info == null) {
            return dto;
        }
        dto.setTitle(info.getName());
        try {
            Template template = this.templateDao.selectTemplateById(info.getTemplateId());
            dto.setImageUrl(template.getThumbNail());
            dto.setContent(ConstantEnums.findProperties((String)TemplateSuffix.getSuffixKey((TemplateTypeCategory)TemplateTypeCategory.DRAW_TYPE, (Number)template.getTemplateId(), (String)"slogan")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dto.setShareUrl(this.getUrl(activityId, info.getTemplateId()));
        return dto;
    }

    private String getUrl(long activityId, int templateId) {
        log.info("[param] activityId=" + activityId + ";templateId=" + templateId);
        CustomActivityDto dto = this.customActivityService.getCustomActivity((int)activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        }
        return "";
    }

    @Override
    public void deleteDrawActivity(Long activityId) {
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(activityId, null);
        if (drawInfo != null) {
            this.redisService.setchangeActivityStatus(activityId, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), Integer.valueOf(DeleteStatus.IS_DELETE.getCode()));
            DrawInfo updateInfo = new DrawInfo();
            updateInfo.setActivityId(activityId);
            updateInfo.setDelStatus(Integer.valueOf(DeleteStatus.IS_DELETE.getCode()));
            updateInfo.setUpdateTime(new Timestamp(new Date().getTime()));
            this.drawActivityDao.updateDrawActivity(updateInfo);
            TxActivityCommon conf = this.txActivityCommonDao.getTxActivityCommon(drawInfo.getOrgId(), drawInfo.getTemplateTypeId(), activityId);
            conf.setDelStatus(Integer.valueOf(DeleteStatus.IS_DELETE.getCode()));
            conf.setUpdateTime(new Date());
            this.txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, new String[]{"delStatus", "updateTime"});
            log.info("[Draw] delete status set success confId:{}", (Object)conf.getId());
        } else {
            log.warn("[Draw] draw is not exist or delete.activityId=" + activityId);
        }
    }
}

