
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.marketing.smsGroupSend.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.connection.balancer.RandomLoadBalancer;

import com.baijia.tianxiao.util.properties.PropertiesReader;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 29, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
@Data
@Deprecated
public class RedissonService {

    private static RedissonService instance;

    private String filename;

    /**
     * 通过应用项目手动配置bean
     * 
     * @param filename ：redis相关配置的配置文件
     * @throws FileNotFoundException
     * @throws IOException
     */
    public RedissonService(String filename) throws FileNotFoundException, IOException {
        init(filename);
    }

    /**
     * 使用构造器初始化对象
     * 
     * @return
     */
    public static RedissonService getInstance() {
        return instance;
    }

    /**
     * 如果当前对象已经基于构造器进行了构造，则该传参无效
     * 
     * @param filename
     * @return
     */
    public static synchronized RedissonService getInstance(String filename) {
        if (instance == null) {
            try {
                instance = new RedissonService(filename);
            } catch (FileNotFoundException e) {
                log.error("can not find the init file for redis : {}", filename);
            } catch (IOException e) {
                log.error("error ", e);
            }
        }
        return instance;
    }

    private static RedissonClient redisson = null;

    public RedissonClient getClient() {
        return redisson;
    }

    public void init(String filename) throws FileNotFoundException, IOException {
        Properties props = PropertiesReader.getProperties(filename);
        String masterName = props.getProperty("redis.masterName");
        String masteAddress = props.getProperty("redis.masteAddress");
        int deploymeModel = Integer.valueOf(props.getProperty("redis.deploymentModel")).intValue();
        int timeout = Integer.valueOf(props.getProperty("redis.timeout")).intValue();
        String password = props.getProperty("redis.password");
        int database = Integer.valueOf(props.getProperty("redis.default.db")).intValue();
        String hosts = props.getProperty("redis.hosts");

        // redis部署模式 SingleHost 1 MasterSlave 2 Sentinel 3 Cluster 4
        switch (deploymeModel) {
            case 1:
                redisson = getSingleClient(hosts, password, database, timeout);// 单机
                break;
            case 2:
                redisson = getMasterSlaveClient(masteAddress, hosts);
                break;
            case 3:
                redisson = getSentinelClient(masterName, hosts);
                break;
            case 4:
                redisson = getClusterClient(hosts);
                break;
        }

    }

    /**
     * singleClient
     * 
     * @param host
     * @return
     */
    public RedissonClient getSingleClient(String host, String password, int database, int timeout) {
        Config config = new Config();
        config.useSingleServer().setAddress(host).setPassword(password).setDatabase(database).setTimeout(timeout)
            .setConnectionPoolSize(1000);
        RedissonClient redisson = Redisson.create(config);
        return redisson;
    }

    /**
     * Master/Slave servers connection:
     * 
     * @param add
     * @param hosts
     * @return
     */
    public RedissonClient getMasterSlaveClient(String add, String hosts) {
        Config config = new Config();
        String[] hostarr = hosts.split(",");
        // RoundRobinLoadBalancer used by default
        config.useMasterSlaveServers().setMasterAddress(add).setLoadBalancer(new RandomLoadBalancer())
            .addSlaveAddress(hostarr).setMasterConnectionPoolSize(10000).setSlaveConnectionPoolSize(10000);
        RedissonClient redisson = Redisson.create(config);
        return redisson;
    }

    /**
     * Sentinel servers connection:
     * 
     * @param masterName
     * @param hosts
     * @return
     */
    public RedissonClient getSentinelClient(String masterName, String hosts) {
        String[] hostarr = hosts.split(",");
        Config config = new Config();
        config.useSentinelServers().setMasterName(masterName).addSentinelAddress(hostarr)
            .setMasterConnectionPoolSize(10000).setSlaveConnectionPoolSize(10000);
        RedissonClient redisson = Redisson.create(config);
        return redisson;
    }

    /**
     * Cluster nodes connections:
     * 
     * @param hosts
     * @return
     */
    @Deprecated
    public RedissonClient getClusterClient(String hosts) {
        Config config = new Config();
        config.useClusterServers().setScanInterval(2000) // sets cluster state scan interval
            .addNodeAddress("127.0.0.1:7000", "127.0.0.1:7001").setMasterConnectionPoolSize(10000)
            .setSlaveConnectionPoolSize(10000);
        RedissonClient redisson = Redisson.create(config);
        return redisson;
    }

}
