/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.wechat.constant.WechatAppServiceType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月25日
 * @desc
 */
@Service
@Slf4j
public class WechatStatisticServiceImpl implements WechatStatisticService {
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentDao OrgStudentDao;
    

    @Override
    public Map<Long, WechatStatisticData> getWechatStatisticData(Date startDate, Date endDate,
        List<Long> TianxiaoOrgIds, int way) {
        Map<Long, WechatStatisticData> wechatDatas = new HashMap<>();
        
        List<AuthorizerInfo> authorizerInfos = this.authorizerInfoDao.getAuthorizerInfosByOrgIds(TianxiaoOrgIds);
        List<String> hasOrgWechatCustomMenuOfAppIds = this.orgWechatCustomMenuDao.OrgIdsHasWechatMenu();
        if(GenericsUtils.notNullAndEmpty(authorizerInfos)){
            List<String> appIds = new ArrayList<>();
            for(AuthorizerInfo authorizerInfo : authorizerInfos){
                String appId = authorizerInfo.getAuthorizerAppId();
                appIds.add(appId);
            }
            
            //微信粉丝数
            Map<String, Integer> fansTotals = this.fansDao.fansTotaByAppIds(appIds, startDate, endDate);
            
            for(AuthorizerInfo authorizerInfo : authorizerInfos){
                String appId = authorizerInfo.getAuthorizerAppId();
                Long orgId = authorizerInfo.getOrgId().longValue();
                WechatStatisticData wechatData = wechatDatas.get(orgId);
                if(wechatData == null){
                    wechatData = new WechatStatisticData();
                    wechatDatas.put(orgId, wechatData);
                }
                wechatData.setIsWechatAuthorizer(true);
                int serviceType = authorizerInfo.getServiceType();
                String serviceTypeDesc = null;
                if(serviceType == WechatAppServiceType.SERVICE_APP.getValue()){
                    serviceTypeDesc = "服务号";
                }else{
                    serviceTypeDesc = WechatAppServiceType.getNote(serviceType);
                }
                wechatData.setServiceTypeDesc(serviceTypeDesc);
                
                if(hasOrgWechatCustomMenuOfAppIds.contains(appId)){
                    wechatData.setIsWechatMenu(true);
                }
                
                Integer wechatFansTotal = fansTotals.get(appId);
                wechatData.setWechatFansTotal(wechatFansTotal == null ? 0 : wechatFansTotal);
            }
            
        }

        
        Map<Long, Integer> studentsHasOrgWechat = new HashMap<>();
        //统计7天数据或者30天数据或者全部时需要导出今日完成总数据
        if(way != 0){
            studentsHasOrgWechat = this.OrgStudentDao.getOrgWechatAuthorizerOfStudentTotal(TianxiaoOrgIds);
        }
        
        if(GenericsUtils.notNullAndEmpty(studentsHasOrgWechat)){
            for(Long orgId : studentsHasOrgWechat.keySet()){
                WechatStatisticData wechatData = wechatDatas.get(orgId);
                if(wechatData == null){
                    wechatData = new WechatStatisticData();
                    wechatDatas.put(orgId, wechatData);
                }
                Integer wechatAuthorizerOfStudentTotal = studentsHasOrgWechat.get(orgId);
                log.info("机构=====" +orgId+"======绑定微信公众号的学生============" + wechatAuthorizerOfStudentTotal);
                wechatData.setWechatAuthorizerOfStudentTotal(wechatAuthorizerOfStudentTotal);
            }
        }
        return wechatDatas;

    }

}
