/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.marketing.export.constant.AccountTypeEnum;
import com.baijia.tianxiao.biz.marketing.export.constant.TeacherStatus;
import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ClassLessonDetailDto;
import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ExportClientDemandDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgCourseDetailDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgSignDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgTypeDto;
import com.baijia.tianxiao.biz.marketing.export.dto.StatisticByWeekOrMonthDto;
import com.baijia.tianxiao.biz.marketing.export.dto.TxBacklogStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ExportOrgInfoService;
import com.baijia.tianxiao.biz.marketing.export.service.OrgTypeService;
import com.baijia.tianxiao.biz.marketing.export.service.TxBacklogStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.biz.marketing.utils.BIzConf;
import com.baijia.tianxiao.biz.marketing.utils.HagTianxiaoOrgNumber;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.UploadRecordDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.UploadRecord;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.advisory.dao.dto.CallStatisticDto;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.export.dao.TXLogStatEventDao;
import com.baijia.tianxiao.dal.export.dao.TXStatisticDataDao;
import com.baijia.tianxiao.dal.export.dto.LogStatisticDto;
import com.baijia.tianxiao.dal.export.po.TXStatisticData;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgAppLoginLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.MsgRecordDto;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityStatisticsData;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityDataExportService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelUtil;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawStatisticData;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawDataExportService;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportKeyData;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralStatisticData;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteDataStatisticService;
import com.baijia.tianxiao.upload.AliyunUploadUtil;
import com.baijia.tianxiao.util.GenericsUtils;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * @author gaodan
 * @createdate 2016年4月18日
 * @desc
 */
@Service
@Slf4j
public class ExportOrgInfoServiceImpl implements ExportOrgInfoService {
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ActivityDataExportService activityDataExportService;
    @Autowired
    private DrawDataExportService drawDataExportService;
    @Autowired
    private VoteDataStatisticService voteDataStatisticService;
    @Autowired
    private ReferralStatisticsService referralStatisticsService;
    @Autowired
    private TxBacklogStatisticService txBacklogStatisticService;
    @Autowired
    private ConsultMessageStatisticService consultMessageStatisticService;
    @Autowired
    private CRMStatisticService crmStatisticService;
    @Autowired
    private WechatStatisticService wechatStatisticService;
    @Autowired
    private ERPStatisticService erpStatisticService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseRoomDao courseRoomDao;
    @Autowired
    private OrgGroupMsgDao groupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao groupMsgReceiverDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    @Autowired
    private TxMonitorTypeDayDao txMonitorTypeDayDao;
    @Autowired
    private OrgAppLoginLogDao orgAppLoginLogDao;
    @Autowired
    private TtsSmsDao ttsSmSDao;
    @Autowired
    private TxSmsDao txSmsDao;
    @Autowired
    private UploadRecordDao uploadRecordDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgCallRecorderDao OrgCallRecorderDao;
    @Autowired
    private FreeMarkerConfigurer freeMarkerConfigurer;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private TXStatisticDataDao txStatisticDataDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private OrgGroupMsgDao orgGroupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao orgGroupMsgReceiverDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgClassRoomDao OrgClassRoomDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgTypeService orgTypeService;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TXLogStatEventDao txLogStatEventDao;

    @Override
    public void createExcelOrgSignInfo() {
        Integer accountType = AccountTypeEnum.ZHENGSHI.getCode();
        List<Long> TianxiaoOrgIds = this.getOrgIdsByAccount(accountType);

        Map<Long, Integer> orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        List<Integer> TianxiaoOrgNumbers = new ArrayList<>();
        for (Long orgId : orgNumberMap.keySet()) {
            Integer orgNumber = orgNumberMap.get(orgId);
            TianxiaoOrgNumbers.add(orgNumber);
        }

        List<OrgLessonSign> signs = this.orgLessonSignDao.getOrgClassLesson(TianxiaoOrgIds);
        Set<Long> userIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        Set<Long> courseIds = new HashSet<>();
        Set<Long> lessonIds = new HashSet<>();
        for (OrgLessonSign sign : signs) {
            Long userId = sign.getUserId();
            userIds.add(userId);

            Long orgId = sign.getOrgId();
            orgIds.add(orgId);

            Long courseId = sign.getCourseId();
            courseIds.add(courseId);

            Long lessonId = sign.getLessonId();
            lessonIds.add(lessonId);
        }

        Map<Long, OrgCourse> orgCourseMap = this.orgCourseDao.getOrgCourseMap(courseIds);

        Map<Long, OrgStudent> orgStudentMap = this.orgStudentDao.getOrgStudentMapByUserIds(userIds);

        Map<Long, OrgTeacherLesson> orgTeacherLessonMap =
                this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(lessonIds);

        Set<Long> userIdsofTeacher = new HashSet<>();
        for (Long lessonId : orgTeacherLessonMap.keySet()) {
            OrgTeacherLesson orgTeacherLesson = orgTeacherLessonMap.get(lessonId);
            Long userId = orgTeacherLesson.getTeacherId();
            userIdsofTeacher.add(userId);
        }

        Map<Long, String> teacherNameMap = this.teacherDao.getTeacherRealNameMap(userIdsofTeacher);

        log.info("得到signs的长度为==========" + signs.size());
        if (GenericsUtils.notNullAndEmpty(signs)) {
            final List<Map<String, String>> rows = new ArrayList<>();
            for (OrgLessonSign sign : signs) {
                OrgStudent orgStudent = orgStudentMap.get(sign.getUserId());
                if (GenericsUtils.notNullAndEmpty(orgStudent)) {
                    OrgSignDto orgSignDto = new OrgSignDto();
                    String studentName = orgStudent.getName();
                    orgSignDto.setStudentId(orgStudent.getId());
                    orgSignDto.setStudentName(studentName == null ? "" : studentName);

                    Integer orgNumber = orgNumberMap.get(sign.getOrgId());
                    orgSignDto.setOrgNumber(orgNumber);

                    orgSignDto.setLessonId(sign.getLessonId());
                    Date date = sign.getCreateTime();
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    String signDate = sdf1.format(date);
                    SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
                    String signTime = sdf2.format(date);
                    orgSignDto.setSignDate(signDate);
                    orgSignDto.setSignTime(signTime);

                    int status = sign.getStatus();
                    orgSignDto.setStatusDesc(SignStatus.getSignStatusByCode(status).getMessage());

                    OrgCourse orgCourse = orgCourseMap.get(sign.getCourseId());
                    if (GenericsUtils.notNullAndEmpty(orgCourse)) {
                        String courseName = orgCourse.getName();
                        orgSignDto.setCourseName(courseName == null ? "" : courseName);
                    } else {
                        orgSignDto.setCourseName("");
                    }

                    // 老师名称
                    OrgTeacherLesson orgTeacherLesson = orgTeacherLessonMap.get(sign.getLessonId());
                    if (GenericsUtils.notNullAndEmpty(orgTeacherLesson)) {
                        Long userId = orgTeacherLesson.getTeacherId();
                        String teacherName = teacherNameMap.get(userId);
                        if (teacherName == null || teacherName == "") {
                        }
                        orgSignDto.setTeacherName(teacherName == null ? "" : teacherName);
                    } else {
                        orgSignDto.setTeacherName("");
                    }
                    Map<String, String> rowMap = new LinkedHashMap<>();
                    rowMap.put("机构number", orgSignDto.getOrgNumber() + "");
                    rowMap.put("微客名称", orgSignDto.getCourseName());
                    rowMap.put("课节id", orgSignDto.getLessonId() + "");
                    rowMap.put("签到日期", orgSignDto.getSignDate());
                    rowMap.put("签到时间", orgSignDto.getSignTime());
                    rowMap.put("课节老师", orgSignDto.getTeacherName());
                    rowMap.put("学员姓名", orgSignDto.getStudentName());
                    rowMap.put("学员id", orgSignDto.getStudentId() + "");
                    rowMap.put("签到状态", orgSignDto.getStatusDesc());

                    rows.add(rowMap);
                }
            }

            String subject = "课程签到信息";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "signInfo";
            ExcelMailSender.sendMail(mail, subject, content, fileName, rows);
        }
    }

    @Override
    public void createExcelOrgGroupMsgInfo() {
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao机构账号列表长度==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);

        Map<Long, Integer> orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        final List<Map<String, String>> rows = new ArrayList<>();

        Map<Long, List<OrgGroupMsg>> orgGroupMsgMap = this.orgGroupMsgDao.getOrgGroupMsgMap(null, null, TianxiaoOrgIds);
        for (Long orgId : orgGroupMsgMap.keySet()) {
            List<OrgGroupMsg> orgGroupMsgs = orgGroupMsgMap.get(orgId);
            Map<Long, OrgGroupMsg> orgGroupMsgMapByMsgId = new HashMap<>();
            List<Long> ids = new ArrayList<>();
            if (GenericsUtils.notNullAndEmpty(orgGroupMsgs)) {
                for (OrgGroupMsg orgGroupMsg : orgGroupMsgs) {
                    Long id = orgGroupMsg.getId();
                    orgGroupMsgMapByMsgId.put(id, orgGroupMsg);
                    ids.add(id);
                }

                Map<Long, Integer> msgReceiverTotalMap =
                        this.orgGroupMsgReceiverDao.getMsgReceiverTotalByMsgId(null, ids);
                Map<Long, Integer> msgReceiverViewTotalMap =
                        this.orgGroupMsgReceiverDao.getMsgReceiverTotalByMsgId(true, ids);

                for (Long msgId : ids) {
                    Map<String, String> rowMap = new LinkedHashMap<>();
                    Integer msgReceiverTotal = msgReceiverTotalMap.get(msgId);
                    log.info("接收人数===========" + msgReceiverTotal);
                    Integer msgReceiverViewTotal = msgReceiverViewTotalMap.get(msgId);
                    log.info("查看呐人数===========" + msgReceiverViewTotal);

                    Integer orgNumber = orgNumberMap.get(orgId);
                    rowMap.put("机构number", orgNumber + "");
                    rowMap.put("群发消息id", msgId + "");
                    String subject = orgGroupMsgMapByMsgId.get(msgId).getSubject();
                    rowMap.put("群发消息名称", subject == null ? "" : subject);
                    Date time = orgGroupMsgMapByMsgId.get(msgId).getCreateTime();
                    rowMap.put("发送时间", time + "");

                    int total1 = msgReceiverTotal == null ? 0 : msgReceiverTotal;
                    int total2 = msgReceiverViewTotal == null ? 0 : msgReceiverViewTotal;
                    rowMap.put("接收人数", total1 + "");
                    rowMap.put("查看人数", total2 + "");

                    rows.add(rowMap);
                }
            }

        }

        String subject = "群发消息信息统计";
        String content = "";
        String mail = "gaodan@baijiahulian.com";
        String fileName = "signInfo";
        ExcelMailSender.sendMail(mail, subject, content, fileName, rows);

    }

    private List<Long> getTianxiaoOrgIds(List<Integer> TianxiaoOrgNumbers) {
        List<OrgAccount> TianxiaoOrgAccounts = orgAccountDao.getAccountByNumbers(TianxiaoOrgNumbers, "id", "number");
        List<Long> TianxiaoOrgIds =
                CollectionUtils.extractList(TianxiaoOrgAccounts, new CollectionUtils.Extracter<Long, OrgAccount>() {
                    @Override
                    public Long extract(OrgAccount arg0) {
                        return arg0.getId().longValue();
                    }
                });
        return TianxiaoOrgIds;
    }

    @Override
    public void createExcel(Date startTime, Date endTime) {
        Properties prop = PropertiesReader.fillProperties("upload.properties");
        String url = prop.getProperty("upload.server");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String uid = "tx_statistics_day_" + sdf.format(startTime);

        File file = new File("test.txt");
        try {
            file.createNewFile();
        } catch (IOException e) {
            e.printStackTrace();
        }
        UploadResult result = AliyunUploadUtil.uploadToRemote(url, uid, file, false);
        if (result.getFiles() != null && result.getFiles().size() > 0) {
            OrgStorage storage = new OrgStorage();
            storage.setFid(result.getFiles().get(0).getFid());
            storage.setCreateTime(new Date());
            storage.setUpdateTime(new Date());
            storage.setSize(result.getFiles().get(0).getSize());
            storage.setSn(result.getFiles().get(0).getSn());
            storage.setMimeType(0);
            orgStorageDao.save(storage);

            UploadRecord record = new UploadRecord();
            record.setCreateTime(new Date());
            record.setFileType(1);
            record.setStorageId(storage.getId().longValue());
            record.setUid(uid);
            uploadRecordDao.insertUploadRecord(record);
        }

    }

    @Override
    public void getOrgTypeInfo(Date startTime, Date endTime) {
        long start = System.currentTimeMillis();
        Map<Long, OrgTypeDto> orgTypeDtoMap = new HashMap<>();
        Integer accountType = AccountTypeEnum.ZHENGSHI.getCode();
        List<Long> TianxiaoOrgIds = this.getOrgIdsByAccount(accountType);

        Map<Long, Integer> orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);

        orgTypeDtoMap = this.orgTypeService.getOrgTypeDtoMap(TianxiaoOrgIds);

        // 线索
        Map<Long, ConsultMessageStatisticData> consultMessageDatas =
                this.consultMessageStatisticService.getConsultMessageData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(consultMessageDatas)) {
            for (Long orgId : consultMessageDatas.keySet()) {
                ConsultMessageStatisticData consultData = consultMessageDatas.get(orgId);

                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty(orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }

                orgTypeDto.setClueTotal(consultData.getClueTotal());
                orgTypeDto.setClueWechat(consultData.getClueWechat());
                orgTypeDto.setClueReserve(consultData.getClueReserve());
                orgTypeDto.setClueCall(consultData.getClueCall());
            }

        }

        // 在读学员总数
        Map<Long, CRMStatisticData> crmStatistics =
                this.crmStatisticService.getConsultUserSData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(crmStatistics)) {
            for (Long orgId : crmStatistics.keySet()) {
                CRMStatisticData statistic = crmStatistics.get(orgId);
                int studentTotal = statistic.getStudentTotal();
                int studyStudentTotal = statistic.getStudyStudentTotal();

                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty(orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                orgTypeDto.setStudentTotal(studentTotal);
                orgTypeDto.setStudyStudentTotal(studyStudentTotal);
            }
        }

        // 机构登录次数
        Map<Long, LogStatisticDto> logStatisticDtoMap =
                this.txLogStatEventDao.getLogStatisticDtoMap(TianxiaoOrgIds, startTime, endTime);
        if (GenericsUtils.notNullAndEmpty(logStatisticDtoMap)) {
            for (Long orgId : logStatisticDtoMap.keySet()) {
                LogStatisticDto logStatisticDto = logStatisticDtoMap.get(orgId);
                Integer loginAccountTotal = logStatisticDto.getLoginAccountTotal();
                Integer loginDeviceTotal = logStatisticDto.getLoginDeviceTotal();

                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty(orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                orgTypeDto.setLoginAccountTotal(loginAccountTotal == null ? 0 : loginAccountTotal);
                orgTypeDto.setLoginDeviceTotal(loginDeviceTotal == null ? 0 : loginDeviceTotal);
            }
        }

        Map<Long, Integer> orgOpenTotalMap =
                this.txLogStatEventDao.getOrgOpenTotalMap(TianxiaoOrgIds, startTime, endTime);

        if (GenericsUtils.notNullAndEmpty(orgOpenTotalMap)) {
            for (Long orgId : orgOpenTotalMap.keySet()) {
                Integer orgOpenTotal = orgOpenTotalMap.get(orgId);
                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty(orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                orgTypeDto.setOrgOpenTotal(orgOpenTotal == null ? 0 : orgOpenTotal);
            }
        }

        if (GenericsUtils.notNullAndEmpty(orgTypeDtoMap)) {
            final List<Map<String, String>> rows = new ArrayList<>();
            for (Long orgId : orgTypeDtoMap.keySet()) {
                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                Map<String, String> rowMap = new LinkedHashMap<>();
                rowMap.put("机构Id", orgId + "");
                rowMap.put("机构number", orgNumberMap.get(orgId) + "");
                if (orgTypeDto.getOrgVipLevelStr() != null) {
                    rowMap.put("机构版本类型", orgTypeDto.getOrgVipLevelStr() + "");
                } else {
                    rowMap.put("机构版本类型", "");
                }
                if (orgTypeDto.getAccountTypeDesc() != null) {
                    rowMap.put("机构帐号类型", orgTypeDto.getAccountTypeDesc() + "");
                } else {
                    rowMap.put("机构帐号类型", "");
                }
                rowMap.put("登录用户次数", orgTypeDto.getLoginAccountTotal() + "");
                rowMap.put("登录设备数据", orgTypeDto.getLoginDeviceTotal() + "");
                rowMap.put("线索总数", orgTypeDto.getClueTotal() + "");
                rowMap.put("微信线索总数", orgTypeDto.getClueWechat() + "");
                rowMap.put("留单线索总数", orgTypeDto.getClueReserve() + "");
                rowMap.put("电话线索总数", orgTypeDto.getClueCall() + "");
                rowMap.put("打开次数", orgTypeDto.getOrgOpenTotal() + "");
                rowMap.put("学员总数", orgTypeDto.getStudentTotal() + "");
                rowMap.put("在读学员总数", orgTypeDto.getStudyStudentTotal() + "");

                rows.add(rowMap);
            }

            String subject = "机构主分校区详细信息";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "msgRecordDetailInfo";
            ExcelMailSender.sendMail(mail, subject, content, fileName, rows);
        }

    }

    @Override
    public List<ExportDto> getExportDtoByDay(Date startTime, Date endTime, int way) {
        Map<Long, ExportDto> exportDtoMap = new HashMap<>();
        List<ExportDto> dataList = new ArrayList<>();
        String curDate = null;
        String startDate = null;

        if (GenericsUtils.notNullAndEmpty(startTime)) {
            startDate = getDate(startTime);
        }
        if (GenericsUtils.notNullAndEmpty(endTime)) {
            curDate = getDate(endTime);// 格式 yyyy-MM-dd
        }

        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao机构账号==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);

        Map<Long, OrgTypeDto> orgTypeDtoMap = this.orgTypeService.getOrgTypeDtoMap(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(orgTypeDtoMap)) {
            for (Long orgId : orgTypeDtoMap.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                String accountTypeDesc = orgTypeDto.getAccountTypeDesc();
                Integer accountType = orgTypeDto.getAccountType();
                exportDto.setAccountTypeDesc(accountTypeDesc == null ? "" : accountTypeDesc);
                exportDto.setAccountType(accountType == null ? 0 : accountType);
                String compusTypeDesc = orgTypeDto.getCompusTypeDesc();
                exportDto.setCompusTypeDesc(compusTypeDesc == null ? "" : compusTypeDesc);
                exportDto.setSubOrgNumber(orgTypeDto.getSubOrgNumber());
                exportDto.setOrgVipLevelStr(orgTypeDto.getOrgVipLevelStr());
            }
        }

        long start = System.currentTimeMillis();
        // 发活动
        Map<Long, ActivityStatisticsData> activityDatas =
                this.activityDataExportService.getActivityData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(activityDatas)) {
            for (Long orgId : activityDatas.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                ActivityStatisticsData activityStaticData = activityDatas.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                ActivityStatisticsData.setExportDto(activityStaticData, exportDto);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 抽奖
        Map<Long, DrawStatisticData> drawDatas =
                this.drawDataExportService.getDrawData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(drawDatas)) {
            for (Long orgId : drawDatas.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                DrawStatisticData drawData = drawDatas.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                DrawStatisticData.setExportDto(drawData, exportDto);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 投票
        Map<Long, VoteStatistics> voteDatas =
                this.voteDataStatisticService.getVoteData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(voteDatas)) {
            for (Long orgId : voteDatas.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                VoteStatistics voteData = voteDatas.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                VoteStatistics.buildExportDtoByVoteStatistics(exportDto, voteData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 转介绍
        Map<Long, ReferralStatisticData> referralDatas = this.referralStatisticsService.getPeriodReferralData(startTime,
                endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(referralDatas)) {
            for (Long orgId : referralDatas.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                ReferralStatisticData referralData = referralDatas.get(orgId);
                log.info(referralData.getBrokerNum() + ":" + referralData.getBrowseCount() + ":"
                        + referralData.getReferralActivityTotal() + ":" + referralData.getCustomerNum());
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                ReferralStatisticData.buildExportDtoByReferralStatisticData(exportDto, referralData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 今日待办
        Map<Long, TxBacklogStatisticData> txBacklogDatas =
                this.txBacklogStatisticService.getTxBacklogData(startTime, endTime, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(txBacklogDatas)) {
            for (Long orgId : txBacklogDatas.keySet()) {
                TxBacklogStatisticData txBacklogData = txBacklogDatas.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                TxBacklogStatisticData.buildExportDtoByTxBacklogStatisticData(exportDto, txBacklogData);
            }

        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 线索
        Map<Long, ConsultMessageStatisticData> consultMessageDatas =
                this.consultMessageStatisticService.getConsultMessageData(startTime, endTime, TianxiaoOrgIds);

        if (GenericsUtils.notNullAndEmpty(consultMessageDatas)) {
            for (Long orgId : consultMessageDatas.keySet()) {
                ConsultMessageStatisticData consultMessageStatisticData = consultMessageDatas.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                ConsultMessageStatisticData.buildExportDtoByConsultMessageStatisticData(exportDto,
                        consultMessageStatisticData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 跟进记录 系统添加总数：学员系统添加总数，意向学员添加总数
        Map<Long, Integer> commentSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime, endTime,
                TianxiaoOrgIds,null, AddType.SYSTEM.getCode(), false);
        Map<Long, Integer> commentStudentSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime, endTime,
                TianxiaoOrgIds,null, AddType.SYSTEM.getCode(), true);
        if (GenericsUtils.notNullAndEmpty(commentSystemTotalMap)) {
            for (Long orgId : commentSystemTotalMap.keySet()) {
                int commentSystemTotal = commentSystemTotalMap.get(orgId);
                int commentStudentSystemTotal = 0;
                if (commentStudentSystemTotalMap.get(orgId) != null) {
                    commentStudentSystemTotal = commentStudentSystemTotalMap.get(orgId);
                }
                int commentConsultSystemTotal = (commentSystemTotal - commentStudentSystemTotal);

                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setCommentStudentSystemTotal(commentStudentSystemTotal);
                exportDto.setCommentConsultSystemTotal(commentConsultSystemTotal);
            }
        }

        //// 跟进记录 手动录入总数：学员手动录入总数，意向学员手动录入总数
        Map<Long, Integer> commentNotSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime, endTime,
                TianxiaoOrgIds,null, AddType.NOT_SYSTEM.getCode(), false);
        Map<Long, Integer> commentStudentNotSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime,
                endTime, TianxiaoOrgIds,null, AddType.NOT_SYSTEM.getCode(), true);
        if (GenericsUtils.notNullAndEmpty(commentNotSystemTotalMap)) {
            for (Long orgId : commentNotSystemTotalMap.keySet()) {
                int commentNotSystemTotal = commentNotSystemTotalMap.get(orgId);
                int commentNotStudentSystemTotal = 0;
                if (commentStudentNotSystemTotalMap.get(orgId) != null) {
                    commentNotStudentSystemTotal = commentStudentNotSystemTotalMap.get(orgId);
                }
                int commentConsultNotSystemTotal = (commentNotSystemTotal - commentNotStudentSystemTotal);

                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setCommentStudentNotSystemTotal(commentNotStudentSystemTotal);
                exportDto.setCommentConsultNotSystemTotal(commentConsultNotSystemTotal);
            }
        }

        // 意向学员，正式学员
        Map<Long, CRMStatisticData> consultUserCounts =
                this.crmStatisticService.getConsultUserSData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(consultUserCounts)) {
            for (Long orgId : consultUserCounts.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                CRMStatisticData crmStatisticData = consultUserCounts.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                CRMStatisticData.buidExportDtoByCRMStatisticData(crmStatisticData, exportDto);
            }

        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 微信相关信息
        Map<Long, WechatStatisticData> wechatDatas =
                this.wechatStatisticService.getWechatStatisticData(startTime, endTime, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(wechatDatas)) {
            for (Long orgId : wechatDatas.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                WechatStatisticData wechatData = wechatDatas.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                WechatStatisticData.buildExportDtoByWechatStatisticData(exportDto, wechatData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // ERP相关信息
        Map<Long, ERPStatisticData> ERPDatas =
                this.erpStatisticService.getERPDatas(startTime, endTime, TianxiaoOrgNumbers, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(ERPDatas)) {
            for (Long orgId : ERPDatas.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                ERPStatisticData ERPData = ERPDatas.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                ERPStatisticData.buildExportDtoByERPStatisticData(exportDto, ERPData);
            }
        }

        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 老师数量
        Map<Long, Integer> teacherCountMap =
                this.orgTeacherDao.getTeacherTotalMapByOrgIds(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(teacherCountMap)) {
            for (Long orgId : teacherCountMap.keySet()) {
                Integer teacherCount = teacherCountMap.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setTeacherTotal(teacherCount);
            }
        }

        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        // 教室数量 教室数量只能获取截至今天为止的
        Map<Long, Integer> roomCountMap = courseRoomDao.getOrgRoomTotal();
        if (GenericsUtils.notNullAndEmpty(roomCountMap) && way != 0) {
            for (Long orgId : roomCountMap.keySet()) {
                Integer roomCount = roomCountMap.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setRoomTotal(roomCount);
            }
        }

        // 群发消息
        Map<Long, Integer> groupMsgCountMap = groupMsgDao.getOrgGroupMsgTotal(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(groupMsgCountMap)) {
            for (Long orgId : groupMsgCountMap.keySet()) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                Integer groupMsgCount = groupMsgCountMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setGroupMsgTotal(groupMsgCount == null ? 0 : groupMsgCount);
            }
        }

        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 新增接受人数
        Map<Long, Integer> msgReceiverCountMap =
                this.groupMsgReceiverDao.getMsgReceiverTotal(true, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(msgReceiverCountMap)) {
            for (Long orgId : msgReceiverCountMap.keySet()) {
                Integer msgReceiverCount = msgReceiverCountMap.get(orgId);
                log.info("新接受人数================" + msgReceiverCount);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setMsgReceiverTotal(msgReceiverCount == null ? 0 : msgReceiverCount);
            }
        }

        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 设置是否使用主页
        Set<Long> useTemplateOrgIds = orgHomepageConfigDao.getUseTemplateOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(useTemplateOrgIds)) {
            for (Long orgId : useTemplateOrgIds) {
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setIsUseHomePage(true);
            }
        }
        // 设置pv和uv
        List<TxMonitorTypeDay> txMonitorTypes =
                this.txMonitorTypeDayDao.listUseMonitorType(startTime, endTime, TianxiaoOrgNumbers);
        if (GenericsUtils.notNullAndEmpty(txMonitorTypes)) {
            Map<Integer, TxMonitorTypeDay> homePageMonitorOrgNumberMap =
                    CollectionUtils.extractMap(txMonitorTypes, new CollectionUtils.Extracter<Integer, TxMonitorTypeDay>() {
                        @Override
                        public Integer extract(TxMonitorTypeDay txMonitorTypeDay) {
                            return txMonitorTypeDay.getOrgNumber().intValue();
                        }
                    });

            List<OrgAccount> orgHomePageAccounts =
                    orgAccountDao.getAccountByNumbers(homePageMonitorOrgNumberMap.keySet(), "id", "number");
            for (OrgAccount account : orgHomePageAccounts) {
                ExportDto exportDto = exportDtoMap.get(account.getId().longValue());
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, account.getId().longValue(), startDate, curDate);
                    exportDtoMap.put(account.getId().longValue(), exportDto);
                }
                TxMonitorTypeDay monitorTypeDay = homePageMonitorOrgNumberMap.get(account.getNumber());
                exportDto.setPvTotal(monitorTypeDay.getPv() == null ? 0 : monitorTypeDay.getPv());
                exportDto.setUvTotal(monitorTypeDay.getUv() == null ? 0 : monitorTypeDay.getUv());
            }
        }

        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 主账号登录
        Map<Long, Integer> loginCountMap =
                this.orgAppLoginLogDao.getOrgAppLoginTotal(null, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(loginCountMap)) {
            for (Long orgId : loginCountMap.keySet()) {
                Integer loginCount = loginCountMap.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setLoginTotal(loginCount == null ? 0 : loginCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        Map<Long, LogStatisticDto> logStatisticDtoMap =
                this.txLogStatEventDao.getLogStatisticDtoMap(TianxiaoOrgIds, startTime, endTime);
        if (GenericsUtils.notNullAndEmpty(logStatisticDtoMap)) {
            for (Long orgId : logStatisticDtoMap.keySet()) {
                LogStatisticDto logDto = logStatisticDtoMap.get(orgId);
                Integer loginAccount = logDto.getLoginAccountTotal();
                Integer loginDevice = logDto.getLoginDeviceTotal();
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }

                exportDto.setLoginAccountTotal(loginAccount == null ? 0 : loginAccount);
                exportDto.setLoginDeviceTotal(loginDevice == null ? 0 : loginDevice);
            }
        }

        Map<Long, Integer> orgOpenTotalMap =
                this.txLogStatEventDao.getOrgOpenTotalMap(TianxiaoOrgIds, startTime, endTime);
        if (GenericsUtils.notNullAndEmpty(orgOpenTotalMap)) {
            for (Long orgId : orgOpenTotalMap.keySet()) {
                Integer orgOpenTotal = orgOpenTotalMap.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setOrgOpenTotal(orgOpenTotal);
            }
        }

        // 短信
        Map<Long, Integer> ttsMsgCountMap = this.ttsSmSDao.getOrgTtsSmsCount(startTime, endTime, TianxiaoOrgIds);
        Map<Long, Integer> txMsgCountMap = this.txSmsDao.getOrgTxSmsCount(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(ttsMsgCountMap)) {
            for (Long orgId : ttsMsgCountMap.keySet()) {
                if (txMsgCountMap.get(orgId) == null) {
                    txMsgCountMap.put(orgId, ttsMsgCountMap.get(orgId));
                } else {
                    txMsgCountMap.put(orgId, txMsgCountMap.get(orgId) + ttsMsgCountMap.get(orgId));
                }
            }
        }
        if (GenericsUtils.notNullAndEmpty(txMsgCountMap)) {
            for (Long orgId : txMsgCountMap.keySet()) {
                Integer smsCount = txMsgCountMap.get(orgId);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setSmsTotal(smsCount == null ? 0 : smsCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 400电话
        Map<Long, String> extensionMap = this.orgInfoDao.getExtentionsByOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(extensionMap)) {
            for (Long orgId : exportDtoMap.keySet()) {
                String extension = extensionMap.get(orgId);
                Integer orgCallRecordCount =
                        this.OrgCallRecorderDao.getOrgCallRecordCountByExtexsion(startTime, endTime, extension);
                Integer orgCallRecordTime =
                        this.OrgCallRecorderDao.getOrgCallRecordTimeByExtension(startTime, endTime, extension);
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    exportDtoMap.put(orgId, exportDto);
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                }
                exportDto.setOrgCallRecordCount(orgCallRecordCount == null ? 0 : orgCallRecordCount);

                exportDto.setOrgCallRecordTime(orgCallRecordTime == null ? 0 : orgCallRecordTime);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());

        // 双呼总数和通话时长
        Map<Long, CallStatisticDto> callStatisticDtoMap =
                this.callServiceInfoDao.getTotalDurationAndCount(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(callStatisticDtoMap)) {
            for (Long orgId : callStatisticDtoMap.keySet()) {
                CallStatisticDto callStatisticDto = callStatisticDtoMap.get(orgId);
                Integer count = callStatisticDto.getCount();
                Integer duration = callStatisticDto.getDuration();
                ExportDto exportDto = exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    exportDtoMap.put(orgId, exportDto);
                    buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                }

                exportDto.setCallServiceCount(count);
                exportDto.setCallServiceDuration(duration);
            }
        }

        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + ttsMsgCountMap.size());

        Map<Integer, Long> orgIdMap = this.orgAccountDao.batchSearchOrgIds(TianxiaoOrgNumbers);
        log.info("orgIdMap size param{}", orgIdMap.size());
        // 按照TianxiaoOrgNumbers进行顺序存储
        for (Integer orgNumber : TianxiaoOrgNumbers) {
            try {
                Long orgId = orgIdMap.get(orgNumber);
                if (orgId == null) {
                    log.info("orgNumber param:{}", orgNumber);
                }
                if (GenericsUtils.notNullAndEmpty(orgId)) {
                    ExportDto exportDto = exportDtoMap.get(orgId);
                    if (exportDto == null) {
                        exportDto = new ExportDto();
                        log.info("exportDto parm:{}, orgId param:{}, startDate param:{}, curDate param:{}", exportDto,
                                orgId, startDate, curDate);
                        buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    }
                    dataList.add(exportDto);
                    TXStatisticData txStatisticData = ExportDto.buildTXStatisticDataByExportDto(exportDto, way);
                    TXStatisticData statisticData =
                            this.txStatisticDataDao.getTXStatisticDataByOrgNumber(orgNumber, curDate, way);
                    log.info("txStatisticData is:{} and statisticData is:{} ", txStatisticData, statisticData);
                    if (GenericsUtils.notNullAndEmpty(statisticData)) {
                        txStatisticData.setId(statisticData.getId());
                        this.txStatisticDataDao.updateTXStatisticData(txStatisticData);
                    } else {
                        this.txStatisticDataDao.addTXStatisticData(txStatisticData);
                    }
                }
            } catch (Exception e) {
                log.error("error :{} ", e);
            }
        }

        return dataList;
    }

    private void buidExportDtoByOrgId(ExportDto exportDto, Long orgId, String startDate, String curDate) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue());
        if (orgAccount != null) {
            exportDto.setOrgNumber(orgAccount.getNumber());
        }

        if (orgInfo == null) {
            exportDto.setOrgShortName("");
        } else {
            exportDto.setOrgShortName(orgInfo.getShortName());
        }

        if (startDate != null) {
            exportDto.setStartDate(startDate);
        }
        if (curDate != null) {
            exportDto.setCurDate(curDate);
        }
    }

    private String getDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(date);
        return curDate;
    }

    public List<ExportKeyData> writeDayDataToSheet(HSSFSheet sheet, List<ExportDto> data) {
        List<ExportKeyData> keyDatas = new ArrayList<>();
        log.info("[Statistics]Day Size=" + data.size());
        for (int i = 3; i < data.size() + 3; i++) {
            ExportKeyData keyData = new ExportKeyData();
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);

            // log.info("机构登录次数 ================" + exportDto.getLoginTotal());

            keyData.setOrgShortName(exportDto.getOrgShortName());
            keyData.setOrgNumber(exportDto.getOrgNumber());
            keyData.setCompusTypeDesc(exportDto.getCompusTypeDesc() == null ? "" : exportDto.getCompusTypeDesc());
            keyData.setAccountTypeDesc(exportDto.getAccountTypeDesc() == null ? "" : exportDto.getAccountTypeDesc());

            keyData.setLoginTotal(exportDto.getLoginTotal() + keyData.getLoginTotal());
            keyData.setBacklogFinish(exportDto.getBacklogFinish()); /// 这个数据需要改
            keyData.setClueTotal(exportDto.getClueTotal());
            keyData.setIncrementStudentTotal(exportDto.getIncrementStudentTotal());
            keyData.setWechatFansTotal(exportDto.getWechatFansTotal());
            keyData.setCourseTotal(exportDto.getCourseTotal());
            keyData.setArrangedClassTotal(exportDto.getArrangedClassTotal());
            keyData.setCourseSmsTotal(exportDto.getCourseSmsTotal());
            keyData.setSignLessonTotal(exportDto.getSignLessonTotal());
            keyData.setSignStudentTotal(exportDto.getSignStudentTotal());
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            int activityTotal = exportDto.getActivityTotal() + exportDto.getDrawActivityTotal()
                    + exportDto.getVoteActivityTotal() + exportDto.getReferralActivityTotal();

            keyData.setActivityTotal(activityTotal);

            int activityAccessTotal = exportDto.getActivityAccessTotal() + exportDto.getReferralAccessTotal()
                    + exportDto.getVoteAccessTotal();
            keyData.setActivityAccessTotal(activityAccessTotal);
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            keyData.setPvTotal(exportDto.getPvTotal());
            keyData.setUvTotal(exportDto.getUvTotal());
            keyData.setWechatAuthorizerOfStudentTotal(exportDto.getWechatAuthorizerOfStudentTotal());
            keyData.setSmsTotal(exportDto.getSmsTotal());
            keyData.setOrgCallRecordCount(exportDto.getOrgCallRecordCount());
            Integer orgCallRecordTime = exportDto.getOrgCallRecordTime();
            String callTime = getTwoPrecision(orgCallRecordTime, 60);
            keyData.setOrgCallRecordTime(callTime);
            keyData.setCallServiceCount(exportDto.getCallServiceCount());
            Integer callServiceDuration = exportDto.getCallServiceDuration();
            String callServiceTime = getTwoPrecision(callServiceDuration, 60);
            keyData.setCallServiceDuration(callServiceTime);

            ExcelUtil.createCell(row, 0, exportDto.getCurDate());
            ExcelUtil.createCell(row, 1, exportDto.getOrgShortName());
            ExcelUtil.createCell(row, 2, exportDto.getOrgNumber());
            ExcelUtil.createCell(row, 3, exportDto.getCompusTypeDesc());
            ExcelUtil.createCell(row, 4, exportDto.getSubOrgNumber());
            ExcelUtil.createCell(row, 5, exportDto.getAccountTypeDesc());
            ExcelUtil.createCell(row, 6, exportDto.getOrgVipLevelStr());

            ExcelUtil.createCell(row, 7, exportDto.getIsWechatAuthorizer());
            ExcelUtil.createCell(row, 8, exportDto.getIsWechatMenu());
            ExcelUtil.createCell(row, 9, exportDto.getServiceTypeDesc());
            ExcelUtil.createCell(row, 10, exportDto.getStudentTotal());
            ExcelUtil.createCell(row, 11, exportDto.getStudyStudentTotal());
            ExcelUtil.createCell(row, 12, exportDto.getIsUseHomePage());

            ExcelUtil.createCell(row, 13, exportDto.getBacklogTotal());
            ExcelUtil.createCell(row, 14, exportDto.getBacklogFinish());
            ExcelUtil.createCell(row, 15, exportDto.getBacklogExpire());
            ExcelUtil.createCell(row, 16, exportDto.getClueTotal());
            ExcelUtil.createCell(row, 17, exportDto.getClueWechat());
            ExcelUtil.createCell(row, 18, exportDto.getClueReserve());
            ExcelUtil.createCell(row, 19, exportDto.getClueCall());
            ExcelUtil.createCell(row, 20, exportDto.getCommentStudentSystemTotal()); // 跟进学员系统录入
            ExcelUtil.createCell(row, 21, exportDto.getCommentConsultSystemTotal()); // 跟进意向学员系统录入
            ExcelUtil.createCell(row, 22, exportDto.getCommentStudentNotSystemTotal()); // 跟进记录学员手动录入
            ExcelUtil.createCell(row, 23, exportDto.getCommentConsultNotSystemTotal()); // 跟进记录意向学员手动录入
            ExcelUtil.createCell(row, 24, exportDto.getConsultUserTotal());
            ExcelUtil.createCell(row, 25, exportDto.getIncrementStudentTotal());

            ExcelUtil.createCell(row, 26, exportDto.getWechatFansTotal());
            ExcelUtil.createCell(row, 27, exportDto.getCourseTotal());
            ExcelUtil.createCell(row, 28, exportDto.getArrangedClassTotal());
            ExcelUtil.createCell(row, 29, exportDto.getLessonTotal());
            ExcelUtil.createCell(row, 30, exportDto.getCourseSmsTotal());
            ExcelUtil.createCell(row, 31, exportDto.getIncomeSum());

            ExcelUtil.createCell(row, 32, exportDto.getIncomeTotal());
            ExcelUtil.createCell(row, 33, exportDto.getSignLessonTotal());
            ExcelUtil.createCell(row, 34, exportDto.getSignStudentTotal());
            ExcelUtil.createCell(row, 35, exportDto.getCashPurchaseSum());
            ExcelUtil.createCell(row, 36, exportDto.getCommentByStudent());
            ExcelUtil.createCell(row, 37, exportDto.getCommentByTeacher());
            ExcelUtil.createCell(row, 38, exportDto.getTeacherTotal());
            ExcelUtil.createCell(row, 39, exportDto.getRoomTotal());

            ExcelUtil.createCell(row, 40, exportDto.getActivityTotal());
            ExcelUtil.createCell(row, 41, exportDto.getActivityAccessTotal());
            ExcelUtil.createCell(row, 42, exportDto.getActivityEnrollTotal());
            ExcelUtil.createCell(row, 43, exportDto.getDrawActivityTotal());
            ExcelUtil.createCell(row, 44, exportDto.getDrawUserTotal());

            ExcelUtil.createCell(row, 45, exportDto.getDrawWinnerTotal());
            ExcelUtil.createCell(row, 46, exportDto.getVoteActivityTotal());
            ExcelUtil.createCell(row, 47, exportDto.getVoteAccessTotal());
            ExcelUtil.createCell(row, 48, exportDto.getVoteTotal());
            ExcelUtil.createCell(row, 49, exportDto.getReferralActivityTotal());

            ExcelUtil.createCell(row, 50, exportDto.getReferralAccessTotal());
            ExcelUtil.createCell(row, 51, exportDto.getBrokerTotal());
            ExcelUtil.createCell(row, 52, exportDto.getReferralTotal());
            ExcelUtil.createCell(row, 53, exportDto.getGroupMsgTotal());
            ExcelUtil.createCell(row, 54, exportDto.getMsgReceiverTotal());

            ExcelUtil.createCell(row, 55, exportDto.getUvTotal());
            ExcelUtil.createCell(row, 56, exportDto.getPvTotal());
            ExcelUtil.createCell(row, 57, exportDto.getLoginTotal());
            ExcelUtil.createCell(row, 58, exportDto.getLoginAccountTotal());
            ExcelUtil.createCell(row, 59, exportDto.getLoginDeviceTotal());

            ExcelUtil.createCell(row, 60, exportDto.getOrgOpenTotal());

            ExcelUtil.createCell(row, 61, exportDto.getWechatAuthorizerOfStudentTotal());

            ExcelUtil.createCell(row, 62, exportDto.getSmsTotal());
            ExcelUtil.createCell(row, 63, exportDto.getOrgCallRecordCount());
            if (callTime == "0") {
                ExcelUtil.createCell(row, 64, "");
            } else {
                ExcelUtil.createCell(row, 64, callTime);
            }

            ExcelUtil.createCell(row, 65, exportDto.getCallServiceCount());
            if (callServiceTime == "0") {
                ExcelUtil.createCell(row, 66, "");
            } else {
                ExcelUtil.createCell(row, 66, callServiceTime);
            }

            keyDatas.add(keyData);
        }

        return keyDatas;
    }

    public void writeTotalDataToSheet(HSSFSheet sheet, List<ExportDto> data) {
        log.info("[Statistics]Total Size=" + data.size());
        for (int i = 3; i < data.size() + 3; i++) {
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);

            ExcelUtil.createCell(row, 0, exportDto.getOrgShortName());
            ExcelUtil.createCell(row, 1, exportDto.getOrgNumber());
            ExcelUtil.createCell(row, 2, exportDto.getCompusTypeDesc());
            ExcelUtil.createCell(row, 3, exportDto.getSubOrgNumber());
            ExcelUtil.createCell(row, 4, exportDto.getAccountTypeDesc());
            ExcelUtil.createCell(row, 5, exportDto.getOrgVipLevelStr());

            ExcelUtil.createCell(row, 6, exportDto.getIsWechatAuthorizer());
            ExcelUtil.createCell(row, 7, exportDto.getIsWechatMenu());
            ExcelUtil.createCell(row, 8, exportDto.getServiceTypeDesc());
            ExcelUtil.createCell(row, 9, exportDto.getStudentTotal());
            ExcelUtil.createCell(row, 10, exportDto.getStudyStudentTotal());
            ExcelUtil.createCell(row, 11, exportDto.getIsUseHomePage());

            ExcelUtil.createCell(row, 12, exportDto.getBacklogTotal());

            ExcelUtil.createCell(row, 13, exportDto.getBacklogFinish());
            ExcelUtil.createCell(row, 14, exportDto.getBacklogExpire());
            ExcelUtil.createCell(row, 15, exportDto.getClueTotal());
            ExcelUtil.createCell(row, 16, exportDto.getClueWechat());
            ExcelUtil.createCell(row, 17, exportDto.getClueReserve());
            ExcelUtil.createCell(row, 18, exportDto.getClueCall());

            ExcelUtil.createCell(row, 19, exportDto.getCommentStudentSystemTotal()); // 跟进学员系统录入
            ExcelUtil.createCell(row, 20, exportDto.getCommentConsultSystemTotal()); // 跟进意向学员系统录入
            ExcelUtil.createCell(row, 21, exportDto.getCommentStudentNotSystemTotal()); // 跟进记录学员手动录入
            ExcelUtil.createCell(row, 22, exportDto.getCommentConsultNotSystemTotal()); // 跟进记录意向学员手动录入

            ExcelUtil.createCell(row, 23, exportDto.getConsultUserTotal());

            ExcelUtil.createCell(row, 24, exportDto.getWechatFansTotal());
            ExcelUtil.createCell(row, 25, exportDto.getCourseTotal());
            ExcelUtil.createCell(row, 26, exportDto.getArrangedClassTotal());
            ExcelUtil.createCell(row, 27, exportDto.getLessonTotal());
            ExcelUtil.createCell(row, 28, exportDto.getCourseSmsTotal());
            ExcelUtil.createCell(row, 29, exportDto.getIncomeSum());

            ExcelUtil.createCell(row, 30, exportDto.getIncomeTotal());
            ExcelUtil.createCell(row, 31, exportDto.getSignLessonTotal());
            ExcelUtil.createCell(row, 32, exportDto.getSignStudentTotal());
            ExcelUtil.createCell(row, 33, exportDto.getCashPurchaseSum());
            ExcelUtil.createCell(row, 34, exportDto.getCommentByStudent());
            ExcelUtil.createCell(row, 35, exportDto.getCommentByTeacher());
            ExcelUtil.createCell(row, 36, exportDto.getTeacherTotal());
            ExcelUtil.createCell(row, 37, exportDto.getRoomTotal());

            ExcelUtil.createCell(row, 38, exportDto.getActivityTotal());
            ExcelUtil.createCell(row, 39, exportDto.getActivityAccessTotal());
            ExcelUtil.createCell(row, 40, exportDto.getActivityEnrollTotal());
            ExcelUtil.createCell(row, 41, exportDto.getDrawActivityTotal());
            ExcelUtil.createCell(row, 42, exportDto.getDrawUserTotal());

            ExcelUtil.createCell(row, 43, exportDto.getDrawWinnerTotal());
            ExcelUtil.createCell(row, 44, exportDto.getVoteActivityTotal());
            ExcelUtil.createCell(row, 45, exportDto.getVoteAccessTotal());
            ExcelUtil.createCell(row, 46, exportDto.getVoteTotal());
            ExcelUtil.createCell(row, 47, exportDto.getReferralActivityTotal());

            ExcelUtil.createCell(row, 48, exportDto.getReferralAccessTotal());
            ExcelUtil.createCell(row, 49, exportDto.getBrokerTotal());
            ExcelUtil.createCell(row, 50, exportDto.getReferralTotal());
            ExcelUtil.createCell(row, 51, exportDto.getGroupMsgTotal());
            ExcelUtil.createCell(row, 52, exportDto.getMsgReceiverTotal());

            ExcelUtil.createCell(row, 53, exportDto.getUvTotal());
            ExcelUtil.createCell(row, 54, exportDto.getPvTotal());
            ExcelUtil.createCell(row, 55, exportDto.getLoginTotal());
            ExcelUtil.createCell(row, 56, exportDto.getLoginAccountTotal());
            ExcelUtil.createCell(row, 57, exportDto.getLoginDeviceTotal());
            ExcelUtil.createCell(row, 58, exportDto.getOrgOpenTotal());

            ExcelUtil.createCell(row, 59, exportDto.getWechatAuthorizerOfStudentTotal());

            ExcelUtil.createCell(row, 60, exportDto.getSmsTotal());
            ExcelUtil.createCell(row, 61, exportDto.getOrgCallRecordCount());

            Integer orgCallRecordTime = exportDto.getOrgCallRecordTime();
            String callTime = getTwoPrecision(orgCallRecordTime, 60);
            if (callTime == "0") {
                ExcelUtil.createCell(row, 62, "");
            } else {
                ExcelUtil.createCell(row, 62, callTime);
            }

            ExcelUtil.createCell(row, 63, exportDto.getCallServiceCount());
            Integer callServiceDuration = exportDto.getCallServiceDuration();
            String callServiceTime = getTwoPrecision(callServiceDuration, 60);
            if (callServiceTime == "0") {
                ExcelUtil.createCell(row, 64, "");
            } else {
                ExcelUtil.createCell(row, 64, callServiceTime);
            }

        }
    }

    @Override
    public void createHSSFWorkbookByDay(Date startTime, Date endTime) {
        List<ExportDto> dayData = getExportDtoByDay(startTime, endTime, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(startTime);

        try {
            InputStream dayIn = getClass().getResourceAsStream("/template/template-excelByDay.xls");
            ;

            File[] files = new File[1];
            List<ExportKeyData> keyDatas = new ArrayList<>();
            // log.info("excel0插数据之前表的行数 = " + sheet0.getLastRowNum() + 1);
            if (GenericsUtils.notNullAndEmpty(dayData)) {
                HSSFWorkbook wb = new HSSFWorkbook(dayIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                keyDatas = writeDayDataToSheet(sheet, dayData);
                files[0] = createFil(wb, curDate + "excelByDay.xls");
            }

            // String email = "gaodan@baijiahulian.com";
            String email = Config.MAIL_CONTACT_TIANXIAO_DATA;
            String content = getContent(keyDatas);
            ExcelMailSender.sendMail(email, curDate + "每日天校监控数据", content, files);

        } catch (FileNotFoundException e) {
            log.warn("excel文件创建失败");
        } catch (IOException e) {
            log.warn("excel文件创建失败");
        }

    }

    @Override
    public void createHSSFWorkbookTotal(Date startTime, Date endTime) {

        List<ExportDto> totalData = getExportDtoByDay(null, endTime, 3);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(startTime);
        try {
            InputStream totaIn = getClass().getResourceAsStream("/template/template-excelTotal.xls");

            File[] files = new File[1];
            if (GenericsUtils.notNullAndEmpty(totalData)) {
                HSSFWorkbook wb = new HSSFWorkbook(totaIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                writeTotalDataToSheet(sheet, totalData);
                files[0] = createFil(wb, curDate + "excelTotal.xls");
            }

            // String email = "yuwenhao@baijiahulian.com";
            String email = Config.MAIL_CONTACT_TIANXIAO_DATA;
            String content = ""; // getContent(keyDatas);
            ExcelMailSender.sendMail(email, curDate + "天校监控总数据", content, files);

        } catch (FileNotFoundException e) {
            log.warn("excel文件创建失败");
        } catch (IOException e) {
            log.warn("excel文件创建失败");
        }
    }

    private String getContent(List<ExportKeyData> keyDatas) {
        StringBuffer sb = new StringBuffer(BIzConf.MAIL_TITLE);
        for (ExportKeyData keyData : keyDatas) {
            sb.append("<tr>");
            sb.append("<td>" + keyData.getOrgShortName() + "</td>");
            sb.append("<td>" + keyData.getOrgNumber() + "</td>");
            sb.append("<td>" + keyData.getCompusTypeDesc() + "</td>");
            sb.append("<td>" + keyData.getAccountTypeDesc() + "</td>");

            sb.append(getTd(keyData.getLoginTotal()));

            sb.append(getTd(keyData.getClueTotal()));

            sb.append(getTd(keyData.getIncrementStudentTotal()));

            sb.append(getTd(keyData.getWechatFansTotal()));

            sb.append(getTd(keyData.getCourseTotal()));

            sb.append(getTd(keyData.getArrangedClassTotal()));

            sb.append(getTd(keyData.getCourseSmsTotal()));

            sb.append(getTd(keyData.getSignLessonTotal()));

            sb.append(getTd(keyData.getSignStudentTotal()));

            sb.append(getTd(keyData.getCommentByTeacher()));

            sb.append(getTd(keyData.getActivityTotal()));

            sb.append(getTd(keyData.getActivityAccessTotal()));

            sb.append(getTd(keyData.getUvTotal()));

            sb.append(getTd(keyData.getPvTotal()));

            sb.append(getTd(keyData.getWechatAuthorizerOfStudentTotal()));

            sb.append(getTd(keyData.getSmsTotal()));

            sb.append(getTd(keyData.getOrgCallRecordCount()));

            sb.append(getTd(keyData.getOrgCallRecordTime()));

            sb.append(getTd(keyData.getCallServiceCount()));
            sb.append(getTd(keyData.getCallServiceDuration()));

            sb.append("</tr>");
        }
        sb.append("</tbody></table></article>");

        return sb.toString();
    }

    private String getTd(String value) {
        if (value == null) {
            return "<td></td>";
        } else {
            return "<td>" + value + "</td>";
        }
    }

    private String getTd(int value) {
        if (value == 0) {
            return "<td></td>";
        } else {
            return "<td>" + value + "</td>";
        }
    }

    private File createFil(HSSFWorkbook wb, String fileName) {
        File localFile = new File(fileName);

        if (!localFile.exists()) {
            try {
                localFile.createNewFile();
            } catch (IOException e) {
                // logger.info(e);
                return null;
            }
        }

        OutputStream out = null;
        BufferedOutputStream bos = null;
        try {
            out = new FileOutputStream(localFile);
            bos = new BufferedOutputStream(out);
            wb.write(bos);
            wb = null;
        } catch (Exception e) {
            // logger.info("[ writer file failure : ]", e);
        } finally {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly(out);
        }
        return localFile;
    }

    @Override
    public void createMailByWeekAndMonth(Date startTime, Date endTime, int beforeDay) {
        List<ExportDto> exportDtos = new ArrayList<>();
        if (beforeDay == 7) {
            exportDtos = getExportDtoByDay(startTime, endTime, 1);
        } else if (beforeDay == 30) {
            exportDtos = getExportDtoByDay(startTime, endTime, 2);
        }
        String startDate = getDate(startTime);
        String endDate = getDate(endTime);

        List<ExportDto> internalExportDtos = new ArrayList<>();
        List<ExportDto> externalExportDtos = new ArrayList<>();
        for (ExportDto exportDto : exportDtos) {
            Integer accountType = exportDto.getAccountType();
            if (AccountTypeEnum.ZHENGSHI.getCode() == accountType) {
                externalExportDtos.add(exportDto);
            } else {
                internalExportDtos.add(exportDto);
            }
        }
        log.info("internalExportDtos size param:{}, externalExportDtos param:{}", internalExportDtos.size(),
                externalExportDtos.size());

        // 内部
        StatisticByWeekOrMonthDto statisticInternal = getStatisticByWeekOrMonthDto(internalExportDtos, beforeDay);
        List<ExportClientDemandDto> exportInternalClientDemandDtos =
                getExportClientDemandDtos(statisticInternal, internalExportDtos.size(), beforeDay);
        log.info("exportInternalClientDemandDtos param:{}", exportInternalClientDemandDtos);

        // 外部
        StatisticByWeekOrMonthDto statisticExternal = getStatisticByWeekOrMonthDto(externalExportDtos, beforeDay);
        List<ExportClientDemandDto> exportExternalClientDemandDtos =
                getExportClientDemandDtos(statisticExternal, externalExportDtos.size(), beforeDay);
        log.info("exportExternalClientDemandDtos param:{}", exportExternalClientDemandDtos);

        try {// freeMarkerConfigurer.getConfiguration().getTemplate("exportClientEmail.ftl");
            InputStream dayIn = getClass().getResourceAsStream("/template/template-excelByDay.xls");
            ;
            File[] files = new File[1];

            if (GenericsUtils.notNullAndEmpty(exportDtos)) {
                HSSFWorkbook wb = new HSSFWorkbook(dayIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                writeDayDataToSheet(sheet, exportDtos);
                files[0] = createFil(wb, beforeDay + "excelData.xls");
            }

            Template parentTemplate = freeMarkerConfigurer.getConfiguration().getTemplate("exportClientEmail.ftl");
            Map<String, Object> map2 = new HashMap<String, Object>();
            map2.put("exportClientDemandDtos", exportExternalClientDemandDtos);
            map2.put("startDate", startDate);
            map2.put("endDate", endDate);
            map2.put("beforeDay", beforeDay);
            map2.put("isInternal", "外部");
            String result = FreeMarkerTemplateUtils.processTemplateIntoString(parentTemplate, map2);

            result += "\n";

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("exportClientDemandDtos", exportInternalClientDemandDtos);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("beforeDay", beforeDay);
            map.put("isInternal", "内部");
            result += FreeMarkerTemplateUtils.processTemplateIntoString(parentTemplate, map);

            // String email = "yuwenhao@baijiahulian.com";
            String email = Config.MAIL_CONTACT_TIANXIAO_CLIENT;
            log.info("天校客户使用数据收件人" + email);
            ExcelMailSender.sendMail(email, "天校客户使用数据" + "(" + beforeDay + "天_" + startDate + "~" + endDate + ")",
                    result, files);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    /**
     * @param statistic
     * @return
     */
    private List<ExportClientDemandDto> getExportClientDemandDtos(StatisticByWeekOrMonthDto statistic, int orgTotal,
                                                                  int beforeDay) {
        List<ExportClientDemandDto> statisticDatas = new ArrayList<>();

        // 登录
        ExportClientDemandDto login = new ExportClientDemandDto();
        int loginValid = getValidTotal(beforeDay, BIzConf.LOGIN_VALID_7, BIzConf.LOGIN_VALID_30);
        login = getExportClientDemandDto(orgTotal, "有效登录", statistic.getEfficientTotalLogin(),
                statistic.getLoginTotal(), "登录次数", "登录天校次数>=" + loginValid);
        statisticDatas.add(login);

        // 登录用户数
        ExportClientDemandDto loginAccount =
                getExportClientDemandDto(orgTotal, "有效登录用户数", statistic.getEfficientTotalLoginAccount(),
                        statistic.getLoginAccountTotal(), "登录用户数", "登录用户>=" + loginValid);
        statisticDatas.add(loginAccount);

        // 登录设备数
        ExportClientDemandDto loginDevice = getExportClientDemandDto(orgTotal, "有效登录设备数",
                statistic.getEfficientTotalLoginDevice(), statistic.getLoginDeviceTotal(), "登录设备数", "登录设备>=" + loginValid);
        statisticDatas.add(loginDevice);

        // 机构设备打开数
        int orgOpenValid = getValidTotal(beforeDay, BIzConf.ORG_OPEN_7, BIzConf.ORG_OPEN_30);
        ExportClientDemandDto orgOpen = getExportClientDemandDto(orgTotal, "机构设备打开次数",
                statistic.getEfficientTotalOrgOpen(), statistic.getOrgOpenTotal(), "打开次数", "打开次数>=" + orgOpenValid);
        statisticDatas.add(orgOpen);

        // 今日代办
        ExportClientDemandDto finish = getExportClientDemandDto(orgTotal, "今日代办", statistic.getEfficientTotalFinish(),
                statistic.getBacklogFinish(), "完成任务次数", "截至目前完成任务总数");
        statisticDatas.add(finish);

        // 微信线索
        int wechatClueValid = getValidTotal(beforeDay, BIzConf.WECHAT_CLUE_VALID_7, BIzConf.WECHAT_CLUE_VALID_30);
        ExportClientDemandDto clueWechat = getExportClientDemandDto(orgTotal, "微信线索",
                statistic.getEfficientTotalClueWechat(), statistic.getClueWechat(), "微信线索量", "微信线索量>=" + wechatClueValid);
        statisticDatas.add(clueWechat);

        // 预约留单
        int clueValid = getValidTotal(beforeDay, BIzConf.CLUERESERVE_VALID_7, BIzConf.CLUERESERVE_VALID_30);
        ExportClientDemandDto clueReserve = getExportClientDemandDto(orgTotal, "预约留单",
                statistic.getEfficientTotalClueReserv(), statistic.getClueReserve(), "留单量", "留单量>=" + clueValid);
        statisticDatas.add(clueReserve);

        // 跟进记录 学员手动录入
        int commentStudentValid = getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
        ExportClientDemandDto commentStudentNotSystem =
                getExportClientDemandDto(orgTotal, "学生手动录入跟进记录", statistic.getEfficientTotalCommentStudentNotSystem(),
                        statistic.getCommentStudentNotSystemTotal(), "学生手动录入跟进记录数", "跟进记录数>=" + commentStudentValid);
        statisticDatas.add(commentStudentNotSystem);

        // 跟进记录 意向学员手动录入
        int commentNotSysValid = getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
        ExportClientDemandDto commentConsultNotSys =
                getExportClientDemandDto(orgTotal, "意向学员手动跟进记录", statistic.getEfficientTotalCommentConsultNotSystem(),
                        statistic.getCommentConsultNotSystemTotal(), "意向学员手动记录数", "跟进记录数>=" + commentNotSysValid);
        statisticDatas.add(commentConsultNotSys);

        // 学员档案
        int studentValid = getValidTotal(beforeDay, BIzConf.STUDENT_TOTAL_VALID_7, BIzConf.STUDENT_TOTAL_VALID_30);
        ExportClientDemandDto student =
                getExportClientDemandDto(orgTotal, "学员档案", statistic.getEfficientTotalIncrementStudent(),
                        statistic.getIncrementStudentTotal(), "学员档案数", "学员档案数>=" + studentValid);
        statisticDatas.add(student);

        // 微信公众号
        ExportClientDemandDto wechatAuthorizer = getExportClientDemandDto(orgTotal, "微信公众号托管",
                statistic.getEfficientTotalWechatAuthorizer(), statistic.getWechatFansTotal(), "微信粉丝数", "微信公众号托管给天校");
        statisticDatas.add(wechatAuthorizer);

        // 设班
        int courseValid = getValidTotal(beforeDay, BIzConf.COURSE_TOTAL_VALID_7, BIzConf.COURSE_TOTAL_VALID_30);
        ExportClientDemandDto course = getExportClientDemandDto(orgTotal, "设班", statistic.getEfficientTotalCourse(),
                statistic.getCourseTotal(), "添加课程数", "添加课程>=" + courseValid);
        statisticDatas.add(course);

        // 排课
        int arrangedClassValid =
                getValidTotal(beforeDay, BIzConf.ARRANGE_CLASS_TOTAL_VALID_7, BIzConf.ARRANGE_CLASS_TOTAL_VALID_30);
        ExportClientDemandDto arrangeCourse =
                getExportClientDemandDto(orgTotal, "排课", statistic.getEfficientTotalArrangedClassTotal(),
                        statistic.getArrangedClassTotal(), "排课班级数", "排课班级>=" + arrangedClassValid);
        statisticDatas.add(arrangeCourse);

        // 发课表
        int courseSmsValid =
                getValidTotal(beforeDay, BIzConf.COURSESMS_TOTAL_VALID_7, BIzConf.COURSESMS_TOTAL_VALID_30);
        ExportClientDemandDto courseSms = getExportClientDemandDto(orgTotal, "发课表",
                statistic.getEfficientTotalCourseSms(), statistic.getCourseSmsTotal(), "发课表人次", "发课表>=" + courseSmsValid);
        statisticDatas.add(courseSms);

        // 收款
        ExportClientDemandDto incomeSum = new ExportClientDemandDto();
        incomeSum.setKeyFunctionName("收款");
        incomeSum.setEfficientTotal(statistic.getEfficientTotalIncomeSum());
        incomeSum.setCoverageRate(getPercentByTwoPrecision(statistic.getEfficientTotalIncomeSum(), orgTotal));
        if (statistic.getEfficientTotalIncomeSum() != 0) {
            incomeSum
                    .setAverageUsers(getAverageUsers(statistic.getIncomeSum(), statistic.getEfficientTotalIncomeSum()));
        } else {
            incomeSum.setAverageUsers("");
        }
        incomeSum.setKeyIndex("收款金额");
        incomeSum.setTotal(statistic.getIncomeSum() + "");
        int incomeSumValid = getValidTotal(beforeDay, BIzConf.INCOMESUM_VALID_7, BIzConf.INCOMESUM_VALID_30);
        incomeSum.setRemarks("收款>=" + incomeSumValid);
        statisticDatas.add(incomeSum);

        // 签到
        int signLessonValid = getValidTotal(beforeDay, BIzConf.SIGN_LESSON_VALID_7, BIzConf.SIGN_LESSON_VALID_30);
        ExportClientDemandDto sign = getExportClientDemandDto(orgTotal, "签到", statistic.getEfficientTotalSign(),
                statistic.getSignStudentTotal(), "签到人次", "签到班级>=" + signLessonValid);
        statisticDatas.add(sign);

        // 评价
        int teacherCommentValid =
                getValidTotal(beforeDay, BIzConf.TEACHER_COMMENT_VALID_7, BIzConf.TEACHER_COMMENT_VALID_30);
        ExportClientDemandDto commentByTeacher =
                getExportClientDemandDto(orgTotal, "评价", statistic.getEfficientTotalCommentByTeacher(),
                        statistic.getCommentByTeacher(), "老师评价数", "老师评价>=" + teacherCommentValid);
        statisticDatas.add(commentByTeacher);

        // 学生评价
        int studentCommentValid =
                getValidTotal(beforeDay, BIzConf.STUDENT_COMMENT_VALID_7, BIzConf.STUDENT_COMMENT_VALID_30);
        ExportClientDemandDto commentByStudent =
                getExportClientDemandDto(orgTotal, "", statistic.getEfficientTotalCommentByStudent(),
                        statistic.getCommentByStudent(), "学生评价数", "学生评价>=" + studentCommentValid);
        statisticDatas.add(commentByStudent);

        // 发活动
        int drawTotalValid =
                getValidTotal(beforeDay, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_7, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_30);
        int activityTotalValid =
                getValidTotal(beforeDay, BIzConf.ACTIVITY_TOTAL_VALID_7, BIzConf.ACTIVITY_TOTAL_VALID_30);
        ExportClientDemandDto activity =
                getExportClientDemandDto(orgTotal, "发活动", statistic.getEfficientTotalActivity(),
                        statistic.getActivityAccessTotal(), "活动访问量(UV)", "发活动>=" + activityTotalValid);
        statisticDatas.add(activity);

        // 抽奖
        ExportClientDemandDto draw = getExportClientDemandDto(orgTotal, "抽奖", statistic.getEfficientTotalDrawActivity(),
                statistic.getDrawUserTotal(), "抽奖参与量", "抽奖活动 >=" + drawTotalValid);
        statisticDatas.add(draw);

        // 投票
        int voteTotalValid =
                getValidTotal(beforeDay, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_7, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_30);
        ExportClientDemandDto vote = getExportClientDemandDto(orgTotal, "投票", statistic.getEfficientTotalvoteActivity(),
                statistic.getVoteAccessTotal(), "投票访问量(UV)", "投票活动>=" + voteTotalValid);
        statisticDatas.add(vote);

        // 转介绍
        int referralTotalValid =
                getValidTotal(beforeDay, BIzConf.REFERRAL_ACTIVITY_VALID_7, BIzConf.REFERRAL_ACTIVITY_VALID_30);
        ExportClientDemandDto referral =
                getExportClientDemandDto(orgTotal, "转介绍", statistic.getEfficientTotalReferralActivity(),
                        statistic.getReferralAccessTotal(), "转介绍访问量(UV)", "转介绍活动>=" + referralTotalValid);
        statisticDatas.add(referral);

        // 群发消息
        int groupMsgTotalValid =
                getValidTotal(beforeDay, BIzConf.GROUP_MESSAGE_TOTAL_VALID_7, BIzConf.GROUP_MESSAGE_TOTAL_VALID_30);
        ExportClientDemandDto groupMsg =
                getExportClientDemandDto(orgTotal, "群发消息", statistic.getEfficientTotalGroupMsg(),
                        statistic.getGroupMsgTotal(), "群发消息人次", "群发消息>=" + groupMsgTotalValid);
        statisticDatas.add(groupMsg);

        // 主页装修
        ExportClientDemandDto useHomePage = new ExportClientDemandDto();
        useHomePage.setKeyFunctionName("主页装修");
        useHomePage.setEfficientTotal(statistic.getEfficientTotalUseHomePage());
        useHomePage.setKeyIndex("");
        useHomePage.setCoverageRate(getPercentByTwoPrecision(statistic.getEfficientTotalUseHomePage(), orgTotal));
        useHomePage.setAverageUsers("");
        useHomePage.setTotal("");
        useHomePage.setRemarks("使用过主页模板");
        statisticDatas.add(useHomePage);

        // 主页有效
        int uvTotalValid = getValidTotal(beforeDay, BIzConf.UV_TOTAL_VALID_7, BIzConf.UV_TOTAL_VALID_30);
        ExportClientDemandDto UV = getExportClientDemandDto(orgTotal, "主页有效", statistic.getEfficientTotalUV(),
                statistic.getUvTotal(), "主页访问量(UV)", "主页访问>=" + uvTotalValid);
        statisticDatas.add(UV);

        // 学生绑定个人中心
        ExportClientDemandDto wechatAuthorizerOfStudent =
                getExportClientDemandDto(orgTotal, "学生绑定个人中心", statistic.getEfficientTotalWechatAuthorizerOfStudent(),
                        statistic.getWechatAuthorizerOfStudentTotal(), "学生绑定个人中心人数", "总量为截至目前总人数");
        statisticDatas.add(wechatAuthorizerOfStudent);

        // 400电话呼出
        ExportClientDemandDto orgCall = getExportClientDemandDto(orgTotal, "400电话呼出",
                statistic.getEfficientTotalorgCallRecordCount(), statistic.getOrgCallRecordCount(), "400电话呼出量", "使用过400电话");
        statisticDatas.add(orgCall);

        // 双呼
        ExportClientDemandDto callService = getExportClientDemandDto(orgTotal, "双呼",
                statistic.getEfficientCallServiceCount(), statistic.getCallServiceCount(), "双呼使用量", "使用过双呼");
        statisticDatas.add(callService);

        return statisticDatas;
    }

    private ExportClientDemandDto getExportClientDemandDto(int orgTotal, String keyFunctionName, int efficientTotal,
                                                           int total, String keyIndex, String remarks) {
        ExportClientDemandDto dto = new ExportClientDemandDto();
        dto.setKeyFunctionName(keyFunctionName);
        dto.setEfficientTotal(efficientTotal);
        dto.setCoverageRate(getPercentByTwoPrecision(efficientTotal, orgTotal));
        if (efficientTotal != 0) {
            dto.setAverageUsers(getAverageUsers(total, efficientTotal));
        } else {
            dto.setAverageUsers("");
        }
        dto.setKeyIndex(keyIndex);
        dto.setTotal(total + "");
        dto.setRemarks(remarks);
        return dto;
    }

    private String getPercentByTwoPrecision(int num1, int num2) {
        // 创建一个数值格式化对象
        NumberFormat numberFormat = NumberFormat.getInstance();

        // 设置精确到小数点后2位
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float) num1 / (float) num2 * 100);
        return result + "%";
    }

    private String getTwoPrecision(int num1, int num2) {
        // 创建一个数值格式化对象
        NumberFormat numberFormat = NumberFormat.getInstance();

        // 设置精确到小数点后2位
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float) num1 / (float) num2);
        return result;

    }

    private String getAverageUsers(double num1, double num2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        // 设置精确到小数点后0位
        numberFormat.setMaximumFractionDigits(0);
        double data = num1 / num2;
        data = Math.ceil(data);
        String result = numberFormat.format(data);
        return result;
    }

    private StatisticByWeekOrMonthDto getStatisticByWeekOrMonthDto(List<ExportDto> exportDtos, int beforeDay) {
        StatisticByWeekOrMonthDto statistic = new StatisticByWeekOrMonthDto();
        for (ExportDto exportDto : exportDtos) {
            // 机构登录
            int loginValid = getValidTotal(beforeDay, BIzConf.LOGIN_VALID_7, BIzConf.LOGIN_VALID_30);
            if (exportDto.getLoginTotal() >= loginValid) {
                statistic.setEfficientTotalLogin(statistic.getEfficientTotalLogin() + 1);
                statistic.setLoginTotal(statistic.getLoginTotal() + exportDto.getLoginTotal());
            }
            // 机构用户登录次数
            if (exportDto.getLoginAccountTotal() >= loginValid) {
                statistic.setEfficientTotalLoginAccount(statistic.getEfficientTotalLoginAccount() + 1);
                statistic.setLoginAccountTotal(statistic.getLoginAccountTotal() + exportDto.getLoginAccountTotal());
            }

            // 机构设备登录次数
            if (exportDto.getLoginAccountTotal() >= loginValid) {
                statistic.setEfficientTotalLoginDevice(statistic.getEfficientTotalLoginDevice() + 1);
                statistic.setLoginDeviceTotal(statistic.getLoginDeviceTotal() + exportDto.getLoginDeviceTotal());
            }

            // 机构打开次数
            int orgOpenValid = getValidTotal(beforeDay, BIzConf.ORG_OPEN_7, BIzConf.ORG_OPEN_30);
            if (exportDto.getOrgOpenTotal() >= orgOpenValid) {
                statistic.setEfficientTotalOrgOpen(statistic.getEfficientTotalOrgOpen() + 1);
                statistic.setOrgOpenTotal(statistic.getOrgOpenTotal() + exportDto.getOrgOpenTotal());
            }

            // 今日代办
            if (exportDto.getBacklogFinish() != 0) {
                statistic.setEfficientTotalFinish(statistic.getEfficientTotalFinish() + 1);
            }
            statistic.setBacklogFinish(statistic.getBacklogFinish() + exportDto.getBacklogFinish());

            // 微信线索
            int wechatClueValid = getValidTotal(beforeDay, BIzConf.WECHAT_CLUE_VALID_7, BIzConf.WECHAT_CLUE_VALID_30);
            if (exportDto.getClueWechat() >= wechatClueValid) {
                statistic.setEfficientTotalClueWechat(statistic.getEfficientTotalClueWechat() + 1);
                statistic.setClueWechat(statistic.getClueWechat() + exportDto.getClueWechat());
            }

            // 预约留单
            int clueValid = getValidTotal(beforeDay, BIzConf.CLUERESERVE_VALID_7, BIzConf.CLUERESERVE_VALID_30);
            if (exportDto.getClueReserve() >= clueValid) {
                statistic.setEfficientTotalClueReserv(statistic.getEfficientTotalClueReserv() + 1);
                statistic.setClueReserve(statistic.getClueReserve() + exportDto.getClueReserve());
            }

            // 跟进记录 学员手动录入
            int commentStudentValid = getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
            if (exportDto.getCommentStudentNotSystemTotal() >= commentStudentValid) {
                statistic
                        .setEfficientTotalCommentStudentNotSystem(statistic.getEfficientTotalCommentStudentNotSystem() + 1);
                statistic.setCommentStudentNotSystemTotal(
                        statistic.getCommentStudentNotSystemTotal() + exportDto.getCommentStudentNotSystemTotal());
            }

            // 跟进记录 意向学员手动录入
            int commentConsultValid = getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
            if (exportDto.getCommentConsultNotSystemTotal() >= commentConsultValid) {
                statistic
                        .setEfficientTotalCommentConsultNotSystem(statistic.getEfficientTotalCommentConsultNotSystem() + 1);
                statistic.setCommentConsultNotSystemTotal(
                        statistic.getCommentConsultNotSystemTotal() + exportDto.getCommentConsultNotSystemTotal());
            }

            // 学员档案
            int studentValid = getValidTotal(beforeDay, BIzConf.STUDENT_TOTAL_VALID_7, BIzConf.STUDENT_TOTAL_VALID_30);
            if (exportDto.getIncrementStudentTotal() >= studentValid) {
                statistic.setEfficientTotalIncrementStudent(statistic.getEfficientTotalIncrementStudent() + 1);
                statistic.setIncrementStudentTotal(
                        statistic.getIncrementStudentTotal() + exportDto.getIncrementStudentTotal());
            }

            // 微信公众号
            if (exportDto.getIsWechatAuthorizer()) {
                statistic.setEfficientTotalWechatAuthorizer(statistic.getEfficientTotalWechatAuthorizer() + 1);
                statistic.setWechatFansTotal(statistic.getWechatFansTotal() + exportDto.getWechatFansTotal());
            }

            // 设班
            int courseValid = getValidTotal(beforeDay, BIzConf.COURSE_TOTAL_VALID_7, BIzConf.COURSE_TOTAL_VALID_30);
            if (exportDto.getCourseTotal() >= courseValid) {
                statistic.setEfficientTotalCourse(statistic.getEfficientTotalCourse() + 1);
                statistic.setCourseTotal(statistic.getCourseTotal() + exportDto.getCourseTotal());
            }

            // 排课
            int arrangedClassValid =
                    getValidTotal(beforeDay, BIzConf.ARRANGE_CLASS_TOTAL_VALID_7, BIzConf.ARRANGE_CLASS_TOTAL_VALID_30);
            if (exportDto.getArrangedClassTotal() >= arrangedClassValid) {
                statistic.setEfficientTotalArrangedClassTotal(statistic.getEfficientTotalArrangedClassTotal() + 1);
                statistic.setArrangedClassTotal(statistic.getArrangedClassTotal() + exportDto.getArrangedClassTotal());
            }

            // 发课表
            int courseSmsValid =
                    getValidTotal(beforeDay, BIzConf.COURSESMS_TOTAL_VALID_7, BIzConf.COURSESMS_TOTAL_VALID_30);
            if (exportDto.getCourseSmsTotal() >= courseSmsValid) {
                statistic.setEfficientTotalCourseSms(statistic.getEfficientTotalCourseSms() + 1);
                statistic.setCourseSmsTotal(statistic.getCourseSmsTotal() + exportDto.getCourseSmsTotal());
            }

            // 收款
            int incomeSumValid = getValidTotal(beforeDay, BIzConf.INCOMESUM_VALID_7, BIzConf.INCOMESUM_VALID_30);
            if (exportDto.getIncomeSum() > incomeSumValid) {
                statistic.setEfficientTotalIncomeSum(statistic.getEfficientTotalIncomeSum() + 1);
                statistic.setIncomeSum(statistic.getIncomeSum() + (int) Math.ceil(exportDto.getIncomeSum()));
            }

            // 签到
            int signLessonValid = getValidTotal(beforeDay, BIzConf.SIGN_LESSON_VALID_7, BIzConf.SIGN_LESSON_VALID_30);
            if (exportDto.getSignLessonTotal() >= signLessonValid) {
                statistic.setEfficientTotalSign(statistic.getEfficientTotalSign() + 1);
                statistic.setSignStudentTotal(statistic.getSignStudentTotal() + exportDto.getSignStudentTotal());
            }

            // 老师评价
            int teacherCommentValid =
                    getValidTotal(beforeDay, BIzConf.TEACHER_COMMENT_VALID_7, BIzConf.TEACHER_COMMENT_VALID_30);
            if (exportDto.getCommentByTeacher() >= teacherCommentValid) {
                statistic.setEfficientTotalCommentByTeacher(statistic.getEfficientTotalCommentByTeacher() + 1);
                statistic.setCommentByTeacher(statistic.getCommentByTeacher() + exportDto.getCommentByTeacher());
            }

            // 学生评价
            int studentCommentValid =
                    getValidTotal(beforeDay, BIzConf.STUDENT_COMMENT_VALID_7, BIzConf.STUDENT_COMMENT_VALID_30);
            if (exportDto.getCommentByStudent() >= studentCommentValid) {
                statistic.setEfficientTotalCommentByStudent(statistic.getEfficientTotalCommentByStudent() + 1);
                statistic.setCommentByStudent(statistic.getCommentByStudent() + exportDto.getCommentByStudent());
            }

            // 发活动
            int activityTotalValid =
                    getValidTotal(beforeDay, BIzConf.ACTIVITY_TOTAL_VALID_7, BIzConf.ACTIVITY_TOTAL_VALID_30);
            if (exportDto.getActivityTotal() >= activityTotalValid) {
                statistic.setEfficientTotalActivity(statistic.getEfficientTotalActivity() + 1);
                statistic
                        .setActivityAccessTotal(statistic.getActivityAccessTotal() + exportDto.getActivityAccessTotal());
            }

            // 抽奖
            int drawTotalValid =
                    getValidTotal(beforeDay, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_7, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_30);
            if (exportDto.getDrawActivityTotal() >= drawTotalValid) {
                statistic.setEfficientTotalDrawActivity(statistic.getEfficientTotalDrawActivity() + 1);
                statistic.setDrawUserTotal(statistic.getDrawUserTotal() + exportDto.getDrawUserTotal());
            }

            // 投票
            int voteTotalValid =
                    getValidTotal(beforeDay, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_7, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_30);
            if (exportDto.getVoteActivityTotal() >= voteTotalValid) {
                statistic.setEfficientTotalvoteActivity(statistic.getEfficientTotalvoteActivity() + 1);
                statistic.setVoteAccessTotal(statistic.getVoteAccessTotal() + exportDto.getVoteAccessTotal());
            }

            // 转介绍
            int referralTotalValid =
                    getValidTotal(beforeDay, BIzConf.REFERRAL_ACTIVITY_VALID_7, BIzConf.REFERRAL_ACTIVITY_VALID_30);
            if (exportDto.getReferralActivityTotal() >= referralTotalValid) {
                statistic.setEfficientTotalReferralActivity(statistic.getEfficientTotalReferralActivity() + 1);
                statistic
                        .setReferralAccessTotal(statistic.getReferralAccessTotal() + exportDto.getReferralAccessTotal());
            }

            // 群发消息
            int groupMsgValid =
                    getValidTotal(beforeDay, BIzConf.GROUP_MESSAGE_TOTAL_VALID_7, BIzConf.GROUP_MESSAGE_TOTAL_VALID_30);
            if (exportDto.getGroupMsgTotal() >= groupMsgValid) {
                statistic.setEfficientTotalGroupMsg(statistic.getEfficientTotalGroupMsg() + 1);
                statistic.setGroupMsgTotal(statistic.getGroupMsgTotal() + exportDto.getGroupMsgTotal());
            }

            // 主页装修
            if (exportDto.getIsUseHomePage()) {
                statistic.setEfficientTotalUseHomePage(statistic.getEfficientTotalUseHomePage() + 1);
            }

            // 主页有效
            int uvTotalValid = getValidTotal(beforeDay, BIzConf.UV_TOTAL_VALID_7, BIzConf.UV_TOTAL_VALID_30);
            if (exportDto.getUvTotal() >= uvTotalValid) {
                statistic.setEfficientTotalUV(statistic.getEfficientTotalUV() + 1);
                statistic.setUvTotal(statistic.getUvTotal() + exportDto.getUvTotal());
            }

            // 学生绑定个人中心 不能算某个阶段的
            if (exportDto.getWechatAuthorizerOfStudentTotal() != 0) {
                statistic.setEfficientTotalWechatAuthorizerOfStudent(
                        statistic.getEfficientTotalWechatAuthorizerOfStudent() + 1);
            }
            statistic.setWechatAuthorizerOfStudentTotal(
                    statistic.getWechatAuthorizerOfStudentTotal() + exportDto.getWechatAuthorizerOfStudentTotal());

            // 400电话呼出
            if (exportDto.getOrgCallRecordCount() >= 1) {
                statistic.setEfficientTotalorgCallRecordCount(statistic.getEfficientTotalorgCallRecordCount() + 1);
                statistic.setOrgCallRecordCount(statistic.getOrgCallRecordCount() + exportDto.getOrgCallRecordCount());
            }

            // 双呼
            if (exportDto.getCallServiceCount() >= 1) {
                statistic.setEfficientCallServiceCount(statistic.getEfficientCallServiceCount() + 1);
                statistic.setCallServiceCount(statistic.getCallServiceCount() + exportDto.getCallServiceCount());
            }
        }

        log.info("statistic param:{}", statistic);
        return statistic;
    }

    private int getValidTotal(int dayNum, int data7, int data30) {
        int result = 0;
        if (dayNum == 7) {
            result = data7;
        } else {
            result = data30;
        }
        return result;
    }

    @Override
    public void getMonitorData(Date startTime, Date endTime) {
        Integer accountType = AccountTypeEnum.ZHENGSHI.getCode();
        List<Long> TianxiaoOrgIds = this.getOrgIdsByAccount(accountType);

        Map<Long, Integer> orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        List<Integer> TianxiaoOrgNumbers = new ArrayList<>();
        for (Long orgId : orgNumberMap.keySet()) {
            Integer orgNumber = orgNumberMap.get(orgId);
            TianxiaoOrgNumbers.add(orgNumber);
        }

        // String path = "template/OrderOrgNumber.txt";
        // List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers(path);
        log.info("taixiao机构账号列表长度==================" + TianxiaoOrgNumbers.size());
        // List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);

        Map<String, TxMonitorTypeDay> txMonitorTypeDayMap =
                this.txMonitorTypeDayDao.mapUseMonitorType(startTime, endTime, TianxiaoOrgNumbers);

        Map<String, Integer> consultTotalMap =
                this.messageDao.getConsultTotalMapByDate(startTime, endTime, TianxiaoOrgIds);
        log.info("线索总量 consultTotalMap param {}", consultTotalMap);

        Map<String, Integer> studentTotalMap =
                this.orgStudentDao.getStudentTotalMap(startTime, endTime, TianxiaoOrgIds);

        Map<String, Integer> courseTotalMap =
                this.orgCourseDao.getCourseTotalMap(startTime, endTime, TianxiaoOrgNumbers, null, null, null);

        Map<String, Integer> commentByTeacherMap =
                this.orgLessonCommentDao.getOrgCommentMap(startTime, endTime, TianxiaoOrgIds, 0);

        Map<String, Integer> commentByStudentMap =
                this.orgLessonCommentDao.getOrgCommentMap(startTime, endTime, TianxiaoOrgIds, 2);

        Map<String, List<Long>> signLessonIdsMap =
                this.orgLessonSignDao.getOrgSignLessonIdsMap(startTime, endTime, TianxiaoOrgIds);

        Map<String, Integer> signByTeacherMap = new HashMap<>();

        if (GenericsUtils.notNullAndEmpty(signLessonIdsMap)) {
            for (String createTime : signLessonIdsMap.keySet()) {
                List<Long> lessonIds = signLessonIdsMap.get(createTime);
                // 根据课节lessonIds找签到老师数量
                Map<Long, OrgTeacherLesson> orgTeacherLessonMap =
                        this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(lessonIds);
                Set<Long> teacherIds = new HashSet<>();
                if (GenericsUtils.notNullAndEmpty(orgTeacherLessonMap)) {
                    for (Long lessonId : orgTeacherLessonMap.keySet()) {
                        Long teacherId = orgTeacherLessonMap.get(lessonId).getTeacherId();
                        teacherIds.add(teacherId);
                    }
                }
                Integer signTeacherCount = teacherIds.size();
                signByTeacherMap.put(createTime, signTeacherCount);
            }
        }
        log.info("signByTeacherMap param{}", signByTeacherMap);

        Map<String, Integer> signByStudentMap =
                this.orgLessonSignDao.getOrgSignMap(startTime, endTime, TianxiaoOrgIds, 2);

        Map<String, Integer> loginMap = this.orgAppLoginLogDao.getOrgLoginMap(startTime, endTime, TianxiaoOrgIds);

        // 四个活动访问量
        // 微活动访问量
        Map<Long, List<Long>> activityIdsMap = this.activityDao.getActivityIdByOrgIds(TianxiaoOrgIds, null, null);
        List<Long> activityIds = new ArrayList<>();
        if (GenericsUtils.notNullAndEmpty(activityIdsMap)) {
            for (Long orgId : activityIdsMap.keySet()) {
                List<Long> ids = activityIdsMap.get(orgId);
                if (GenericsUtils.notNullAndEmpty(ids)) {
                    activityIds.addAll(ids);
                }
            }
        }
        Map<String, Integer> activityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(activityIds,
                TemplateTypeCategory.COMMON_TYPE.getType(), startTime, endTime);
        // log.info("activityTotalMap========长度=====" + activityTotalMap);
        Map<String, Integer> activityUserTotalMap = this.activityUserDao.getUserTotalMap(activityIds,
                TemplateTypeCategory.COMMON_TYPE.getType(), startTime, endTime);

        // 抽奖
        Map<Long, List<Long>> drawActivityIdsMap =
                this.drawActivityDao.getDrawActivitysByIds(TianxiaoOrgIds, null, null);
        List<Long> drawActivityIds = new ArrayList<>();
        if (GenericsUtils.notNullAndEmpty(drawActivityIdsMap)) {
            for (Long orgId : drawActivityIdsMap.keySet()) {
                List<Long> ids = drawActivityIdsMap.get(orgId);
                if (GenericsUtils.notNullAndEmpty(ids)) {
                    drawActivityIds.addAll(ids);
                }
            }
        }
        Map<String, Integer> drawActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(
                drawActivityIds, TemplateTypeCategory.DRAW_TYPE.getType(), startTime, endTime);

        Map<String, Integer> drawActivityUserTotalMap = this.activityUserDao.getUserTotalMap(drawActivityIds,
                TemplateTypeCategory.DRAW_TYPE.getType(), startTime, endTime);

        // 投票
        Map<Long, List<Long>> voteActivityIdsMap =
                this.voteInfoDao.getVoteActivityIdsByOrgIds(TianxiaoOrgIds, null, null);
        List<Long> voteActivityIds = new ArrayList<>();
        if (GenericsUtils.notNullAndEmpty(voteActivityIdsMap)) {
            for (Long orgId : voteActivityIdsMap.keySet()) {
                List<Long> ids = voteActivityIdsMap.get(orgId);
                if (GenericsUtils.notNullAndEmpty(ids)) {
                    voteActivityIds.addAll(ids);
                }
            }
        }
        Map<String, Integer> voteActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(
                voteActivityIds, TemplateTypeCategory.VOTE_TYPE.getType(), startTime, endTime);

        Map<String, Integer> voteActivityUserTotalMap = this.activityUserDao.getUserTotalMap(voteActivityIds,
                TemplateTypeCategory.VOTE_TYPE.getType(), startTime, endTime);

        // 转介绍
        Map<Long, List<Long>> referralActivityIdsMap =
                this.referralInfoDao.getReferralActivityIdsByOrgIds(TianxiaoOrgIds, null, null);
        List<Long> referralActivityIds = new ArrayList<>();
        if (GenericsUtils.notNullAndEmpty(referralActivityIdsMap)) {
            for (Long orgId : referralActivityIdsMap.keySet()) {
                List<Long> ids = referralActivityIdsMap.get(orgId);
                if (GenericsUtils.notNullAndEmpty(ids)) {
                    referralActivityIds.addAll(ids);
                }
            }
        }
        Map<String, Integer> referralActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(
                referralActivityIds, TemplateTypeCategory.REFERRAL_TYPE.getType(), startTime, endTime);

        Map<String, Integer> referralActivityUserTotalMap = this.activityUserDao.getUserTotalMap(referralActivityIds,
                TemplateTypeCategory.REFERRAL_TYPE.getType(), startTime, endTime);

        Map<String, ExportDto> exportDtoMap = new HashMap<>();

        for (String date : txMonitorTypeDayMap.keySet()) {
            TxMonitorTypeDay txMonitorTypeDay = txMonitorTypeDayMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setPvTotal(txMonitorTypeDay.getPv() == null ? 0 : txMonitorTypeDay.getPv());
            exportDto.setUvTotal(txMonitorTypeDay.getUv() == null ? 0 : txMonitorTypeDay.getUv());
        }

        for (String date : consultTotalMap.keySet()) {
            Integer consultTotal = consultTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                log.info("");
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setClueTotal(consultTotal == null ? 0 : consultTotal);
        }

        for (String date : studentTotalMap.keySet()) {
            Integer studentTotal = studentTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setStudentTotal(studentTotal == null ? 0 : studentTotal);
        }

        // 微课
        for (String date : courseTotalMap.keySet()) {
            Integer courseTotal = courseTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setCourseTotal(courseTotal == null ? 0 : courseTotal);
        }

        // 机构登录
        for (String date : loginMap.keySet()) {
            Integer loginTotal = loginMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setLoginTotal(loginTotal == null ? 0 : loginTotal);
        }

        // 学生评价
        for (String date : commentByStudentMap.keySet()) {
            Integer commsentStuTotal = commentByStudentMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setCommentByStudent(commsentStuTotal == null ? 0 : commsentStuTotal);
        }

        // 老师评价
        for (String date : commentByTeacherMap.keySet()) {
            Integer commentTeacherTotal = commentByTeacherMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setCommentByTeacher(commentTeacherTotal == null ? 0 : commentTeacherTotal);
        }

        // 学生签到
        for (String date : signByStudentMap.keySet()) {
            Integer signStuTotal = signByStudentMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setSignStudentTotal(signStuTotal == null ? 0 : signStuTotal);
        }

        // 老师签到 signByTeacherMap
        for (String date : signByTeacherMap.keySet()) {
            Integer signTeacherTotal = signByTeacherMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setSignTeacherTotal(signTeacherTotal == null ? 0 : signTeacherTotal);
        }

        // 说明在这里exportDto.getActivityTotal记作是四个活动的累加和
        // 发活动
        for (String date : activityTotalMap.keySet()) {
            Integer activityTotal = activityTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityTotal = exportDto.getActivityTotal() + activityTotal;
            exportDto.setActivityTotal(activityTotal == null ? 0 : activityTotal);
        }

        // 抽奖
        for (String date : drawActivityTotalMap.keySet()) {
            Integer activityTotal = drawActivityTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityTotal = exportDto.getActivityTotal() + activityTotal;
            exportDto.setActivityTotal(activityTotal == null ? 0 : activityTotal);
        }

        // 投票
        for (String date : voteActivityTotalMap.keySet()) {
            Integer activityTotal = voteActivityTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityTotal = exportDto.getActivityTotal() + activityTotal;
            exportDto.setActivityTotal(activityTotal == null ? 0 : activityTotal);
        }
        // 转介绍
        for (String date : referralActivityTotalMap.keySet()) {
            Integer activityTotal = referralActivityTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityTotal = exportDto.getActivityTotal() + activityTotal;
            exportDto.setActivityTotal(activityTotal == null ? 0 : activityTotal);
        }

        // 参与人数 四个活动相加
        // 发活动
        for (String date : activityUserTotalMap.keySet()) {
            Integer activityUserTotal = activityUserTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityUserTotal = exportDto.getDrawUserTotal() + activityUserTotal;
            exportDto.setDrawUserTotal(activityUserTotal == null ? 0 : activityUserTotal);
        }

        // 抽奖

        for (String date : drawActivityUserTotalMap.keySet()) {
            Integer activityUserTotal = drawActivityUserTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityUserTotal = exportDto.getDrawUserTotal() + activityUserTotal;
            exportDto.setDrawUserTotal(activityUserTotal == null ? 0 : activityUserTotal);
        }

        // toupiao
        for (String date : voteActivityUserTotalMap.keySet()) {
            Integer activityUserTotal = voteActivityUserTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityUserTotal = exportDto.getDrawUserTotal() + activityUserTotal;
            exportDto.setDrawUserTotal(activityUserTotal == null ? 0 : activityUserTotal);
        }

        // 转介绍哦啊
        for (String date : referralActivityUserTotalMap.keySet()) {
            Integer activityUserTotal = referralActivityUserTotalMap.get(date);
            ExportDto exportDto = exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            activityUserTotal = exportDto.getDrawUserTotal() + activityUserTotal;
            exportDto.setDrawUserTotal(activityUserTotal == null ? 0 : activityUserTotal);
        }

        final List<Map<String, String>> rows = new ArrayList<>();
        for (String date : exportDtoMap.keySet()) {
            ExportDto exportDto = exportDtoMap.get(date);
            Map<String, String> rowMap = new LinkedHashMap<>();
            rowMap.put("日期", exportDto.getCurDate());
            rowMap.put("新增线索", exportDto.getClueTotal() + "");
            rowMap.put("新增学员", exportDto.getStudentTotal() + "");
            rowMap.put("机构主页UV", exportDto.getUvTotal() + "");
            rowMap.put("机构主页PV", exportDto.getPvTotal() + "");
            rowMap.put("新增微课数量", exportDto.getCourseTotal() + "");
            rowMap.put("活动PV", exportDto.getActivityTotal() + "");
            rowMap.put("活动UV", exportDto.getDrawUserTotal() + "");
            rowMap.put("机构登录", exportDto.getLoginTotal() + "");
            rowMap.put("学生主动评价数", exportDto.getCommentByStudent() + "");
            rowMap.put("老师主动评价数", exportDto.getCommentByTeacher() + "");
            rowMap.put("学生签到", exportDto.getSignStudentTotal() + "");
            rowMap.put("老师签到", exportDto.getSignTeacherTotal() + "");

            rows.add(rowMap);
        }
        String startDate = null;
        String endDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        startDate = dateFormat.format(startTime);
        endDate = dateFormat.format(endTime);

        String subject = "机构主页访问信息(" + startDate + "~" + endDate + ")";
        String content = "";
        String mail = "yuwenhao@baijiahulian.com,taoyaping@baijiahulian.com,liuminglei@baijiahulian.com,lishaoheng@baijiahulian.com";
        String fileName = "orgInfo";
        ExcelMailSender.sendMail(mail, subject, content, fileName, rows);
    }

    @Override
    public void createExcelOfErpData() {
        // 购买天校机构number
        String filePath = "template/OrderOrgNumber.txt";
        List<Integer> tianXiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers(filePath);

        List<Long> orgIds = getTianxiaoOrgIds(tianXiaoOrgNumbers);

        Map<Long, Integer> orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(orgIds);

        List<OrgCourse> orgCourseList =
                this.orgCourseDao.getOrgCourseList(tianXiaoOrgNumbers, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);

        if (GenericsUtils.isNullOrEmpty(orgCourseList)) {
            log.info("获取机构课程为数据位Null");
            return;
        }

        // 获取课程id与课程对应关系
        Map<Long, OrgCourse> orgCourseMap = new HashMap<>();
        List<Long> courseIds = new ArrayList<>();
        Set<Long> roomIds = new HashSet<>();

        for (OrgCourse orgCourse : orgCourseList) {
            Long orgCourseId = orgCourse.getId();
            orgCourseMap.put(orgCourseId, orgCourse);
            courseIds.add(orgCourseId);

            Long roomId = orgCourse.getRoomId();
            if (GenericsUtils.notNullAndEmpty(roomId)) {
                roomIds.add(roomId);
            }
        }

        Map<Long, OrgClassRoom> orgClassRoomMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(roomIds)) {
            List<OrgClassRoom> orgClassRooms = this.OrgClassRoomDao.getOrgClassRoomListByRoomIds(roomIds);
            for (OrgClassRoom orgClassRoom : orgClassRooms) {
                Long roomId = orgClassRoom.getId();
                orgClassRoomMap.put(roomId, orgClassRoom);
            }
        }

        // 根据courseIds获取课程与老师usrId关系映射表
        Map<Long, List<Long>> teacherUserIdsMap = this.orgCourseTeacherDao.getTeacherMap(courseIds);
        Set<Long> teacherUserIds = new HashSet<>();
        Map<Long, String> teacherNameMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(teacherUserIdsMap)) {
            for (Long courseId : teacherUserIdsMap.keySet()) {
                List<Long> teacherIds = teacherUserIdsMap.get(courseId);
                teacherUserIds.addAll(teacherIds);
            }

            // 获取老师姓名信息
            teacherNameMap = this.teacherDao.getTeacherRealNameMap(teacherUserIds);
        }

        // 根据courseIds获取课程与学生userId关系映射
        Map<Long, List<OrgStudentCourse>> orgStudentCourseMapBycourseIds =
                this.orgStudentCourseDao.getStudentMapBycourseIds(courseIds);
        Map<Long, Integer> stuTotalMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(orgStudentCourseMapBycourseIds)) {
            for (Long courseId : orgStudentCourseMapBycourseIds.keySet()) {
                List<OrgStudentCourse> orgStudentCourses = orgStudentCourseMapBycourseIds.get(courseId);
                stuTotalMap.put(courseId, orgStudentCourses.size());
            }
        }

        // 已安排课节数
        List<OrgClassLesson> orgClassLessons = this.orgClassLessonDao.getOrgClassLessonList(courseIds);
        List<Long> orgLessonIds = new ArrayList<>();
        // 课程和课节映射关系
        Map<Long, List<OrgClassLesson>> orgClassLessonListMap = new HashMap<>();
        // 课节id与课节映射关系
        Map<Long, OrgClassLesson> orgClassLessonMap = new HashMap<>();

        Set<Long> roomLessonIds = new HashSet<>();
        if (GenericsUtils.notNullAndEmpty(orgClassLessons)) {
            for (OrgClassLesson orgClassLesson : orgClassLessons) {
                Long courseId = orgClassLesson.getCourseId();
                List<OrgClassLesson> lessonList = orgClassLessonListMap.get(courseId);
                if (GenericsUtils.isNullOrEmpty(lessonList)) {
                    lessonList = new ArrayList<>();
                    orgClassLessonListMap.put(courseId, lessonList);
                }
                lessonList.add(orgClassLesson);
                Long lessonId = orgClassLesson.getId();
                orgClassLessonMap.put(lessonId, orgClassLesson);
                orgLessonIds.add(lessonId);
                Long roomId = orgClassLesson.getRoomId();
                if (GenericsUtils.notNullAndEmpty(roomId)) {
                    roomLessonIds.add(roomId);
                }
            }

        }

        // 获取每个机构课程详细信息和机构班级信息
        List<OrgCourseDetailDto> orgCourseDetailDtos = new ArrayList<>();
        for (Long courseId : courseIds) {
            OrgCourse orgCourse = orgCourseMap.get(courseId);
            OrgCourseDetailDto orgCourseDetailDto = OrgCourseDetailDto.buildOrgCourseDetailDtoByOrgCourse(orgCourse);
            // 老师姓名
            String teacherNames = null;
            List<Long> teacherUserIdList = teacherUserIdsMap.get(courseId);
            if (GenericsUtils.notNullAndEmpty(teacherUserIdList)) {
                StringBuffer names = new StringBuffer();
                for (Long teacherId : teacherUserIdList) {
                    String teacherName = teacherNameMap.get(teacherId);
                    names.append(teacherName == null ? "" : teacherName);
                }
                teacherNames = names.toString();
            }
            orgCourseDetailDto.setTeacherNames(teacherNames == null ? "" : teacherNames);

            // 学生人数
            Integer studentTotal = stuTotalMap.get(courseId);
            orgCourseDetailDto.setStudentCount(studentTotal == null ? 0 : studentTotal);

            // 安排课节数
            Integer arrangeLessonTotal = null;
            List<OrgClassLesson> lessonList = orgClassLessonListMap.get(courseId);
            if (GenericsUtils.notNullAndEmpty(lessonList)) {
                arrangeLessonTotal = lessonList.size();
            }
            orgCourseDetailDto.setLessonCount(arrangeLessonTotal == null ? 0 : arrangeLessonTotal);

            // 教室
            Long roomId = orgCourse.getRoomId();
            String roomName = null;
            OrgClassRoom orgClassRoom = orgClassRoomMap.get(roomId);
            if (GenericsUtils.notNullAndEmpty(orgClassRoom)) {
                roomName = orgClassRoom.getRoomName();
            }
            orgCourseDetailDto.setRoomNames(roomName == null ? "" : roomName);

            orgCourseDetailDtos.add(orgCourseDetailDto);

        }

        // 课节详细信息
        if (GenericsUtils.notNullAndEmpty(orgClassLessons)) {
            // 获取课节与学生对应关系
            Map<Long, OrgClassRoom> orgClassRoomMapOfLesson = new HashMap<>();

            Map<Long, List<Long>> studentUserIdLessonMap = this.orgStudentLessonDao.getLessonStudentList(orgLessonIds);
            // 获取教室信息
            List<OrgClassRoom> orgClassRooms = this.OrgClassRoomDao.getOrgClassRoomListByRoomIds(roomLessonIds);
            for (OrgClassRoom orgClassRoom : orgClassRooms) {
                Long roomId = orgClassRoom.getId();
                orgClassRoomMapOfLesson.put(roomId, orgClassRoom);
            }

            // 获取老师姓名
            Map<Long, OrgTeacherLesson> orgTeacherLessonMap =
                    this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(orgLessonIds);
            Set<Long> userIdsofTeacher = new HashSet<>();
            for (Long lessonId : orgTeacherLessonMap.keySet()) {
                OrgTeacherLesson orgTeacherLesson = orgTeacherLessonMap.get(lessonId);
                Long userId = orgTeacherLesson.getTeacherId();
                userIdsofTeacher.add(userId);
            }

            Map<Long, String> teacherNameMapOfLesson = new HashMap<>();
            teacherNameMapOfLesson = this.teacherDao.getTeacherRealNameMap(userIdsofTeacher);

            final List<Map<String, String>> rows = new ArrayList<>();
            for (OrgClassLesson orgClassLesson : orgClassLessons) {
                Long lessonId = orgClassLesson.getId();
                List<Long> studentUserIds = studentUserIdLessonMap.get(lessonId);
                Integer studentTotal = null;
                if (GenericsUtils.notNullAndEmpty(studentUserIds)) {
                    studentTotal = studentUserIds.size();
                }
                Long roomId = orgClassLesson.getRoomId();
                String roomName = null;
                OrgClassRoom orgClassRoom = orgClassRoomMapOfLesson.get(roomId);
                if (GenericsUtils.notNullAndEmpty(orgClassRoom)) {
                    roomName = orgClassRoom.getRoomName();
                }

                String teacherName = null;
                OrgTeacherLesson orgTeacherLesson = orgTeacherLessonMap.get(lessonId);
                if (GenericsUtils.notNullAndEmpty(orgTeacherLesson)) {
                    Long teacherUserId = orgTeacherLesson.getTeacherId();
                    teacherName = teacherNameMapOfLesson.get(teacherUserId);
                }

                Long courseId = orgClassLesson.getCourseId();
                OrgCourse orgCourse = orgCourseMap.get(courseId);
                String courseName = orgCourse.getName();

                ClassLessonDetailDto classLessonDetailDto = ClassLessonDetailDto
                        .buildClassLessonDetailDto(orgClassLesson, studentTotal, roomName, teacherName, courseName);
                Map<String, String> rowMap = new LinkedHashMap<>();
                rowMap.put("课节id", classLessonDetailDto.getLessonId() + "");
                rowMap.put("课程id", courseId + "");
                rowMap.put("所属班级", classLessonDetailDto.getCourseName());
                rowMap.put("课节号", classLessonDetailDto.getIndex() + "");
                rowMap.put("上课日期", classLessonDetailDto.getBeginDate() + "");
                rowMap.put("上课开始时间", classLessonDetailDto.getStart());
                rowMap.put("上课结束时间", classLessonDetailDto.getEnd());
                rowMap.put("老师", classLessonDetailDto.getTeacherName());
                rowMap.put("教室 ", classLessonDetailDto.getRoomName());
                rowMap.put("学员数", classLessonDetailDto.getStudentTotal() + "");
                rowMap.put("创建时间", classLessonDetailDto.getCreateTime() + "");
                rows.add(rowMap);
            }

            String subject = "课节详细信息";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "lessonDetailInfo";
            ExcelMailSender.sendMail(mail, subject, content, fileName, rows);

        }

        // 课程详细信息填充邮件Excel信息
        if (GenericsUtils.notNullAndEmpty(orgCourseDetailDtos)) {
            final List<Map<String, String>> rows = new ArrayList<>();
            for (OrgCourseDetailDto orgCourseDetailDto : orgCourseDetailDtos) {
                Map<String, String> rowMap = new LinkedHashMap<>();

                rowMap.put("课程id", orgCourseDetailDto.getOrgCourseId() + "");
                rowMap.put("课程名称", orgCourseDetailDto.getCourseName());
                rowMap.put("价格", orgCourseDetailDto.getPrice() + "");
                rowMap.put("上课次数", orgCourseDetailDto.getFreq() + "");
                rowMap.put("班级人数", orgCourseDetailDto.getMaxStudent() + "");
                rowMap.put("学生人数", orgCourseDetailDto.getStudentCount() + "");
                rowMap.put("添加时间", orgCourseDetailDto.getCreateTime() + "");
                rowMap.put("开课时间", orgCourseDetailDto.getStartTime() + "");
                rowMap.put("结束时间", orgCourseDetailDto.getEndTime() + "");
                rowMap.put("上课地址", orgCourseDetailDto.getCourseUrl());
                rowMap.put("课程介绍", orgCourseDetailDto.getIntroduction());
                rowMap.put("老师", orgCourseDetailDto.getTeacherNames());
                rowMap.put("课程状态", orgCourseDetailDto.getClassStatus());
                rowMap.put("机构number", orgCourseDetailDto.getOrgNumber() + "");
                rowMap.put("教室", orgCourseDetailDto.getRoomNames());
                rowMap.put("已安排课节数", orgCourseDetailDto.getLessonCount() + "");
                rows.add(rowMap);
            }

            String subject = "课程详细信息";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "classDetailInfo";
            ExcelMailSender.sendMail(mail, subject, content, fileName, rows);
        }

        // 机构老师信息
        List<OrgTeacher> orgTeachers = this.orgTeacherDao.getOrgTeacherListByOrgIds(orgIds);
        List<Integer> orgIdsOfInteger = new ArrayList<>();
        for (Long orgId : orgIds) {
            orgIdsOfInteger.add(orgId.intValue());
        }
        List<OrgInfo> orgInfos = this.orgInfoDao.getOrgInfos(orgIdsOfInteger);
        Map<Long, OrgInfo> orgInfoMap = new HashMap<>();
        for (OrgInfo orgInfo : orgInfos) {
            orgInfoMap.put(orgInfo.getOrgId().longValue(), orgInfo);
        }
        if (GenericsUtils.notNullAndEmpty(orgTeachers)) {
            final List<Map<String, String>> rows = new ArrayList<>();
            Set<Long> teachUserIds = new HashSet<>();
            Map<Long, OrgTeacher> orgTeacherMap = new HashMap<>();
            for (OrgTeacher orgTeacher : orgTeachers) {
                Long userId = orgTeacher.getUserId();
                teachUserIds.add(userId);
                orgTeacherMap.put(userId, orgTeacher);
            }
            List<Teacher> teachers = this.teacherDao.getByUserIds(teachUserIds);

            for (Teacher teacher : teachers) {
                Long orgId = teacher.getOrgId();
                OrgInfo orgInfo = orgInfoMap.get(orgId);
                String orgName = null;
                if (GenericsUtils.notNullAndEmpty(orgInfo)) {
                    orgName = orgInfo.getShortName();
                }
                Integer orgNumber = orgNumberMap.get(orgId);
                Map<String, String> rowMap = new LinkedHashMap<>();
                rowMap.put("老师id", teacher.getId() + "");
                rowMap.put("老师Number", teacher.getUserId() + "");
                rowMap.put("老师名称", teacher.getRealName());
                Long userId = teacher.getUserId();
                OrgTeacher orgTeacher = orgTeacherMap.get(userId);
                Integer status = orgTeacher.getStatus();
                rowMap.put("老师手机", orgTeacher.getMobile());
                rowMap.put("老师状态", TeacherStatus.getTeacherStatusByCode(status).getMessage());
                rowMap.put("机构名称", orgName + "");
                rowMap.put("机构number", orgNumber + "");

                rows.add(rowMap);

            }

            String subject = "机构老师详细信息";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "teacherDetailInfo";
            ExcelMailSender.sendMail(mail, subject, content, fileName, rows);

        }

    }

    @Override
    public void createExcelOfMsgRecordData() {
        // 正式天校机构number
        String filePath = "template/OrderOrgNumber.txt";
        List<Integer> tianXiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers(filePath);

        List<Long> orgIds = getTianxiaoOrgIds(tianXiaoOrgNumbers);

        List<Integer> orgIdsInteger = new ArrayList<>();

        for (Long orgId : orgIds) {
            orgIdsInteger.add(orgId.intValue());
        }

        Map<Integer, Long> orgNumberMap = this.orgAccountDao.batchSearchOrgIds(tianXiaoOrgNumbers);

        List<OrgInfo> orgInfos = this.orgInfoDao.getOrgInfos(orgIdsInteger);

        Map<Long, OrgInfo> orgInfoMap = new HashMap<>();
        for (OrgInfo orgInfo : orgInfos) {
            Long orgId = orgInfo.getOrgId().longValue();
            orgInfoMap.put(orgId, orgInfo);
        }

        List<MsgRecordDto> msgRecordDtos = this.messageDao.getMsgRecordDtoListByOrgIds(tianXiaoOrgNumbers);

        if (GenericsUtils.notNullAndEmpty(msgRecordDtos)) {
            final List<Map<String, String>> rows = new ArrayList<>();
            for (MsgRecordDto msgRecordDto : msgRecordDtos) {
                Map<String, String> rowMap = new LinkedHashMap<>();
                Integer orgNumber = msgRecordDto.getOrgNumber();
                Long orgId = orgNumberMap.get(orgNumber);
                String shortName = null; // 机构名臣
                OrgInfo orgInfo = orgInfoMap.get(orgId);
                if (GenericsUtils.notNullAndEmpty(orgInfo)) {
                    shortName = orgInfo.getShortName();
                }
                rowMap.put("机构number", orgNumber + "");
                rowMap.put("机构简称", shortName);
                rowMap.put("咨询用户id", msgRecordDto.getConsultId() + "");
                Integer consultRole = msgRecordDto.getConsultRole();
                rowMap.put("咨询用户类型", consultRole + "");
                Integer consultType = msgRecordDto.getConsultType();
                rowMap.put("信息来源", MessageSource.getByType(consultType).getDesc());
                Integer msgType = msgRecordDto.getMsgType();
                rowMap.put("消息类型", MsgType.getByType(msgType).getDesc());
                rowMap.put("咨询内容", msgRecordDto.getContent());
                rowMap.put("访问时间", msgRecordDto.getCreateTime() + "");
                rows.add(rowMap);
            }

            String subject = "咨询消息详细信息";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "msgRecordDetailInfo";
            ExcelMailSender.sendMail(mail, subject, content, fileName, rows);
        }

    }

    public List<Long> getOrgIdsByAccount(Integer accountType) {
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("TianxiaoOrgNumbers  are :{} ", TianxiaoOrgNumbers);
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        log.info("TianxiaoOrgIds are :{} ", TianxiaoOrgIds);
        // 获取机构类型
        Map<Long, TXAccount> txAccountMap = this.txAccountDao.getAccountTypeMap(TianxiaoOrgIds);

        // 判断机构类型 是否有主分校区
        List<OrgSubAccount> orgSubAccounts =
                this.orgSubAccountDao.getOrgSubAccountByOrgIds(TianxiaoOrgIds, OrgSubAccountStatus.NORMAL.getCode());

        // 子校区的主校区orgNumber与子校区orgId映射关系，主键是子帐号orgId,值是其对应主校区orgNumber
        Map<Long, List<Long>> orgSubIdsMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(orgSubAccounts)) {
            for (OrgSubAccount orgSubAccount : orgSubAccounts) {
                Integer pid = orgSubAccount.getPid();
                Long orgId = orgSubAccount.getOrgId().longValue();
                if (pid != OrgSubAccount.MASTER_PID) { // 说明pid是主账号，此时orgId是其分校区
                    List<Long> orgSubIds = orgSubIdsMap.get(pid.longValue());
                    if (GenericsUtils.isNullOrEmpty(orgSubIds)) {
                        orgSubIds = new ArrayList<>();
                        orgSubIdsMap.put(pid.longValue(), orgSubIds);
                    }
                    orgSubIds.add(orgId);
                }
            }
        }

        // 进行子校区类型填充
        if (GenericsUtils.notNullAndEmpty(orgSubIdsMap)) {
            for (Long mainOrgId : orgSubIdsMap.keySet()) {
                TXAccount account = txAccountMap.get(mainOrgId);
                if (GenericsUtils.notNullAndEmpty(account)) {
                    List<Long> subOrgIds = orgSubIdsMap.get(mainOrgId);
                    log.info("subOrgIds param:{}", subOrgIds);
                    for (Long subOrgId : subOrgIds) {
                        txAccountMap.put(subOrgId, account);
                    }
                }
            }
        }

        List<Long> orgIds = new ArrayList<>();
        for (Long orgId : txAccountMap.keySet()) {
            TXAccount account = txAccountMap.get(orgId);
            if (account.getAccountType() == accountType) {
                log.info("add orgId {} with show :{} ", orgId, account.getAccountType());
                orgIds.add(orgId);
            }
        }

        return orgIds;
    }

}
