/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.dto.CoursePurchaseDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年4月25日
 * @desc
 */
@Service
@Slf4j
public class ERPStatisticServiceImpl implements ERPStatisticService {
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseSmsDao orgCourseSmsDao;
    @Autowired
    private OrgLessonCommentDao OrgLessonCommentDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private OrgFinanceAccountService orgFinanceAccountService;

    @Override
    public Map<Long, ERPStatisticData> getERPDatas(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers,
        List<Long> TianxiaoOrgIds) {
        Map<Long, ERPStatisticData> ERPDataMap = new HashMap<>();

        // 微课
        Map<Integer, Integer> courseTotals =
            this.orgCourseDao.getCourseTotal(startTime, endTime, TianxiaoOrgNumbers, null, null, null); // Long
        // 对应的是机构namber
        if (GenericsUtils.notNullAndEmpty(courseTotals)) {
            List<Integer> orgNumbers = new ArrayList<>();
            for (Integer orgNumber : courseTotals.keySet()) {
                orgNumbers.add(orgNumber);
            }
            List<OrgAccount> orgAccounts = this.orgAccountDao.getAccountByNumbers(orgNumbers);
            for (OrgAccount orgAccount : orgAccounts) {
                Integer number = orgAccount.getNumber();
                Long orgId = orgAccount.getId().longValue();
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData.setCourseTotal(courseTotals.get(number) == null ? 0 : courseTotals.get(number));
            }
        }

        // 已排课班级总数
        Map<Long, Integer> arrangedClassTotals =
            this.orgClassLessonDao.getArrangedClassCount(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(arrangedClassTotals)) {
            for (Long orgId : arrangedClassTotals.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData
                    .setArrangedClassTotal(arrangedClassTotals.get(orgId) == null ? 0 : arrangedClassTotals.get(orgId));
            }
        }

        // 课节总数
        Map<Long, Integer> lessonTotals = this.orgClassLessonDao.getLessonTotal(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(lessonTotals)) {
            for (Long orgId : lessonTotals.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData.setLessonTotal(lessonTotals.get(orgId) == null ? 0 : lessonTotals.get(orgId));
            }
        }
        // 发课表
        Map<Long, Integer> courseSmsTotals = this.orgCourseSmsDao.courseSmsTotal(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(courseSmsTotals)) {
            for (Long orgId : courseSmsTotals.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData.setCourseSmsTotal(courseSmsTotals.get(orgId) == null ? 0 : courseSmsTotals.get(orgId));
            }
        }

        // 收款总额，收款笔数
        Map<Long, CoursePurchaseDto> incomeTotals =
            this.coursePurchaseDao.getIncomeTotal(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(incomeTotals)) {
            for (Long orgId : incomeTotals.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                CoursePurchaseDto coursePurchaseDto = incomeTotals.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                Integer count = coursePurchaseDto.getCount();
                Double payMoneySum = coursePurchaseDto.getPayMoneySum();
                erpStatisticData.setIncomeTotal(count == null ? 0 : count);
                erpStatisticData.setIncomeSum(payMoneySum == null ? 0 : payMoneySum);
            }
        }

        // 签到
        Map<Long, Integer> signLessonTotals =
            this.orgLessonSignDao.getOrgSignLessonTotal(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(signLessonTotals)) {
            for (Long orgId : signLessonTotals.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData
                    .setSignLessonTotal(signLessonTotals.get(orgId) == null ? 0 : signLessonTotals.get(orgId));
            }
        }

        Map<Long, Integer> signStudentTotals =
            this.orgLessonSignDao.getOrgSignStudentTotal(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(signStudentTotals)) {
            for (Long orgId : signStudentTotals.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData
                    .setSignStudentTotal(signStudentTotals.get(orgId) == null ? 0 : signStudentTotals.get(orgId));
            }
        }
        
        Map<Integer, OrgFinanceAccountDto> map = orgFinanceAccountService.getAccountInfos(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(map)) {
            for (Integer orgId : map.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId.longValue());
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId.longValue(), erpStatisticData);
                }
                OrgFinanceAccountDto ofadto = map.get(orgId);
                double d = ArithUtil.round(new Double(ofadto.getBalance()) + new Double(ofadto.getFreeze_money()), 2);
                erpStatisticData.setCashPurchaseSum(d);
            }
        }

        // 评价
        Map<Long, Integer> commentByStudents =
            this.OrgLessonCommentDao.getComment(2, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(commentByStudents)) {
            for (Long orgId : commentByStudents.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData
                    .setCommentByStudent(commentByStudents.get(orgId) == null ? 0 : commentByStudents.get(orgId));
            }
        }

        Map<Long, Integer> commentByTeachers =
            this.OrgLessonCommentDao.getComment(0, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(commentByTeachers)) {
            for (Long orgId : commentByTeachers.keySet()) {
                ERPStatisticData erpStatisticData = ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData);
                }
                erpStatisticData
                    .setCommentByTeacher(commentByTeachers.get(orgId) == null ? 0 : commentByTeachers.get(orgId));
            }
        }

        return ERPDataMap;
    }

}
