/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年4月24日
 * @desc
 */
@Service
public class ConsultMessageStatisticServiceImpl implements ConsultMessageStatisticService {
    @Autowired
    private MessageDao messageDao;

    @Override
    public Map<Long, ConsultMessageStatisticData> getConsultMessageData(Date startDate, Date endDate, 
        List<Long> TianxiaoOrgIds) {
        
        Map<Long, ConsultMessageStatisticData> consultMessageDatas = new HashMap<>();

        Map<Long, Integer> leaveBillCountMap =
            this.messageDao.getConsultCountByTypeAndOrgIds(startDate, endDate, MessageSource.APPOINTMENT.getValue(),
                TianxiaoOrgIds);
        Map<Long, Integer> wechatCountMap =
            this.messageDao.getConsultCountByTypeAndOrgIds(startDate, endDate, MessageSource.WECHAT.getValue(),
                TianxiaoOrgIds);
        Map<Long, Integer> callCountMap =
            this.messageDao.getConsultCountByTypeAndOrgIds(startDate, endDate, MessageSource.TELEPHONE.getValue(),
                TianxiaoOrgIds);
        //除去微信所有线索总数
        Map<Long, Integer> clueTotalCountMap = this.messageDao.getConsultTotalByOrgIds(startDate, endDate, TianxiaoOrgIds);

        for (Long orgId : leaveBillCountMap.keySet()) {
            ConsultMessageStatisticData consultMessage = consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            Integer leaveBillCount = leaveBillCountMap.get(orgId);
            consultMessage.setClueReserve(leaveBillCount == null ? 0 : leaveBillCount);
        }

        for (Long orgId  : wechatCountMap.keySet()) {
            ConsultMessageStatisticData consultMessage = consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            Integer wechatCount = wechatCountMap.get(orgId);
            consultMessage.setClueWechat(wechatCount == null ? 0 : wechatCount);
        }

        for (Long orgId : callCountMap.keySet()) {
            ConsultMessageStatisticData consultMessage = consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            Integer callCount = callCountMap.get(orgId);
            consultMessage.setClueCall(callCount == null ? 0 : callCount);
        }

        for (Long orgId : clueTotalCountMap.keySet()) {
            ConsultMessageStatisticData consultMessage = consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            Integer wechatTotal = wechatCountMap.get(orgId);
            if(GenericsUtils.isNullOrEmpty(wechatTotal)){
                wechatTotal = 0;
            }
            Integer clueTotal = clueTotalCountMap.get(orgId) + wechatTotal;
            consultMessage.setClueTotal(clueTotal);
        }
        return consultMessageDatas;
    }

}
