/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.dto;

import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年4月25日
 * @desc
 */
@Data
public class WechatStatisticData {
    private boolean isWechatAuthorizer; // 是否有微信公众号
    private boolean isWechatMenu; // 是否有公众号菜单
    private String serviceTypeDesc;   //公众号类型
    private int wechatFansTotal; /// 粉丝数
    
    private int wechatAuthorizerOfStudentTotal; // 绑定微信公众号学生数

    public void setIsWechatAuthorizer(boolean isWechatAuthorizer) {
        this.isWechatAuthorizer = isWechatAuthorizer;
    }

    public boolean getIsWechatAuthorizer() {
        return isWechatAuthorizer;
    }

    public void setIsWechatMenu(boolean isWechatMenu) {
        this.isWechatMenu = isWechatMenu;
    }

    public boolean getIsWechatMenu() {
        return isWechatMenu;
    }

    public static void buildExportDtoByWechatStatisticData(ExportDto exportDto,
        WechatStatisticData wechatStatisticData) {

        exportDto.setIsWechatAuthorizer(wechatStatisticData.getIsWechatAuthorizer());
        exportDto.setWechatFansTotal(wechatStatisticData.getWechatFansTotal());
        exportDto.setIsWechatMenu(wechatStatisticData.getIsWechatMenu());
        exportDto.setServiceTypeDesc(wechatStatisticData.getServiceTypeDesc());
        exportDto.setWechatAuthorizerOfStudentTotal(wechatStatisticData.getWechatAuthorizerOfStudentTotal());
    }

}
