/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.smsGroupSend.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.biz.marketing.dto.SmsSendResponse;
import com.baijia.tianxiao.biz.marketing.dto.StudentAndCourseListDto;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.BizSmsGroupSendService;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.TxMarktingSmsService;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao;
import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.CourseDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.RecordRespDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendRequest;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendResp;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.service.SmsGroupSendService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizSmsGroupSendServiceImpl
implements BizSmsGroupSendService {
    private static final Logger log = LoggerFactory.getLogger(BizSmsGroupSendServiceImpl.class);
    @Autowired
    private SmsGroupSendRecordDao smsGroupSendRecordDao;
    @Autowired
    private SmsGroupSendService smsGroupSendService;
    @Autowired
    private TxMarktingSmsService smsService;
    @Autowired
    private CourseStudentService courseStudentService;
    @Autowired
    private ErpCourseListService erpCourseListService;

    @Override
    public StudentAndCourseListDto searchStudentAndCourses(Long orgId, int type, String keyWord, PageDto pageDto) {
        StudentAndCourseListDto retData = new StudentAndCourseListDto();
        List<StudentDto> studentDtos = null;
        List<CourseDto> courseDtos = null;
        int totalStuCount = 0;
        int totalCourseCount = 0;
        if (type == 0 || type == 1) {
            List studentChooseList = this.courseStudentService.getStudentChooseList(orgId, Long.valueOf(-1L), keyWord, pageDto);
            studentDtos = this.buildStudetnDtos(studentChooseList);
            totalStuCount = pageDto.getCount();
        }
        if (type == 0 || type == 2) {
            CourseListRequestDto params = new CourseListRequestDto();
            params.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
            params.setSearchKey(keyWord);
            params.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
            List dtoList = this.erpCourseListService.getCourseList(orgId, null, null, params, pageDto, CourseListInfoDto.class);
            courseDtos = this.buildCourseDtos(dtoList);
            totalCourseCount = pageDto.getCount();
        }
        retData.setCourses(courseDtos);
        retData.setStudents(studentDtos);
        retData.setTotalStuCount(totalStuCount);
        retData.setTotalCourseCount(totalCourseCount);
        return retData;
    }

    private List<CourseDto> buildCourseDtos(List<CourseListInfoDto> dtoList) {
        if (GenericsUtils.isNullOrEmpty(dtoList)) {
            return GenericsUtils.emptyList();
        }
        ArrayList dtos = Lists.newArrayListWithExpectedSize((int)dtoList.size());
        for (CourseListInfoDto courseListInfoDto : dtoList) {
            CourseDto dto = new CourseDto(courseListInfoDto.getCourseId(), courseListInfoDto.getCourseName(), courseListInfoDto.getStudentCount() == null ? 0 : courseListInfoDto.getStudentCount());
            dtos.add(dto);
        }
        return dtos;
    }

    private List<StudentDto> buildStudetnDtos(List<OrgStudentsChooseListDto> studentChooseList) {
        if (GenericsUtils.isNullOrEmpty(studentChooseList)) {
            return GenericsUtils.emptyList();
        }
        ArrayList dtos = Lists.newArrayListWithCapacity((int)studentChooseList.size());
        for (OrgStudentsChooseListDto stu : studentChooseList) {
            StudentDto dto = new StudentDto(stu.getStudentId(), stu.getName(), stu.getMobile(), stu.getAvatarUrl());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public SmsGroupSendResp sendAndSaveRecord(SmsGroupSendRequest request) {
        SmsGroupSendRecord searchRecordWithOrgId;
        String content = request.getContent();
        if (GenericsUtils.isNullOrEmpty((Object)content)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a");
        }
        SendStatus sendStatus = SendStatus.SEND_OK;
        Integer code = null;
        Long orgId = request.getOrgId();
        SmsGroupSendRecord record = null;
        if (request.getRecordId() != null && (searchRecordWithOrgId = this.smsGroupSendRecordDao.searchRecordWithOrgId(request.getRecordId(), orgId)) == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.INVALIDATE_CLIENTID, "\u975e\u6cd5\u8bbf\u95ee\u7fa4\u53d1\u8bb0\u5f55");
        }
        List studentDtos = this.smsGroupSendService.getAllStudents(request);
        if (GenericsUtils.isNullOrEmpty((Object)studentDtos)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u672a\u627e\u5230\u4efb\u4f55\u5b66\u5458");
        }
        record = request.buildPo(studentDtos);
        Timestamp sendTime = null;
        Integer leftSmsCount = this.smsService.leftSmsCount(orgId);
        if (leftSmsCount <= 0 || leftSmsCount < studentDtos.size() && leftSmsCount < RecordRespDto.system_limit) {
            log.info("orgId:{} has't enought smsCount to send messages , and record id  is : {} , limitCount is : {}  ", new Object[]{orgId, record.getId(), leftSmsCount});
            sendStatus = SendStatus.NOT_ENOUGHT_SMS;
            code = SendStatus.SEND_OK.getCode();
        } else {
            sendTime = new Timestamp(System.currentTimeMillis());
            SmsSendResponse sendSmsMessage = this.smsService.sendSmsMessage(orgId, studentDtos, content);
            if (sendSmsMessage.getResult() == SmsSendResult.FAILED) {
                sendStatus = SendStatus.SYSTEM_SEND_ERROR;
                record.setFailureReceiver(record.getAllReceiver());
                code = sendStatus.getCode();
            } else {
                record.setSendStatus(SendStatus.SEND_OK.code.intValue());
                record.setFailureReceiver(sendSmsMessage.getFailureIdsStr());
            }
            leftSmsCount = this.smsService.leftSmsCount(orgId);
        }
        record.setSendStatus(sendStatus.getCode().intValue());
        record.setSendTime(sendTime);
        this.smsGroupSendRecordDao.saveOrUpdate((Object)record, new String[0]);
        RecordRespDto resp = RecordRespDto.buildDto((Long)record.getId(), (int)record.getTotalCount(), (int)leftSmsCount, (int)sendStatus.getCode(), (Integer)code);
        return resp;
    }
}

