/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.wechat.constant.WechatAppServiceType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatStatisticServiceImpl
implements WechatStatisticService {
    private static final Logger log = LoggerFactory.getLogger(WechatStatisticServiceImpl.class);
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentDao OrgStudentDao;

    @Override
    public Map<Long, WechatStatisticData> getWechatStatisticData(Date startDate, Date endDate, List<Long> TianxiaoOrgIds, int way) {
        HashMap<Long, WechatStatisticData> wechatDatas = new HashMap<Long, WechatStatisticData>();
        List authorizerInfos = this.authorizerInfoDao.getAuthorizerInfosByOrgIds(TianxiaoOrgIds);
        List hasOrgWechatCustomMenuOfAppIds = this.orgWechatCustomMenuDao.OrgIdsHasWechatMenu();
        if (GenericsUtils.notNullAndEmpty((Object)authorizerInfos)) {
            ArrayList<String> appIds = new ArrayList<String>();
            for (Object authorizerInfo : authorizerInfos) {
                String appId = authorizerInfo.getAuthorizerAppId();
                appIds.add(appId);
            }
            Map fansTotals = this.fansDao.fansTotaByAppIds(appIds, startDate, endDate);
            for (AuthorizerInfo authorizerInfo : authorizerInfos) {
                Integer wechatFansTotal;
                String appId = authorizerInfo.getAuthorizerAppId();
                Long orgId = authorizerInfo.getOrgId().longValue();
                WechatStatisticData wechatData = (WechatStatisticData)wechatDatas.get(orgId);
                if (wechatData == null) {
                    wechatData = new WechatStatisticData();
                    wechatDatas.put(orgId, wechatData);
                }
                wechatData.setIsWechatAuthorizer(true);
                int serviceType = authorizerInfo.getServiceType();
                String serviceTypeDesc = null;
                serviceTypeDesc = serviceType == WechatAppServiceType.SERVICE_APP.getValue() ? "\u670d\u52a1\u53f7" : WechatAppServiceType.getNote((Integer)serviceType);
                wechatData.setServiceTypeDesc(serviceTypeDesc);
                if (hasOrgWechatCustomMenuOfAppIds.contains(appId)) {
                    wechatData.setIsWechatMenu(true);
                }
                wechatData.setWechatFansTotal((wechatFansTotal = (Integer)fansTotals.get(appId)) == null ? 0 : wechatFansTotal);
            }
        }
        Map studentsHasOrgWechat = new HashMap();
        if (way != 0) {
            studentsHasOrgWechat = this.OrgStudentDao.getOrgWechatAuthorizerOfStudentTotal(TianxiaoOrgIds);
        }
        if (GenericsUtils.notNullAndEmpty(studentsHasOrgWechat)) {
            for (Long orgId : studentsHasOrgWechat.keySet()) {
                WechatStatisticData wechatData = (WechatStatisticData)wechatDatas.get(orgId);
                if (wechatData == null) {
                    wechatData = new WechatStatisticData();
                    wechatDatas.put(orgId, wechatData);
                }
                Integer wechatAuthorizerOfStudentTotal = (Integer)studentsHasOrgWechat.get(orgId);
                log.info("\u673a\u6784=====" + orgId + "======\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u5b66\u751f============" + wechatAuthorizerOfStudentTotal);
                wechatData.setWechatAuthorizerOfStudentTotal(wechatAuthorizerOfStudentTotal);
            }
        }
        return wechatDatas;
    }
}

