/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.dto;

import com.baijia.tianxiao.biz.marketing.export.constant.CourseStatus;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.util.GenericsUtils;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgCourseDetailDto
extends CourseListReponseDto {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseDetailDto.class);
    private Date createTime;
    private Integer orgNumber;
    private String classStatus;

    public String getClassStatus() {
        return this.classStatus;
    }

    public void setClassStatus(String classStatus) {
        this.classStatus = classStatus;
    }

    public void setOrgNumber(Integer orgNumber) {
        this.orgNumber = orgNumber;
    }

    public Integer getOrgNumber() {
        return this.orgNumber;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public static OrgCourseDetailDto buildOrgCourseDetailDtoByOrgCourse(OrgCourse orgCourse) {
        OrgCourseDetailDto orgCourseDetailDto = new OrgCourseDetailDto();
        orgCourseDetailDto.setOrgCourseId(orgCourse.getId());
        orgCourseDetailDto.setCourseName(orgCourse.getName());
        orgCourseDetailDto.setPrice(orgCourse.getPrice());
        orgCourseDetailDto.setFreq(orgCourse.getFreq());
        orgCourseDetailDto.setMaxStudent(orgCourse.getMaxStudent());
        orgCourseDetailDto.setCreateTime(orgCourse.getCreateTime());
        orgCourseDetailDto.setStartTime(orgCourse.getBeginTime());
        orgCourseDetailDto.setEndTime(orgCourse.getEndTime());
        orgCourseDetailDto.setAddress(orgCourse.getAddress());
        orgCourseDetailDto.setOrgNumber(orgCourse.getOrgNumber().intValue());
        Blob introduction = orgCourse.getIntroduction();
        String contentIntro = null;
        if (GenericsUtils.notNullAndEmpty((Object)introduction)) {
            try {
                contentIntro = new String(introduction.getBytes(1L, (int)introduction.length()));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        orgCourseDetailDto.setIntroduction(contentIntro);
        Integer value = orgCourse.getStatus();
        String classStatus = null;
        if (value == 0) {
            classStatus = CourseStatus.ENROLLING.getMessage();
        }
        if (value == 1) {
            classStatus = CourseStatus.YIXIAJIA.getMessage();
        }
        orgCourseDetailDto.setClassStatus(classStatus);
        return orgCourseDetailDto;
    }
}

