/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.article.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.marketing.article.service.BizArticleService;
import com.baijia.tianxiao.biz.marketing.dto.OrgActivityInfos;
import com.baijia.tianxiao.dal.activity.dao.article.ArticleBaseInfoDao;
import com.baijia.tianxiao.dal.activity.dao.article.PicArticleDao;
import com.baijia.tianxiao.dal.activity.dao.article.PicArticleDetailDao;
import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.dal.activity.po.article.PicArticleDetailInfo;
import com.baijia.tianxiao.dal.activity.po.article.PicArticleInfo;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleBaseDto;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleDetailDto;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleMedia;
import com.baijia.tianxiao.sal.marketing.article.dto.PicArticleDetailListDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.utils.JsonUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.OrgUtils;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.BatchMsgService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaNewsDto;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaUploadResultDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizArticleServiceImpl
implements BizArticleService {
    private static final Logger log = LoggerFactory.getLogger(BizArticleServiceImpl.class);
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private BatchMsgService batchMsgService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private PicArticleDao picArticleDao;
    @Autowired
    private PicArticleDetailDao picArticleDetailDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired(required=false)
    private ArticleBaseInfoDao articleBaseInfoDao;

    @Override
    public List<MediaNewsDto> getMediaNews(Integer orgId, PageDto pageDto) {
        return this.mediaService.listPermanentMediaNews(orgId.intValue(), pageDto);
    }

    @Override
    public void sendMedia(Integer orgId, String mediaId) {
        this.batchMsgService.sendMediaNews(orgId, mediaId, null);
    }

    @Override
    public ArticleDetailDto getArticleInfo(String articleId, Long orgId) {
        ArticleDetail detail = this.articleBaseInfoDao.findArticleDetailById(articleId);
        if (GenericsUtils.isNullOrEmpty((Object)detail)) {
            return null;
        }
        ArticleDetailDto articleDetail = ArticleDetailDto.buildDto((ArticleDetail)detail);
        OrgActivityInfos orgActivityInfos = this.getOrgInfo(orgId);
        BeanUtils.copyProperties((Object)orgActivityInfos, (Object)articleDetail);
        return articleDetail;
    }

    public OrgActivityInfos getOrgInfo(Long orgId) {
        OrgActivityInfos orgActivityInfos = new OrgActivityInfos();
        OrgInfoSimpleDto orgInfoSimpleDto = null;
        try {
            orgInfoSimpleDto = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            log.error("[Article] Query OrgInfo Error.", (Throwable)e);
        }
        orgActivityInfos.setOrgName(orgInfoSimpleDto.getShortName());
        orgActivityInfos.setOrgLogo(orgInfoSimpleDto.getLogo());
        String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfoSimpleDto.getOrgNumber();
        orgActivityInfos.setOrgWeiPage(weiPage);
        AuthorizerInfo authorizationInfo = this.authorizerInfoDao.getByOrgId(orgInfoSimpleDto.getOrgId());
        if (authorizationInfo != null && StringUtils.isNotBlank((String)authorizationInfo.getQrcodeUrl())) {
            orgActivityInfos.setOrgQrCodeUrl(authorizationInfo.getQrcodeUrl());
        } else {
            orgActivityInfos.setOrgQrCodeUrl("");
        }
        String mQrCode = OrgUtils.getQrCodeUrl((String)String.valueOf(orgInfoSimpleDto.getOrgNumber()));
        if (!GenericsUtils.isNullOrEmpty((Object)mQrCode)) {
            orgActivityInfos.setOrgHomeQrCodeUrl(mQrCode);
        } else {
            orgActivityInfos.setOrgLogo("");
        }
        return orgActivityInfos;
    }

    @Override
    public PicArticleDetailListDto createPicArticle(long orgId, String picArticle) {
        PicArticleInfo picArticleInfo = new PicArticleInfo();
        picArticleInfo.setOrgId(Long.valueOf(orgId));
        picArticleInfo.setCreateTime(new Date());
        long picArticleId = this.picArticleDao.insertPicArticleInfo(picArticleInfo);
        List<PicArticleDetailInfo> picArticleDetailInfos = this.buildPicArticleDetailInfo(picArticleId, picArticle);
        ArrayList<ArticleBaseDto> baseDtos = new ArrayList<ArticleBaseDto>(picArticleDetailInfos.size());
        for (PicArticleDetailInfo picArticleDetailInfo : picArticleDetailInfos) {
            picArticleDetailInfo.setPicArticleId(Long.valueOf(picArticleId));
            ArticleBaseDto pad = ArticleBaseDto.buildArticleDtoByPicArticleDetailInfo((PicArticleDetailInfo)picArticleDetailInfo);
            baseDtos.add(pad);
        }
        this.picArticleDetailDao.batchInsertArticle(picArticleDetailInfos);
        List articleIds = CollectionUtils.extractList(baseDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, ArticleBaseDto>(){

            public String extract(ArticleBaseDto baseDto) {
                return baseDto.getArticleId();
            }
        });
        Map articleInfos = this.articleBaseInfoDao.findArticleBaseInfoListByIds(articleIds);
        ArrayList<ArticleMedia> medias = new ArrayList<ArticleMedia>(articleIds.size());
        OrgActivityInfos orgInfo = this.getOrgInfo(orgId);
        for (ArticleBaseDto dto : baseDtos) {
            ArticleDetail detail = (ArticleDetail)articleInfos.get(dto.getArticleId());
            String title = detail.getArticleTitle();
            dto.setTitle(title);
            String thumbNail = detail.getArticleImg();
            dto.setThumbNail(thumbNail);
            ArticleMedia media = ArticleMedia.getMediaByArticleInfo((ArticleDetail)detail);
            try {
                MediaUploadResultDto resultDto = this.mediaService.uploadPermanentMediaImage((int)orgId, thumbNail);
                media.setThumb_media_id(resultDto.getMediaId());
                medias.add(media);
            }
            catch (WechatException wechatException) {
                log.warn("[Article] Upload Wechat Image wechatException.{}", (Throwable)wechatException);
                throw wechatException;
            }
            catch (Exception e) {
                log.warn("[Article] Upload Wechat Image Error.{}", (Throwable)e);
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_API_RETURN_ERROR);
            }
        }
        PicArticleDetailListDto picArticleDetailListDto = new PicArticleDetailListDto();
        Gson gson = new Gson();
        try {
            String json = "{articles:" + gson.toJson(medias) + "}";
            MediaUploadResultDto resultDto = this.mediaService.uploadPermanentMediaNews((int)orgId, json);
            picArticleDetailListDto.setMediaId(resultDto.getMediaId());
            picArticleDetailListDto.setMediaType(5);
        }
        catch (WechatException wechatException) {
            log.warn("[Article] Upload Wechat News wechatException.{}", (Throwable)wechatException);
            throw wechatException;
        }
        catch (Exception e) {
            log.warn("[Article] Upload Wechat News Error.{}", (Throwable)e);
            throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_API_RETURN_ERROR);
        }
        picArticleDetailListDto.setNewsItem(picArticleDetailListDto.createArticleInfoListByBaseDtos(baseDtos));
        picArticleDetailListDto.setId(picArticleId);
        return picArticleDetailListDto;
    }

    private void addOrgInfo(ArticleDetail detail, OrgActivityInfos orgInfo) {
        String orgInfoDiv = "%s<div class='org-info'><div class='logo'><img src='%s' width='100%'></div><div class='qrcode'><img src='%s' width='100%'></div></div>";
        String content = detail.getContent();
        String orgLogo = orgInfo.getOrgLogo();
        String qrCodeUrl = GenericsUtils.notNullAndEmpty((Object)orgInfo.getOrgQrCodeUrl()) ? orgInfo.getOrgQrCodeUrl() : orgInfo.getOrgHomeQrCodeUrl();
        content = String.format(orgInfoDiv, content, orgLogo, qrCodeUrl);
        detail.setContent(content);
    }

    private List<PicArticleDetailInfo> buildPicArticleDetailInfo(Long picArticleId, String picArticle) {
        if (GenericsUtils.notNullAndEmpty((Object)picArticle)) {
            List picArticleDetailInfos = JsonUtil.buildOptions((String)picArticle, PicArticleDetailInfo.class);
            if (GenericsUtils.notNullAndEmpty((Object)picArticleId)) {
                for (PicArticleDetailInfo picArticleDetailInfo : picArticleDetailInfos) {
                    picArticleDetailInfo.setPicArticleId(picArticleId);
                }
            }
            return picArticleDetailInfos;
        }
        return Collections.emptyList();
    }
}

