
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.marketing.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

import javax.mail.Session;

import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Sep 27, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class SynchMailSender {

    private static String ip;

    static {
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            ip = " unknow ";
        }
    }

    public static final String SINGLE_INFO_FORMAT = "<font color='red'>频道:%s ------------ %s</font><br/>";
    private static final String SUCCESS_TEMPLATE = "Hi,xxx们,本次头条同步任务完成状态:%s,机器IP:%s具体详情为:<br/><br/>%s <br/>";
    private static final String FAILURE_TEMPLATE =
        "<font size='18' color='orange' >本次爬取任务失败了，具体原因正在排查,如果急的话请联系{余文浩:18270826271},见谅!</br>";

    public static void sendNotifyMail(Map<String, Integer> typeCounts) {
        if (GenericsUtils.isNullOrEmpty(typeCounts)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : typeCounts.entrySet()) {
            String key = entry.getKey();
            Integer count = entry.getValue();
            sb.append(String.format(SINGLE_INFO_FORMAT, key, count));
        }
        final String content = createContent(true, sb.toString());
        sendMail(content, "头条文件同步监控", "yuwenhao@baijiahulian.com");
    }

    public static void sendMail(String content, String subject, String...emails) {
        if (GenericsUtils.isNullOrEmpty(emails)) {
            log.info("can not send mail cause by not assign any email receiver ");
            return;
        }
        try {
            Mail mail = new Mail();
            String from = ConstantEnums.MAILBOX_FROM.value();
            String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
            String username = ConstantEnums.MAILBOX_USERNAME.value();
            String password = ConstantEnums.MAILBOX_PASSWORD.value();
            mail.setFrom(from);
            mail.setContent(content);
            for (String email : emails) {
                mail.addToAddress(email);
            }
            mail.setSubject(subject);
            Session session = null;
            if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                session = MailUtils.createSession(host, username, password);
            } else {
                session = MailUtils.createSession(host);
            }
            MailUtils.send(session, mail);
            log.info("send successful");
        } catch (Exception ex) {
            log.error("can not send email cause by {}", ex);
        }
    }

    /**
     * @param isOk
     * @return
     */
    private static String createContent(boolean isOk, String info) {
        String append = "";
        if (!isOk) {
            append = FAILURE_TEMPLATE;
        }
        String successRet = String.format(SUCCESS_TEMPLATE, isOk ? "成功" : "失败", ip, info, append);
        return successRet;
    }

}
