/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年6月4日
* @desc 
 */
public enum TeacherStatus {

    ADIVISOR(0, "邀约中"),
    
    HASSIGN(1, "已签约"),
    
    BREAKOFF(2, "已解约"),
    
    REFUSED(3, "已拒绝"),
    
    EXPIERD(4, "已过期"),
    
    UNDO(5, "已撤销");
    
    private int code;

    private String message;

    private TeacherStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }
    
    public String getMessage() {
        return message;
    }
    
    private static Map<Integer, TeacherStatus> map = new HashMap<>();
    
    static{
        for(TeacherStatus teacherStatus : TeacherStatus.values()){
           map.put(teacherStatus.getCode(), teacherStatus);
        }
    }
    
    public static TeacherStatus getTeacherStatusByCode(Integer code){
        TeacherStatus teacherStatus = map.get(code);
        return teacherStatus;
    }
    
}
