package com.baijia.tianxiao.biz.marketing.vote.service;

import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteCacheDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoRequest;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoResponse;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteRenderDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteResult;

/**
 * Created by liuxp on 16/2/20.
 */
public interface BizVoteService {

    /**
     * 渲染投票
     * 
     * @param activityId
     * @param wechatOpenId
     * @return
     */
    public VoteRenderDto renderVoteActivity(Long activityId, String wechatOpenId);

    /**
     * 投票
     * 
     * @param activityId
     * @param optionsId
     * @param wechatOpenId
     * @param userInfo
     * @return
     */
    public VoteResult vote(Long activityId, Long optionsId, String wechatOpenId, String userInfo, String targetOpenId);

    /**
     * 导出参与者
     *
     * @param request
     * @return
     */
    public TwoTuple<Integer, String> exportVoteResult(VoteInfoRequest request);

    /**
     * 添加投票
     * 
     * @param request
     * @param orgId
     * @return
     */
    public VoteInfoResponse addVote(VoteInfoRequest request, Long orgId);

    /**
     * 分享信息
     * 
     * @param activityId
     * @param orgId
     * @return
     */
    public ShareDto getShareInfo(Long activityId, Long orgId);

    /**
     * 删除投票活动
     */
    public void deleteVoteActivity(Long activityId, Long orgId);


}
