/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.utils;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.biz.marketing.export.dto.HagDownload;
import com.baijia.tianxiao.biz.marketing.export.dto.TianxiaoOrgNumber;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.util.GenericsUtils;

import com.google.common.collect.Maps;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月29日
* @desc 
 */
@Slf4j
public class HagTianxiaoOrgNumber {
    public static List<Integer> getOrgNumbers() {
        List<Integer> orgNumbers = new ArrayList<>();
        String numberStr = null;
        try{
            String url = Config.HAG_URL;
            String hagRecourceName = BIzConf.HAG_RESOURSE_TIANXIAO_TRIAL_ACCOUNT;
            HagDownload hagDto = getHagDownload(hagRecourceName, url);
            if(hagDto == null || GenericsUtils.isNullOrEmpty(hagDto.getData())){
                log.warn("[Hag] Org number is empty");
                return Collections.EMPTY_LIST;
            }
            log.info("hagDto.getData().size() =" + hagDto.getData().size());
            
            //获取测试orgNumber
//            List<String> orgTestNumbers = HagTianxiaoOrgNumber.getOrgTestNumbers();
//            log.info("testNumber size ===" + orgTestNumbers.size());
            for(int i = 0; i<hagDto.getData().size() ;i++){
                numberStr = ((String) hagDto.getData().get(i)).split("#")[0];
                  orgNumbers.add(Integer.parseInt(numberStr));
//                if(! orgTestNumbers.contains(numberStr)){
//                    try{
//                        orgNumbers.add(Integer.parseInt(numberStr));
//                    }catch(NumberFormatException e){
//                        log.warn("[Hag] NumberFormatException" + e.getMessage());
//                    }
//                }
            }
        }catch(Exception e){
            log.error("[Hag] Get org number.", e);
        }
        return orgNumbers;
    }
    
    /**
     * hag内部机构numbers
     * @return
     */
    public static List<Integer> getInternalOrgNumber(){
        List<Integer> internalOrgNumbers = new ArrayList<>();
        String url = Config.HAG_URL;
        String hagRecourceName = BIzConf.HAG_RECOURSE_TIANXIAO_INTERNAL;
        HagDownload hagDto = getHagDownload(hagRecourceName, url);
        String numberStr = null;
        for(int i = 0; i<hagDto.getData().size() ;i++){
            numberStr = ((String) hagDto.getData().get(i)).split("#")[0];
            try{
                internalOrgNumbers.add(Integer.parseInt(numberStr));
            }catch(NumberFormatException e){
                log.warn("[Hag] NumberFormatException" + e.getMessage());
            }
        
        }
        
        return internalOrgNumbers;
    }
    
    private static HagDownload getHagDownload(String hagRecourceName, String hagUrl){
        HagDownload hagDto = new HagDownload();
        try{
            Map<String, String> params = Maps.newHashMap();
            params.put("resource", hagRecourceName);
            log.info("[hag_url]" + hagUrl);
            String url = hagUrl;
            String response = HttpClientUtils.doPost(url, params);
            hagDto = JacksonUtil.str2Obj(response, HagDownload.class);
        }catch(Exception e){
            log.error("[Hag] Get org number.", e);
        }
        return hagDto;
    }
    
    /**
     * 根据文件绝对路径读取机构Number
     * @param filePath
     * @return
     */
    public static List<Integer> getOrgNumbers(String filePath){
        String path = TianxiaoOrgNumber.class.getResource("/").getPath();
        List<Integer> orgNumbers = new ArrayList<>();
        
        File file1 = new File(path + filePath);
        
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file1));
            String numberStr = "";
            while ((numberStr = br.readLine()) != null) {
                orgNumbers.add(Integer.parseInt(numberStr));
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return orgNumbers;
    }
    
    private  static List<String> getOrgTestNumbers(){
        String path = TianxiaoOrgNumber.class.getResource("/").getPath();
        List<String> orgTestNumbers = new ArrayList<>();
        File file1 = new File(path + "template/orgNumberTest.txt");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file1));
            String numberStr = "";
            while ((numberStr = br.readLine()) != null) {
                orgTestNumbers.add(numberStr);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return orgTestNumbers;
    }
    
    public static void main(String[] args) {
        HagTianxiaoOrgNumber.getOrgNumbers();
    }
    

}
