
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.marketing.utils;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 29, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class CompletionableExecutor {

    private static final ExecutorService executor = Executors.newFixedThreadPool(500);

    public static <T> List<T> executeTasks(Collection<? extends Callable<T>> tasks) {
        if (GenericsUtils.isNullOrEmpty(tasks)) {
            return GenericsUtils.emptyList();
        }
        CompletionService<T> completionService = new ExecutorCompletionService<>(executor);
        List<T> rets = Lists.newArrayListWithCapacity(tasks.size());
        for (Callable<T> task : tasks) {
            completionService.submit(task);
        }
        try {
            for (int t = 0, n = tasks.size(); t < n; t++) {
                Future<T> f = completionService.take();
                T retT = f.get();
                rets.add(retT);
            }
        } catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        } catch (Exception e) {
            log.error("cause error : {} ", e);
            throw new RuntimeException(e);
        }
        return rets;
    }

}
