/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月25日
 * @desc
 */
@Service
@Slf4j
public class CRMStatisticServiceImpl implements CRMStatisticService {
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public Map<Long, CRMStatisticData> getConsultUserSData(Date startDate, Date endDate,
        List<Long> TianxiaoOrgIds) {
        Map<Long, CRMStatisticData> crmStatisticDataMap = new HashMap<>();
        
        Map<Long, Integer> consultUserCountsMap =
            this.txConsultUserDao.getConsultUserTotal(startDate, endDate, TianxiaoOrgIds);
        //学员某阶段总数
        Map<Long, Integer> duringStudentCountsMap = this.orgStudentDao.getStudentTotal(startDate, endDate, TianxiaoOrgIds);
        
        //学员总数
        Map<Long, Integer> studentTotalMap = this.orgStudentDao.getStudentTotal(null, null, TianxiaoOrgIds);
        if(GenericsUtils.notNullAndEmpty(studentTotalMap)){
            for(Long orgId : studentTotalMap.keySet()){
                CRMStatisticData crmStatisticData = crmStatisticDataMap.get(orgId);
                if (crmStatisticData == null) {
                    crmStatisticData = new CRMStatisticData();
                    crmStatisticDataMap.put(orgId, crmStatisticData);
                }
                Integer studentTotal = studentTotalMap.get(orgId);
                crmStatisticData.setStudentTotal(studentTotal == null ? 0 : studentTotal);
            }
        }
        
        //获取在读学员总数
        Map<Long, Integer> studyingStudentTotalMap = this.orgStudentDao.getStudentTotalByStatus(TianxiaoOrgIds, StudentLessonStatus.STUDYING.getStatus());
        if(GenericsUtils.notNullAndEmpty(studyingStudentTotalMap)){
            for(Long orgId : studentTotalMap.keySet()){
                CRMStatisticData crmStatisticData = crmStatisticDataMap.get(orgId);
                if (crmStatisticData == null) {
                    crmStatisticData = new CRMStatisticData();
                    crmStatisticDataMap.put(orgId, crmStatisticData);
                }
                Integer studyStudentTotal = studyingStudentTotalMap.get(orgId);
                crmStatisticData.setStudyStudentTotal(studyStudentTotal == null ? 0 : studyStudentTotal);
            }
        }
        
        if(GenericsUtils.notNullAndEmpty(consultUserCountsMap)){
            for (Long orgId : consultUserCountsMap.keySet()) {
                CRMStatisticData crmStatisticData = crmStatisticDataMap.get(orgId);
                if (crmStatisticData == null) {
                    crmStatisticData = new CRMStatisticData();
                    crmStatisticDataMap.put(orgId, crmStatisticData);
                }
                Integer consultUserTotal = consultUserCountsMap.get(orgId);
                crmStatisticData.setConsultUserTotal(consultUserTotal == null ? 0 : consultUserTotal);
            }
        }

        for (Long orgId : duringStudentCountsMap.keySet()) {
            CRMStatisticData crmStatisticData = crmStatisticDataMap.get(orgId);
            if (crmStatisticData == null) {
                crmStatisticData = new CRMStatisticData();
                crmStatisticDataMap.put(orgId, crmStatisticData);
            }
            Integer increaseStudentTotal = duringStudentCountsMap.get(orgId);
            crmStatisticData.setIncrementStudentTotal(increaseStudentTotal == null ? 0 : increaseStudentTotal);
        }
        return crmStatisticDataMap;
    }
    
}
