/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.marketing.export.dto;

import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年4月25日
 * @desc
 */
@Data
public class ERPStatisticData {

    private int courseTotal; // 微课数

    private int arrangedClassTotal; // 排课数
    private int lessonTotal; // 课节数

    private int courseSmsTotal; // 课表数

    private double incomeSum; // 收入总额，课程收入总额
    private int incomeTotal; // 收入笔数，课程收入总笔数

    private int signLessonTotal; // 签到课节数
    private int signStudentTotal; // 签到学生数

    private double cashPurchaseSum; // 可提现，余额
    private double balanceSum;       //

    private int commentByStudent; // 学生评价
    private int commentByTeacher; // 老师评价

    private int teacherTotal; // 老师数
    private int roomTotal; // 教室数

    public static void buildExportDtoByERPStatisticData(ExportDto exportDto, ERPStatisticData erpStatisticData) {

        exportDto.setCourseTotal(erpStatisticData.getCourseTotal());
        exportDto.setArrangedClassTotal(erpStatisticData.getArrangedClassTotal());
        exportDto.setLessonTotal(erpStatisticData.getLessonTotal());
        exportDto.setCourseSmsTotal(erpStatisticData.getCourseSmsTotal());
        exportDto.setIncomeSum(erpStatisticData.getIncomeSum());
        exportDto.setIncomeTotal(erpStatisticData.getIncomeTotal());
        exportDto.setSignLessonTotal(erpStatisticData.getSignLessonTotal());
        exportDto.setSignStudentTotal(erpStatisticData.getSignStudentTotal());
        exportDto.setCashPurchaseSum(erpStatisticData.getCashPurchaseSum());
        exportDto.setCommentByStudent(erpStatisticData.getCommentByStudent());
        exportDto.setCommentByTeacher(erpStatisticData.getCommentByTeacher());
        exportDto.setTeacherTotal(erpStatisticData.getTeacherTotal());
        exportDto.setRoomTotal(erpStatisticData.getRoomTotal());
    }

}
