package com.baijia.tianxiao.biz.marketing.article.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.marketing.article.service.BizArticleService;
import com.baijia.tianxiao.biz.marketing.dto.OrgActivityInfos;
import com.baijia.tianxiao.dal.activity.dao.article.ArticleBaseInfoDao;
import com.baijia.tianxiao.dal.activity.dao.article.PicArticleDao;
import com.baijia.tianxiao.dal.activity.dao.article.PicArticleDetailDao;
import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.dal.activity.po.article.PicArticleDetailInfo;
import com.baijia.tianxiao.dal.activity.po.article.PicArticleInfo;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleBaseDto;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleDetailDto;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleMedia;
import com.baijia.tianxiao.sal.marketing.article.dto.PicArticleDetailListDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.marketing.commons.utils.JsonUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.OrgUtils;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.BatchMsgService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaNewsDto;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaUploadResultDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/4/7.
 */
@Service
@Slf4j
public class BizArticleServiceImpl implements BizArticleService {

    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private BatchMsgService batchMsgService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private PicArticleDao picArticleDao;
    @Autowired
    private PicArticleDetailDao picArticleDetailDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired(required = false)
    private ArticleBaseInfoDao articleBaseInfoDao;

    @Override
    public List<MediaNewsDto> getMediaNews(Integer orgId, PageDto pageDto) {
        return mediaService.listPermanentMediaNews(orgId, pageDto);
    }

    @Override
    public void sendMedia(Integer orgId, String mediaId) {
        batchMsgService.sendMediaNews(orgId, mediaId, null);
    }

    @Override
    public ArticleDetailDto getArticleInfo(String articleId, Long orgId) {
        ArticleDetail detail = this.articleBaseInfoDao.findArticleDetailById(articleId);
        if (GenericsUtils.isNullOrEmpty(detail)) {
            return null;
        }
        ArticleDetailDto articleDetail = ArticleDetailDto.buildDto(detail);
        //
        // OrgInfoSimpleDto orgInfoSimpleDto = null;
        // try {
        // orgInfoSimpleDto = this.orgInfoService.getOrgInfo(orgId);
        // } catch (Exception e) {
        // log.error("[Article] Query OrgInfo Error.", e);
        // }
        // articleDetail.setOrgInfo(orgInfoSimpleDto);
        //
        // // 微官网连接
        // String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfoSimpleDto.getOrgNumber();
        // articleDetail.setOrgWeiPage(weiPage);
        //
        // AuthorizerInfo authorizationInfo = authorizerInfoDao.getByOrgId(orgInfoSimpleDto.getOrgId());
        //
        // if (authorizationInfo != null && StringUtils.isNotBlank(authorizationInfo.getQrcodeUrl())) {
        // articleDetail.setOrgQrCodeUrl(authorizationInfo.getQrcodeUrl());
        // } else {
        // articleDetail.setOrgQrCodeUrl("");
        // }
        //
        // // 这里设置orgHomeUrl值的目的是 前段需要根据qrCode是否为空来判断是否弹出二维码
        // String mQrCode = OrgUtils.getQrCodeUrl(String.valueOf(orgInfoSimpleDto.getOrgNumber()));
        // if (!GenericsUtils.isNullOrEmpty(mQrCode)) {
        // articleDetail.setOrgHomeQrCodeUrl(mQrCode);
        // } else {
        // articleDetail.setOrgLogo("");
        // }

        OrgActivityInfos orgActivityInfos = this.getOrgInfo(orgId);
        BeanUtils.copyProperties(orgActivityInfos, articleDetail);

        return articleDetail;
    }

    public OrgActivityInfos getOrgInfo(Long orgId) {
        OrgActivityInfos orgActivityInfos = new OrgActivityInfos();
        OrgInfoSimpleDto orgInfoSimpleDto = null;
        try {
            orgInfoSimpleDto = this.orgInfoService.getOrgInfo(orgId);
        } catch (Exception e) {
            log.error("[Article] Query OrgInfo Error.", e);
        }
        orgActivityInfos.setOrgName(orgInfoSimpleDto.getShortName());
        orgActivityInfos.setOrgLogo(orgInfoSimpleDto.getLogo());
        // 微官网连接
        String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfoSimpleDto.getOrgNumber();
        orgActivityInfos.setOrgWeiPage(weiPage);
        AuthorizerInfo authorizationInfo = authorizerInfoDao.getByOrgId(orgInfoSimpleDto.getOrgId());
        if (authorizationInfo != null && StringUtils.isNotBlank(authorizationInfo.getQrcodeUrl())) {
            orgActivityInfos.setOrgQrCodeUrl(authorizationInfo.getQrcodeUrl());
        } else {
            orgActivityInfos.setOrgQrCodeUrl("");
        }
        // 这里设置orgHomeUrl值的目的是 前段需要根据qrCode是否为空来判断是否弹出二维码
        String mQrCode = OrgUtils.getQrCodeUrl(String.valueOf(orgInfoSimpleDto.getOrgNumber()));
        if (!GenericsUtils.isNullOrEmpty(mQrCode)) {
            orgActivityInfos.setOrgHomeQrCodeUrl(mQrCode);
        } else {
            orgActivityInfos.setOrgLogo("");
        }
        return orgActivityInfos;
    }

    @Override
    public PicArticleDetailListDto createPicArticle(long orgId, String picArticle) {
        PicArticleInfo picArticleInfo = new PicArticleInfo();
        picArticleInfo.setOrgId(orgId);
        picArticleInfo.setCreateTime(new Date());
        long picArticleId = this.picArticleDao.insertPicArticleInfo(picArticleInfo);

        List<PicArticleDetailInfo> picArticleDetailInfos = buildPicArticleDetailInfo(picArticleId, picArticle);
        List<ArticleBaseDto> baseDtos = new ArrayList<>(picArticleDetailInfos.size());
        for (PicArticleDetailInfo picArticleDetailInfo : picArticleDetailInfos) {
            picArticleDetailInfo.setPicArticleId(picArticleId);
            ArticleBaseDto pad = ArticleBaseDto.buildArticleDtoByPicArticleDetailInfo(picArticleDetailInfo);
            baseDtos.add(pad);
        }
        picArticleDetailDao.batchInsertArticle(picArticleDetailInfos);

        List<String> articleIds =
            CollectionUtils.extractList(baseDtos, new CollectionUtils.Extracter<String, ArticleBaseDto>() {
                @Override
                public String extract(ArticleBaseDto baseDto) {
                    return baseDto.getArticleId();
                }
            });

        Map<String, ArticleDetail> articleInfos = this.articleBaseInfoDao.findArticleBaseInfoListByIds(articleIds);

        List<ArticleMedia> medias = new ArrayList<>(articleIds.size());

        OrgActivityInfos orgInfo = this.getOrgInfo(orgId);

        for (ArticleBaseDto dto : baseDtos) {
            ArticleDetail detail = articleInfos.get(dto.getArticleId());
            String title = detail.getArticleTitle();
            dto.setTitle(title);
            String thumbNail = detail.getArticleImg();
            dto.setThumbNail(thumbNail);
//            addOrgInfo(detail, orgInfo);
            ArticleMedia media = ArticleMedia.getMediaByArticleInfo(detail);
            try {
                MediaUploadResultDto resultDto = mediaService.uploadPermanentMediaImage((int) orgId, thumbNail);
                media.setThumb_media_id(resultDto.getMediaId());
                medias.add(media);
            } catch (WechatException wechatException){
                log.warn("[Article] Upload Wechat Image wechatException.{}", wechatException);
                throw wechatException;
            } catch (Exception e) {
                log.warn("[Article] Upload Wechat Image Error.{}", e);
                throw new WechatException(SalWechatErrorCode.WECHAT_API_RETURN_ERROR);
            }
        }

        PicArticleDetailListDto picArticleDetailListDto = new PicArticleDetailListDto();
        Gson gson = new Gson();
        try {
            String json = "{articles:" + gson.toJson(medias) + "}";
            MediaUploadResultDto resultDto = mediaService.uploadPermanentMediaNews((int) orgId, json);
            picArticleDetailListDto.setMediaId(resultDto.getMediaId());
            picArticleDetailListDto.setMediaType(5);
        } catch (WechatException wechatException){
            log.warn("[Article] Upload Wechat News wechatException.{}", wechatException);
            throw wechatException;
        } catch (Exception e) {
            log.warn("[Article] Upload Wechat News Error.{}", e);
            throw new WechatException(SalWechatErrorCode.WECHAT_API_RETURN_ERROR);
        }
        picArticleDetailListDto.setNewsItem(picArticleDetailListDto.createArticleInfoListByBaseDtos(baseDtos));
        picArticleDetailListDto.setId(picArticleId);
        return picArticleDetailListDto;
    }

    /**
     * @param detail
     * @desc 添加机构头像以及二维码信息
     */
    private void addOrgInfo(ArticleDetail detail, OrgActivityInfos orgInfo) {
        String orgInfoDiv =
            "%s<div class='org-info'><div class='logo'><img src='%s' width='100%'></div><div class='qrcode'><img src='%s' width='100%'></div></div>";
        String content = detail.getContent();
        String orgLogo = orgInfo.getOrgLogo();
        String qrCodeUrl = GenericsUtils.notNullAndEmpty(orgInfo.getOrgQrCodeUrl()) ? orgInfo.getOrgQrCodeUrl()
            : orgInfo.getOrgHomeQrCodeUrl();
        content = String.format(orgInfoDiv, content, orgLogo, qrCodeUrl);
        detail.setContent(content);
    }

    private List<PicArticleDetailInfo> buildPicArticleDetailInfo(Long picArticleId, String picArticle) {
        if (GenericsUtils.notNullAndEmpty(picArticle)) {
            List<PicArticleDetailInfo> picArticleDetailInfos =
                JsonUtil.buildOptions(picArticle, PicArticleDetailInfo.class);
            if (GenericsUtils.notNullAndEmpty(picArticleId)) {
                for (PicArticleDetailInfo picArticleDetailInfo : picArticleDetailInfos) {
                    picArticleDetailInfo.setPicArticleId(picArticleId);
                }
            }
            return picArticleDetailInfos;
        } else {
            return Collections.emptyList();
        }
    }
}
