/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.constant.AccountTypeEnum;
import com.baijia.tianxiao.biz.marketing.export.constant.CompusType;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgTypeDto;
import com.baijia.tianxiao.biz.marketing.export.service.OrgTypeService;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTypeServiceImpl
implements OrgTypeService {
    private static final Logger log = LoggerFactory.getLogger(OrgTypeServiceImpl.class);
    @Autowired
    OrgAccountDao orgAccountDao;
    @Autowired
    TXAccountDao txAccountDao;
    @Autowired
    OrgSubAccountDao orgSubAccountDao;

    @Override
    public Map<Long, OrgTypeDto> getOrgTypeDtoMap(List<Long> TianxiaoOrgIds) {
        TXAccount account;
        HashMap<Long, OrgTypeDto> orgTypeDtoMap = new HashMap<Long, OrgTypeDto>();
        Map orgIdMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        Map txAccountMap = this.txAccountDao.getAccountTypeMap(TianxiaoOrgIds);
        List orgSubAccounts = this.orgSubAccountDao.getOrgSubAccountByOrgIds(TianxiaoOrgIds, OrgSubAccountStatus.NORMAL.getCode());
        HashMap<Long, Integer> mainOrgNumberMap = new HashMap<Long, Integer>();
        HashMap<Long, ArrayList<Long>> orgSubIdsMap = new HashMap<Long, ArrayList<Long>>();
        if (GenericsUtils.notNullAndEmpty((Object)orgSubAccounts)) {
            for (OrgSubAccount orgSubAccount : orgSubAccounts) {
                Integer pid = orgSubAccount.getPid();
                Long orgId = orgSubAccount.getOrgId().longValue();
                if (pid != 0) {
                    ArrayList<Long> orgSubIds = (ArrayList<Long>)orgSubIdsMap.get(pid.longValue());
                    if (GenericsUtils.isNullOrEmpty((Object)orgSubIds)) {
                        orgSubIds = new ArrayList<Long>();
                        orgSubIdsMap.put(pid.longValue(), orgSubIds);
                    }
                    orgSubIds.add(orgId);
                    Integer mainOrgNumber = (Integer)orgIdMap.get(pid.longValue());
                    mainOrgNumberMap.put(orgId, mainOrgNumber);
                }
                int compusType = orgSubAccount.getAccountType();
                OrgTypeDto orgTypeDto = (OrgTypeDto)orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                String compusTypeDesc = null;
                compusTypeDesc = compusType == 0 ? "" : CompusType.getCompusTypeByCode(compusType).getMessage();
                orgTypeDto.setCompusTypeDesc(compusTypeDesc);
            }
        }
        if (GenericsUtils.notNullAndEmpty(orgSubIdsMap)) {
            for (Long mainOrgId : orgSubIdsMap.keySet()) {
                account = (TXAccount)txAccountMap.get(mainOrgId);
                if (!GenericsUtils.notNullAndEmpty((Object)account)) continue;
                List subOrgIds = (List)orgSubIdsMap.get(mainOrgId);
                for (Long subOrgId : subOrgIds) {
                    txAccountMap.put(subOrgId, account);
                }
            }
            log.info("\u586b\u5145\u540etxAccountTypeMap param:{}", (Object)txAccountMap.size());
        }
        for (Long orgId : txAccountMap.keySet()) {
            account = (TXAccount)txAccountMap.get(orgId);
            String accountTypeDesc = AccountTypeEnum.getAccountTypeEnumByCode(account.getAccountType()).getLabel();
            OrgTypeDto orgTypeDto = (OrgTypeDto)orgTypeDtoMap.get(orgId);
            if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto)) {
                orgTypeDto = new OrgTypeDto();
                orgTypeDtoMap.put(orgId, orgTypeDto);
            }
            TXAccountType accountTypeEumn = null;
            if (account.getVipLevel() != TXAccountType.ERROR_TYPE.getCode()) {
                accountTypeEumn = TXAccountType.getTXAccountTypeByCode((Integer)account.getVipLevel());
            }
            if (accountTypeEumn != null) {
                orgTypeDto.setOrgVipLevelStr(accountTypeEumn.getLabel());
            } else {
                orgTypeDto.setOrgVipLevelStr("");
            }
            orgTypeDto.setAccountType(account.getAccountType());
            orgTypeDto.setAccountTypeDesc(accountTypeDesc);
        }
        for (Long orgId : mainOrgNumberMap.keySet()) {
            Integer subOrgNumber = (Integer)mainOrgNumberMap.get(orgId);
            OrgTypeDto orgTypeDto = (OrgTypeDto)orgTypeDtoMap.get(orgId);
            if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto)) {
                orgTypeDto = new OrgTypeDto();
                orgTypeDtoMap.put(orgId, orgTypeDto);
            }
            orgTypeDto.setSubOrgNumber(subOrgNumber);
        }
        return orgTypeDtoMap;
    }
}

