/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.smsGroupSend.service.impl;

import com.baijia.tianxiao.biz.marketing.dto.SmsSendResponse;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.RedissonService;
import com.baijia.tianxiao.biz.marketing.smsGroupSend.service.TxMarktingSmsService;
import com.baijia.tianxiao.biz.marketing.utils.CompletionableExecutor;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsAccountDao;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsAccount;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.commons.utils.SmsUtils;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.RecordRespDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxMarktingSmsServiceImpl
implements TxMarktingSmsService {
    private static final Logger log = LoggerFactory.getLogger(TxMarktingSmsServiceImpl.class);
    public static final Long LOCK_TIMEOUT = 60000L;
    @Autowired
    private SmsAccountDao smsAccountDao;
    @Autowired(required=false)
    private RedissonService redissonService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TXAccountService txAccountService;
    public static final String OWN_LOCK = "lockValue";
    public static final String LOCK_FORMAT = "lock:smsSend:%s";
    public static final String MOBILE_RESULT = "%s:%s";
    public static final String SMS_CONTENT_FORMAT = "[\u901a\u77e5]   %s %s \u56det\u9000\u8ba2\u3010\u5929\u6821\u3011";

    @Override
    public Integer leftSmsCount(Long orgId) {
        Timestamp dataMonth = SmsAccount.createDataMonth();
        SmsAccount smsAccountInfo = this.smsAccountDao.getSmsAccountInfo(orgId, dataMonth);
        if (smsAccountInfo == null) {
            return RecordRespDto.system_limit;
        }
        return smsAccountInfo.getCountLimit() - smsAccountInfo.getTotalCount();
    }

    @Override
    public SmsSendResponse sendSmsMessage(Long orgId, Collection<StudentDto> studentDtos, String content) {
        ArrayList failureIds;
        List<String> executeTasks;
        ArrayList callableTasks;
        HashMap mobileStudentIdMaps;
        int totalSucc;
        int countOfSms;
        block14: {
            if (GenericsUtils.isNullOrEmpty((Object)content) || GenericsUtils.isNullOrEmpty(studentDtos)) {
                return SmsSendResponse.newInstance(SmsSendResult.FAILED, 0);
            }
            countOfSms = SmsUtils.countContentSimple((String)content);
            totalSucc = 0;
            mobileStudentIdMaps = Maps.newHashMap();
            for (StudentDto dto : studentDtos) {
                String mobile = dto.getMobile();
                Object list = (List)mobileStudentIdMaps.get(mobile);
                if (GenericsUtils.isNullOrEmpty((Object)list)) {
                    list = Lists.newArrayList();
                    mobileStudentIdMaps.put(mobile, list);
                }
                list.add(dto.getId());
            }
            String branchSchoolName = this.getOrgName(orgId);
            Set mobiles = mobileStudentIdMaps.keySet();
            callableTasks = Lists.newArrayListWithCapacity((int)studentDtos.size());
            for (String mobile : mobiles) {
                callableTasks.add(new CallableTask(orgId, mobile, content, branchSchoolName, this.txAccountService.getTxAccountSmsGate(Integer.valueOf(orgId.intValue()))));
            }
            executeTasks = null;
            failureIds = Lists.newArrayList();
            Integer leftSmsCount = this.leftSmsCount(orgId);
            if (leftSmsCount > 0 && (leftSmsCount >= mobiles.size() || leftSmsCount >= RecordRespDto.system_limit)) break block14;
            SmsSendResponse smsSendResponse = SmsSendResponse.newInstance(SmsSendResult.FAILED, 0);
            return smsSendResponse;
        }
        try {
            executeTasks = CompletionableExecutor.executeTasks(callableTasks);
            for (String retInfo : executeTasks) {
                String[] retInfos = retInfo.split(":");
                String mobile = retInfos[0];
                Boolean isOk = Boolean.parseBoolean(retInfos[1]);
                if (isOk.booleanValue()) {
                    ++totalSucc;
                    continue;
                }
                failureIds.addAll((Collection)mobileStudentIdMaps.get(mobile));
                log.info("mobile :{} ,and with this mobile has student's count:{}", (Object)mobile, (Object)((List)mobileStudentIdMaps.get(mobile)).size());
            }
            SmsAccount smsAccountInfo = this.smsAccountDao.getSmsAccountInfo(orgId, SmsAccount.createDataMonth());
            if (smsAccountInfo == null) {
                smsAccountInfo = SmsAccount.newInstance((Long)orgId);
            }
            smsAccountInfo.setCountLimit(Integer.valueOf(RecordRespDto.system_limit));
            smsAccountInfo.setTotalCount(smsAccountInfo.getTotalCount() + totalSucc * countOfSms);
            log.info("saveOrUpdate smsAccount : {} ", (Object)smsAccountInfo);
            this.smsAccountDao.saveOrUpdate((Object)smsAccountInfo, new String[0]);
        }
        catch (Exception e) {
            log.error("error while send messages ", (Throwable)e);
            throw new RuntimeException("error ,and will tracaction roll-back");
        }
        mobileStudentIdMaps.clear();
        SmsSendResponse resp = SmsSendResponse.newInstance(SmsSendResult.FAILED, totalSucc);
        if (totalSucc != 0) {
            resp.setResult(SmsSendResult.SUCCESS);
            resp.setFailureIds(failureIds);
        } else {
            resp.setFailureIds(null);
            log.info("totalSendSucc is 0 ");
        }
        log.info("smsSendResponse is : {} ", (Object)resp);
        return resp;
    }

    private String getOrgName(Long orgId) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"name", "shortName"});
        if (orgInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NO_LOGIN, "\u5f53\u524d\u673a\u6784\u672a\u767b\u5f55\u6216\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String name = orgInfo.getName();
        name = GenericsUtils.isNullOrEmpty((Object)name) ? orgInfo.getShortName() : name;
        return name;
    }

    private RLock getLock(Long orgId) {
        String lockKey = this.createLockKey(orgId);
        RedissonClient client = this.redissonService.getClient();
        RLock lock = client.getLock(lockKey);
        return lock;
    }

    private String createLockKey(Long orgId) {
        return String.format(LOCK_FORMAT, orgId);
    }

    static class CallableTask
    implements Callable<String> {
        private String mobile;
        private String content;
        private Long orgId;
        private Integer smsGate;

        public CallableTask(Long orgId, String mobile, String content, String branchSchoolName, Integer smsGate) {
            this.orgId = orgId;
            this.mobile = mobile;
            this.content = String.format(TxMarktingSmsServiceImpl.SMS_CONTENT_FORMAT, content, branchSchoolName);
            this.smsGate = smsGate;
        }

        @Override
        public String call() throws Exception {
            boolean isOk = false;
            try {
                isOk = SmsSendUtil.sendSms((String)this.mobile, (String)this.content, (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)this.orgId.intValue(), (Integer)UserRole.ORGANIZATION.getRole(), (Integer)this.smsGate);
            }
            catch (Exception e) {
                log.error("can not send sms to mobile : {} cause by : {} ", (Object)this.mobile, (Object)e);
            }
            return String.format(TxMarktingSmsServiceImpl.MOBILE_RESULT, this.mobile, isOk);
        }
    }
}

