/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.vote.service.impl;

import com.baijia.tianxiao.biz.marketing.utils.PictureUtil;
import com.baijia.tianxiao.biz.marketing.vote.service.BizVoteService;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.DeleteStatus;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.WechatException;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.utils.ActivityMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.enums.DrawCode;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteCacheDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoRequest;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoResponse;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteRenderDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteResult;
import com.baijia.tianxiao.sal.marketing.vote.enums.VotedCode;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteOptionService;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteService;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteStatisticsService;
import com.baijia.tianxiao.sal.marketing.vote.utils.VoteOptionUtil;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizVoteServiceImpl
implements BizVoteService {
    private static final Logger log = LoggerFactory.getLogger(BizVoteServiceImpl.class);
    @Autowired
    private VoteService voteService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private VoteStatisticsService voteStatisticsService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private FansService fansService;
    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private VoteOptionService optionService;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private VoteOptionDao optionDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private TemplateDao templateDao;

    @Override
    @Transactional(value="yunyingTransactionManager")
    public VoteInfoResponse addVote(VoteInfoRequest request, Long orgId) {
        VoteInfo info = request.getVoteInfo();
        info.setTemplateTypeId(Integer.valueOf(201));
        info.setStatus(Integer.valueOf(1));
        info.setOrgId(orgId);
        this.voteInfoDao.insertVoteActivity(info);
        List optionList = VoteOptionUtil.parseOptionList((VoteInfoRequest)request);
        if (optionList != null) {
            HashMap<String, Integer> doubleCheck = new HashMap<String, Integer>();
            for (VoteOption option : optionList) {
                String name = option.getName();
                if (doubleCheck.get(name) == null) {
                    doubleCheck.put(name, 1);
                } else {
                    doubleCheck.put(name, (Integer)doubleCheck.get(name) + 1);
                }
                option.setActivityId(info.getActivityId());
                option.setStatus(Integer.valueOf(1));
            }
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry entry : doubleCheck.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                sb.append((String)entry.getKey()).append(",");
            }
            if (GenericsUtils.notNullAndEmpty((Object)sb.toString().trim())) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(" are repeat");
                BussinessException doublNames = new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, sb.toString());
                throw doublNames;
            }
        }
        this.templateDao.updateTemplateUseCount(Long.valueOf(request.getTemplateId().longValue()));
        try {
            log.info("[Param]=" + ToStringBuilder.reflectionToString((Object)request));
            CustomActivityDto wechat = this.customActivityService.createCustomActivityForReplace(request.getReplaceOrgId().intValue(), orgId.intValue(), info.getActivityId().intValue(), request.getTemplateId().intValue(), request.getName(), "\u70b9\u51fb\u53c2\u4e0e\u3002", ConstantEnums.VOTE_TOP_IMG_URL.value());
            if (wechat == null) {
                throw new RuntimeException("\u521b\u5efa\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.warn("[Vote] create error.{}", (Throwable)e);
            throw new WechatException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5fae\u4fe1\u516c\u4f17\u53f7\u6743\u9650\uff01");
        }
        this.optionDao.batchInsertVoteOptions(optionList);
        VoteInfoResponse response = VoteInfoResponse.getVoteInfoResponse((VoteInfo)info);
        response.setVoteOptions(this.optionService.getOptionList(info.getActivityId().longValue()));
        return response;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public VoteResult vote(Long activityId, Long optionsId, String wechatOpenId, String userInfo, String targetOpenId) {
        VoteResult result = new VoteResult();
        Integer status = this.redisService.getActivityStatus(activityId, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()));
        if (status != null && status == DeleteStatus.IS_DELETE.code) {
            result.setCode(Integer.valueOf(VotedCode.DELETE.getCode()));
            return result;
        }
        try {
            VoteCacheDto voteCacheDto = this.findVoteCache(activityId);
            if (voteCacheDto == null) {
                result.setCode(Integer.valueOf(VotedCode.ERROR.code));
                return result;
            }
            Integer infoFillStatus = voteCacheDto.getInfoFillStatus();
            infoFillStatus = infoFillStatus == null ? 1 : infoFillStatus;
            Fans fans = null;
            if (infoFillStatus == 1 || infoFillStatus == 3) {
                fans = this.fansService.getFans(voteCacheDto.getOrgId().intValue(), wechatOpenId);
                log.info(" fans 0 is : {} ", (Object)fans);
                CustomActivityDto wechatDto = this.customActivityService.getCustomActivity(activityId.intValue(), voteCacheDto.getTemplateId());
                log.info("wechatDto is : {} ", (Object)wechatDto);
                boolean needAuth = false;
                if (fans == null && wechatDto != null && wechatDto.getReplaceOrgId() != null) {
                    Integer visitCount = this.redisService.visitCount(wechatOpenId, voteCacheDto.getOrgId());
                    log.info("find visit count is : {} ", (Object)visitCount);
                    if (visitCount == null || visitCount == 0) {
                        visitCount = 1;
                        needAuth = true;
                        this.redisService.setVisitCount(wechatOpenId, voteCacheDto.getOrgId(), visitCount);
                    } else {
                        fans = fans == null || !fans.isSubscribed() ? this.fansService.getFans(wechatDto.getReplaceOrgId().intValue(), wechatOpenId) : fans;
                        fans.setSubscribe(Integer.valueOf(1));
                        log.info("fans 1 is : {} ", (Object)fans);
                        log.info("with replaceOrgId , and isSubscribed for ReplaceOrgId : {} ", (Object)wechatDto.getReplaceOrgId());
                    }
                }
                log.info("needAuth is : {} ", (Object)needAuth);
                if (needAuth || fans == null || !fans.isSubscribed()) {
                    result.setCode(Integer.valueOf(DrawCode.UN_BIND.getCode()));
                    result.setQrcodeUrl(wechatDto.getQrCodeUrl());
                    String replyWord = wechatDto.getKeyWord();
                    if (GenericsUtils.notNullAndEmpty((Object)replyWord)) {
                        JSONArray array = JSONArray.fromObject((Object)replyWord);
                        JSONObject object = array.getJSONObject(0);
                        replyWord = object.getString("keyword");
                        log.info("replyWord is : {}", (Object)replyWord);
                    }
                    result.setKeyWord(replyWord);
                    return result;
                }
                if (infoFillStatus == 3) {
                    infoFillStatus = 2;
                }
            }
            VotedCode votedCode = null;
            boolean needUpdate = false;
            try {
                votedCode = this.validate(voteCacheDto);
            }
            catch (Exception e) {
                needUpdate = true;
            }
            if (votedCode != null || needUpdate) {
                VoteInfo voteInfo = this.voteInfoDao.selectVoteInfo(activityId, null);
                voteCacheDto = VoteCacheDto.getInstanceByVoteInfo((VoteInfo)voteInfo);
                this.redisService.setVoteActivityBase(activityId.longValue(), voteCacheDto);
                this.validate(voteCacheDto);
                if (votedCode != null) {
                    result.setCode(Integer.valueOf(votedCode.getCode()));
                    return result;
                }
            }
            Map extractMap = this.voteService.getVoteResultByWechatOpenId(activityId, wechatOpenId, voteCacheDto.getIsVotedByDay());
            int voteNums = 0;
            if (GenericsUtils.notNullAndEmpty((Object)extractMap)) {
                voteNums = extractMap.size();
            }
            if (extractMap.get(optionsId) != null) {
                result.setCode(Integer.valueOf(VotedCode.REPEAT_VOTE.code));
                return result;
            }
            if (voteNums >= voteCacheDto.getCountLimit()) {
                result.setCode(Integer.valueOf(DrawCode.LIMIT_COUNT.getCode()));
                return result;
            }
            if (infoFillStatus == 2) {
                Set keySet;
                ArrayList firstId;
                ActivityUser au;
                boolean existsPreUserInfo = false;
                if (GenericsUtils.notNullAndEmpty((Object)extractMap) && GenericsUtils.notNullAndEmpty((Object)(au = (ActivityUser)extractMap.get((firstId = new ArrayList(keySet = extractMap.keySet())).get(0))).getUserInfo())) {
                    existsPreUserInfo = true;
                }
                if (GenericsUtils.isNullOrEmpty((Object)userInfo) && !existsPreUserInfo) {
                    result.setCode(Integer.valueOf(DrawCode.INFO_LOSE.getCode()));
                    return result;
                }
            }
            ActivityUser user = new ActivityUser();
            user.setActivityId(activityId);
            user.setCreateTime(new Date());
            user.setDoneCount(0);
            user.setDoneDate(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd"));
            user.setWechatOpenId(wechatOpenId);
            user.setOptionsId(optionsId);
            user.setCategory(Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()));
            user.setUpdateTime(new Date());
            user.setUserInfo(userInfo);
            this.activityUserDao.insertActivityUser(user);
            result.setCode(Integer.valueOf(VotedCode.SUCCESS.code));
        }
        catch (Exception e) {
            log.error("error while vote cause by : ", (Throwable)e);
            result.setCode(Integer.valueOf(VotedCode.ERROR.code));
        }
        return result;
    }

    private VoteCacheDto findVoteCache(Long activityId) {
        VoteCacheDto voteCacheDto = this.redisService.getVoteActivityBase(activityId);
        if (voteCacheDto == null) {
            VoteInfo voteInfo = this.voteInfoDao.selectVoteInfo(activityId, null);
            voteCacheDto = VoteCacheDto.getInstanceByVoteInfo((VoteInfo)voteInfo);
            this.redisService.setVoteActivityBase(activityId.longValue(), voteCacheDto);
        }
        return voteCacheDto;
    }

    private VotedCode validate(VoteCacheDto voteCacheDto) {
        if (voteCacheDto.getStatus() == 0) {
            return VotedCode.CLOSED;
        }
        Date current = new Date();
        Date begin = new Date(voteCacheDto.getStartTime());
        Date end = new Date(voteCacheDto.getEndTime());
        if (current.before(begin)) {
            return VotedCode.NOT_START;
        }
        if (current.after(end)) {
            return VotedCode.IS_END;
        }
        return null;
    }

    @Override
    public VoteRenderDto renderVoteActivity(Long activityId, String wechatOpenId) {
        VoteRenderDto dto = this.voteService.getVoteRenderDtoById(activityId.longValue(), wechatOpenId);
        if (dto == null) {
            return null;
        }
        OrgInfoSimpleDto orgInfo = null;
        try {
            orgInfo = this.orgInfoService.getOrgInfo(dto.getOrgId());
            String weiPage = ConstantEnums.ORG_WEI_PAGE.value().trim() + orgInfo.getOrgNumber();
            dto.setOrgWeiPage(weiPage);
            dto.setOrgName(orgInfo.getShortName());
            dto.setOrgLogo(orgInfo.getLogo());
            dto.setOrgNumber(orgInfo.getOrgNumber());
        }
        catch (Exception e) {
            log.error("[Vote] Query org error.orgId=" + dto.getOrgId());
            log.error("[Vote] Query org error", (Throwable)e);
        }
        return dto;
    }

    @Override
    public TwoTuple<Integer, String> exportVoteResult(VoteInfoRequest request) {
        Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            log.info("can not find an org with org_ID {}", (Object)orgId);
            return TupleUtil.tuple((Object)400, (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String orgName = simple.getShortName();
        String email = request.getEmail();
        return this.createVoteResultStatisticsMail(orgId, activityId, orgName, email);
    }

    private TwoTuple<Integer, String> createVoteResultStatisticsMail(Long orgId, Long activityId, String orgName, String email) {
        VoteInfoResponse voteInfo = this.voteService.getVoteInfoById(activityId.longValue(), orgId.longValue());
        if (voteInfo == null) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List voteResult = this.voteStatisticsService.votedDairyCountStatistics(activityId, orgId);
        if (GenericsUtils.isNullOrEmpty((Object)voteResult)) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6682\u65e0\u6295\u7968\u7ed3\u679c");
        }
        boolean isNotLimited = this.redisService.addOrgEmailCount(orgId.longValue(), activityId.longValue(), TemplateTypeCategory.VOTE_TYPE.getType(), EmailType.USER);
        if (!isNotLimited) {
            log.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)("\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5"));
        }
        ArrayList rows = new ArrayList();
        for (VoteResult statistics : voteResult) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            Integer number = statistics.getNumber();
            String name = statistics.getName();
            String count = String.valueOf(statistics.getCount());
            rowMap.put("\u7f16\u53f7", String.valueOf(number));
            rowMap.put("\u540d\u79f0", name);
            rowMap.put("\u5f97\u7968\u6570", String.valueOf(count));
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_VOTE_SUBJECT_RESULT.value();
        String content = ConstantEnums.MAILBOX_VOTE_CONTENT_RESULT.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        ActivityMailSender.sendMail((String)email, (String)subject, (String)content, (Long)activityId, rows);
        return TupleUtil.tuple((Object)TupleUtil.OK, (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    @Override
    public ShareDto getShareInfo(Long activityId, Long orgId) {
        ShareDto dto = new ShareDto();
        VoteInfo voteInfo = this.voteInfoDao.selectVoteInfo(activityId, orgId);
        if (voteInfo == null) {
            return dto;
        }
        dto.setTitle(voteInfo.getName());
        try {
            String logo = this.orgInfoService.getOrgInfo(orgId).getLogo();
            dto.setImageUrl(PictureUtil.handlePictureSize(logo));
        }
        catch (Exception e) {
            log.error("[ActivityShareService ] ", (Throwable)e);
        }
        dto.setContent(ConstantEnums.VOTE_SLOGAN.value());
        dto.setShareUrl(this.getUrl(activityId, voteInfo.getTemplateId()));
        return dto;
    }

    private String getUrl(long activityId, int templateId) {
        CustomActivityDto dto = this.customActivityService.getCustomActivity((int)activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        }
        return "";
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void deleteVoteActivity(Long activityId, Long orgId) {
        VoteInfo info = this.voteInfoDao.selectVoteInfo(activityId, orgId);
        if (info != null) {
            this.redisService.setchangeActivityStatus(activityId, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), Integer.valueOf(DeleteStatus.IS_DELETE.getCode()));
            VoteInfo updateInfo = new VoteInfo();
            updateInfo.setActivityId(activityId);
            updateInfo.setDelStatus(Integer.valueOf(1));
            updateInfo.setUpdateTime(new Timestamp(new Date().getTime()));
            this.voteInfoDao.updateVoteActivity(updateInfo);
        } else {
            log.info("[Vote] vote is not exist  , voteId=", (Object)activityId);
        }
    }
}

