/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.referral.service.impl;

import com.baijia.tianxiao.biz.marketing.referral.service.QRCodeService;
import com.baijia.tianxiao.sal.marketing.commons.utils.QRCodeUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QRCodeServiceImpl
implements QRCodeService {
    private static final Logger log = LoggerFactory.getLogger(QRCodeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] findQRCode(String url) {
        String path = System.getProperty("java.io.tmpdir");
        String fileName = Base64.encodeBase64((byte[])url.getBytes()) + ".png";
        byte[] buffer = new byte[2048];
        String filePath = path + File.separator + fileName;
        log.info("filepath is : {} ", (Object)filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            log.info("file was not  exists");
            this.generatorQRCode(file, url);
        }
        FileInputStream input = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            input = new FileInputStream(file);
            int len = 0;
            while ((len = ((InputStream)input).read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            log.info("length is :{}", (Object)baos.toByteArray().length);
            baos.flush();
        }
        catch (Exception e) {
            try {
                log.error("generator qrCode failure cause by :{} ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        IOUtils.closeQuietly((InputStream)input);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generatorQRCode(File file, String url) {
        FileOutputStream out = null;
        try {
            file.createNewFile();
            out = new FileOutputStream(file);
            QRCodeUtils.genQrCode((String)url, (OutputStream)out);
            out.flush();
            if (out == null) return;
        }
        catch (Exception e) {
            try {
                log.error("generator qrcode fail cause by : {}", (Throwable)e);
                if (out == null) return;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            return;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return;
    }

    @Override
    public void createQRCode(String text, OutputStream stream) {
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(new String(text.getBytes("UTF-8"), "ISO-8859-1"), BarcodeFormat.QR_CODE, 260, 260);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)stream);
        }
        catch (WriterException e) {
            log.error("[CreateQRCode]", (Throwable)e);
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            log.error("[CreateQRCode]", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error("[CreateQRCode]", (Throwable)e);
            e.printStackTrace();
        }
    }
}

